/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.tileentity;

import coffee.cypher.mcextlib.extensions.inventories.InventoriesKt;
import coffee.cypher.mcextlib.extensions.vectors.DoubleVectorsKt;
import coffee.cypher.mcextlib.extensions.vectors.IntVectorsKt;
import com.cout970.magneticraft.api.internal.registries.machines.crushingtable.CrushingTableRecipeManager;
import com.cout970.magneticraft.api.registries.machines.crushingtable.ICrushingTableRecipe;
import com.cout970.magneticraft.registry.CapabilitiesKt;
import com.cout970.magneticraft.registry.SoundsKt;
import com.cout970.magneticraft.tileentity.TileBase;
import com.cout970.magneticraft.util.MinecraftUtilsKt;
import com.cout970.magneticraft.util.vector.Vec3dKt;
import java.util.Random;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleBreaking;
import net.minecraft.client.particle.ParticleDigging;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 +2\u00020\u00012\u00020\u0002:\u0002+,B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0005J/\u0010\u0017\u001a\u0004\u0018\u0001H\u0018\"\u0004\b\u0000\u0010\u00182\u000e\u0010\u0019\u001a\n\u0012\u0004\u0012\u0002H\u0018\u0018\u00010\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0017\u00a2\u0006\u0002\u0010\u001dJ\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u001f\u001a\u00020\u000bJ\b\u0010 \u001a\u0004\u0018\u00010\u000bJ \u0010!\u001a\u00020\u00132\f\u0010\u0019\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0016J\u0010\u0010\"\u001a\u00020\u00152\u0006\u0010#\u001a\u00020$H\u0016J\b\u0010%\u001a\u00020\u0015H\u0016J\b\u0010&\u001a\u00020$H\u0016J\u0010\u0010'\u001a\u00020\u00152\b\u0010(\u001a\u0004\u0018\u00010\u000bJ\b\u0010)\u001a\u00020\u0015H\u0003J\b\u0010*\u001a\u00020\u0015H\u0016R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0015\u0010\f\u001a\u00060\rR\u00020\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lcom/cout970/magneticraft/tileentity/TileCrushingTable;", "Lcom/cout970/magneticraft/tileentity/TileBase;", "Lnet/minecraft/util/ITickable;", "()V", "damageTaken", "", "getDamageTaken", "()I", "setDamageTaken", "(I)V", "inputCache", "Lnet/minecraft/item/ItemStack;", "inventory", "Lcom/cout970/magneticraft/tileentity/TileCrushingTable$CrushingTableInventory;", "getInventory", "()Lcom/cout970/magneticraft/tileentity/TileCrushingTable$CrushingTableInventory;", "recipeCache", "Lcom/cout970/magneticraft/api/registries/machines/crushingtable/ICrushingTableRecipe;", "canDamage", "", "doDamage", "", "amount", "getCapability", "T", "capability", "Lnet/minecraftforge/common/capabilities/Capability;", "facing", "Lnet/minecraft/util/EnumFacing;", "(Lnet/minecraftforge/common/capabilities/Capability;Lnet/minecraft/util/EnumFacing;)Ljava/lang/Object;", "getRecipe", "input", "getStack", "hasCapability", "load", "nbt", "Lnet/minecraft/nbt/NBTTagCompound;", "onBreak", "save", "setStack", "stack", "spawnParticles", "update", "Companion", "CrushingTableInventory", "magneticraft-compileKotlin"})
public final class TileCrushingTable
extends TileBase
implements ITickable {
    @NotNull
    private final CrushingTableInventory inventory = new CrushingTableInventory();
    private int damageTaken;
    private ICrushingTableRecipe recipeCache;
    private ItemStack inputCache;
    private static final int CRUSHING_DAMAGE = 40;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final CrushingTableInventory getInventory() {
        return this.inventory;
    }

    public final int getDamageTaken() {
        return this.damageTaken;
    }

    public final void setDamageTaken(int n) {
        this.damageTaken = n;
    }

    @Nullable
    public final ICrushingTableRecipe getRecipe(@NotNull ItemStack input) {
        Intrinsics.checkParameterIsNotNull(input, "input");
        if (input == this.inputCache) {
            return this.recipeCache;
        }
        ICrushingTableRecipe recipe = CrushingTableRecipeManager.INSTANCE.findRecipe(input);
        if (recipe != null) {
            this.recipeCache = recipe;
            this.inputCache = input;
        }
        return recipe;
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K && MinecraftUtilsKt.shouldTick(this, 100)) {
            this.sendUpdateToNearPlayers();
        }
    }

    @Nullable
    public final ItemStack getStack() {
        ItemStack itemStack = InventoriesKt.get((IItemHandler)this.inventory, 0);
        return itemStack != null ? itemStack.func_77946_l() : null;
    }

    public final void setStack(@Nullable ItemStack stack) {
        ItemStack itemStack = stack;
        InventoriesKt.set(this.inventory, 0, (ItemStack)(itemStack != null ? itemStack.func_77946_l() : null));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean canDamage() {
        if (this.getStack() == null) return false;
        ItemStack itemStack = this.getStack();
        if (itemStack == null) {
            Intrinsics.throwNpe();
        }
        if (this.getRecipe(itemStack) == null) return false;
        return true;
    }

    public final void doDamage(int amount) {
        if (!this.canDamage()) {
            return;
        }
        this.damageTaken += amount;
        if (this.damageTaken >= Companion.getCRUSHING_DAMAGE()) {
            if (this.func_145831_w().field_72995_K) {
                this.func_145831_w().func_184133_a((EntityPlayer)Minecraft.func_71410_x().field_71439_g, this.field_174879_c, SoundsKt.getSounds().get("crushing_final"), SoundCategory.BLOCKS, 1.0f, 1.0f);
                this.spawnParticles();
            }
            ItemStack itemStack = this.getStack();
            if (itemStack == null) {
                Intrinsics.throwNpe();
            }
            ICrushingTableRecipe iCrushingTableRecipe = this.getRecipe(itemStack);
            if (iCrushingTableRecipe == null) {
                Intrinsics.throwNpe();
            }
            ItemStack itemStack2 = iCrushingTableRecipe.getOutput();
            Intrinsics.checkExpressionValueIsNotNull(itemStack2, "getRecipe(getStack()!!)!!.output");
            this.inventory.setResult(itemStack2);
        } else if (this.func_145831_w().field_72995_K) {
            this.func_145831_w().func_184133_a((EntityPlayer)Minecraft.func_71410_x().field_71439_g, this.field_174879_c, SoundsKt.getSounds().get("crushing_hit"), SoundCategory.BLOCKS, 1.0f, 1.0f);
            this.spawnParticles();
        }
        this.sendUpdateToNearPlayers();
    }

    /*
     * WARNING - void declaration
     */
    @SideOnly(value=Side.CLIENT)
    private final void spawnParticles() {
        Vec3d center = DoubleVectorsKt.plus(IntVectorsKt.toDoubleVec((Vec3i)this.field_174879_c), Vec3dKt.vec3Of(0.5, 0.95, 0.5));
        ItemStack itemStack = this.getStack();
        if (itemStack == null) {
            return;
        }
        ItemStack stack = itemStack;
        Item item = stack.func_77973_b();
        if (item == null) {
            return;
        }
        Item item2 = item;
        if (item2 instanceof ItemBlock) {
            IBlockState state = ((ItemBlock)item2).field_150939_a.func_176203_a(stack.func_77960_j());
            ParticleDigging.Factory factory = new ParticleDigging.Factory();
            Random rand2 = new Random();
            int n = 0;
            int n2 = 5;
            if (n <= n2) {
                while (true) {
                    void i;
                    Particle particle = factory.func_178902_a(EnumParticleTypes.BLOCK_DUST.func_179348_c(), this.func_145831_w(), DoubleVectorsKt.getX(center), DoubleVectorsKt.getY(center), DoubleVectorsKt.getZ(center), (rand2.nextDouble() - 0.5) * 0.15, rand2.nextDouble() * 0.2, (rand2.nextDouble() - 0.5) * 0.15, new int[]{Block.func_176210_f((IBlockState)state)});
                    Minecraft.func_71410_x().field_71452_i.func_78873_a(particle);
                    if (i != n2) {
                        ++i;
                        continue;
                    }
                    break;
                }
            }
        } else {
            ParticleBreaking.Factory factory = new ParticleBreaking.Factory();
            Random rand = new Random();
            int rand2 = 0;
            int n = 5;
            if (rand2 <= n) {
                while (true) {
                    void i;
                    Particle particle = factory.func_178902_a(EnumParticleTypes.BLOCK_DUST.func_179348_c(), this.func_145831_w(), DoubleVectorsKt.getX(center), DoubleVectorsKt.getY(center), DoubleVectorsKt.getZ(center), (rand.nextDouble() - 0.5) * 0.15, rand.nextDouble() * 0.2, (rand.nextDouble() - 0.5) * 0.15, new int[]{Item.func_150891_b((Item)item2), stack.func_77952_i()});
                    Minecraft.func_71410_x().field_71452_i.func_78873_a(particle);
                    if (i == n) break;
                    ++i;
                }
            }
        }
    }

    @Override
    @NotNull
    public NBTTagCompound save() {
        NBTTagCompound nBTTagCompound = new NBTTagCompound();
        NBTTagCompound $receiver = nBTTagCompound;
        if (this.getStack() != null) {
            NBTTagCompound nBTTagCompound2 = new NBTTagCompound();
            String string = "stack";
            NBTTagCompound nBTTagCompound3 = $receiver;
            NBTTagCompound $receiver2 = nBTTagCompound2;
            ItemStack itemStack = this.getStack();
            if (itemStack != null) {
                itemStack.func_77955_b($receiver2);
            }
            NBTTagCompound nBTTagCompound4 = nBTTagCompound2;
            nBTTagCompound3.func_74782_a(string, (NBTBase)nBTTagCompound4);
        }
        $receiver.func_74768_a("damage", this.damageTaken);
        return nBTTagCompound;
    }

    @Override
    public void load(@NotNull NBTTagCompound nbt) {
        Intrinsics.checkParameterIsNotNull(nbt, "nbt");
        InventoriesKt.set(this.inventory, 0, nbt.func_74764_b("stack") ? ItemStack.func_77949_a((NBTTagCompound)nbt.func_74775_l("stack")) : (ItemStack)null);
        this.damageTaken = nbt.func_74762_e("damage");
    }

    public boolean hasCapability(@Nullable Capability<?> capability, @Nullable EnumFacing facing) {
        return Intrinsics.areEqual(capability, CapabilitiesKt.getITEM_HANDLER()) || super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(@Nullable Capability<T> capability, @Nullable EnumFacing facing) {
        return (T)(Intrinsics.areEqual(capability, CapabilitiesKt.getITEM_HANDLER()) ? (Object)((Object)this.inventory) : super.getCapability(capability, facing));
    }

    @Override
    public void onBreak() {
        super.onBreak();
        if (!this.field_145850_b.field_72995_K && InventoriesKt.get((IItemHandler)this.inventory, 0) != null) {
            ItemStack itemStack = InventoriesKt.get((IItemHandler)this.inventory, 0);
            if (itemStack == null) {
                Intrinsics.throwNpe();
            }
            BlockPos blockPos = this.field_174879_c;
            Intrinsics.checkExpressionValueIsNotNull(blockPos, "pos");
            this.dropItem(itemStack, blockPos);
        }
    }

    static {
        CRUSHING_DAMAGE = 40;
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u0004H\u0014J\u000e\u0010\n\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\u000b"}, d2={"Lcom/cout970/magneticraft/tileentity/TileCrushingTable$CrushingTableInventory;", "Lnet/minecraftforge/items/ItemStackHandler;", "(Lcom/cout970/magneticraft/tileentity/TileCrushingTable;)V", "getStackLimit", "", "slot", "stack", "Lnet/minecraft/item/ItemStack;", "onContentsChanged", "", "setResult", "magneticraft-compileKotlin"})
    public final class CrushingTableInventory
    extends ItemStackHandler {
        protected void onContentsChanged(int slot) {
            TileCrushingTable.this.setDamageTaken(0);
        }

        protected int getStackLimit(int slot, @NotNull ItemStack stack) {
            Intrinsics.checkParameterIsNotNull(stack, "stack");
            return 1;
        }

        public final void setResult(@NotNull ItemStack stack) {
            Intrinsics.checkParameterIsNotNull(stack, "stack");
            super.setStackInSlot(0, stack);
        }

        public CrushingTableInventory() {
            super(1);
        }
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/cout970/magneticraft/tileentity/TileCrushingTable$Companion;", "", "()V", "CRUSHING_DAMAGE", "", "getCRUSHING_DAMAGE", "()I", "magneticraft-compileKotlin"})
    public static final class Companion {
        public final int getCRUSHING_DAMAGE() {
            return CRUSHING_DAMAGE;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

