/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.tileentity;

import coffee.cypher.mcextlib.extensions.inventories.InventoriesKt;
import com.cout970.magneticraft.api.internal.registries.machines.tablesieve.TableSieveRecipeManager;
import com.cout970.magneticraft.api.registries.machines.tablesieve.ITableSieveRecipe;
import com.cout970.magneticraft.registry.CapabilitiesKt;
import com.cout970.magneticraft.tileentity.TileBase;
import com.cout970.magneticraft.tileentity.TileTableSieve;
import com.cout970.magneticraft.util.MinecraftUtilsKt;
import com.google.common.base.Predicate;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 )2\u00020\u00012\u00020\u0002:\u0001)B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0006\u0010\u001b\u001a\u00020\u001cJ\u000e\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\tJ\u0006\u0010\u001f\u001a\u00020\u001cJ\u0010\u0010 \u001a\u0004\u0018\u00010\u00132\u0006\u0010!\u001a\u00020\tJ\u0010\u0010\"\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020$H\u0016J\b\u0010%\u001a\u00020\u001cH\u0016J\b\u0010&\u001a\u00020$H\u0016J\u0006\u0010'\u001a\u00020\u001cJ\b\u0010(\u001a\u00020\u001cH\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\t0\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0007\"\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u0007\"\u0004\b\u001a\u0010\u0017\u00a8\u0006*"}, d2={"Lcom/cout970/magneticraft/tileentity/TileTableSieve;", "Lcom/cout970/magneticraft/tileentity/TileBase;", "Lnet/minecraft/util/ITickable;", "()V", "craftingTime", "", "getCraftingTime", "()I", "inputCache", "Lnet/minecraft/item/ItemStack;", "inventory", "Lnet/minecraftforge/items/ItemStackHandler;", "getInventory", "()Lnet/minecraftforge/items/ItemStackHandler;", "output", "", "getOutput", "()Ljava/util/List;", "recipeCache", "Lcom/cout970/magneticraft/api/registries/machines/tablesieve/ITableSieveRecipe;", "size", "getSize", "setSize", "(I)V", "tickCounter", "getTickCounter", "setTickCounter", "craftItem", "", "dropOutput", "item", "ejectItems", "getRecipe", "input", "load", "nbt", "Lnet/minecraft/nbt/NBTTagCompound;", "onBreak", "save", "suckItems", "update", "Companion", "magneticraft-compileKotlin"})
public final class TileTableSieve
extends TileBase
implements ITickable {
    @NotNull
    private final ItemStackHandler inventory = new ItemStackHandler(1);
    @NotNull
    private final List<ItemStack> output = CollectionsKt.mutableListOf(new ItemStack[0]);
    private final int craftingTime = 40;
    private int tickCounter;
    private int size;
    private ITableSieveRecipe recipeCache;
    private ItemStack inputCache;
    private static final int UPDATE_TIME = 20;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final ItemStackHandler getInventory() {
        return this.inventory;
    }

    @NotNull
    public final List<ItemStack> getOutput() {
        return this.output;
    }

    public final int getCraftingTime() {
        return this.craftingTime;
    }

    public final int getTickCounter() {
        return this.tickCounter;
    }

    public final void setTickCounter(int n) {
        this.tickCounter = n;
    }

    public final int getSize() {
        return this.size;
    }

    public final void setSize(int n) {
        this.size = n;
    }

    @Nullable
    public final ITableSieveRecipe getRecipe(@NotNull ItemStack input) {
        Intrinsics.checkParameterIsNotNull(input, "input");
        if (input == this.inputCache) {
            return this.recipeCache;
        }
        ITableSieveRecipe recipe = TableSieveRecipeManager.INSTANCE.findRecipe(input);
        if (recipe != null) {
            this.recipeCache = recipe;
            this.inputCache = input;
        }
        return recipe;
    }

    public void func_73660_a() {
        if (MinecraftUtilsKt.shouldTick(this, Companion.getUPDATE_TIME())) {
            this.suckItems();
        }
        if (!this.output.isEmpty()) {
            this.ejectItems();
        }
        if (InventoriesKt.get((IItemHandler)this.inventory, 0) != null && this.output.isEmpty()) {
            if (this.tickCounter > this.craftingTime) {
                this.tickCounter = 0;
                this.craftItem();
            } else {
                int n = this.tickCounter;
                this.tickCounter = n + 1;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void ejectItems() {
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c.func_177977_b());
        TileEntity tile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177977_b());
        if (tile != null) {
            IItemHandler inventory;
            Capability<IItemHandler> capability = CapabilitiesKt.getITEM_HANDLER();
            if (capability == null) {
                Intrinsics.throwNpe();
            }
            if ((inventory = (IItemHandler)CapabilitiesKt.fromTile$default(capability, tile, null, 2, null)) != null) {
                Iterator<ItemStack> iterator2 = this.output.iterator();
                block0: while (iterator2.hasNext()) {
                    int n;
                    ItemStack output = iterator2.next();
                    IntRange intRange = RangesKt.until(0, inventory.getSlots());
                    int n2 = intRange.getFirst();
                    if (n2 > (n = intRange.getLast())) continue;
                    while (true) {
                        void slot;
                        ItemStack result;
                        if ((result = inventory.insertItem((int)slot, output.func_77946_l(), true)) == null) {
                            inventory.insertItem((int)slot, output.func_77946_l(), false);
                            iterator2.remove();
                            continue block0;
                        }
                        if (slot == n) continue block0;
                        ++slot;
                    }
                }
            }
        }
        if (!state.func_185917_h()) {
            while (!this.output.isEmpty()) {
                ItemStack itemStack = CollectionsKt.first(this.output).func_77946_l();
                Intrinsics.checkExpressionValueIsNotNull(itemStack, "output.first().copy()");
                this.dropOutput(itemStack);
                this.output.remove(0);
            }
        }
    }

    public final void dropOutput(@NotNull ItemStack item) {
        Intrinsics.checkParameterIsNotNull(item, "item");
        if (!this.func_145831_w().field_72995_K) {
            EntityItem entityItem = new EntityItem(this.func_145831_w(), (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() - 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, item);
            entityItem.field_70159_w = 0.0;
            entityItem.field_70181_x = 0.0;
            entityItem.field_70179_y = 0.0;
            entityItem.func_174869_p();
            this.func_145831_w().func_72838_d((Entity)entityItem);
        }
    }

    public final void suckItems() {
        AxisAlignedBB aabb = new AxisAlignedBB(this.field_174879_c, this.field_174879_c.func_177984_a().func_177963_a(1.0, 1.0, 1.0));
        List items2 = this.field_145850_b.func_175674_a((Entity)null, aabb, (Predicate)suckItems.items.1.INSTANCE);
        for (Entity i : items2) {
            ItemStack item;
            if (!(i instanceof EntityItem)) continue;
            ItemStack itemStack = item = ((EntityItem)i).func_92059_d();
            Intrinsics.checkExpressionValueIsNotNull(itemStack, "item");
            if (this.getRecipe(itemStack) == null) continue;
            ItemStack inserted = this.inventory.insertItem(0, item, true);
            if (inserted == null) {
                this.inventory.insertItem(0, item.func_77946_l(), false);
                i.func_70106_y();
                continue;
            }
            if (inserted.field_77994_a == item.field_77994_a) continue;
            this.inventory.insertItem(0, item.func_77946_l(), false);
            item.field_77994_a = inserted.field_77994_a;
        }
    }

    public final void craftItem() {
        ItemStack itemStack = InventoriesKt.get((IItemHandler)this.inventory, 0);
        if (itemStack == null) {
            Intrinsics.throwNpe();
        }
        ItemStack stack = itemStack;
        ITableSieveRecipe iTableSieveRecipe = this.getRecipe(stack);
        if (iTableSieveRecipe == null) {
            Intrinsics.throwNpe();
        }
        ITableSieveRecipe recipe = iTableSieveRecipe;
        ItemStack itemStack2 = recipe.getPrimaryOutput();
        Intrinsics.checkExpressionValueIsNotNull(itemStack2, "recipe.primaryOutput");
        this.output.add(itemStack2);
        ItemStack extra = recipe.getSecondaryOutput();
        if (extra != null) {
            Random random = new Random();
            if (random.nextFloat() < recipe.getProbability()) {
                this.output.add(extra);
            }
        }
        int n = stack.field_77994_a;
        stack.field_77994_a = n + -1;
        if (stack.field_77994_a <= 0) {
            this.inventory.setStackInSlot(0, (ItemStack)null);
        }
    }

    @Override
    @NotNull
    public NBTTagCompound save() {
        NBTTagCompound nBTTagCompound = new NBTTagCompound();
        NBTTagCompound $receiver = nBTTagCompound;
        $receiver.func_74782_a("inventory", (NBTBase)this.inventory.serializeNBT());
        return nBTTagCompound;
    }

    @Override
    public void load(@NotNull NBTTagCompound nbt) {
        Intrinsics.checkParameterIsNotNull(nbt, "nbt");
        this.inventory.deserializeNBT(nbt.func_74775_l("inventory"));
    }

    @Override
    public void onBreak() {
        super.onBreak();
        if (!this.field_145850_b.field_72995_K) {
            if (InventoriesKt.get((IItemHandler)this.inventory, 0) != null) {
                ItemStack itemStack = InventoriesKt.get((IItemHandler)this.inventory, 0);
                if (itemStack == null) {
                    Intrinsics.throwNpe();
                }
                BlockPos blockPos = this.field_174879_c;
                Intrinsics.checkExpressionValueIsNotNull(blockPos, "pos");
                this.dropItem(itemStack, blockPos);
            }
            for (ItemStack i : this.output) {
                BlockPos blockPos = this.field_174879_c;
                Intrinsics.checkExpressionValueIsNotNull(blockPos, "pos");
                this.dropItem(i, blockPos);
            }
        }
    }

    static {
        UPDATE_TIME = 20;
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/cout970/magneticraft/tileentity/TileTableSieve$Companion;", "", "()V", "UPDATE_TIME", "", "getUPDATE_TIME", "()I", "magneticraft-compileKotlin"})
    public static final class Companion {
        public final int getUPDATE_TIME() {
            return UPDATE_TIME;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

