/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.tileentity.electric;

import com.cout970.magneticraft.api.energy.IElectricNode;
import com.cout970.magneticraft.api.internal.energy.ElectricNode;
import com.cout970.magneticraft.block.SharedPropertiesKt;
import com.cout970.magneticraft.tileentity.electric.TileElectricBase;
import com.cout970.magneticraft.util.MinecraftUtilsKt;
import com.cout970.magneticraft.util.misc.ValueAverage;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 )2\u00020\u0001:\u0001)B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010!H\u0016J\u0006\u0010\"\u001a\u00020!J\u0010\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0016J\b\u0010'\u001a\u00020&H\u0016J\b\u0010(\u001a\u00020$H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0006R\u001a\u0010\u0012\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\u00020\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001d\u00a8\u0006*"}, d2={"Lcom/cout970/magneticraft/tileentity/electric/TileBattery;", "Lcom/cout970/magneticraft/tileentity/electric/TileElectricBase;", "()V", "chargeRate", "Lcom/cout970/magneticraft/util/misc/ValueAverage;", "getChargeRate", "()Lcom/cout970/magneticraft/util/misc/ValueAverage;", "electricNodes", "", "Lcom/cout970/magneticraft/api/energy/IElectricNode;", "getElectricNodes", "()Ljava/util/List;", "inventory", "Lnet/minecraftforge/items/ItemStackHandler;", "getInventory", "()Lnet/minecraftforge/items/ItemStackHandler;", "itemChargeRate", "getItemChargeRate", "mainNode", "Lcom/cout970/magneticraft/api/internal/energy/ElectricNode;", "getMainNode", "()Lcom/cout970/magneticraft/api/internal/energy/ElectricNode;", "setMainNode", "(Lcom/cout970/magneticraft/api/internal/energy/ElectricNode;)V", "storage", "", "getStorage", "()I", "setStorage", "(I)V", "canConnectAtSide", "", "facing", "Lnet/minecraft/util/EnumFacing;", "getFacing", "load", "", "nbt", "Lnet/minecraft/nbt/NBTTagCompound;", "save", "update", "Companion", "magneticraft-compileKotlin"})
public final class TileBattery
extends TileElectricBase {
    @NotNull
    private ElectricNode mainNode = new ElectricNode(new Function0<World>(this){
        final /* synthetic */ TileBattery this$0;

        public final World invoke() {
            World world = this.this$0.func_145831_w();
            Intrinsics.checkExpressionValueIsNotNull(world, "world");
            return world;
        }
        {
            this.this$0 = tileBattery;
            super(0);
        }
    }, new Function0<BlockPos>(this){
        final /* synthetic */ TileBattery this$0;

        public final BlockPos invoke() {
            BlockPos blockPos = TileBattery.access$getPos$p(this.this$0);
            Intrinsics.checkExpressionValueIsNotNull(blockPos, "pos");
            return blockPos;
        }
        {
            this.this$0 = tileBattery;
            super(0);
        }
    }, 0.0, 1.25, 4, null);
    private int storage;
    @NotNull
    private final ItemStackHandler inventory = new ItemStackHandler(2);
    @NotNull
    private final ValueAverage chargeRate = new ValueAverage(20);
    @NotNull
    private final ValueAverage itemChargeRate = new ValueAverage(20);
    private static final int MAX_STORAGE = 1000000;
    private static final int MAX_CHARGE_SPEED = 400;
    private static final double UPPER_LIMIT = 100.0;
    private static final double LOWER_LIMIT = 90.0;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final ElectricNode getMainNode() {
        return this.mainNode;
    }

    public final void setMainNode(@NotNull ElectricNode electricNode) {
        Intrinsics.checkParameterIsNotNull(electricNode, "<set-?>");
        this.mainNode = electricNode;
    }

    @Override
    @NotNull
    public List<IElectricNode> getElectricNodes() {
        return CollectionsKt.listOf(this.mainNode);
    }

    public final int getStorage() {
        return this.storage;
    }

    public final void setStorage(int n) {
        this.storage = n;
    }

    @NotNull
    public final ItemStackHandler getInventory() {
        return this.inventory;
    }

    @NotNull
    public final ValueAverage getChargeRate() {
        return this.chargeRate;
    }

    @NotNull
    public final ValueAverage getItemChargeRate() {
        return this.itemChargeRate;
    }

    @Override
    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.mainNode.getVoltage() > Companion.getUPPER_LIMIT()) {
                double speed = TileElectricBase.Companion.interpolate(this.mainNode.getVoltage(), Companion.getUPPER_LIMIT(), 120.0) * (double)Companion.getMAX_CHARGE_SPEED();
                int finalSpeed = Math.min((int)Math.floor(speed), Companion.getMAX_STORAGE() - this.storage);
                this.mainNode.applyPower(-((double)finalSpeed), false);
                this.storage += finalSpeed;
                this.chargeRate.plusAssign(finalSpeed);
            } else if (this.mainNode.getVoltage() < Companion.getLOWER_LIMIT()) {
                double speed = (1.0 - TileElectricBase.Companion.interpolate(this.mainNode.getVoltage(), 60.0, Companion.getLOWER_LIMIT())) * (double)Companion.getMAX_CHARGE_SPEED();
                int finalSpeed = Math.min((int)Math.floor(speed), this.storage);
                this.mainNode.applyPower(finalSpeed, false);
                this.storage -= finalSpeed;
                this.chargeRate.minusAssign(finalSpeed);
            }
            this.chargeRate.tick();
            this.itemChargeRate.tick();
        }
        super.func_73660_a();
    }

    @Override
    @NotNull
    public NBTTagCompound save() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74768_a("storage", this.storage);
        nbt.func_74782_a("inventory", (NBTBase)this.inventory.serializeNBT());
        return nbt;
    }

    @Override
    public void load(@NotNull NBTTagCompound nbt) {
        Intrinsics.checkParameterIsNotNull(nbt, "nbt");
        this.storage = nbt.func_74762_e("storage");
        this.inventory.deserializeNBT(nbt.func_74775_l("inventory"));
    }

    @NotNull
    public final EnumFacing getFacing() {
        IBlockState state = this.func_145831_w().func_180495_p(this.field_174879_c);
        IProperty iProperty = (IProperty)SharedPropertiesKt.getPROPERTY_DIRECTION();
        IBlockState iBlockState = state;
        Intrinsics.checkExpressionValueIsNotNull(iBlockState, "state");
        EnumFacing enumFacing = (EnumFacing)MinecraftUtilsKt.get(iProperty, iBlockState);
        Intrinsics.checkExpressionValueIsNotNull(enumFacing, "PROPERTY_DIRECTION[state]");
        return enumFacing;
    }

    @Override
    public boolean canConnectAtSide(@Nullable EnumFacing facing) {
        return facing == null || Intrinsics.areEqual(facing, this.getFacing());
    }

    static {
        MAX_STORAGE = 1000000;
        MAX_CHARGE_SPEED = 400;
        UPPER_LIMIT = 100.0;
        LOWER_LIMIT = 90.0;
    }

    public static final /* synthetic */ BlockPos access$getPos$p(TileBattery $this) {
        return $this.field_174879_c;
    }

    public static final /* synthetic */ void access$setPos$p(TileBattery $this, BlockPos blockPos) {
        $this.field_174879_c = blockPos;
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\bX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0014\u0010\r\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0006\u00a8\u0006\u000f"}, d2={"Lcom/cout970/magneticraft/tileentity/electric/TileBattery$Companion;", "", "()V", "LOWER_LIMIT", "", "getLOWER_LIMIT", "()D", "MAX_CHARGE_SPEED", "", "getMAX_CHARGE_SPEED", "()I", "MAX_STORAGE", "getMAX_STORAGE", "UPPER_LIMIT", "getUPPER_LIMIT", "magneticraft-compileKotlin"})
    public static final class Companion {
        public final int getMAX_STORAGE() {
            return MAX_STORAGE;
        }

        public final int getMAX_CHARGE_SPEED() {
            return MAX_CHARGE_SPEED;
        }

        public final double getUPPER_LIMIT() {
            return UPPER_LIMIT;
        }

        public final double getLOWER_LIMIT() {
            return LOWER_LIMIT;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

