/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.tileentity.electric;

import coffee.cypher.mcextlib.extensions.vectors.IntVectorsKt;
import com.cout970.magneticraft.api.energy.IElectricConnection;
import com.cout970.magneticraft.api.energy.IElectricNode;
import com.cout970.magneticraft.api.energy.IElectricNodeHandler;
import com.cout970.magneticraft.api.energy.INode;
import com.cout970.magneticraft.api.energy.INodeHandler;
import com.cout970.magneticraft.api.energy.IWireConnector;
import com.cout970.magneticraft.api.internal.energy.ElectricConnection;
import com.cout970.magneticraft.registry.CapabilitiesKt;
import com.cout970.magneticraft.tileentity.TileBase;
import com.cout970.magneticraft.tileentity.electric.TileElectricBase;
import com.cout970.magneticraft.util.MinecraftUtilsKt;
import com.cout970.magneticraft.util.misc.RenderCache;
import com.cout970.magneticraft.util.misc.UnloadedElectricConnection;
import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SpreadBuilder;
import kotlin.ranges.IntProgression;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.capabilities.Capability;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\b&\u0018\u0000 P2\u00020\u00012\u00020\u00022\u00020\u0003:\u0001PB\u0005\u00a2\u0006\u0002\u0010\u0004J\"\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u00182\b\u0010*\u001a\u0004\u0018\u00010+2\u0006\u0010,\u001a\u00020\u0006H\u0016J*\u0010-\u001a\u00020\u00062\u0006\u0010.\u001a\u00020\r2\u0006\u0010/\u001a\u00020\u00022\u0006\u00100\u001a\u00020\r2\b\u0010*\u001a\u0004\u0018\u00010+H\u0016J\u0012\u00101\u001a\u00020\u00062\b\u00102\u001a\u0004\u0018\u00010+H\u0016J\u0006\u00103\u001a\u00020(J\u0006\u00104\u001a\u00020(J\u0018\u00105\u001a\u00020\u00062\u0006\u00106\u001a\u0002072\u0006\u0010*\u001a\u00020+H\u0016J/\u00108\u001a\u0004\u0018\u0001H9\"\u0004\b\u0000\u001092\u000e\u0010:\u001a\n\u0012\u0004\u0012\u0002H9\u0018\u00010;2\b\u00102\u001a\u0004\u0018\u00010+H\u0017\u00a2\u0006\u0002\u0010<J\u000e\u0010=\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0016J\b\u0010>\u001a\u00020?H\u0016J\u0014\u0010@\u001a\u0004\u0018\u0001072\b\u00102\u001a\u0004\u0018\u00010+H\u0016J\u000e\u0010A\u001a\b\u0012\u0004\u0012\u00020B0\fH\u0016J\u000e\u0010C\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0016J \u0010D\u001a\u00020\u00062\f\u0010:\u001a\b\u0012\u0002\b\u0003\u0018\u00010;2\b\u00102\u001a\u0004\u0018\u00010+H\u0016J\b\u0010E\u001a\u00020(H\u0016J\b\u0010F\u001a\u00020(H\u0016J\u0012\u0010G\u001a\u00020(2\b\u0010H\u001a\u0004\u0018\u00010IH\u0016J\u0010\u0010J\u001a\u00020(2\u0006\u0010)\u001a\u00020\u0018H\u0016J\b\u0010K\u001a\u00020(H\u0016J\b\u0010L\u001a\u00020(H\u0016J\b\u0010M\u001a\u00020(H\u0016J\b\u0010N\u001a\u00020(H\u0016J\u0014\u0010O\u001a\u0004\u0018\u00010I2\b\u0010H\u001a\u0004\u0018\u00010IH\u0016R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0018\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u0017\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u000fR\u0017\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u000fR\u0017\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u000fR\u0017\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u000fR\u0017\u0010 \u001a\b\u0012\u0004\u0012\u00020!0\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u000fR\u0011\u0010#\u001a\u00020$\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&\u00a8\u0006Q"}, d2={"Lcom/cout970/magneticraft/tileentity/electric/TileElectricBase;", "Lcom/cout970/magneticraft/tileentity/TileBase;", "Lcom/cout970/magneticraft/api/energy/IElectricNodeHandler;", "Lnet/minecraft/util/ITickable;", "()V", "autoConnectWires", "", "getAutoConnectWires", "()Z", "setAutoConnectWires", "(Z)V", "electricNodes", "", "Lcom/cout970/magneticraft/api/energy/IElectricNode;", "getElectricNodes", "()Ljava/util/List;", "firstTicks", "", "getFirstTicks", "()I", "setFirstTicks", "(I)V", "inputNormalConnections", "", "Lcom/cout970/magneticraft/api/energy/IElectricConnection;", "getInputNormalConnections", "inputWiredConnections", "getInputWiredConnections", "outputNormalConnections", "getOutputNormalConnections", "outputWiredConnections", "getOutputWiredConnections", "unloadedConnections", "Lcom/cout970/magneticraft/util/misc/UnloadedElectricConnection;", "getUnloadedConnections", "wireRender", "Lcom/cout970/magneticraft/util/misc/RenderCache;", "getWireRender", "()Lcom/cout970/magneticraft/util/misc/RenderCache;", "addConnection", "", "connection", "side", "Lnet/minecraft/util/EnumFacing;", "output", "canConnect", "thisNode", "other", "otherNode", "canConnectAtSide", "facing", "clearNormalConnections", "clearWireConnections", "connectWire", "handler", "Lcom/cout970/magneticraft/api/energy/INodeHandler;", "getCapability", "T", "capability", "Lnet/minecraftforge/common/capabilities/Capability;", "(Lnet/minecraftforge/common/capabilities/Capability;Lnet/minecraft/util/EnumFacing;)Ljava/lang/Object;", "getInputConnections", "getMaxWireDistance", "", "getNodeHandler", "getNodes", "Lcom/cout970/magneticraft/api/energy/INode;", "getOutputConnections", "hasCapability", "iterate", "onBreak", "readFromNBT", "compound", "Lnet/minecraft/nbt/NBTTagCompound;", "removeConnection", "resolveUnloadedConnections", "update", "updateConnections", "updateWiredConnections", "writeToNBT", "Companion", "magneticraft-compileKotlin"})
public abstract class TileElectricBase
extends TileBase
implements IElectricNodeHandler,
ITickable {
    @NotNull
    private final List<IElectricConnection> inputNormalConnections = CollectionsKt.mutableListOf(new IElectricConnection[0]);
    @NotNull
    private final List<IElectricConnection> outputNormalConnections = CollectionsKt.mutableListOf(new IElectricConnection[0]);
    @NotNull
    private final List<IElectricConnection> inputWiredConnections = CollectionsKt.mutableListOf(new IElectricConnection[0]);
    @NotNull
    private final List<IElectricConnection> outputWiredConnections = CollectionsKt.mutableListOf(new IElectricConnection[0]);
    @NotNull
    private final List<UnloadedElectricConnection> unloadedConnections = CollectionsKt.mutableListOf(new UnloadedElectricConnection[0]);
    @NotNull
    private final RenderCache wireRender = new RenderCache();
    private int firstTicks = -1;
    private boolean autoConnectWires;
    @NotNull
    private static final List<EnumFacing> NEGATIVE_DIRECTIONS;
    public static final Companion Companion;

    @NotNull
    public final List<IElectricConnection> getInputNormalConnections() {
        return this.inputNormalConnections;
    }

    @NotNull
    public final List<IElectricConnection> getOutputNormalConnections() {
        return this.outputNormalConnections;
    }

    @NotNull
    public final List<IElectricConnection> getInputWiredConnections() {
        return this.inputWiredConnections;
    }

    @NotNull
    public final List<IElectricConnection> getOutputWiredConnections() {
        return this.outputWiredConnections;
    }

    @NotNull
    public abstract List<IElectricNode> getElectricNodes();

    @NotNull
    public final List<UnloadedElectricConnection> getUnloadedConnections() {
        return this.unloadedConnections;
    }

    @NotNull
    public final RenderCache getWireRender() {
        return this.wireRender;
    }

    public final int getFirstTicks() {
        return this.firstTicks;
    }

    public final void setFirstTicks(int n) {
        this.firstTicks = n;
    }

    public final boolean getAutoConnectWires() {
        return this.autoConnectWires;
    }

    public final void setAutoConnectWires(boolean bl) {
        this.autoConnectWires = bl;
    }

    public void func_73660_a() {
        if (MinecraftUtilsKt.shouldTick(this, 40)) {
            this.updateConnections();
        }
        this.resolveUnloadedConnections();
        if (MinecraftUtilsKt.isServer(this.func_145831_w())) {
            if (MinecraftUtilsKt.shouldTick(this, 400)) {
                this.sendUpdateToNearPlayers();
            }
            if (this.firstTicks > 0) {
                int n = this.firstTicks;
                this.firstTicks = n + -1;
                if (this.firstTicks % 20 == 0) {
                    this.sendUpdateToNearPlayers();
                }
            }
            this.iterate();
        }
    }

    public void resolveUnloadedConnections() {
        if (!this.unloadedConnections.isEmpty()) {
            Iterator<UnloadedElectricConnection> iterator2 = this.unloadedConnections.iterator();
            while (iterator2.hasNext()) {
                UnloadedElectricConnection con = iterator2.next();
                World world = this.func_145831_w();
                Intrinsics.checkExpressionValueIsNotNull(world, "world");
                if (!con.create(world, this)) continue;
                iterator2.remove();
            }
            if (!this.func_145831_w().field_72995_K) {
                this.firstTicks = 60;
            } else {
                this.wireRender.reset();
            }
        }
    }

    public void iterate() {
        Object it;
        Iterable $receiver$iv = this.getElectricNodes();
        for (Object element$iv : $receiver$iv) {
            it = (IElectricNode)element$iv;
            it.iterate();
        }
        $receiver$iv = this.outputNormalConnections;
        for (Object element$iv : $receiver$iv) {
            it = (IElectricConnection)element$iv;
            it.iterate();
        }
        $receiver$iv = this.outputWiredConnections;
        for (Object element$iv : $receiver$iv) {
            it = (IElectricConnection)element$iv;
            it.iterate();
        }
    }

    public void updateConnections() {
        IElectricNode iElectricNode;
        Collection collection;
        Collection destination$iv$iv;
        INode it;
        Iterable $receiver$iv$iv;
        this.clearNormalConnections();
        Iterable $receiver$iv = this.getNodes();
        Iterable iterable = $receiver$iv;
        Collection collection2 = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            it = (INode)element$iv$iv;
            if (!(it instanceof IElectricNode)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            it = (INode)item$iv$iv;
            collection = destination$iv$iv;
            INode iNode = it;
            if (iNode == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.cout970.magneticraft.api.energy.IElectricNode");
            }
            iElectricNode = (IElectricNode)iNode;
            collection.add(iElectricNode);
        }
        for (IElectricNode thisNode : (List)destination$iv$iv) {
            for (EnumFacing dir : Companion.getNEGATIVE_DIRECTIONS()) {
                Collection destination$iv$iv2;
                INode it2;
                Iterable $receiver$iv$iv2;
                Iterable $receiver$iv2;
                TileEntity tile;
                if (this.field_145850_b.func_175625_s(thisNode.getPos().func_177972_a(dir)) == null) {
                    continue;
                }
                Capability<INodeHandler> capability = CapabilitiesKt.getNODE_HANDLER();
                if (capability == null) {
                    Intrinsics.throwNpe();
                }
                TileEntity tileEntity = tile;
                Intrinsics.checkExpressionValueIsNotNull(tileEntity, "tile");
                INodeHandler handler = CapabilitiesKt.fromTile(capability, tileEntity, dir.func_176734_d());
                if (!(handler instanceof IElectricNodeHandler)) continue;
                Iterable $i$a$2$map = ((IElectricNodeHandler)handler).getNodes();
                void $i$f$mapTo = $receiver$iv2;
                Collection $i$f$map = new ArrayList();
                for (Object element$iv$iv : $receiver$iv$iv2) {
                    it2 = (INode)element$iv$iv;
                    if (!(it2 instanceof IElectricNode)) continue;
                    destination$iv$iv2.add(element$iv$iv);
                }
                $receiver$iv2 = (List)destination$iv$iv2;
                $receiver$iv$iv2 = $receiver$iv2;
                destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv2, 10));
                for (Object item$iv$iv : $receiver$iv$iv2) {
                    it2 = (INode)item$iv$iv;
                    collection = destination$iv$iv2;
                    INode iNode = it2;
                    if (iNode == null) {
                        throw new TypeCastException("null cannot be cast to non-null type com.cout970.magneticraft.api.energy.IElectricNode");
                    }
                    iElectricNode = (IElectricNode)iNode;
                    collection.add(iElectricNode);
                }
                for (IElectricNode otherNode : (List)destination$iv$iv2) {
                    if (!this.canConnect(thisNode, (IElectricNodeHandler)handler, otherNode, dir) || !((IElectricNodeHandler)handler).canConnect(otherNode, this, thisNode, dir.func_176734_d())) continue;
                    ElectricConnection connection = new ElectricConnection(thisNode, otherNode);
                    this.addConnection(connection, dir, true);
                    ((IElectricNodeHandler)handler).addConnection(connection, dir.func_176734_d(), false);
                }
            }
        }
        this.updateWiredConnections();
    }

    public void updateWiredConnections() {
        if (this.func_145831_w().field_72995_K) {
            this.wireRender.reset();
        }
        Iterator<IElectricConnection> iterator2 = this.outputWiredConnections.iterator();
        while (iterator2.hasNext()) {
            IElectricConnection i = iterator2.next();
            IElectricNode iElectricNode = i.getSecondNode();
            Intrinsics.checkExpressionValueIsNotNull(iElectricNode, "i.secondNode");
            IElectricNodeHandler handler = Companion.getHandler(iElectricNode);
            if (handler != null && handler.getNodes().contains(i.getSecondNode())) continue;
            iterator2.remove();
        }
    }

    public final void clearNormalConnections() {
        Iterator<IElectricConnection> iterator2 = this.outputNormalConnections.iterator();
        while (iterator2.hasNext()) {
            IElectricNodeHandler handler;
            IElectricConnection con = iterator2.next();
            IElectricNode iElectricNode = con.getSecondNode();
            Intrinsics.checkExpressionValueIsNotNull(iElectricNode, "con.secondNode");
            IElectricNodeHandler iElectricNodeHandler = handler = Companion.getHandler(iElectricNode);
            if (iElectricNodeHandler != null) {
                iElectricNodeHandler.removeConnection(con);
            }
            iterator2.remove();
        }
    }

    public final void clearWireConnections() {
        Iterator<IElectricConnection> iterator2 = this.outputWiredConnections.iterator();
        while (iterator2.hasNext()) {
            IElectricNodeHandler handler;
            IElectricConnection con = iterator2.next();
            IElectricNode iElectricNode = con.getSecondNode();
            Intrinsics.checkExpressionValueIsNotNull(iElectricNode, "con.secondNode");
            IElectricNodeHandler iElectricNodeHandler = handler = Companion.getHandler(iElectricNode);
            if (iElectricNodeHandler != null) {
                iElectricNodeHandler.removeConnection(con);
            }
            iterator2.remove();
        }
    }

    @Override
    public boolean canConnect(@NotNull IElectricNode thisNode, @NotNull IElectricNodeHandler other, @NotNull IElectricNode otherNode, @Nullable EnumFacing side) {
        Intrinsics.checkParameterIsNotNull(thisNode, "thisNode");
        Intrinsics.checkParameterIsNotNull(other, "other");
        Intrinsics.checkParameterIsNotNull(otherNode, "otherNode");
        if (Intrinsics.areEqual(other, this) || Intrinsics.areEqual(otherNode, thisNode)) {
            return false;
        }
        if (!this.canConnectAtSide(side)) {
            return false;
        }
        if (side == null) {
            boolean bl;
            block11: {
                boolean bl2;
                IElectricConnection it;
                Iterable $receiver$iv;
                block10: {
                    if (!(thisNode instanceof IWireConnector) || !(otherNode instanceof IWireConnector)) {
                        return false;
                    }
                    if (((IWireConnector)thisNode).getConnectorsSize() != ((IWireConnector)otherNode).getConnectorsSize()) {
                        return false;
                    }
                    Iterable iterable = this.inputWiredConnections;
                    for (Object element$iv : $receiver$iv) {
                        it = (IElectricConnection)element$iv;
                        if (!Intrinsics.areEqual(it.getFirstNode(), otherNode)) continue;
                        bl2 = true;
                        break block10;
                    }
                    bl2 = false;
                }
                if (bl2) {
                    return false;
                }
                $receiver$iv = this.outputWiredConnections;
                for (Object element$iv : $receiver$iv) {
                    it = (IElectricConnection)element$iv;
                    if (!Intrinsics.areEqual(it.getSecondNode(), otherNode)) continue;
                    bl = true;
                    break block11;
                }
                bl = false;
            }
            if (bl) {
                return false;
            }
            Vec3i vec3i = (Vec3i)((IWireConnector)thisNode).getPos();
            Vec3i vec3i2 = (Vec3i)((IWireConnector)otherNode).getPos();
            Intrinsics.checkExpressionValueIsNotNull(vec3i2, "otherNode.pos");
            double distance = IntVectorsKt.getLength(IntVectorsKt.minus(vec3i, vec3i2));
            if (distance > this.getMaxWireDistance()) {
                return false;
            }
        }
        return true;
    }

    @Override
    public void addConnection(@NotNull IElectricConnection connection, @Nullable EnumFacing side, boolean output) {
        Intrinsics.checkParameterIsNotNull(connection, "connection");
        if (side == null) {
            if (output) {
                this.outputWiredConnections.add(connection);
            } else {
                this.inputWiredConnections.add(connection);
            }
            if (this.func_145831_w().field_72995_K) {
                this.wireRender.reset();
            }
        } else if (output) {
            this.outputNormalConnections.add(connection);
        } else {
            this.inputNormalConnections.add(connection);
        }
    }

    @Override
    public void removeConnection(@NotNull IElectricConnection connection) {
        Intrinsics.checkParameterIsNotNull(connection, "connection");
        this.inputNormalConnections.remove(connection);
        this.outputNormalConnections.remove(connection);
        this.inputWiredConnections.remove(connection);
        this.outputWiredConnections.remove(connection);
        if (this.func_145831_w().field_72995_K) {
            this.wireRender.reset();
        }
    }

    public boolean connectWire(@NotNull INodeHandler handler, @NotNull EnumFacing side) {
        Intrinsics.checkParameterIsNotNull(handler, "handler");
        Intrinsics.checkParameterIsNotNull(side, "side");
        return false;
    }

    @Override
    @NotNull
    public List<INode> getNodes() {
        return this.getElectricNodes();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<IElectricConnection> getInputConnections() {
        Collection $receiver$iv$iv;
        SpreadBuilder spreadBuilder;
        void $receiver$iv;
        List<IElectricConnection> list = this.inputNormalConnections;
        List<IElectricConnection> other$iv = this.inputWiredConnections;
        Collection collection = (Collection)$receiver$iv;
        SpreadBuilder spreadBuilder2 = spreadBuilder = new SpreadBuilder(2);
        void v0 = $receiver$iv$iv;
        if (v0 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
        }
        Collection thisCollection$iv$iv = (Collection)v0;
        IElectricConnection[] iElectricConnectionArray = thisCollection$iv$iv.toArray(new IElectricConnection[thisCollection$iv$iv.size()]);
        if (iElectricConnectionArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        Object[] objectArray = iElectricConnectionArray;
        spreadBuilder.addSpread(objectArray);
        $receiver$iv$iv = other$iv;
        spreadBuilder2 = spreadBuilder = spreadBuilder2;
        Collection collection2 = $receiver$iv$iv;
        if (collection2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
        }
        thisCollection$iv$iv = collection2;
        IElectricConnection[] iElectricConnectionArray2 = thisCollection$iv$iv.toArray(new IElectricConnection[thisCollection$iv$iv.size()]);
        if (iElectricConnectionArray2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        objectArray = iElectricConnectionArray2;
        SpreadBuilder spreadBuilder3 = spreadBuilder2;
        spreadBuilder.addSpread(objectArray);
        return CollectionsKt.mutableListOf(spreadBuilder3.toArray(new IElectricConnection[spreadBuilder3.size()]));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<IElectricConnection> getOutputConnections() {
        Collection $receiver$iv$iv;
        SpreadBuilder spreadBuilder;
        void $receiver$iv;
        List<IElectricConnection> list = this.outputNormalConnections;
        List<IElectricConnection> other$iv = this.outputWiredConnections;
        Collection collection = (Collection)$receiver$iv;
        SpreadBuilder spreadBuilder2 = spreadBuilder = new SpreadBuilder(2);
        void v0 = $receiver$iv$iv;
        if (v0 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
        }
        Collection thisCollection$iv$iv = (Collection)v0;
        IElectricConnection[] iElectricConnectionArray = thisCollection$iv$iv.toArray(new IElectricConnection[thisCollection$iv$iv.size()]);
        if (iElectricConnectionArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        Object[] objectArray = iElectricConnectionArray;
        spreadBuilder.addSpread(objectArray);
        $receiver$iv$iv = other$iv;
        spreadBuilder2 = spreadBuilder = spreadBuilder2;
        Collection collection2 = $receiver$iv$iv;
        if (collection2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
        }
        thisCollection$iv$iv = collection2;
        IElectricConnection[] iElectricConnectionArray2 = thisCollection$iv$iv.toArray(new IElectricConnection[thisCollection$iv$iv.size()]);
        if (iElectricConnectionArray2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        objectArray = iElectricConnectionArray2;
        SpreadBuilder spreadBuilder3 = spreadBuilder2;
        spreadBuilder.addSpread(objectArray);
        return CollectionsKt.mutableListOf(spreadBuilder3.toArray(new IElectricConnection[spreadBuilder3.size()]));
    }

    public boolean canConnectAtSide(@Nullable EnumFacing facing) {
        return true;
    }

    @Nullable
    public INodeHandler getNodeHandler(@Nullable EnumFacing facing) {
        return this.canConnectAtSide(facing) ? (INodeHandler)this : (INodeHandler)null;
    }

    public double getMaxWireDistance() {
        return 16.0;
    }

    @Nullable
    public <T> T getCapability(@Nullable Capability<T> capability, @Nullable EnumFacing facing) {
        if (Intrinsics.areEqual(capability, CapabilitiesKt.getNODE_HANDLER())) {
            return (T)this.getNodeHandler(facing);
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean hasCapability(@Nullable Capability<?> capability, @Nullable EnumFacing facing) {
        if (Intrinsics.areEqual(capability, CapabilitiesKt.getNODE_HANDLER())) {
            return this.getNodeHandler(facing) != null;
        }
        return super.hasCapability(capability, facing);
    }

    @Override
    public void func_145839_a(@Nullable NBTTagCompound compound) {
        int i;
        int n;
        NBTTagCompound nBTTagCompound = compound;
        if (nBTTagCompound == null) {
            Intrinsics.throwNpe();
        }
        if (nBTTagCompound.func_74764_b("ElectricNodes")) {
            NBTTagCompound tag = compound.func_74775_l("ElectricNodes");
            IntRange intRange = RangesKt.until(0, this.getElectricNodes().size());
            int n2 = intRange.getFirst();
            if (n2 <= (n = intRange.getLast())) {
                while (true) {
                    this.getElectricNodes().get(i).deserializeNBT((NBTBase)tag.func_74775_l("Node" + i));
                    if (i == n) break;
                    ++i;
                }
            }
        }
        if (compound.func_74764_b("ElectricConnections")) {
            NBTTagList list = compound.func_150295_c("ElectricConnections", 10);
            IntRange intRange = RangesKt.until(0, list.func_74745_c());
            i = intRange.getFirst();
            if (i <= (n = intRange.getLast())) {
                while (true) {
                    NBTTagCompound nBTTagCompound2 = list.func_150305_b(i);
                    Intrinsics.checkExpressionValueIsNotNull(nBTTagCompound2, "list.getCompoundTagAt(i)");
                    this.unloadedConnections.add(UnloadedElectricConnection.Companion.load(nBTTagCompound2));
                    if (i == n) break;
                    ++i;
                }
            }
        }
        super.func_145839_a(compound);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public NBTTagCompound func_189515_b(@Nullable NBTTagCompound compound) {
        int n;
        NBTTagCompound tag = new NBTTagCompound();
        IntRange intRange = RangesKt.until(0, this.getElectricNodes().size());
        int n2 = intRange.getFirst();
        if (n2 <= (n = intRange.getLast())) {
            while (true) {
                void i;
                tag.func_74782_a("Node" + (int)i, this.getElectricNodes().get((int)i).serializeNBT());
                if (i == n) break;
                ++i;
            }
        }
        NBTTagCompound nBTTagCompound = compound;
        if (nBTTagCompound == null) {
            Intrinsics.throwNpe();
        }
        nBTTagCompound.func_74782_a("ElectricNodes", (NBTBase)tag);
        NBTTagList list = new NBTTagList();
        for (IElectricConnection i : this.outputWiredConnections) {
            list.func_74742_a((NBTBase)UnloadedElectricConnection.Companion.save(i));
        }
        for (UnloadedElectricConnection i : this.unloadedConnections) {
            if (!i.isValid()) continue;
            list.func_74742_a((NBTBase)UnloadedElectricConnection.Companion.save(i));
        }
        compound.func_74782_a("ElectricConnections", (NBTBase)list);
        return super.func_189515_b(compound);
    }

    @Override
    public void onBreak() {
        IElectricNodeHandler handler;
        IElectricConnection con;
        super.onBreak();
        this.clearNormalConnections();
        this.clearWireConnections();
        TileElectricBase tileElectricBase = this;
        TileElectricBase it = tileElectricBase;
        Iterator<IElectricConnection> iterator2 = this.inputNormalConnections.iterator();
        while (iterator2.hasNext()) {
            con = iterator2.next();
            IElectricNode iElectricNode = con.getFirstNode();
            Intrinsics.checkExpressionValueIsNotNull(iElectricNode, "con.firstNode");
            IElectricNodeHandler iElectricNodeHandler = handler = Companion.getHandler(iElectricNode);
            if (iElectricNodeHandler != null) {
                iElectricNodeHandler.removeConnection(con);
            }
            iterator2.remove();
        }
        tileElectricBase = this;
        it = tileElectricBase;
        iterator2 = this.inputWiredConnections.iterator();
        while (iterator2.hasNext()) {
            con = iterator2.next();
            IElectricNode iElectricNode = con.getFirstNode();
            Intrinsics.checkExpressionValueIsNotNull(iElectricNode, "con.firstNode");
            IElectricNodeHandler iElectricNodeHandler = handler = Companion.getHandler(iElectricNode);
            if (iElectricNodeHandler != null) {
                iElectricNodeHandler.removeConnection(con);
            }
            iterator2.remove();
        }
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var2_2;
        void $receiver$iv$iv;
        Companion = new Companion(null);
        Object[] $receiver$iv = EnumFacing.values();
        Object[] objectArray = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (int i = 0; i < ((void)$receiver$iv$iv).length; ++i) {
            void element$iv$iv = $receiver$iv$iv[i];
            EnumFacing it = (EnumFacing)element$iv$iv;
            if (!Intrinsics.areEqual(it.func_176743_c(), EnumFacing.AxisDirection.NEGATIVE)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        NEGATIVE_DIRECTIONS = (List)var2_2;
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JJ\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u001a\b\u0002\u0010\u0013\u001a\u0014\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00150\u0014J2\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00182\u001a\b\u0002\u0010\u0013\u001a\u0014\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00150\u0014J&\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u0012J\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0011\u001a\u00020\u001eJ2\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020 0!J\u001e\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020#2\u0006\u0010%\u001a\u00020#2\u0006\u0010&\u001a\u00020#J!\u0010'\u001a\u00020\u0015*\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f0(2\u0006\u0010)\u001a\u00020\u000fH\u0086\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006*"}, d2={"Lcom/cout970/magneticraft/tileentity/electric/TileElectricBase$Companion;", "", "()V", "NEGATIVE_DIRECTIONS", "", "Lnet/minecraft/util/EnumFacing;", "getNEGATIVE_DIRECTIONS", "()Ljava/util/List;", "autoConnectWires", "", "tile", "Lcom/cout970/magneticraft/tileentity/electric/TileElectricBase;", "world", "Lnet/minecraft/world/World;", "start", "Lnet/minecraft/util/math/BlockPos;", "end", "node", "Lcom/cout970/magneticraft/api/energy/IWireConnector;", "filter", "Lkotlin/Function2;", "", "connectHandlers", "first", "Lcom/cout970/magneticraft/api/energy/IElectricNodeHandler;", "second", "connectNodes", "firstNode", "secondNode", "getHandler", "Lcom/cout970/magneticraft/api/energy/IElectricNode;", "getTileEntitiesIn", "Lnet/minecraft/tileentity/TileEntity;", "Lcom/google/common/base/Predicate;", "interpolate", "", "v", "min", "max", "contains", "Lkotlin/Pair;", "pos", "magneticraft-compileKotlin"})
    public static final class Companion {
        @NotNull
        public final List<EnumFacing> getNEGATIVE_DIRECTIONS() {
            return NEGATIVE_DIRECTIONS;
        }

        public final double interpolate(double v, double min, double max) {
            if (v < min) {
                return 0.0;
            }
            if (v > max) {
                return 1.0;
            }
            return (v - min) / (max - min);
        }

        public final void autoConnectWires(@NotNull TileElectricBase tile, @NotNull World world, @NotNull BlockPos start, @NotNull BlockPos end, @NotNull IWireConnector node2, @NotNull Function2<? super IWireConnector, ? super IWireConnector, Boolean> filter) {
            Intrinsics.checkParameterIsNotNull(tile, "tile");
            Intrinsics.checkParameterIsNotNull(world, "world");
            Intrinsics.checkParameterIsNotNull(start, "start");
            Intrinsics.checkParameterIsNotNull(end, "end");
            Intrinsics.checkParameterIsNotNull(node2, "node");
            Intrinsics.checkParameterIsNotNull(filter, "filter");
            Predicate predicate2 = (Predicate)new Predicate<TileEntity>(tile){
                final /* synthetic */ TileElectricBase $tile;

                public final boolean apply(@Nullable TileEntity it) {
                    return Intrinsics.areEqual(it, this.$tile) ^ true;
                }
                {
                    this.$tile = tileElectricBase;
                }
            };
            for (TileEntity t : this.getTileEntitiesIn(world, start, end, (Predicate<TileEntity>)predicate2)) {
                INodeHandler handler;
                Capability<INodeHandler> capability = CapabilitiesKt.getNODE_HANDLER();
                if (capability == null) {
                    Intrinsics.throwNpe();
                }
                if (!((handler = (INodeHandler)CapabilitiesKt.fromTile$default(capability, t, null, 2, null)) instanceof IElectricNodeHandler)) continue;
                this.connectHandlers(tile, (IElectricNodeHandler)handler, filter);
            }
        }

        public static /* bridge */ /* synthetic */ void autoConnectWires$default(Companion companion, TileElectricBase tileElectricBase, World world, BlockPos blockPos, BlockPos blockPos2, IWireConnector iWireConnector, Function2 function2, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: autoConnectWires");
            }
            if ((n & 0x20) != 0) {
                function2 = autoConnectWires.1.INSTANCE;
            }
            companion.autoConnectWires(tileElectricBase, world, blockPos, blockPos2, iWireConnector, function2);
        }

        public final boolean connectHandlers(@NotNull IElectricNodeHandler first, @NotNull IElectricNodeHandler second, @NotNull Function2<? super IWireConnector, ? super IWireConnector, Boolean> filter) {
            IWireConnector iWireConnector;
            Collection collection;
            Iterable destination$iv$iv;
            INode it;
            Iterable $receiver$iv$iv;
            Iterable $receiver$iv;
            Intrinsics.checkParameterIsNotNull(first, "first");
            Intrinsics.checkParameterIsNotNull(second, "second");
            Intrinsics.checkParameterIsNotNull(filter, "filter");
            boolean result = false;
            Iterable iterable = first.getNodes();
            Iterator iterator2 = $receiver$iv;
            Collection collection2 = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                it = (INode)element$iv$iv;
                if (!(it instanceof IWireConnector)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $receiver$iv = (List)destination$iv$iv;
            $receiver$iv$iv = $receiver$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                it = (INode)item$iv$iv;
                collection = destination$iv$iv;
                INode iNode = it;
                if (iNode == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.cout970.magneticraft.api.energy.IWireConnector");
                }
                iWireConnector = (IWireConnector)iNode;
                collection.add(iWireConnector);
            }
            for (IWireConnector firstNode : (List)destination$iv$iv) {
                Collection destination$iv$iv2;
                INode it2;
                Iterable $receiver$iv$iv2;
                Iterable $receiver$iv2;
                Object item$iv$iv;
                destination$iv$iv = second.getNodes();
                Iterator iterator3 = $receiver$iv2;
                item$iv$iv = new ArrayList();
                for (Object element$iv$iv : $receiver$iv$iv2) {
                    it2 = (INode)element$iv$iv;
                    if (!(it2 instanceof IWireConnector)) continue;
                    destination$iv$iv2.add(element$iv$iv);
                }
                $receiver$iv2 = (List)destination$iv$iv2;
                $receiver$iv$iv2 = $receiver$iv2;
                destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv2, 10));
                for (Object item$iv$iv2 : $receiver$iv$iv2) {
                    it2 = (INode)item$iv$iv2;
                    collection = destination$iv$iv2;
                    INode iNode = it2;
                    if (iNode == null) {
                        throw new TypeCastException("null cannot be cast to non-null type com.cout970.magneticraft.api.energy.IWireConnector");
                    }
                    iWireConnector = (IWireConnector)iNode;
                    collection.add(iWireConnector);
                }
                for (IWireConnector secondNode : (List)destination$iv$iv2) {
                    if (!filter.invoke(firstNode, secondNode).booleanValue() || !this.connectNodes(first, firstNode, second, secondNode)) continue;
                    result = true;
                }
            }
            return result;
        }

        public static /* bridge */ /* synthetic */ boolean connectHandlers$default(Companion companion, IElectricNodeHandler iElectricNodeHandler, IElectricNodeHandler iElectricNodeHandler2, Function2 function2, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: connectHandlers");
            }
            if ((n & 4) != 0) {
                function2 = connectHandlers.1.INSTANCE;
            }
            return companion.connectHandlers(iElectricNodeHandler, iElectricNodeHandler2, function2);
        }

        public final boolean connectNodes(@NotNull IElectricNodeHandler first, @NotNull IWireConnector firstNode, @NotNull IElectricNodeHandler second, @NotNull IWireConnector secondNode) {
            Intrinsics.checkParameterIsNotNull(first, "first");
            Intrinsics.checkParameterIsNotNull(firstNode, "firstNode");
            Intrinsics.checkParameterIsNotNull(second, "second");
            Intrinsics.checkParameterIsNotNull(secondNode, "secondNode");
            if (first.canConnect(firstNode, second, secondNode, null) && second.canConnect(secondNode, first, firstNode, null)) {
                ElectricConnection connection = new ElectricConnection(firstNode, secondNode);
                first.addConnection(connection, null, true);
                second.addConnection(connection, null, false);
                return true;
            }
            return false;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<TileEntity> getTileEntitiesIn(@NotNull World world, @NotNull BlockPos start, @NotNull BlockPos end, @NotNull Predicate<TileEntity> filter) {
            Intrinsics.checkParameterIsNotNull(world, "world");
            Intrinsics.checkParameterIsNotNull(start, "start");
            Intrinsics.checkParameterIsNotNull(end, "end");
            Intrinsics.checkParameterIsNotNull(filter, "filter");
            List<TileEntity> list = CollectionsKt.mutableListOf(new TileEntity[0]);
            IntProgression intProgression = RangesKt.step(new IntRange(start.func_177958_n(), end.func_177958_n()), 16);
            int n = intProgression.getFirst();
            int n2 = intProgression.getLast();
            int n3 = intProgression.getStep();
            int n4 = n;
            int n5 = n2;
            if (n3 > 0 ? n4 <= n5 : n4 >= n5) {
                while (true) {
                    void x;
                    IntProgression intProgression2 = RangesKt.step(new IntRange(start.func_177952_p(), end.func_177952_p()), 16);
                    int n6 = intProgression2.getFirst();
                    int n7 = intProgression2.getLast();
                    int n8 = intProgression2.getStep();
                    int n9 = n6;
                    int n10 = n7;
                    if (n8 > 0 ? n9 <= n10 : n9 >= n10) {
                        while (true) {
                            void z;
                            Chunk chunk = world.func_72964_e((int)(x >> 4), (int)(z >> 4));
                            Map map = chunk.func_177434_r();
                            Iterator iterator2 = map.entrySet().iterator();
                            while (iterator2.hasNext()) {
                                Map.Entry entry;
                                Map.Entry entry2 = entry = iterator2.next();
                                BlockPos pos = (BlockPos)entry2.getKey();
                                Map.Entry entry3 = entry;
                                TileEntity tile = (TileEntity)entry3.getValue();
                                if (tile.func_145837_r()) continue;
                                Pair<BlockPos, BlockPos> pair = TuplesKt.to(start, end);
                                BlockPos blockPos = pos;
                                Intrinsics.checkExpressionValueIsNotNull(blockPos, "pos");
                                if (!this.contains(pair, blockPos) || !filter.apply((Object)tile)) continue;
                                TileEntity tileEntity = tile;
                                Intrinsics.checkExpressionValueIsNotNull(tileEntity, "tile");
                                list.add(tileEntity);
                            }
                            if (z == n7) break;
                            z += n8;
                        }
                    }
                    if (x == n2) break;
                    x += n3;
                }
            }
            return list;
        }

        @Nullable
        public final IElectricNodeHandler getHandler(@NotNull IElectricNode node2) {
            Intrinsics.checkParameterIsNotNull(node2, "node");
            TileEntity tile = node2.getWorld().func_175625_s(node2.getPos());
            if (tile != null) {
                INodeHandler handler;
                Capability<INodeHandler> capability = CapabilitiesKt.getNODE_HANDLER();
                if (capability == null) {
                    Intrinsics.throwNpe();
                }
                if ((handler = (INodeHandler)CapabilitiesKt.fromTile$default(capability, tile, null, 2, null)) instanceof IElectricNodeHandler) {
                    return (IElectricNodeHandler)handler;
                }
            }
            return null;
        }

        public final boolean contains(@NotNull Pair<? extends BlockPos, ? extends BlockPos> $receiver, @NotNull BlockPos pos) {
            Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
            Intrinsics.checkParameterIsNotNull(pos, "pos");
            return pos.func_177958_n() >= $receiver.getFirst().func_177958_n() && pos.func_177958_n() <= $receiver.getSecond().func_177958_n() && pos.func_177956_o() >= $receiver.getFirst().func_177956_o() && pos.func_177956_o() <= $receiver.getSecond().func_177956_o() && pos.func_177952_p() >= $receiver.getFirst().func_177952_p() && pos.func_177952_p() <= $receiver.getSecond().func_177952_p();
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

