/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.tileentity.electric;

import coffee.cypher.mcextlib.extensions.vectors.IntVectorsKt;
import com.cout970.magneticraft.api.energy.IElectricNode;
import com.cout970.magneticraft.api.energy.IElectricNodeHandler;
import com.cout970.magneticraft.api.energy.INodeHandler;
import com.cout970.magneticraft.api.internal.energy.ElectricConnection;
import com.cout970.magneticraft.api.internal.energy.ElectricNode;
import com.cout970.magneticraft.block.SharedPropertiesKt;
import com.cout970.magneticraft.integration.IntegrationHandler;
import com.cout970.magneticraft.integration.tesla.TeslaNodeWrapper;
import com.cout970.magneticraft.registry.CapabilitiesKt;
import com.cout970.magneticraft.tileentity.electric.TileElectricBase;
import com.cout970.magneticraft.tileentity.electric.connectors.ElectricConnector;
import com.cout970.magneticraft.util.MathKt;
import com.cout970.magneticraft.util.MinecraftUtilsKt;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KProperty;
import net.darkhax.tesla.api.ITeslaConsumer;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 92\u00020\u0001:\u00019B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010 \u001a\u00020\t2\b\u0010!\u001a\u0004\u0018\u00010\"H\u0016J\u0018\u0010#\u001a\u00020\t2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\"H\u0016J/\u0010'\u001a\u0004\u0018\u0001H(\"\u0004\b\u0000\u0010(2\u000e\u0010)\u001a\n\u0012\u0004\u0012\u0002H(\u0018\u00010*2\b\u0010!\u001a\u0004\u0018\u00010\"H\u0017\u00a2\u0006\u0002\u0010+J\u0006\u0010,\u001a\u00020\"J\b\u0010-\u001a\u00020.H\u0016J\b\u0010/\u001a\u000200H\u0016J \u00101\u001a\u00020\t2\f\u0010)\u001a\b\u0012\u0002\b\u0003\u0018\u00010*2\b\u0010!\u001a\u0004\u0018\u00010\"H\u0016J\u0010\u00102\u001a\u0002032\u0006\u00104\u001a\u000205H\u0016J\b\u00106\u001a\u000205H\u0016J\b\u00107\u001a\u000203H\u0016J\b\u00108\u001a\u000203H\u0016R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0019\u0010\u0014\u001a\u0004\u0018\u00010\u00158F\u00a2\u0006\f\n\u0004\b\u0018\u0010\u0019\u001a\u0004\b\u0016\u0010\u0017R\u001a\u0010\u001a\u001a\u00020\u001bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001f\u00a8\u0006:"}, d2={"Lcom/cout970/magneticraft/tileentity/electric/TileElectricConnector;", "Lcom/cout970/magneticraft/tileentity/electric/TileElectricBase;", "()V", "electricNodes", "", "Lcom/cout970/magneticraft/api/energy/IElectricNode;", "getElectricNodes", "()Ljava/util/List;", "hasBase", "", "getHasBase", "()Z", "setHasBase", "(Z)V", "mainNode", "Lcom/cout970/magneticraft/tileentity/electric/connectors/ElectricConnector;", "getMainNode", "()Lcom/cout970/magneticraft/tileentity/electric/connectors/ElectricConnector;", "setMainNode", "(Lcom/cout970/magneticraft/tileentity/electric/connectors/ElectricConnector;)V", "teslaWrapper", "", "getTeslaWrapper", "()Ljava/lang/Object;", "teslaWrapper$delegate", "Lkotlin/Lazy;", "tickToNextUpdate", "", "getTickToNextUpdate", "()I", "setTickToNextUpdate", "(I)V", "canConnectAtSide", "facing", "Lnet/minecraft/util/EnumFacing;", "connectWire", "handler", "Lcom/cout970/magneticraft/api/energy/INodeHandler;", "side", "getCapability", "T", "capability", "Lnet/minecraftforge/common/capabilities/Capability;", "(Lnet/minecraftforge/common/capabilities/Capability;Lnet/minecraft/util/EnumFacing;)Ljava/lang/Object;", "getFacing", "getMaxWireDistance", "", "getRenderBoundingBox", "Lnet/minecraft/util/math/AxisAlignedBB;", "hasCapability", "load", "", "nbt", "Lnet/minecraft/nbt/NBTTagCompound;", "save", "update", "updateWiredConnections", "Companion", "magneticraft-compileKotlin"})
public final class TileElectricConnector
extends TileElectricBase {
    @NotNull
    private ElectricConnector mainNode = new ElectricConnector(new ElectricNode(new Function0<World>(this){
        final /* synthetic */ TileElectricConnector this$0;

        public final World invoke() {
            World world = this.this$0.func_145831_w();
            Intrinsics.checkExpressionValueIsNotNull(world, "world");
            return world;
        }
        {
            this.this$0 = tileElectricConnector;
            super(0);
        }
    }, new Function0<BlockPos>(this){
        final /* synthetic */ TileElectricConnector this$0;

        public final BlockPos invoke() {
            BlockPos blockPos = TileElectricConnector.access$getPos$p(this.this$0);
            Intrinsics.checkExpressionValueIsNotNull(blockPos, "pos");
            return blockPos;
        }
        {
            this.this$0 = tileElectricConnector;
            super(0);
        }
    }, 0.0, 0.0, 12, null), this);
    private boolean hasBase = true;
    private int tickToNextUpdate;
    @Nullable
    private final Lazy teslaWrapper$delegate = LazyKt.lazy((Function0)new Function0<TeslaNodeWrapper>(this){
        final /* synthetic */ TileElectricConnector this$0;

        @Nullable
        public final TeslaNodeWrapper invoke() {
            return IntegrationHandler.INSTANCE.getTESLA() ? new TeslaNodeWrapper(this.this$0.getMainNode()) : (TeslaNodeWrapper)null;
        }
        {
            this.this$0 = tileElectricConnector;
            super(0);
        }
    });
    private static final double MAX_WIRE_DISTANCE = 8.0;
    private static final /* synthetic */ KProperty[] $$delegatedProperties;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final ElectricConnector getMainNode() {
        return this.mainNode;
    }

    public final void setMainNode(@NotNull ElectricConnector electricConnector) {
        Intrinsics.checkParameterIsNotNull(electricConnector, "<set-?>");
        this.mainNode = electricConnector;
    }

    @Override
    @NotNull
    public List<IElectricNode> getElectricNodes() {
        return CollectionsKt.listOf(this.mainNode);
    }

    public final boolean getHasBase() {
        return this.hasBase;
    }

    public final void setHasBase(boolean bl) {
        this.hasBase = bl;
    }

    public final int getTickToNextUpdate() {
        return this.tickToNextUpdate;
    }

    public final void setTickToNextUpdate(int n) {
        this.tickToNextUpdate = n;
    }

    @Nullable
    public final Object getTeslaWrapper() {
        Lazy lazy = this.teslaWrapper$delegate;
        TileElectricConnector tileElectricConnector = this;
        KProperty kProperty = $$delegatedProperties[0];
        return lazy.getValue();
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.field_145850_b.field_72995_K) {
            if (this.tickToNextUpdate > 0) {
                int n = this.tickToNextUpdate;
                this.tickToNextUpdate = n + -1;
            }
            if (IntegrationHandler.INSTANCE.getTESLA()) {
                TileEntity tileEntity = this.field_145850_b.func_175625_s(IntVectorsKt.toBlockPos((Vec3i)MathKt.plus(this.field_174879_c, this.getFacing())));
                if (tileEntity == null) {
                    return;
                }
                TileEntity tile = tileEntity;
                Capability<ITeslaConsumer> capability = CapabilitiesKt.getTESLA_CONSUMER();
                if (capability == null) {
                    Intrinsics.throwNpe();
                }
                TileEntity tileEntity2 = tile;
                Intrinsics.checkExpressionValueIsNotNull(tileEntity2, "tile");
                ITeslaConsumer iTeslaConsumer = CapabilitiesKt.fromTile(capability, tileEntity2, this.getFacing().func_176734_d());
                if (iTeslaConsumer == null) {
                    return;
                }
                ITeslaConsumer consumer = iTeslaConsumer;
                Object object = this.getTeslaWrapper();
                if (object == null) {
                    Intrinsics.throwNpe();
                }
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.cout970.magneticraft.integration.tesla.TeslaNodeWrapper");
                }
                TeslaNodeWrapper node2 = (TeslaNodeWrapper)object;
                long accepted = consumer.givePower(Math.min(node2.getStoredPower(), 200L), true);
                if (accepted > (long)0) {
                    node2.takePower(consumer.givePower(accepted, false), false);
                }
            }
        }
    }

    @Override
    @NotNull
    public NBTTagCompound save() {
        return new NBTTagCompound();
    }

    @Override
    public void load(@NotNull NBTTagCompound nbt) {
        Intrinsics.checkParameterIsNotNull(nbt, "nbt");
    }

    @NotNull
    public AxisAlignedBB getRenderBoundingBox() {
        AxisAlignedBB axisAlignedBB = TileEntity.INFINITE_EXTENT_AABB;
        Intrinsics.checkExpressionValueIsNotNull(axisAlignedBB, "INFINITE_EXTENT_AABB");
        return axisAlignedBB;
    }

    @Override
    public void updateWiredConnections() {
        TileEntity tile;
        EnumFacing dir = this.getFacing();
        if (Intrinsics.areEqual(dir.func_176743_c(), EnumFacing.AxisDirection.NEGATIVE) && (tile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177967_a(dir, 2))) instanceof TileElectricConnector && this.canConnect(this.mainNode, (IElectricNodeHandler)tile, ((TileElectricConnector)tile).mainNode, dir) && ((TileElectricConnector)tile).canConnect(((TileElectricConnector)tile).mainNode, this, this.mainNode, dir.func_176734_d())) {
            ElectricConnection connection = new ElectricConnection(this.mainNode, ((TileElectricConnector)tile).mainNode);
            this.addConnection(connection, dir, true);
            ((TileElectricConnector)tile).addConnection(connection, dir.func_176734_d(), false);
        }
        if (this.getAutoConnectWires()) {
            TileElectricBase tileElectricBase = this;
            World world = this.func_145831_w();
            Intrinsics.checkExpressionValueIsNotNull(world, "world");
            BlockPos blockPos = this.field_174879_c.func_177973_b(new Vec3i(16, 5, 16));
            Intrinsics.checkExpressionValueIsNotNull(blockPos, "pos.subtract(Vec3i(16, 5, 16))");
            BlockPos blockPos2 = this.field_174879_c.func_177971_a(new Vec3i(16, 5, 16));
            Intrinsics.checkExpressionValueIsNotNull(blockPos2, "pos.add(Vec3i(16, 5, 16))");
            TileElectricBase.Companion.autoConnectWires$default(TileElectricBase.Companion, tileElectricBase, world, blockPos, blockPos2, this.mainNode, null, 32, null);
        }
        super.updateWiredConnections();
    }

    @NotNull
    public final EnumFacing getFacing() {
        IBlockState state = this.getBlockState();
        if (MinecraftUtilsKt.isIn((IProperty)SharedPropertiesKt.getPROPERTY_FACING(), state)) {
            EnumFacing enumFacing = (EnumFacing)MinecraftUtilsKt.get((IProperty)SharedPropertiesKt.getPROPERTY_FACING(), state);
            Intrinsics.checkExpressionValueIsNotNull(enumFacing, "PROPERTY_FACING[state]");
            return enumFacing;
        }
        return EnumFacing.DOWN;
    }

    @Override
    public boolean canConnectAtSide(@Nullable EnumFacing facing) {
        return facing == null || Intrinsics.areEqual(facing, this.getFacing());
    }

    @Override
    public double getMaxWireDistance() {
        return Companion.getMAX_WIRE_DISTANCE();
    }

    @Override
    public boolean connectWire(@NotNull INodeHandler handler, @NotNull EnumFacing side) {
        Intrinsics.checkParameterIsNotNull(handler, "handler");
        Intrinsics.checkParameterIsNotNull(side, "side");
        boolean result = false;
        if (Intrinsics.areEqual(handler, this) || !(handler instanceof IElectricNodeHandler)) {
            return result;
        }
        result = TileElectricBase.Companion.connectHandlers$default(TileElectricBase.Companion, this, (IElectricNodeHandler)handler, null, 4, null);
        this.getWireRender().reset();
        return result;
    }

    @Override
    @Nullable
    public <T> T getCapability(@Nullable Capability<T> capability, @Nullable EnumFacing facing) {
        if (Intrinsics.areEqual(facing, this.getFacing()) && (Intrinsics.areEqual(capability, CapabilitiesKt.getTESLA_CONSUMER()) || Intrinsics.areEqual(capability, CapabilitiesKt.getTESLA_PRODUCER()) || Intrinsics.areEqual(capability, CapabilitiesKt.getTESLA_STORAGE()))) {
            return (T)this.getTeslaWrapper();
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public boolean hasCapability(@Nullable Capability<?> capability, @Nullable EnumFacing facing) {
        if (Intrinsics.areEqual(facing, this.getFacing()) && (Intrinsics.areEqual(capability, CapabilitiesKt.getTESLA_CONSUMER()) || Intrinsics.areEqual(capability, CapabilitiesKt.getTESLA_PRODUCER()) || Intrinsics.areEqual(capability, CapabilitiesKt.getTESLA_STORAGE()))) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    static {
        MAX_WIRE_DISTANCE = 8.0;
        $$delegatedProperties = new KProperty[]{Reflection.property1(new PropertyReference1Impl(Reflection.getOrCreateKotlinClass(TileElectricConnector.class), "teslaWrapper", "getTeslaWrapper()Ljava/lang/Object;"))};
    }

    public static final /* synthetic */ BlockPos access$getPos$p(TileElectricConnector $this) {
        return $this.field_174879_c;
    }

    public static final /* synthetic */ void access$setPos$p(TileElectricConnector $this, BlockPos blockPos) {
        $this.field_174879_c = blockPos;
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/cout970/magneticraft/tileentity/electric/TileElectricConnector$Companion;", "", "()V", "MAX_WIRE_DISTANCE", "", "getMAX_WIRE_DISTANCE", "()D", "magneticraft-compileKotlin"})
    public static final class Companion {
        public final double getMAX_WIRE_DISTANCE() {
            return MAX_WIRE_DISTANCE;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

