/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.tileentity.electric;

import coffee.cypher.mcextlib.extensions.inventories.InventoriesKt;
import com.cout970.magneticraft.api.energy.IElectricNode;
import com.cout970.magneticraft.api.internal.energy.ElectricNode;
import com.cout970.magneticraft.config.Config;
import com.cout970.magneticraft.registry.CapabilitiesKt;
import com.cout970.magneticraft.tileentity.electric.TileElectricBase;
import com.cout970.magneticraft.util.EletricityKt;
import com.cout970.magneticraft.util.misc.ValueAverage;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 .2\u00020\u0001:\u0002./B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u001c\u001a\u00020\u001dJ/\u0010\u001e\u001a\u0004\u0018\u0001H\u001f\"\u0004\b\u0000\u0010\u001f2\u000e\u0010 \u001a\n\u0012\u0004\u0012\u0002H\u001f\u0018\u00010!2\b\u0010\"\u001a\u0004\u0018\u00010#H\u0017\u00a2\u0006\u0002\u0010$J \u0010%\u001a\u00020\u001d2\f\u0010 \u001a\b\u0012\u0002\b\u0003\u0018\u00010!2\b\u0010\"\u001a\u0004\u0018\u00010#H\u0016J\u0010\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)H\u0016J\b\u0010*\u001a\u00020'H\u0016J\b\u0010+\u001a\u00020)H\u0016J\u0006\u0010,\u001a\u00020'J\b\u0010-\u001a\u00020'H\u0016R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0015\u0010\u000e\u001a\u00060\u000fR\u00020\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0018\u001a\u00020\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001b\u00a8\u00060"}, d2={"Lcom/cout970/magneticraft/tileentity/electric/TileElectricFurnace;", "Lcom/cout970/magneticraft/tileentity/electric/TileElectricBase;", "()V", "burningTime", "", "getBurningTime", "()F", "setBurningTime", "(F)V", "electricNodes", "", "Lcom/cout970/magneticraft/api/energy/IElectricNode;", "getElectricNodes", "()Ljava/util/List;", "inventory", "Lcom/cout970/magneticraft/tileentity/electric/TileElectricFurnace$Inventory;", "getInventory", "()Lcom/cout970/magneticraft/tileentity/electric/TileElectricFurnace$Inventory;", "mainNode", "Lcom/cout970/magneticraft/api/internal/energy/ElectricNode;", "getMainNode", "()Lcom/cout970/magneticraft/api/internal/energy/ElectricNode;", "setMainNode", "(Lcom/cout970/magneticraft/api/internal/energy/ElectricNode;)V", "production", "Lcom/cout970/magneticraft/util/misc/ValueAverage;", "getProduction", "()Lcom/cout970/magneticraft/util/misc/ValueAverage;", "canSmelt", "", "getCapability", "T", "capability", "Lnet/minecraftforge/common/capabilities/Capability;", "facing", "Lnet/minecraft/util/EnumFacing;", "(Lnet/minecraftforge/common/capabilities/Capability;Lnet/minecraft/util/EnumFacing;)Ljava/lang/Object;", "hasCapability", "load", "", "nbt", "Lnet/minecraft/nbt/NBTTagCompound;", "onBreak", "save", "smelt", "update", "Companion", "Inventory", "magneticraft-compileKotlin"})
public final class TileElectricFurnace
extends TileElectricBase {
    @NotNull
    private ElectricNode mainNode = new ElectricNode(new Function0<World>(this){
        final /* synthetic */ TileElectricFurnace this$0;

        public final World invoke() {
            World world = this.this$0.func_145831_w();
            Intrinsics.checkExpressionValueIsNotNull(world, "world");
            return world;
        }
        {
            this.this$0 = tileElectricFurnace;
            super(0);
        }
    }, new Function0<BlockPos>(this){
        final /* synthetic */ TileElectricFurnace this$0;

        public final BlockPos invoke() {
            BlockPos blockPos = TileElectricFurnace.access$getPos$p(this.this$0);
            Intrinsics.checkExpressionValueIsNotNull(blockPos, "pos");
            return blockPos;
        }
        {
            this.this$0 = tileElectricFurnace;
            super(0);
        }
    }, 0.0, 1.25, 4, null);
    @NotNull
    private final Inventory inventory = new Inventory();
    private float burningTime;
    @NotNull
    private final ValueAverage production = new ValueAverage(0, 1, null);
    private static final float MAX_BURNING_TIME = 100.0f;
    private static final int SPEED = 2;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final ElectricNode getMainNode() {
        return this.mainNode;
    }

    public final void setMainNode(@NotNull ElectricNode electricNode) {
        Intrinsics.checkParameterIsNotNull(electricNode, "<set-?>");
        this.mainNode = electricNode;
    }

    @Override
    @NotNull
    public List<IElectricNode> getElectricNodes() {
        return CollectionsKt.listOf(this.mainNode);
    }

    @NotNull
    public final Inventory getInventory() {
        return this.inventory;
    }

    public final float getBurningTime() {
        return this.burningTime;
    }

    public final void setBurningTime(float f) {
        this.burningTime = f;
    }

    @NotNull
    public final ValueAverage getProduction() {
        return this.production;
    }

    @Override
    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.mainNode.getVoltage() >= EletricityKt.getTIER_1_MACHINES_MIN_VOLTAGE() && this.canSmelt()) {
                double applied = this.mainNode.applyPower(-Config.INSTANCE.getElectricFurnaceMaxConsumption() * TileElectricBase.Companion.interpolate(this.mainNode.getVoltage(), 60.0, 70.0), false);
                this.burningTime += (float)Companion.getSPEED() * (float)applied / (float)Config.INSTANCE.getElectricFurnaceMaxConsumption();
                this.production.plusAssign(applied);
                if (this.burningTime > Companion.getMAX_BURNING_TIME()) {
                    this.smelt();
                    this.burningTime -= Companion.getMAX_BURNING_TIME();
                }
            }
            this.production.tick();
        }
        super.func_73660_a();
    }

    public final boolean canSmelt() {
        if (InventoriesKt.get((IItemHandler)this.inventory, 0) == null) {
            return false;
        }
        ItemStack itemStack = FurnaceRecipes.func_77602_a().func_151395_a(InventoriesKt.get((IItemHandler)this.inventory, 0));
        if (itemStack == null) {
            return false;
        }
        ItemStack result = itemStack;
        if (InventoriesKt.get((IItemHandler)this.inventory, 1) == null) {
            return true;
        }
        this.inventory.setIgnoreFilter(true);
        boolean ret = this.inventory.insertItem(1, result, true) == null;
        this.inventory.setIgnoreFilter(false);
        return ret;
    }

    public final void smelt() {
        this.inventory.setIgnoreFilter(true);
        ItemStack item = this.inventory.extractItem(0, 1, false);
        ItemStack itemStack = FurnaceRecipes.func_77602_a().func_151395_a(item);
        ItemStack result = itemStack != null ? itemStack.func_77946_l() : null;
        this.inventory.insertItem(1, result, false);
        this.inventory.setIgnoreFilter(false);
    }

    @Override
    @NotNull
    public NBTTagCompound save() {
        NBTTagCompound nBTTagCompound = new NBTTagCompound();
        NBTTagCompound $receiver = nBTTagCompound;
        $receiver.func_74782_a("inventory", (NBTBase)this.inventory.serializeNBT());
        $receiver.func_74776_a("burningTime", this.burningTime);
        return nBTTagCompound;
    }

    @Override
    public void load(@NotNull NBTTagCompound nbt) {
        Intrinsics.checkParameterIsNotNull(nbt, "nbt");
        this.inventory.deserializeNBT(nbt.func_74775_l("inventory"));
        this.burningTime = nbt.func_74760_g("burningTime");
    }

    @Override
    @Nullable
    public <T> T getCapability(@Nullable Capability<T> capability, @Nullable EnumFacing facing) {
        if (Intrinsics.areEqual(capability, CapabilitiesKt.getITEM_HANDLER())) {
            return (T)((Object)this.inventory);
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public boolean hasCapability(@Nullable Capability<?> capability, @Nullable EnumFacing facing) {
        if (Intrinsics.areEqual(capability, CapabilitiesKt.getITEM_HANDLER())) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onBreak() {
        super.onBreak();
        if (!this.field_145850_b.field_72995_K) {
            int n;
            IntRange intRange = RangesKt.until(0, this.inventory.getSlots());
            int n2 = intRange.getFirst();
            if (n2 <= (n = intRange.getLast())) {
                while (true) {
                    void i;
                    ItemStack item;
                    if ((item = InventoriesKt.get((IItemHandler)this.inventory, (int)i)) != null) {
                        BlockPos blockPos = this.field_174879_c;
                        Intrinsics.checkExpressionValueIsNotNull(blockPos, "pos");
                        this.dropItem(item, blockPos);
                    }
                    if (i == n) break;
                    ++i;
                }
            }
        }
    }

    static {
        MAX_BURNING_TIME = 100.0f;
        SPEED = 2;
    }

    public static final /* synthetic */ BlockPos access$getPos$p(TileElectricFurnace $this) {
        return $this.field_174879_c;
    }

    public static final /* synthetic */ void access$setPos$p(TileElectricFurnace $this, BlockPos blockPos) {
        $this.field_174879_c = blockPos;
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\"\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u0004H\u0016J$\u0010\u000f\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\u0010\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000e\u001a\u00020\u0004H\u0016R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\u0011"}, d2={"Lcom/cout970/magneticraft/tileentity/electric/TileElectricFurnace$Inventory;", "Lnet/minecraftforge/items/ItemStackHandler;", "(Lcom/cout970/magneticraft/tileentity/electric/TileElectricFurnace;)V", "ignoreFilter", "", "getIgnoreFilter", "()Z", "setIgnoreFilter", "(Z)V", "extractItem", "Lnet/minecraft/item/ItemStack;", "slot", "", "amount", "simulate", "insertItem", "stack", "magneticraft-compileKotlin"})
    public final class Inventory
    extends ItemStackHandler {
        private boolean ignoreFilter;

        public final boolean getIgnoreFilter() {
            return this.ignoreFilter;
        }

        public final void setIgnoreFilter(boolean bl) {
            this.ignoreFilter = bl;
        }

        @Nullable
        public ItemStack insertItem(int slot, @Nullable ItemStack stack, boolean simulate) {
            if (slot == 0 || this.ignoreFilter) {
                return super.insertItem(slot, stack, simulate);
            }
            return stack;
        }

        @Nullable
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (slot == 1 || this.ignoreFilter) {
                return super.extractItem(slot, amount, simulate);
            }
            return null;
        }

        public Inventory() {
            super(2);
        }
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/cout970/magneticraft/tileentity/electric/TileElectricFurnace$Companion;", "", "()V", "MAX_BURNING_TIME", "", "getMAX_BURNING_TIME", "()F", "SPEED", "", "getSPEED", "()I", "magneticraft-compileKotlin"})
    public static final class Companion {
        public final float getMAX_BURNING_TIME() {
            return MAX_BURNING_TIME;
        }

        public final int getSPEED() {
            return SPEED;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

