/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.tileentity.electric;

import com.cout970.magneticraft.api.energy.IElectricNode;
import com.cout970.magneticraft.api.internal.energy.ElectricNode;
import com.cout970.magneticraft.block.SharedPropertiesKt;
import com.cout970.magneticraft.config.Config;
import com.cout970.magneticraft.gui.common.ConstantsKt;
import com.cout970.magneticraft.registry.CapabilitiesKt;
import com.cout970.magneticraft.tileentity.TileBase;
import com.cout970.magneticraft.tileentity.electric.TileElectricBase;
import com.cout970.magneticraft.util.EletricityKt;
import com.cout970.magneticraft.util.HeatKt;
import com.cout970.magneticraft.util.InventoriesKt;
import com.cout970.magneticraft.util.MinecraftUtilsKt;
import com.cout970.magneticraft.util.fluid.Tank;
import com.cout970.magneticraft.util.misc.AnimationTimer;
import com.cout970.magneticraft.util.misc.IBD;
import com.cout970.magneticraft.util.misc.ValueAverage;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 U2\u00020\u00012\u00020\u0002:\u0002UVB\u000f\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0012\u00103\u001a\u0002042\b\u00105\u001a\u0004\u0018\u000106H\u0016J \u00107\u001a\t\u0018\u000108\u00a2\u0006\u0002\b92\u0006\u0010:\u001a\u00020(2\u0006\u0010;\u001a\u000204H\u0097\u0001J(\u00107\u001a\t\u0018\u000108\u00a2\u0006\u0002\b92\u000e\u0010:\u001a\n <*\u0004\u0018\u000108082\u0006\u0010;\u001a\u000204H\u0097\u0001J!\u0010=\u001a\u00020(2\u000e\u0010:\u001a\n <*\u0004\u0018\u000108082\u0006\u0010;\u001a\u000204H\u0096\u0001J/\u0010>\u001a\u0004\u0018\u0001H?\"\u0004\b\u0000\u0010?2\u000e\u0010@\u001a\n\u0012\u0004\u0012\u0002H?\u0018\u00010A2\b\u00105\u001a\u0004\u0018\u000106H\u0017\u00a2\u0006\u0002\u0010BJ\u0006\u0010C\u001a\u000206J4\u0010D\u001a(\u0012\f\u0012\n <*\u0004\u0018\u00010F0F <*\u0014\u0012\u000e\b\u0001\u0012\n <*\u0004\u0018\u00010F0F\u0018\u00010E0EH\u0096\u0001\u00a2\u0006\u0002\u0010GJ \u0010H\u001a\u0002042\f\u0010@\u001a\b\u0012\u0002\b\u0003\u0018\u00010A2\b\u00105\u001a\u0004\u0018\u000106H\u0016J\u0010\u0010I\u001a\u00020J2\u0006\u0010K\u001a\u00020LH\u0016J\b\u0010M\u001a\u00020JH\u0016J\u0018\u0010N\u001a\u00020J2\u0006\u0010O\u001a\u00020P2\u0006\u0010Q\u001a\u00020RH\u0016J\b\u0010S\u001a\u00020LH\u0016J\b\u0010T\u001a\u00020JH\u0016R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\t\"\u0004\b\u0019\u0010\u000bR\u0011\u0010\u001a\u001a\u00020\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u001a\u0010\u001e\u001a\u00020\u001fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u001a\u0010$\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010\t\"\u0004\b&\u0010\u000bR\u001a\u0010'\u001a\u00020(X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010*\"\u0004\b+\u0010,R\u0011\u0010-\u001a\u00020.\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u00100R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u00102\u00a8\u0006W"}, d2={"Lcom/cout970/magneticraft/tileentity/electric/TileIncendiaryGenerator;", "Lcom/cout970/magneticraft/tileentity/electric/TileElectricBase;", "Lnet/minecraftforge/fluids/capability/IFluidHandler;", "tank", "Lcom/cout970/magneticraft/util/fluid/Tank;", "(Lcom/cout970/magneticraft/util/fluid/Tank;)V", "burningTime", "", "getBurningTime", "()F", "setBurningTime", "(F)V", "electricNodes", "", "Lcom/cout970/magneticraft/api/energy/IElectricNode;", "getElectricNodes", "()Ljava/util/List;", "fanAnimation", "Lcom/cout970/magneticraft/util/misc/AnimationTimer;", "getFanAnimation", "()Lcom/cout970/magneticraft/util/misc/AnimationTimer;", "setFanAnimation", "(Lcom/cout970/magneticraft/util/misc/AnimationTimer;)V", "heat", "getHeat", "setHeat", "inventory", "Lnet/minecraftforge/items/ItemStackHandler;", "getInventory", "()Lnet/minecraftforge/items/ItemStackHandler;", "mainNode", "Lcom/cout970/magneticraft/api/internal/energy/ElectricNode;", "getMainNode", "()Lcom/cout970/magneticraft/api/internal/energy/ElectricNode;", "setMainNode", "(Lcom/cout970/magneticraft/api/internal/energy/ElectricNode;)V", "maxBurningTime", "getMaxBurningTime", "setMaxBurningTime", "nanoBuckets", "", "getNanoBuckets", "()I", "setNanoBuckets", "(I)V", "production", "Lcom/cout970/magneticraft/util/misc/ValueAverage;", "getProduction", "()Lcom/cout970/magneticraft/util/misc/ValueAverage;", "getTank", "()Lcom/cout970/magneticraft/util/fluid/Tank;", "canConnectAtSide", "", "facing", "Lnet/minecraft/util/EnumFacing;", "drain", "Lnet/minecraftforge/fluids/FluidStack;", "Ljavax/annotation/Nullable;", "p0", "p1", "kotlin.jvm.PlatformType", "fill", "getCapability", "T", "capability", "Lnet/minecraftforge/common/capabilities/Capability;", "(Lnet/minecraftforge/common/capabilities/Capability;Lnet/minecraft/util/EnumFacing;)Ljava/lang/Object;", "getDirection", "getTankProperties", "", "Lnet/minecraftforge/fluids/capability/IFluidTankProperties;", "()[Lnet/minecraftforge/fluids/capability/IFluidTankProperties;", "hasCapability", "load", "", "nbt", "Lnet/minecraft/nbt/NBTTagCompound;", "onBreak", "receiveSyncData", "data", "Lcom/cout970/magneticraft/util/misc/IBD;", "side", "Lnet/minecraftforge/fml/relauncher/Side;", "save", "update", "Companion", "TileIncendiaryGeneratorBottom", "magneticraft-compileKotlin"})
public final class TileIncendiaryGenerator
extends TileElectricBase
implements IFluidHandler {
    @NotNull
    private ElectricNode mainNode;
    @NotNull
    private final ItemStackHandler inventory;
    private float maxBurningTime;
    private float burningTime;
    private float heat;
    @NotNull
    private final ValueAverage production;
    private int nanoBuckets;
    @NotNull
    private AnimationTimer fanAnimation;
    @NotNull
    private final Tank tank;
    private static final double MAX_HEAT;
    private static final int FUEL_TO_WATTS = 10;
    private static final float FUEL_TO_HEAT = 0.5f;
    private static final float HEAT_TO_WATTS = 20.0f;
    public static final Companion Companion;

    @NotNull
    public final ElectricNode getMainNode() {
        return this.mainNode;
    }

    public final void setMainNode(@NotNull ElectricNode electricNode) {
        Intrinsics.checkParameterIsNotNull(electricNode, "<set-?>");
        this.mainNode = electricNode;
    }

    @Override
    @NotNull
    public List<IElectricNode> getElectricNodes() {
        return CollectionsKt.listOf(this.mainNode);
    }

    @NotNull
    public final ItemStackHandler getInventory() {
        return this.inventory;
    }

    public final float getMaxBurningTime() {
        return this.maxBurningTime;
    }

    public final void setMaxBurningTime(float f) {
        this.maxBurningTime = f;
    }

    public final float getBurningTime() {
        return this.burningTime;
    }

    public final void setBurningTime(float f) {
        this.burningTime = f;
    }

    public final float getHeat() {
        return this.heat;
    }

    public final void setHeat(float f) {
        this.heat = f;
    }

    @NotNull
    public final ValueAverage getProduction() {
        return this.production;
    }

    public final int getNanoBuckets() {
        return this.nanoBuckets;
    }

    public final void setNanoBuckets(int n) {
        this.nanoBuckets = n;
    }

    @NotNull
    public final AnimationTimer getFanAnimation() {
        return this.fanAnimation;
    }

    public final void setFanAnimation(@NotNull AnimationTimer animationTimer) {
        Intrinsics.checkParameterIsNotNull(animationTimer, "<set-?>");
        this.fanAnimation = animationTimer;
    }

    @Override
    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            int time;
            if (this.burningTime <= 0.0f && this.mainNode.getVoltage() < (double)120 && coffee.cypher.mcextlib.extensions.inventories.InventoriesKt.get((IItemHandler)this.inventory, 0) != null && (time = TileEntityFurnace.func_145952_a((ItemStack)coffee.cypher.mcextlib.extensions.inventories.InventoriesKt.get((IItemHandler)this.inventory, 0))) > 0) {
                this.maxBurningTime = time;
                this.burningTime = time;
                ItemStack itemStack = coffee.cypher.mcextlib.extensions.inventories.InventoriesKt.get((IItemHandler)this.inventory, 0);
                if (itemStack == null) {
                    Intrinsics.throwNpe();
                }
                coffee.cypher.mcextlib.extensions.inventories.InventoriesKt.set(this.inventory, 0, InventoriesKt.consumeItem$default(itemStack, 0, 1, null));
                this.func_70296_d();
            }
            if (this.burningTime > 0.0f && (double)this.heat < Companion.getMAX_HEAT()) {
                int burningSpeed = (int)Math.ceil(Config.INSTANCE.getIncendiaryGeneratorMaxProduction() / 10.0);
                this.burningTime -= (float)burningSpeed;
                this.heat += (float)burningSpeed * Companion.getFUEL_TO_HEAT();
            }
            if ((double)this.heat > HeatKt.getSTANDARD_AMBIENT_TEMPERATURE() + (double)75 && this.tank.getFluidAmount() > 0) {
                double speed = TileElectricBase.Companion.interpolate(this.heat, HeatKt.getSTANDARD_AMBIENT_TEMPERATURE(), Companion.getMAX_HEAT() - (double)50);
                double prod = Config.INSTANCE.getIncendiaryGeneratorMaxProduction() * speed;
                double applied = this.mainNode.applyPower((1.0 - TileElectricBase.Companion.interpolate(this.mainNode.getVoltage(), EletricityKt.getTIER_1_MAX_VOLTAGE(), EletricityKt.getTIER_1_GENERATORS_MAX_VOLTAGE())) * prod, false);
                this.production.plusAssign(applied);
                this.heat -= (float)applied / Companion.getHEAT_TO_WATTS();
                this.nanoBuckets += (int)(applied / (double)Companion.getFUEL_TO_WATTS() * 78.125);
                if (this.nanoBuckets > 1000) {
                    this.nanoBuckets -= 1000;
                    this.tank.drainInternal(1, true);
                }
            } else if ((double)this.heat > HeatKt.getSTANDARD_AMBIENT_TEMPERATURE() && this.tank.getFluidAmount() > 0) {
                this.heat -= 0.109f;
            }
            this.production.tick();
            if (MinecraftUtilsKt.shouldTick(this, 200)) {
                IBD data = new IBD();
                data.setBoolean(ConstantsKt.getDATA_ID_MACHINE_WORKING(), (double)this.heat > HeatKt.getSTANDARD_AMBIENT_TEMPERATURE() + 1.0);
                data.setFloat(ConstantsKt.getDATA_ID_MACHINE_HEAT(), this.heat);
                this.sendSyncData(data, Side.CLIENT);
            }
        }
        super.func_73660_a();
    }

    @Override
    public void receiveSyncData(@NotNull IBD data, @NotNull Side side) {
        Intrinsics.checkParameterIsNotNull(data, "data");
        Intrinsics.checkParameterIsNotNull(side, "side");
        super.receiveSyncData(data, side);
        if (Intrinsics.areEqual(side, Side.SERVER)) {
            data.getBoolean(ConstantsKt.getDATA_ID_MACHINE_WORKING(), (Function1<? super Boolean, Unit>)new Function1<Boolean, Unit>(this){
                final /* synthetic */ TileIncendiaryGenerator this$0;

                public final void invoke(boolean it) {
                    this.this$0.getFanAnimation().setActive(it);
                }
                {
                    this.this$0 = tileIncendiaryGenerator;
                    super(1);
                }
            });
            data.getFloat(ConstantsKt.getDATA_ID_MACHINE_WORKING(), (Function1<? super Float, Unit>)new Function1<Float, Unit>(this){
                final /* synthetic */ TileIncendiaryGenerator this$0;

                public final void invoke(float it) {
                    this.this$0.setHeat(it);
                }
                {
                    this.this$0 = tileIncendiaryGenerator;
                    super(1);
                }
            });
        }
    }

    @Override
    @NotNull
    public NBTTagCompound save() {
        NBTTagCompound nBTTagCompound = new NBTTagCompound();
        NBTTagCompound $receiver = nBTTagCompound;
        $receiver.func_74782_a("inventory", (NBTBase)this.inventory.serializeNBT());
        $receiver.func_74776_a("maxBurningTime", this.maxBurningTime);
        $receiver.func_74776_a("burningTime", this.burningTime);
        $receiver.func_74776_a("heat", this.heat);
        NBTTagCompound nBTTagCompound2 = new NBTTagCompound();
        String string = "tank";
        NBTTagCompound nBTTagCompound3 = $receiver;
        NBTTagCompound $receiver2 = nBTTagCompound2;
        this.tank.writeToNBT($receiver2);
        NBTTagCompound nBTTagCompound4 = nBTTagCompound2;
        nBTTagCompound3.func_74782_a(string, (NBTBase)nBTTagCompound4);
        return nBTTagCompound;
    }

    @Override
    public void load(@NotNull NBTTagCompound nbt) {
        Intrinsics.checkParameterIsNotNull(nbt, "nbt");
        this.inventory.deserializeNBT(nbt.func_74775_l("inventory"));
        this.maxBurningTime = nbt.func_74760_g("maxBurningTime");
        this.burningTime = nbt.func_74760_g("burningTime");
        this.heat = nbt.func_74760_g("heat");
        this.tank.readFromNBT(nbt.func_74775_l("tank"));
    }

    @Override
    public void onBreak() {
        super.onBreak();
        if (!this.field_145850_b.field_72995_K && coffee.cypher.mcextlib.extensions.inventories.InventoriesKt.get((IItemHandler)this.inventory, 0) != null) {
            ItemStack itemStack = coffee.cypher.mcextlib.extensions.inventories.InventoriesKt.get((IItemHandler)this.inventory, 0);
            if (itemStack == null) {
                Intrinsics.throwNpe();
            }
            BlockPos blockPos = this.field_174879_c;
            Intrinsics.checkExpressionValueIsNotNull(blockPos, "pos");
            this.dropItem(itemStack, blockPos);
        }
    }

    @Override
    public boolean canConnectAtSide(@Nullable EnumFacing facing) {
        return Intrinsics.areEqual(facing, EnumFacing.UP);
    }

    @Override
    @Nullable
    public <T> T getCapability(@Nullable Capability<T> capability, @Nullable EnumFacing facing) {
        if (Intrinsics.areEqual(capability, CapabilitiesKt.getFLUID_HANDLER())) {
            return (T)this;
        }
        if (Intrinsics.areEqual(capability, CapabilitiesKt.getITEM_HANDLER())) {
            return (T)this.inventory;
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public boolean hasCapability(@Nullable Capability<?> capability, @Nullable EnumFacing facing) {
        if (Intrinsics.areEqual(capability, CapabilitiesKt.getFLUID_HANDLER())) {
            return true;
        }
        if (Intrinsics.areEqual(capability, CapabilitiesKt.getITEM_HANDLER())) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @NotNull
    public final EnumFacing getDirection() {
        IBlockState state = this.func_145831_w().func_180495_p(this.field_174879_c);
        IProperty iProperty = (IProperty)SharedPropertiesKt.getPROPERTY_DIRECTION();
        IBlockState iBlockState = state;
        Intrinsics.checkExpressionValueIsNotNull(iBlockState, "state");
        if (MinecraftUtilsKt.isIn(iProperty, iBlockState)) {
            IProperty iProperty2 = (IProperty)SharedPropertiesKt.getPROPERTY_DIRECTION();
            IBlockState iBlockState2 = state;
            Intrinsics.checkExpressionValueIsNotNull(iBlockState2, "state");
            EnumFacing enumFacing = (EnumFacing)MinecraftUtilsKt.get(iProperty2, iBlockState2);
            Intrinsics.checkExpressionValueIsNotNull(enumFacing, "PROPERTY_DIRECTION[state]");
            return enumFacing;
        }
        return EnumFacing.NORTH;
    }

    @NotNull
    public final Tank getTank() {
        return this.tank;
    }

    public TileIncendiaryGenerator(@NotNull Tank tank) {
        AnimationTimer animationTimer;
        Intrinsics.checkParameterIsNotNull((Object)tank, "tank");
        this.tank = tank;
        this.mainNode = new ElectricNode(new Function0<World>(this){
            final /* synthetic */ TileIncendiaryGenerator this$0;

            public final World invoke() {
                World world = this.this$0.func_145831_w();
                Intrinsics.checkExpressionValueIsNotNull(world, "world");
                return world;
            }
            {
                this.this$0 = tileIncendiaryGenerator;
                super(0);
            }
        }, new Function0<BlockPos>(this){
            final /* synthetic */ TileIncendiaryGenerator this$0;

            public final BlockPos invoke() {
                BlockPos blockPos = TileIncendiaryGenerator.access$getPos$p(this.this$0);
                Intrinsics.checkExpressionValueIsNotNull(blockPos, "pos");
                return blockPos;
            }
            {
                this.this$0 = tileIncendiaryGenerator;
                super(0);
            }
        }, 0.0, 1.25, 4, null);
        this.inventory = new ItemStackHandler(1);
        this.heat = (float)HeatKt.getSTANDARD_AMBIENT_TEMPERATURE();
        this.production = new ValueAverage(0, 1, null);
        AnimationTimer animationTimer2 = new AnimationTimer();
        TileIncendiaryGenerator tileIncendiaryGenerator = this;
        AnimationTimer $receiver = animationTimer2;
        $receiver.setActive(false);
        tileIncendiaryGenerator.fanAnimation = animationTimer = animationTimer2;
    }

    public /* synthetic */ TileIncendiaryGenerator(Tank tank, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            tank = new Tank(4000){

                public boolean canFillFluidType(@Nullable FluidStack fluid) {
                    FluidStack fluidStack = fluid;
                    return Intrinsics.areEqual(fluidStack != null && (fluidStack = fluidStack.getFluid()) != null ? fluidStack.getName() : null, "water");
                }
            };
        }
        this(tank);
    }

    public TileIncendiaryGenerator() {
        this(null, 1, null);
    }

    static {
        Companion = new Companion(null);
        MAX_HEAT = HeatKt.toKelvinFromCelsius(500);
        FUEL_TO_WATTS = 10;
        FUEL_TO_HEAT = 0.5f;
        HEAT_TO_WATTS = (float)Companion.getFUEL_TO_WATTS() / Companion.getFUEL_TO_HEAT();
    }

    @javax.annotation.Nullable
    @Nullable
    public FluidStack drain(int p0, boolean p1) {
        return this.tank.drain(p0, p1);
    }

    @javax.annotation.Nullable
    @Nullable
    public FluidStack drain(FluidStack p0, boolean p1) {
        return this.tank.drain(p0, p1);
    }

    public int fill(FluidStack p0, boolean p1) {
        return this.tank.fill(p0, p1);
    }

    public IFluidTankProperties[] getTankProperties() {
        return this.tank.getTankProperties();
    }

    public static final /* synthetic */ BlockPos access$getPos$p(TileIncendiaryGenerator $this) {
        return $this.field_174879_c;
    }

    public static final /* synthetic */ void access$setPos$p(TileIncendiaryGenerator $this, BlockPos blockPos) {
        $this.field_174879_c = blockPos;
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J/\u0010\u0003\u001a\u0004\u0018\u0001H\u0004\"\u0004\b\u0000\u0010\u00042\u000e\u0010\u0005\u001a\n\u0012\u0004\u0012\u0002H\u0004\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0017\u00a2\u0006\u0002\u0010\tJ \u0010\n\u001a\u00020\u000b2\f\u0010\u0005\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u000fH\u0016\u00a8\u0006\u0011"}, d2={"Lcom/cout970/magneticraft/tileentity/electric/TileIncendiaryGenerator$TileIncendiaryGeneratorBottom;", "Lcom/cout970/magneticraft/tileentity/TileBase;", "()V", "getCapability", "T", "capability", "Lnet/minecraftforge/common/capabilities/Capability;", "facing", "Lnet/minecraft/util/EnumFacing;", "(Lnet/minecraftforge/common/capabilities/Capability;Lnet/minecraft/util/EnumFacing;)Ljava/lang/Object;", "hasCapability", "", "load", "", "nbt", "Lnet/minecraft/nbt/NBTTagCompound;", "save", "magneticraft-compileKotlin"})
    public static final class TileIncendiaryGeneratorBottom
    extends TileBase {
        /*
         * WARNING - void declaration
         */
        @Nullable
        public <T> T getCapability(@Nullable Capability<T> capability, @Nullable EnumFacing facing) {
            TileIncendiaryGenerator tile;
            void pos$iv;
            void $receiver$iv;
            IBlockAccess iBlockAccess = (IBlockAccess)this.field_145850_b;
            BlockPos blockPos = this.field_174879_c.func_177984_a();
            Intrinsics.checkExpressionValueIsNotNull(blockPos, "pos.up()");
            BlockPos blockPos2 = blockPos;
            TileEntity tileEntity = $receiver$iv.func_175625_s((BlockPos)pos$iv);
            if (!(tileEntity instanceof TileIncendiaryGenerator)) {
                tileEntity = null;
            }
            if ((tile = (TileIncendiaryGenerator)tileEntity) != null) {
                return tile.getCapability(capability, facing);
            }
            return (T)super.getCapability(capability, facing);
        }

        /*
         * WARNING - void declaration
         */
        public boolean hasCapability(@Nullable Capability<?> capability, @Nullable EnumFacing facing) {
            TileIncendiaryGenerator tile;
            void pos$iv;
            void $receiver$iv;
            IBlockAccess iBlockAccess = (IBlockAccess)this.field_145850_b;
            BlockPos blockPos = this.field_174879_c.func_177984_a();
            Intrinsics.checkExpressionValueIsNotNull(blockPos, "pos.up()");
            BlockPos blockPos2 = blockPos;
            TileEntity tileEntity = $receiver$iv.func_175625_s((BlockPos)pos$iv);
            if (!(tileEntity instanceof TileIncendiaryGenerator)) {
                tileEntity = null;
            }
            if ((tile = (TileIncendiaryGenerator)tileEntity) != null) {
                return tile.hasCapability(capability, facing);
            }
            return super.hasCapability(capability, facing);
        }

        @Override
        @NotNull
        public NBTTagCompound save() {
            return new NBTTagCompound();
        }

        @Override
        public void load(@NotNull NBTTagCompound nbt) {
            Intrinsics.checkParameterIsNotNull(nbt, "nbt");
        }
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lcom/cout970/magneticraft/tileentity/electric/TileIncendiaryGenerator$Companion;", "", "()V", "FUEL_TO_HEAT", "", "getFUEL_TO_HEAT", "()F", "FUEL_TO_WATTS", "", "getFUEL_TO_WATTS", "()I", "HEAT_TO_WATTS", "getHEAT_TO_WATTS", "MAX_HEAT", "", "getMAX_HEAT", "()D", "magneticraft-compileKotlin"})
    public static final class Companion {
        public final double getMAX_HEAT() {
            return MAX_HEAT;
        }

        public final int getFUEL_TO_WATTS() {
            return FUEL_TO_WATTS;
        }

        public final float getFUEL_TO_HEAT() {
            return FUEL_TO_HEAT;
        }

        public final float getHEAT_TO_WATTS() {
            return HEAT_TO_WATTS;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

