/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.tileentity.electric.connectors;

import coffee.cypher.mcextlib.extensions.vectors.DoubleVectorsKt;
import coffee.cypher.mcextlib.extensions.vectors.IntVectorsKt;
import com.cout970.magneticraft.api.energy.IElectricNode;
import com.cout970.magneticraft.api.energy.IWireConnector;
import com.cout970.magneticraft.api.internal.energy.ElectricNode;
import com.cout970.magneticraft.tileentity.electric.TileElectricConnector;
import com.cout970.magneticraft.tilerenderer.TileRendererUtilsKt;
import com.google.common.collect.ImmutableList;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0011\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0096\u0001J\u0019\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0096\u0001J\u0019\u0010\u0014\u001a\u00020\r2\u000e\u0010\u0015\u001a\n \u0017*\u0004\u0018\u00010\u00160\u0016H\u0096\u0001J\t\u0010\u0018\u001a\u00020\u000fH\u0096\u0001J\t\u0010\u0019\u001a\u00020\u000fH\u0096\u0001J\u000e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bH\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\u0011\u0010\u001f\u001a\n \u0017*\u0004\u0018\u00010 0 H\u0096\u0001J\t\u0010!\u001a\u00020\u000fH\u0096\u0001J\t\u0010\"\u001a\u00020\u000fH\u0096\u0001J\u0011\u0010#\u001a\n \u0017*\u0004\u0018\u00010$0$H\u0096\u0001J\t\u0010%\u001a\u00020\rH\u0096\u0001J\u0011\u0010&\u001a\n \u0017*\u0004\u0018\u00010\u00160\u0016H\u0096\u0001J\b\u0010'\u001a\u00020(H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006)"}, d2={"Lcom/cout970/magneticraft/tileentity/electric/connectors/ElectricConnector;", "Lcom/cout970/magneticraft/api/energy/IElectricNode;", "Lcom/cout970/magneticraft/api/energy/IWireConnector;", "node", "Lcom/cout970/magneticraft/api/internal/energy/ElectricNode;", "tile", "Lcom/cout970/magneticraft/tileentity/electric/TileElectricConnector;", "(Lcom/cout970/magneticraft/api/internal/energy/ElectricNode;Lcom/cout970/magneticraft/tileentity/electric/TileElectricConnector;)V", "getNode", "()Lcom/cout970/magneticraft/api/internal/energy/ElectricNode;", "getTile", "()Lcom/cout970/magneticraft/tileentity/electric/TileElectricConnector;", "applyCurrent", "", "current", "", "applyPower", "power", "simulated", "", "deserializeNBT", "p0", "Lnet/minecraft/nbt/NBTTagCompound;", "kotlin.jvm.PlatformType", "getAmperage", "getCapacity", "getConnectors", "Lcom/google/common/collect/ImmutableList;", "Lnet/minecraft/util/math/Vec3d;", "getConnectorsSize", "", "getPos", "Lnet/minecraft/util/math/BlockPos;", "getResistance", "getVoltage", "getWorld", "Lnet/minecraft/world/World;", "iterate", "serializeNBT", "toString", "", "magneticraft-compileKotlin"})
public final class ElectricConnector
implements IElectricNode,
IWireConnector {
    @NotNull
    private final ElectricNode node;
    @NotNull
    private final TileElectricConnector tile;

    @Override
    @NotNull
    public ImmutableList<Vec3d> getConnectors() {
        Vec3d offset = !this.tile.func_145837_r() ? DoubleVectorsKt.times(DoubleVectorsKt.times(IntVectorsKt.toDoubleVec(this.tile.getFacing().func_176730_m()), TileRendererUtilsKt.PIXEL), 3.0) : Vec3d.field_186680_a;
        Vec3d vec3d = new Vec3d(0.5, 0.5, 0.5);
        Vec3d vec3d2 = offset;
        Intrinsics.checkExpressionValueIsNotNull(vec3d2, "offset");
        Vec3d vec = DoubleVectorsKt.plus(vec3d, vec3d2);
        ImmutableList immutableList = ImmutableList.of((Object)vec);
        Intrinsics.checkExpressionValueIsNotNull(immutableList, "ImmutableList.of(vec)");
        return immutableList;
    }

    @Override
    public int getConnectorsSize() {
        return 1;
    }

    @NotNull
    public String toString() {
        return this.node.toString();
    }

    @NotNull
    public final ElectricNode getNode() {
        return this.node;
    }

    @NotNull
    public final TileElectricConnector getTile() {
        return this.tile;
    }

    public ElectricConnector(@NotNull ElectricNode node2, @NotNull TileElectricConnector tile) {
        Intrinsics.checkParameterIsNotNull(node2, "node");
        Intrinsics.checkParameterIsNotNull(tile, "tile");
        this.node = node2;
        this.tile = tile;
    }

    @Override
    public void applyCurrent(double current) {
        this.node.applyCurrent(current);
    }

    @Override
    public double applyPower(double power, boolean simulated) {
        return this.node.applyPower(power, simulated);
    }

    public void deserializeNBT(NBTTagCompound p0) {
        this.node.deserializeNBT(p0);
    }

    @Override
    public double getAmperage() {
        return this.node.getAmperage();
    }

    @Override
    public double getCapacity() {
        return this.node.getCapacity();
    }

    @Override
    public BlockPos getPos() {
        return this.node.getPos();
    }

    @Override
    public double getResistance() {
        return this.node.getResistance();
    }

    @Override
    public double getVoltage() {
        return this.node.getVoltage();
    }

    @Override
    public World getWorld() {
        return this.node.getWorld();
    }

    @Override
    public void iterate() {
        this.node.iterate();
    }

    public NBTTagCompound serializeNBT() {
        return this.node.serializeNBT();
    }
}

