/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.tilerenderer;

import coffee.cypher.mcextlib.extensions.inventories.InventoriesKt;
import com.cout970.loader.api.ModelCacheFactory;
import com.cout970.loader.api.model.ICachedModel;
import com.cout970.loader.api.model.IDynamicModel;
import com.cout970.loader.api.model.IModelFilter;
import com.cout970.loader.api.model.IModelPart;
import com.cout970.loader.api.model.IObjGroup;
import com.cout970.magneticraft.multiblock.impl.MultiblockHydraulicPress;
import com.cout970.magneticraft.tileentity.multiblock.TileHydraulicPress;
import com.cout970.magneticraft.tilerenderer.TileEntityRenderer;
import com.cout970.magneticraft.tilerenderer.TileRendererUtilsKt;
import com.cout970.magneticraft.util.ResourcesKt;
import com.cout970.magneticraft.util.misc.CraftingProcess;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.item.ItemSkull;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0000\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0011\u001a\u00020\u0012H\u0016J8\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u0005X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\u0007\"\u0004\b\f\u0010\tR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001d"}, d2={"Lcom/cout970/magneticraft/tilerenderer/TileRendererHydraulicPress;", "Lcom/cout970/magneticraft/tilerenderer/TileEntityRenderer;", "Lcom/cout970/magneticraft/tileentity/multiblock/TileHydraulicPress;", "()V", "hammer", "Lcom/cout970/loader/api/model/ICachedModel;", "getHammer", "()Lcom/cout970/loader/api/model/ICachedModel;", "setHammer", "(Lcom/cout970/loader/api/model/ICachedModel;)V", "noHammer", "getNoHammer", "setNoHammer", "texture", "Lnet/minecraft/util/ResourceLocation;", "getTexture", "()Lnet/minecraft/util/ResourceLocation;", "onModelRegistryReload", "", "renderTileEntityAt", "te", "x", "", "y", "z", "partialTicks", "", "destroyStage", "", "magneticraft-compileKotlin"})
public final class TileRendererHydraulicPress
extends TileEntityRenderer<TileHydraulicPress> {
    @NotNull
    private static final ResourceLocation texture;
    @NotNull
    public static ICachedModel noHammer;
    @NotNull
    public static ICachedModel hammer;
    public static final TileRendererHydraulicPress INSTANCE;

    @NotNull
    public final ResourceLocation getTexture() {
        return texture;
    }

    @NotNull
    public final ICachedModel getNoHammer() {
        ICachedModel iCachedModel = noHammer;
        if (iCachedModel == null) {
            Intrinsics.throwUninitializedPropertyAccessException("noHammer");
        }
        return iCachedModel;
    }

    public final void setNoHammer(@NotNull ICachedModel iCachedModel) {
        Intrinsics.checkParameterIsNotNull(iCachedModel, "<set-?>");
        noHammer = iCachedModel;
    }

    @NotNull
    public final ICachedModel getHammer() {
        ICachedModel iCachedModel = hammer;
        if (iCachedModel == null) {
            Intrinsics.throwUninitializedPropertyAccessException("hammer");
        }
        return iCachedModel;
    }

    public final void setHammer(@NotNull ICachedModel iCachedModel) {
        Intrinsics.checkParameterIsNotNull(iCachedModel, "<set-?>");
        hammer = iCachedModel;
    }

    @Override
    public void renderTileEntityAt(@NotNull TileHydraulicPress te, double x, double y, double z, float partialTicks, int destroyStage) {
        Intrinsics.checkParameterIsNotNull(te, "te");
        if (!te.getActive()) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)x, (double)y, (double)z);
            TileRendererUtilsKt.rotateFromCenter(te.getDirection(), 0.0f);
            TileRendererUtilsKt.renderMultiblockBlueprint(MultiblockHydraulicPress.INSTANCE);
            GlStateManager.func_179121_F();
            return;
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        ItemStack stack = InventoriesKt.get((IItemHandler)te.getInventory(), 0);
        if (stack != null) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)0.5, (double)0.9375, (double)0.3125);
            if (!Minecraft.func_71410_x().func_175599_af().func_175050_a(stack) || stack.func_77973_b() instanceof ItemSkull) {
                GlStateManager.func_179137_b((double)0.0, (double)-0.045, (double)0.0625);
                GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            } else {
                GlStateManager.func_179137_b((double)0.0, (double)-0.125, (double)0.1875);
            }
            this.func_147499_a(TextureMap.field_110575_b);
            Minecraft.func_71410_x().func_175599_af().func_181564_a(stack, ItemCameraTransforms.TransformType.GROUND);
            GlStateManager.func_179121_F();
        }
        TileRendererUtilsKt.rotateFromCenter(te.getDirection(), 0.0f);
        this.func_147499_a(texture);
        ICachedModel iCachedModel = noHammer;
        if (iCachedModel == null) {
            Intrinsics.throwUninitializedPropertyAccessException("noHammer");
        }
        iCachedModel.render();
        float speed = 360.0f;
        CraftingProcess craftingProcess = te.getCraftingProcess();
        World world = te.func_145831_w();
        Intrinsics.checkExpressionValueIsNotNull(world, "te.world");
        if (craftingProcess.isWorking(world)) {
            te.getHammerAnimation().updateAnimation();
        } else if ((double)((te.getHammerAnimation().getMotionState(speed) + 1.0f) * 0.5f) > 0.5) {
            te.getHammerAnimation().updateAnimation();
        } else {
            te.getHammerAnimation().resetDelta();
        }
        float state = (te.getHammerAnimation().getMotionState(speed) + 1.0f) * 0.5f;
        GlStateManager.func_179109_b((float)0.0f, (float)(-state * 8.0f / 16.0f), (float)0.0f);
        ICachedModel iCachedModel2 = hammer;
        if (iCachedModel2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("hammer");
        }
        iCachedModel2.render();
        GlStateManager.func_179121_F();
    }

    @Override
    public void onModelRegistryReload() {
        super.onModelRegistryReload();
        try {
            IDynamicModel model = this.getModelObj(ResourcesKt.resource("models/block/obj/hydraulic_press.obj"));
            IModelFilter hasFan2 = new IModelFilter(){

                public boolean apply(@Nullable IModelPart it) {
                    return it instanceof IObjGroup ? StringsKt.contains$default((CharSequence)((IObjGroup)it).getName(), "head", false, 2, null) || StringsKt.contains$default((CharSequence)((IObjGroup)it).getName(), "rod", false, 2, null) : false;
                }
            };
            Predicate predicate2 = Predicates.not((Predicate)hasFan2);
            Intrinsics.checkExpressionValueIsNotNull(predicate2, "Predicates.not(hasFan)");
            ICachedModel iCachedModel = ModelCacheFactory.createCachedModel(model.filter((Predicate<IModelPart>)predicate2), 1);
            Intrinsics.checkExpressionValueIsNotNull(iCachedModel, "ModelCacheFactory.create\u2026edicates.not(hasFan)), 1)");
            noHammer = iCachedModel;
            ICachedModel iCachedModel2 = ModelCacheFactory.createCachedModel(model.filter((Predicate<IModelPart>)((Predicate)hasFan2)), 1);
            Intrinsics.checkExpressionValueIsNotNull(iCachedModel2, "ModelCacheFactory.create\u2026(model.filter(hasFan), 1)");
            hammer = iCachedModel2;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private TileRendererHydraulicPress() {
        INSTANCE = this;
        texture = ResourcesKt.resource("textures/models/hydraulic_press.png");
    }

    static {
        new TileRendererHydraulicPress();
    }
}

