/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.tilerenderer;

import com.cout970.loader.api.ModelCacheFactory;
import com.cout970.loader.api.model.ICachedModel;
import com.cout970.loader.api.model.IDynamicModel;
import com.cout970.loader.api.model.IModelFilter;
import com.cout970.loader.api.model.IModelPart;
import com.cout970.loader.api.model.IObjGroup;
import com.cout970.magneticraft.tileentity.electric.TileIncendiaryGenerator;
import com.cout970.magneticraft.tilerenderer.TileEntityRenderer;
import com.cout970.magneticraft.tilerenderer.TileRendererUtilsKt;
import com.cout970.magneticraft.util.ResourcesKt;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0000\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0011\u001a\u00020\u0012H\u0016J8\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001c\u0010\n\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\u0007\"\u0004\b\f\u0010\tR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001d"}, d2={"Lcom/cout970/magneticraft/tilerenderer/TileRendererIncendiaryGenerator;", "Lcom/cout970/magneticraft/tilerenderer/TileEntityRenderer;", "Lcom/cout970/magneticraft/tileentity/electric/TileIncendiaryGenerator;", "()V", "block", "Lcom/cout970/loader/api/model/ICachedModel;", "getBlock", "()Lcom/cout970/loader/api/model/ICachedModel;", "setBlock", "(Lcom/cout970/loader/api/model/ICachedModel;)V", "fan", "getFan", "setFan", "texture", "Lnet/minecraft/util/ResourceLocation;", "getTexture", "()Lnet/minecraft/util/ResourceLocation;", "onModelRegistryReload", "", "renderTileEntityAt", "te", "x", "", "y", "z", "partialTicks", "", "destroyStage", "", "magneticraft-compileKotlin"})
public final class TileRendererIncendiaryGenerator
extends TileEntityRenderer<TileIncendiaryGenerator> {
    @NotNull
    private static final ResourceLocation texture;
    @Nullable
    private static ICachedModel block;
    @Nullable
    private static ICachedModel fan;
    public static final TileRendererIncendiaryGenerator INSTANCE;

    @NotNull
    public final ResourceLocation getTexture() {
        return texture;
    }

    @Nullable
    public final ICachedModel getBlock() {
        return block;
    }

    public final void setBlock(@Nullable ICachedModel iCachedModel) {
        block = iCachedModel;
    }

    @Nullable
    public final ICachedModel getFan() {
        return fan;
    }

    public final void setFan(@Nullable ICachedModel iCachedModel) {
        fan = iCachedModel;
    }

    @Override
    public void renderTileEntityAt(@NotNull TileIncendiaryGenerator te, double x, double y, double z, float partialTicks, int destroyStage) {
        Intrinsics.checkParameterIsNotNull(te, "te");
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)x, (double)(y - 1.0), (double)z);
        EnumFacing dir = te.getDirection();
        TileRendererUtilsKt.rotateFromCenter(dir, -90.0f);
        this.func_147499_a(texture);
        ICachedModel iCachedModel = block;
        if (iCachedModel != null) {
            iCachedModel.render();
        }
        GlStateManager.func_179109_b((float)0.5f, (float)0.0f, (float)0.5f);
        if (te.getFanAnimation().getActive()) {
            te.getFanAnimation().updateAnimation();
        }
        GlStateManager.func_179114_b((float)te.getFanAnimation().getRotationState(te.getHeat() * 0.5f), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179109_b((float)-0.5f, (float)-0.0f, (float)-0.5f);
        ICachedModel iCachedModel2 = fan;
        if (iCachedModel2 != null) {
            iCachedModel2.render();
        }
        GlStateManager.func_179121_F();
    }

    @Override
    public void onModelRegistryReload() {
        super.onModelRegistryReload();
        try {
            IDynamicModel model = this.getModelObj(ResourcesKt.resource("models/block/obj/incendiary_generator.obj"));
            IModelFilter hasFan2 = new IModelFilter(){

                public boolean apply(@Nullable IModelPart it) {
                    return it instanceof IObjGroup ? StringsKt.contains$default((CharSequence)((IObjGroup)it).getName(), "fan", false, 2, null) : false;
                }
            };
            Predicate predicate2 = Predicates.not((Predicate)hasFan2);
            Intrinsics.checkExpressionValueIsNotNull(predicate2, "Predicates.not(hasFan)");
            block = ModelCacheFactory.createCachedModel(model.filter((Predicate<IModelPart>)predicate2), 1);
            fan = ModelCacheFactory.createCachedModel(model.filter((Predicate<IModelPart>)((Predicate)hasFan2)), 1);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private TileRendererIncendiaryGenerator() {
        INSTANCE = this;
        texture = ResourcesKt.resource("textures/models/incendiary_generator.png");
    }

    static {
        new TileRendererIncendiaryGenerator();
    }
}

