/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.util;

import com.cout970.magneticraft.api.energy.IElectricConnection;
import com.cout970.magneticraft.api.energy.IElectricNode;
import io.netty.buffer.ByteBuf;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.Charsets;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=2, d1={"\u0000\u0082\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u001a'\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0012\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000f0\u000e\"\u00020\u000f\u00a2\u0006\u0002\u0010\u0010\u001a\u0015\u0010\u0011\u001a\u00020\u0005*\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0086\u0002\u001a\u0014\u0010\u0015\u001a\u0004\u0018\u00010\u0001*\u00020\u00012\u0006\u0010\u0016\u001a\u00020\u0001\u001a0\u0010\u0017\u001a\u0002H\u0018\"\u000e\b\u0000\u0010\u0018*\b\u0012\u0004\u0012\u0002H\u00180\u0019*\b\u0012\u0004\u0012\u0002H\u00180\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0086\u0002\u00a2\u0006\u0002\u0010\u001d\u001a\u0012\u0010\u001e\u001a\u00020\u001f*\u00020 2\u0006\u0010!\u001a\u00020\f\u001a\u0012\u0010\"\u001a\u00020#*\u00020 2\u0006\u0010!\u001a\u00020\f\u001a(\u0010$\u001a\u00020\u0005\"\u000e\b\u0000\u0010\u0018*\b\u0012\u0004\u0012\u0002H\u00180\u0019*\b\u0012\u0004\u0012\u0002H\u00180\u001a2\u0006\u0010\u001b\u001a\u00020\u001c\u001a\n\u0010%\u001a\u00020\f*\u00020&\u001a+\u0010'\u001a\u00020(*\u00020)2\u0006\u0010\u000b\u001a\u00020\f2\u0012\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000f0\u000e\"\u00020\u000f\u00a2\u0006\u0002\u0010*\u001a\u001a\u0010+\u001a\u00020(*\u00020 2\u0006\u0010!\u001a\u00020\f2\u0006\u0010,\u001a\u00020\u001f\u001a\u001a\u0010-\u001a\u00020(*\u00020 2\u0006\u0010!\u001a\u00020\f2\u0006\u0010.\u001a\u00020#\u001a\u0012\u0010/\u001a\u00020\u0005*\u0002002\u0006\u00101\u001a\u000202\u001a\u0012\u00103\u001a\u00020(*\u00020&2\u0006\u0010\u000b\u001a\u00020\f\"\u0011\u0010\u0000\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"\u0015\u0010\u0004\u001a\u00020\u0005*\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0007\"\u0015\u0010\b\u001a\u00020\u0005*\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0007\u00a8\u00064"}, d2={"EMPTY_AABB", "Lnet/minecraft/util/math/AxisAlignedBB;", "getEMPTY_AABB", "()Lnet/minecraft/util/math/AxisAlignedBB;", "isClient", "", "Lnet/minecraft/world/World;", "(Lnet/minecraft/world/World;)Z", "isServer", "translate", "Lnet/minecraft/util/text/TextComponentTranslation;", "str", "", "args", "", "", "(Ljava/lang/String;[Ljava/lang/Object;)Lnet/minecraft/util/text/TextComponentTranslation;", "contains", "Lcom/cout970/magneticraft/api/energy/IElectricConnection;", "node", "Lcom/cout970/magneticraft/api/energy/IElectricNode;", "cut", "other", "get", "T", "", "Lnet/minecraft/block/properties/IProperty;", "state", "Lnet/minecraft/block/state/IBlockState;", "(Lnet/minecraft/block/properties/IProperty;Lnet/minecraft/block/state/IBlockState;)Ljava/lang/Comparable;", "getBlockPos", "Lnet/minecraft/util/math/BlockPos;", "Lnet/minecraft/nbt/NBTTagCompound;", "key", "getEnumFacing", "Lnet/minecraft/util/EnumFacing;", "isIn", "readString", "Lio/netty/buffer/ByteBuf;", "sendMessage", "", "Lnet/minecraft/entity/player/EntityPlayer;", "(Lnet/minecraft/entity/player/EntityPlayer;Ljava/lang/String;[Ljava/lang/Object;)V", "setBlockPos", "pos", "setEnumFacing", "facing", "shouldTick", "Lnet/minecraft/tileentity/TileEntity;", "time", "", "writeString", "magneticraft-compileKotlin"})
public final class MinecraftUtilsKt {
    @NotNull
    private static final AxisAlignedBB EMPTY_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);

    public static final boolean shouldTick(@NotNull TileEntity $receiver, int time) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return ($receiver.func_145831_w().func_82737_E() + (long)$receiver.func_174877_v().hashCode()) % (long)time == 0L;
    }

    @NotNull
    public static final <T extends Comparable<? super T>> T get(@NotNull IProperty<T> $receiver, @NotNull IBlockState state) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(state, "state");
        Comparable comparable = state.func_177229_b($receiver);
        Intrinsics.checkExpressionValueIsNotNull(comparable, "state.getValue(this)");
        return (T)comparable;
    }

    public static final <T extends Comparable<? super T>> boolean isIn(@NotNull IProperty<T> $receiver, @NotNull IBlockState state) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(state, "state");
        Map map = (Map)state.func_177228_b();
        Map map2 = map;
        Map map3 = map2;
        if (map3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Map<K, *>");
        }
        return map3.containsKey($receiver);
    }

    public static final boolean contains(@NotNull IElectricConnection $receiver, @NotNull IElectricNode node2) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(node2, "node");
        return Intrinsics.areEqual($receiver.getFirstNode(), node2) || Intrinsics.areEqual($receiver.getSecondNode(), node2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String readString(@NotNull ByteBuf $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        int size = Math.abs($receiver.readShort());
        byte[] buffer = new byte[size];
        IntRange intRange = RangesKt.until(0, size);
        int n = intRange.getFirst();
        int n2 = intRange.getLast();
        if (n <= n2) {
            while (true) {
                void i;
                buffer[i] = $receiver.readByte();
                if (i == n2) break;
                ++i;
            }
        }
        Charset charset = Charsets.UTF_8;
        return new String(buffer, charset);
    }

    /*
     * WARNING - void declaration
     */
    public static final void writeString(@NotNull ByteBuf $receiver, @NotNull String str) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(str, "str");
        String string = str;
        Charset charset = Charsets.UTF_8;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string2.getBytes(charset);
        Intrinsics.checkExpressionValueIsNotNull(byArray, "(this as java.lang.String).getBytes(charset)");
        byte[] array = byArray;
        $receiver.writeShort(array.length);
        IntRange intRange = RangesKt.until(0, array.length);
        int n = intRange.getFirst();
        int n2 = intRange.getLast();
        if (n <= n2) {
            while (true) {
                void i;
                $receiver.writeByte((int)array[i]);
                if (i == n2) break;
                ++i;
            }
        }
    }

    public static final void sendMessage(@NotNull EntityPlayer $receiver, @NotNull String str, Object ... args) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(str, "str");
        Intrinsics.checkParameterIsNotNull(args, "args");
        $receiver.func_146105_b((ITextComponent)new TextComponentTranslation(str, Arrays.copyOf(args, args.length)));
    }

    @NotNull
    public static final TextComponentTranslation translate(@NotNull String str, Object ... args) {
        Intrinsics.checkParameterIsNotNull(str, "str");
        Intrinsics.checkParameterIsNotNull(args, "args");
        return new TextComponentTranslation(str, Arrays.copyOf(args, args.length));
    }

    public static final boolean isServer(@NotNull World $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return !$receiver.field_72995_K;
    }

    public static final boolean isClient(@NotNull World $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return $receiver.field_72995_K;
    }

    public static final void setBlockPos(@NotNull NBTTagCompound $receiver, @NotNull String key, @NotNull BlockPos pos) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(key, "key");
        Intrinsics.checkParameterIsNotNull(pos, "pos");
        NBTTagList nBTTagList = new NBTTagList();
        String string = key;
        NBTTagCompound nBTTagCompound = $receiver;
        NBTTagList $receiver2 = nBTTagList;
        $receiver2.func_74742_a((NBTBase)new NBTTagInt(pos.func_177958_n()));
        $receiver2.func_74742_a((NBTBase)new NBTTagInt(pos.func_177956_o()));
        $receiver2.func_74742_a((NBTBase)new NBTTagInt(pos.func_177952_p()));
        NBTTagList nBTTagList2 = nBTTagList;
        nBTTagCompound.func_74782_a(string, (NBTBase)nBTTagList2);
    }

    @NotNull
    public static final BlockPos getBlockPos(@NotNull NBTTagCompound $receiver, @NotNull String key) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(key, "key");
        NBTTagList list = $receiver.func_150295_c(key, 3);
        return new BlockPos(list.func_186858_c(0), list.func_186858_c(1), list.func_186858_c(2));
    }

    public static final void setEnumFacing(@NotNull NBTTagCompound $receiver, @NotNull String key, @NotNull EnumFacing facing) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(key, "key");
        Intrinsics.checkParameterIsNotNull(facing, "facing");
        $receiver.func_74768_a(key, facing.ordinal());
    }

    @NotNull
    public static final EnumFacing getEnumFacing(@NotNull NBTTagCompound $receiver, @NotNull String key) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(key, "key");
        EnumFacing enumFacing = EnumFacing.func_82600_a((int)$receiver.func_74762_e(key));
        if (enumFacing == null) {
            Intrinsics.throwNpe();
        }
        return enumFacing;
    }

    @Nullable
    public static final AxisAlignedBB cut(@NotNull AxisAlignedBB $receiver, @NotNull AxisAlignedBB other) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(other, "other");
        if (!$receiver.func_72326_a(other)) {
            return null;
        }
        return new AxisAlignedBB(Math.max($receiver.field_72340_a, other.field_72340_a), Math.max($receiver.field_72338_b, other.field_72338_b), Math.max($receiver.field_72339_c, other.field_72339_c), Math.min($receiver.field_72336_d, other.field_72336_d), Math.min($receiver.field_72337_e, other.field_72337_e), Math.min($receiver.field_72334_f, other.field_72334_f));
    }

    @NotNull
    public static final AxisAlignedBB getEMPTY_AABB() {
        return EMPTY_AABB;
    }
}

