/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.util.misc;

import com.cout970.magneticraft.util.vector.Vec2d;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\u0011\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0003H\u0086\u0002J\u001d\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001R\u0011\u0010\u0006\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\bR\u0011\u0010\u000b\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\b\u00a8\u0006\u0013"}, d2={"Lcom/cout970/magneticraft/util/misc/Box;", "", "pos", "Lcom/cout970/magneticraft/util/vector/Vec2d;", "size", "(Lcom/cout970/magneticraft/util/vector/Vec2d;Lcom/cout970/magneticraft/util/vector/Vec2d;)V", "end", "getEnd", "()Lcom/cout970/magneticraft/util/vector/Vec2d;", "getPos", "getSize", "start", "getStart", "component1", "component2", "contains", "", "point", "copy", "magneticraft-compileKotlin"})
public final class Box {
    @NotNull
    private final Vec2d pos;
    @NotNull
    private final Vec2d size;

    @NotNull
    public final Vec2d getStart() {
        return this.pos;
    }

    @NotNull
    public final Vec2d getEnd() {
        return this.pos.plus(this.size);
    }

    public final boolean contains(@NotNull Vec2d point) {
        Intrinsics.checkParameterIsNotNull(point, "point");
        return RangesKt.rangeTo(this.getStart().getX(), this.getEnd().getX()).contains(point.getX()) && RangesKt.rangeTo(this.getStart().getY(), this.getEnd().getY()).contains(point.getY());
    }

    @NotNull
    public final Vec2d getPos() {
        return this.pos;
    }

    @NotNull
    public final Vec2d getSize() {
        return this.size;
    }

    public Box(@NotNull Vec2d pos, @NotNull Vec2d size) {
        Intrinsics.checkParameterIsNotNull(pos, "pos");
        Intrinsics.checkParameterIsNotNull(size, "size");
        this.pos = pos;
        this.size = size;
    }

    @NotNull
    public final Vec2d component1() {
        return this.pos;
    }

    @NotNull
    public final Vec2d component2() {
        return this.size;
    }

    @NotNull
    public final Box copy(@NotNull Vec2d pos, @NotNull Vec2d size) {
        Intrinsics.checkParameterIsNotNull(pos, "pos");
        Intrinsics.checkParameterIsNotNull(size, "size");
        return new Box(pos, size);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ Box copy$default(Box box, Vec2d vec2d, Vec2d vec2d2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: copy");
        }
        if ((n & 1) != 0) {
            vec2d = box.pos;
        }
        if ((n & 2) != 0) {
            vec2d2 = box.size;
        }
        return box.copy(vec2d, vec2d2);
    }

    public String toString() {
        return "Box(pos=" + this.pos + ", size=" + this.size + ")";
    }

    public int hashCode() {
        Vec2d vec2d = this.pos;
        Vec2d vec2d2 = this.size;
        return (vec2d != null ? ((Object)vec2d).hashCode() : 0) * 31 + (vec2d2 != null ? ((Object)vec2d2).hashCode() : 0);
    }

    public boolean equals(Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof Box)) break block3;
                Box box = (Box)object;
                if (!Intrinsics.areEqual(this.pos, box.pos) || !Intrinsics.areEqual(this.size, box.size)) break block3;
            }
            return true;
        }
        return false;
    }
}

