/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.util.misc;

import com.cout970.magneticraft.api.energy.IElectricConnection;
import com.cout970.magneticraft.api.energy.IElectricNode;
import com.cout970.magneticraft.api.energy.IElectricNodeHandler;
import com.cout970.magneticraft.api.energy.INode;
import com.cout970.magneticraft.api.energy.INodeHandler;
import com.cout970.magneticraft.api.energy.IWireConnector;
import com.cout970.magneticraft.registry.CapabilitiesKt;
import com.cout970.magneticraft.tileentity.electric.TileElectricBase;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\bJ\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0005H\u00c6\u0003J1\u0010\u0019\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\u0005H\u00c6\u0001J\u0016\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR$\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000e@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\nR\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\f\u00a8\u0006 "}, d2={"Lcom/cout970/magneticraft/util/misc/UnloadedElectricConnection;", "", "first", "Lnet/minecraft/util/math/BlockPos;", "firstIndex", "", "second", "secondIndex", "(Lnet/minecraft/util/math/BlockPos;ILnet/minecraft/util/math/BlockPos;I)V", "getFirst", "()Lnet/minecraft/util/math/BlockPos;", "getFirstIndex", "()I", "<set-?>", "", "isValid", "()Z", "setValid", "(Z)V", "getSecond", "getSecondIndex", "component1", "component2", "component3", "component4", "copy", "create", "world", "Lnet/minecraft/world/World;", "handler", "Lcom/cout970/magneticraft/api/energy/IElectricNodeHandler;", "Companion", "magneticraft-compileKotlin"})
public final class UnloadedElectricConnection {
    private boolean isValid;
    @NotNull
    private final BlockPos first;
    private final int firstIndex;
    @NotNull
    private final BlockPos second;
    private final int secondIndex;
    public static final Companion Companion = new Companion(null);

    public final boolean isValid() {
        return this.isValid;
    }

    private final void setValid(boolean bl) {
        this.isValid = bl;
    }

    public final boolean create(@NotNull World world, @NotNull IElectricNodeHandler handler) {
        Intrinsics.checkParameterIsNotNull(world, "world");
        Intrinsics.checkParameterIsNotNull(handler, "handler");
        if (!world.func_175707_a(this.first, this.second)) {
            return false;
        }
        TileEntity tile0 = world.func_175625_s(this.first);
        TileEntity tile1 = world.func_175625_s(this.second);
        if (tile0 == null || tile1 == null) {
            return true;
        }
        Capability<INodeHandler> capability = CapabilitiesKt.getNODE_HANDLER();
        if (capability == null) {
            Intrinsics.throwNpe();
        }
        INodeHandler handler0 = (INodeHandler)CapabilitiesKt.fromTile$default(capability, tile0, null, 2, null);
        Capability<INodeHandler> capability2 = CapabilitiesKt.getNODE_HANDLER();
        if (capability2 == null) {
            Intrinsics.throwNpe();
        }
        INodeHandler handler1 = (INodeHandler)CapabilitiesKt.fromTile$default(capability2, tile1, null, 2, null);
        if (!(handler0 instanceof IElectricNodeHandler) || !(handler1 instanceof IElectricNodeHandler)) {
            return true;
        }
        List<INode> nodes0 = ((IElectricNodeHandler)handler0).getNodes();
        List<INode> nodes1 = ((IElectricNodeHandler)handler1).getNodes();
        if (this.firstIndex < 0 || this.secondIndex < 0) {
            return true;
        }
        if (nodes0.size() <= this.firstIndex || nodes1.size() <= this.secondIndex) {
            return true;
        }
        INode node0 = nodes0.get(this.firstIndex);
        INode node1 = nodes1.get(this.secondIndex);
        if (!(node0 instanceof IWireConnector)) {
            return true;
        }
        if (!(node1 instanceof IWireConnector)) {
            return true;
        }
        TileElectricBase.Companion.connectNodes((IElectricNodeHandler)handler0, (IWireConnector)node0, (IElectricNodeHandler)handler1, (IWireConnector)node1);
        return true;
    }

    @NotNull
    public final BlockPos getFirst() {
        return this.first;
    }

    public final int getFirstIndex() {
        return this.firstIndex;
    }

    @NotNull
    public final BlockPos getSecond() {
        return this.second;
    }

    public final int getSecondIndex() {
        return this.secondIndex;
    }

    public UnloadedElectricConnection(@NotNull BlockPos first, int firstIndex, @NotNull BlockPos second, int secondIndex) {
        Intrinsics.checkParameterIsNotNull(first, "first");
        Intrinsics.checkParameterIsNotNull(second, "second");
        this.first = first;
        this.firstIndex = firstIndex;
        this.second = second;
        this.secondIndex = secondIndex;
        this.isValid = true;
    }

    @NotNull
    public final BlockPos component1() {
        return this.first;
    }

    public final int component2() {
        return this.firstIndex;
    }

    @NotNull
    public final BlockPos component3() {
        return this.second;
    }

    public final int component4() {
        return this.secondIndex;
    }

    @NotNull
    public final UnloadedElectricConnection copy(@NotNull BlockPos first, int firstIndex, @NotNull BlockPos second, int secondIndex) {
        Intrinsics.checkParameterIsNotNull(first, "first");
        Intrinsics.checkParameterIsNotNull(second, "second");
        return new UnloadedElectricConnection(first, firstIndex, second, secondIndex);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ UnloadedElectricConnection copy$default(UnloadedElectricConnection unloadedElectricConnection, BlockPos blockPos, int n, BlockPos blockPos2, int n2, int n3, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: copy");
        }
        if ((n3 & 1) != 0) {
            blockPos = unloadedElectricConnection.first;
        }
        if ((n3 & 2) != 0) {
            n = unloadedElectricConnection.firstIndex;
        }
        if ((n3 & 4) != 0) {
            blockPos2 = unloadedElectricConnection.second;
        }
        if ((n3 & 8) != 0) {
            n2 = unloadedElectricConnection.secondIndex;
        }
        return unloadedElectricConnection.copy(blockPos, n, blockPos2, n2);
    }

    public String toString() {
        return "UnloadedElectricConnection(first=" + this.first + ", firstIndex=" + this.firstIndex + ", second=" + this.second + ", secondIndex=" + this.secondIndex + ")";
    }

    public int hashCode() {
        BlockPos blockPos = this.first;
        BlockPos blockPos2 = this.second;
        return (((blockPos != null ? blockPos.hashCode() : 0) * 31 + this.firstIndex) * 31 + (blockPos2 != null ? blockPos2.hashCode() : 0)) * 31 + this.secondIndex;
    }

    public boolean equals(Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof UnloadedElectricConnection)) break block3;
                UnloadedElectricConnection unloadedElectricConnection = (UnloadedElectricConnection)object;
                if (!Intrinsics.areEqual(this.first, unloadedElectricConnection.first) || !(this.firstIndex == unloadedElectricConnection.firstIndex) || !Intrinsics.areEqual(this.second, unloadedElectricConnection.second) || !(this.secondIndex == unloadedElectricConnection.secondIndex)) break block3;
            }
            return true;
        }
        return false;
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0004\u00a8\u0006\n"}, d2={"Lcom/cout970/magneticraft/util/misc/UnloadedElectricConnection$Companion;", "", "()V", "load", "Lcom/cout970/magneticraft/util/misc/UnloadedElectricConnection;", "nbt", "Lnet/minecraft/nbt/NBTTagCompound;", "save", "con", "Lcom/cout970/magneticraft/api/energy/IElectricConnection;", "magneticraft-compileKotlin"})
    public static final class Companion {
        @NotNull
        public final UnloadedElectricConnection load(@NotNull NBTTagCompound nbt) {
            Intrinsics.checkParameterIsNotNull(nbt, "nbt");
            BlockPos pos0 = new BlockPos(nbt.func_74762_e("x0"), nbt.func_74762_e("y0"), nbt.func_74762_e("z0"));
            BlockPos pos1 = new BlockPos(nbt.func_74762_e("x1"), nbt.func_74762_e("y1"), nbt.func_74762_e("z1"));
            return new UnloadedElectricConnection(pos0, nbt.func_74762_e("index0"), pos1, nbt.func_74762_e("index1"));
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final NBTTagCompound save(@NotNull IElectricConnection con) {
            int n;
            BlockPos pos1;
            NBTTagCompound $receiver;
            NBTTagCompound nBTTagCompound;
            block7: {
                void $receiver$iv;
                IElectricNodeHandler handler1;
                int n2;
                Object item$iv2;
                BlockPos pos0;
                block6: {
                    void $receiver$iv2;
                    IElectricNodeHandler handler0;
                    Intrinsics.checkParameterIsNotNull(con, "con");
                    nBTTagCompound = new NBTTagCompound();
                    $receiver = nBTTagCompound;
                    pos0 = con.getFirstNode().getPos();
                    IElectricNode iElectricNode = con.getFirstNode();
                    Intrinsics.checkExpressionValueIsNotNull(iElectricNode, "con.firstNode");
                    IElectricNodeHandler iElectricNodeHandler = handler0 = TileElectricBase.Companion.getHandler(iElectricNode);
                    if (iElectricNodeHandler == null) {
                        Intrinsics.throwNpe();
                    }
                    List<INode> list = iElectricNodeHandler.getNodes();
                    int index$iv = 0;
                    for (Object item$iv2 : $receiver$iv2) {
                        INode it = (INode)item$iv2;
                        if (Intrinsics.areEqual(con.getFirstNode(), it)) {
                            n2 = index$iv;
                            break block6;
                        }
                        ++index$iv;
                    }
                    n2 = -1;
                }
                int index0 = n2;
                $receiver.func_74768_a("x0", pos0.func_177958_n());
                $receiver.func_74768_a("y0", pos0.func_177956_o());
                $receiver.func_74768_a("z0", pos0.func_177952_p());
                $receiver.func_74768_a("index0", index0);
                pos1 = con.getSecondNode().getPos();
                IElectricNode iElectricNode = con.getSecondNode();
                Intrinsics.checkExpressionValueIsNotNull(iElectricNode, "con.secondNode");
                IElectricNodeHandler iElectricNodeHandler = handler1 = TileElectricBase.Companion.getHandler(iElectricNode);
                if (iElectricNodeHandler == null) {
                    Intrinsics.throwNpe();
                }
                item$iv2 = iElectricNodeHandler.getNodes();
                int index$iv = 0;
                for (Object item$iv3 : $receiver$iv) {
                    INode it = (INode)item$iv3;
                    if (Intrinsics.areEqual(con.getSecondNode(), it)) {
                        n = index$iv;
                        break block7;
                    }
                    ++index$iv;
                }
                n = -1;
            }
            int index1 = n;
            $receiver.func_74768_a("x1", pos1.func_177958_n());
            $receiver.func_74768_a("y1", pos1.func_177956_o());
            $receiver.func_74768_a("z1", pos1.func_177952_p());
            $receiver.func_74768_a("index1", index1);
            return nBTTagCompound;
        }

        @NotNull
        public final NBTTagCompound save(@NotNull UnloadedElectricConnection con) {
            Intrinsics.checkParameterIsNotNull(con, "con");
            NBTTagCompound nBTTagCompound = new NBTTagCompound();
            NBTTagCompound $receiver = nBTTagCompound;
            BlockPos pos0 = con.getFirst();
            $receiver.func_74768_a("x0", pos0.func_177958_n());
            $receiver.func_74768_a("y0", pos0.func_177956_o());
            $receiver.func_74768_a("z0", pos0.func_177952_p());
            $receiver.func_74768_a("index0", con.getFirstIndex());
            BlockPos pos1 = con.getSecond();
            $receiver.func_74768_a("x1", pos1.func_177958_n());
            $receiver.func_74768_a("y1", pos1.func_177956_o());
            $receiver.func_74768_a("z1", pos1.func_177952_p());
            $receiver.func_74768_a("index1", con.getSecondIndex());
            return nBTTagCompound;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

