/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.util.vector;

import com.cout970.magneticraft.util.misc.Box;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0004\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u000b\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0015\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\b\u0018\u0000 72\u00020\u0001:\u00017B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0007\u0012\u0006\u0010\u0004\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\u001f\u001a\u00020\u0000J\u0011\u0010 \u001a\u00020\u00002\u0006\u0010!\u001a\u00020\u0000H\u0086\u0004J\u0016\u0010 \u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003J\t\u0010\"\u001a\u00020\u0007H\u00c6\u0003J\t\u0010#\u001a\u00020\u0007H\u00c6\u0003J\u001d\u0010$\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00072\b\b\u0002\u0010\u0004\u001a\u00020\u0007H\u00c6\u0001J\u0011\u0010%\u001a\u00020\u00002\u0006\u0010&\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010%\u001a\u00020\u00002\u0006\u0010&\u001a\u00020\u0003H\u0086\u0002J\u0006\u0010'\u001a\u00020\u0000J\u0011\u0010(\u001a\u00020\u00002\u0006\u0010&\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010(\u001a\u00020\u00002\u0006\u0010&\u001a\u00020\u0003H\u0086\u0002J\u0011\u0010)\u001a\u00020\u00002\u0006\u0010&\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010)\u001a\u00020\u00002\u0006\u0010&\u001a\u00020\u0003H\u0086\u0002J\u0006\u0010*\u001a\u00020\u0000J\u0011\u0010+\u001a\u00020\u00002\u0006\u0010&\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010+\u001a\u00020\u00002\u0006\u0010&\u001a\u00020\u0003H\u0086\u0002J\u0011\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020\u0000H\u0086\u0004J\u0012\u0010/\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u000700J\u001a\u00101\u001a\u00020\u00002\u0012\u00102\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u000703J\t\u00104\u001a\u00020\u0000H\u0086\u0002J\u0006\u00105\u001a\u00020\u0000J\u0006\u00106\u001a\u00020\u0000R\u0017\u0010\t\u001a\u00020\u00078F\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\u000e\u001a\u00020\u00078F\u00a2\u0006\f\n\u0004\b\u0010\u0010\r\u001a\u0004\b\u000f\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000bR\u0011\u0010\u0012\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u0004\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u000bR\u0011\u0010\u001b\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u0015R\u0011\u0010\u001d\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u0019\u00a8\u00068"}, d2={"Lcom/cout970/magneticraft/util/vector/Vec2d;", "", "x", "", "y", "(Ljava/lang/Number;Ljava/lang/Number;)V", "(Ljava/lang/Number;)V", "", "(DD)V", "length", "getLength", "()D", "length$delegate", "Lkotlin/Lazy;", "lengthSquared", "getLengthSquared", "lengthSquared$delegate", "getX", "xf", "", "getXf", "()F", "xi", "", "getXi", "()I", "getY", "yf", "getYf", "yi", "getYi", "center", "centeredAt", "pos", "component1", "component2", "copy", "div", "v", "floor", "minus", "plus", "swap", "times", "to", "Lcom/cout970/magneticraft/util/misc/Box;", "other", "toPair", "Lkotlin/Pair;", "transform", "op", "Lkotlin/Function1;", "unaryMinus", "xCenter", "yCenter", "Companion", "magneticraft-compileKotlin"})
public final class Vec2d {
    @NotNull
    private final Lazy lengthSquared$delegate;
    @NotNull
    private final Lazy length$delegate;
    private final double x;
    private final double y;
    @NotNull
    private static final Vec2d ZERO;
    private static final /* synthetic */ KProperty[] $$delegatedProperties;
    public static final Companion Companion;

    public final double getLengthSquared() {
        Lazy lazy = this.lengthSquared$delegate;
        Vec2d vec2d = this;
        KProperty kProperty = $$delegatedProperties[0];
        return ((Number)lazy.getValue()).doubleValue();
    }

    public final double getLength() {
        Lazy lazy = this.length$delegate;
        Vec2d vec2d = this;
        KProperty kProperty = $$delegatedProperties[1];
        return ((Number)lazy.getValue()).doubleValue();
    }

    public final float getXf() {
        return (float)this.x;
    }

    public final float getYf() {
        return (float)this.y;
    }

    public final int getXi() {
        return (int)this.x;
    }

    public final int getYi() {
        return (int)this.y;
    }

    @NotNull
    public final Pair<Double, Double> toPair() {
        return TuplesKt.to(this.x, this.y);
    }

    @NotNull
    public final Vec2d swap() {
        return new Vec2d(this.y, this.x);
    }

    @NotNull
    public final Vec2d plus(@NotNull Number v) {
        Intrinsics.checkParameterIsNotNull(v, "v");
        return new Vec2d(v.doubleValue() + this.x, v.doubleValue() + this.y);
    }

    @NotNull
    public final Vec2d plus(@NotNull Vec2d v) {
        Intrinsics.checkParameterIsNotNull(v, "v");
        return new Vec2d(v.x + this.x, v.y + this.y);
    }

    @NotNull
    public final Vec2d minus(@NotNull Number v) {
        Intrinsics.checkParameterIsNotNull(v, "v");
        return new Vec2d(this.x - v.doubleValue(), this.y - v.doubleValue());
    }

    @NotNull
    public final Vec2d minus(@NotNull Vec2d v) {
        Intrinsics.checkParameterIsNotNull(v, "v");
        return new Vec2d(this.x - v.x, this.y - v.y);
    }

    @NotNull
    public final Vec2d times(@NotNull Vec2d v) {
        Intrinsics.checkParameterIsNotNull(v, "v");
        return new Vec2d(v.x * this.x, v.y * this.y);
    }

    @NotNull
    public final Vec2d times(@NotNull Number v) {
        Intrinsics.checkParameterIsNotNull(v, "v");
        return new Vec2d(v.doubleValue() * this.x, v.doubleValue() * this.y);
    }

    @NotNull
    public final Vec2d div(@NotNull Vec2d v) {
        Intrinsics.checkParameterIsNotNull(v, "v");
        return new Vec2d(this.x / v.x, this.y / v.y);
    }

    @NotNull
    public final Vec2d div(@NotNull Number v) {
        Intrinsics.checkParameterIsNotNull(v, "v");
        return new Vec2d(this.x / v.doubleValue(), this.y / v.doubleValue());
    }

    @NotNull
    public final Vec2d unaryMinus() {
        return new Vec2d(-this.x, -this.y);
    }

    @NotNull
    public final Vec2d center() {
        return new Vec2d(this.x / (double)2, this.y / (double)2);
    }

    @NotNull
    public final Vec2d xCenter() {
        return new Vec2d(this.x / (double)2, this.y);
    }

    @NotNull
    public final Vec2d yCenter() {
        return new Vec2d(this.x, this.y / (double)2);
    }

    @NotNull
    public final Vec2d centeredAt(@NotNull Vec2d pos) {
        Intrinsics.checkParameterIsNotNull(pos, "pos");
        return pos.minus(this.center());
    }

    @NotNull
    public final Vec2d centeredAt(@NotNull Number x, @NotNull Number y) {
        Intrinsics.checkParameterIsNotNull(x, "x");
        Intrinsics.checkParameterIsNotNull(y, "y");
        return new Vec2d(x, y).minus(this.center());
    }

    @NotNull
    public final Box to(@NotNull Vec2d other) {
        Intrinsics.checkParameterIsNotNull(other, "other");
        return new Box(this, other.minus(this));
    }

    @NotNull
    public final Vec2d floor() {
        return new Vec2d((Number)((int)this.x), (Number)((int)this.y));
    }

    @NotNull
    public final Vec2d transform(@NotNull Function1<? super Double, Double> op) {
        Intrinsics.checkParameterIsNotNull(op, "op");
        return new Vec2d(((Number)op.invoke((Double)this.x)).doubleValue(), ((Number)op.invoke((Double)this.y)).doubleValue());
    }

    public final double getX() {
        return this.x;
    }

    public final double getY() {
        return this.y;
    }

    public Vec2d(double x, double y) {
        this.x = x;
        this.y = y;
        this.lengthSquared$delegate = LazyKt.lazy((Function0)new Function0<Double>(this){
            final /* synthetic */ Vec2d this$0;

            public final double invoke() {
                return this.this$0.getX() * this.this$0.getX() + this.this$0.getY() * this.this$0.getY();
            }
            {
                this.this$0 = vec2d;
                super(0);
            }
        });
        this.length$delegate = LazyKt.lazy((Function0)new Function0<Double>(this){
            final /* synthetic */ Vec2d this$0;

            public final double invoke() {
                return Math.sqrt(this.this$0.getLengthSquared());
            }
            {
                this.this$0 = vec2d;
                super(0);
            }
        });
    }

    public Vec2d(@NotNull Number x, @NotNull Number y) {
        Intrinsics.checkParameterIsNotNull(x, "x");
        Intrinsics.checkParameterIsNotNull(y, "y");
        this(x.doubleValue(), y.doubleValue());
    }

    public Vec2d(@NotNull Number x) {
        Intrinsics.checkParameterIsNotNull(x, "x");
        this(x.doubleValue(), x.doubleValue());
    }

    static {
        Companion = new Companion(null);
        ZERO = new Vec2d(0.0, 0.0);
        $$delegatedProperties = new KProperty[]{Reflection.property1(new PropertyReference1Impl(Reflection.getOrCreateKotlinClass(Vec2d.class), "lengthSquared", "getLengthSquared()D")), Reflection.property1(new PropertyReference1Impl(Reflection.getOrCreateKotlinClass(Vec2d.class), "length", "getLength()D"))};
    }

    public final double component1() {
        return this.x;
    }

    public final double component2() {
        return this.y;
    }

    @NotNull
    public final Vec2d copy(double x, double y) {
        return new Vec2d(x, y);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ Vec2d copy$default(Vec2d vec2d, double d, double d2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: copy");
        }
        if ((n & 1) != 0) {
            d = vec2d.x;
        }
        if ((n & 2) != 0) {
            d2 = vec2d.y;
        }
        return vec2d.copy(d, d2);
    }

    public String toString() {
        return "Vec2d(x=" + this.x + ", y=" + this.y + ")";
    }

    public int hashCode() {
        long l = Double.doubleToLongBits(this.x);
        long l2 = Double.doubleToLongBits(this.y);
        return (int)(l ^ l >>> 32) * 31 + (int)(l2 ^ l2 >>> 32);
    }

    public boolean equals(Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof Vec2d)) break block3;
                Vec2d vec2d = (Vec2d)object;
                if (Double.compare(this.x, vec2d.x) != 0 || Double.compare(this.y, vec2d.y) != 0) break block3;
            }
            return true;
        }
        return false;
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/cout970/magneticraft/util/vector/Vec2d$Companion;", "", "()V", "ZERO", "Lcom/cout970/magneticraft/util/vector/Vec2d;", "getZERO", "()Lcom/cout970/magneticraft/util/vector/Vec2d;", "magneticraft-compileKotlin"})
    public static final class Companion {
        @NotNull
        public final Vec2d getZERO() {
            return ZERO;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

