/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.world;

import com.cout970.magneticraft.config.GaussOreConfig;
import com.cout970.magneticraft.config.OreConfig;
import com.cout970.magneticraft.util.vector.Vec2d;
import com.cout970.magneticraft.world.OreGenerator;
import java.util.Random;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import net.minecraft.block.state.IBlockState;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkGenerator;
import net.minecraft.world.chunk.IChunkProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J@\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0016"}, d2={"Lcom/cout970/magneticraft/world/GaussianOreGenerator;", "Lcom/cout970/magneticraft/world/OreGenerator;", "blockstate", "Lnet/minecraft/block/state/IBlockState;", "conf", "Lcom/cout970/magneticraft/config/GaussOreConfig;", "(Lnet/minecraft/block/state/IBlockState;Lcom/cout970/magneticraft/config/GaussOreConfig;)V", "getConf", "()Lcom/cout970/magneticraft/config/GaussOreConfig;", "generate", "", "random", "Ljava/util/Random;", "chunkX", "", "chunkZ", "world", "Lnet/minecraft/world/World;", "chunkGenerator", "Lnet/minecraft/world/chunk/IChunkGenerator;", "chunkProvider", "Lnet/minecraft/world/chunk/IChunkProvider;", "magneticraft-compileKotlin"})
public final class GaussianOreGenerator
extends OreGenerator {
    @NotNull
    private final GaussOreConfig conf;

    @Override
    public void generate(@Nullable Random random, int chunkX, int chunkZ, @Nullable World world, @Nullable IChunkGenerator chunkGenerator, @Nullable IChunkProvider chunkProvider) {
        if (world == null || random == null) {
            return;
        }
        if (CollectionsKt.listOf(new Integer[]{1, -1}).contains(world.field_73011_w.getDimension())) {
            return;
        }
        if (this.conf.getActive()) {
            double randGaussian = random.nextGaussian() * (double)this.conf.getDeviation() + (double)this.conf.getChunkAmount();
            int veins = RangesKt.coerceIn(RangesKt.coerceAtLeast((int)Math.floor(randGaussian), 0), this.conf.getMinAmountPerChunk(), this.conf.getMaxAmountPerChunk());
            this.generateChunkOres(world, new Vec2d((Number)chunkX, (Number)chunkZ), random, veins);
        }
    }

    @NotNull
    public final GaussOreConfig getConf() {
        return this.conf;
    }

    public GaussianOreGenerator(@NotNull IBlockState blockstate, @NotNull GaussOreConfig conf) {
        Intrinsics.checkParameterIsNotNull(blockstate, "blockstate");
        Intrinsics.checkParameterIsNotNull(conf, "conf");
        super(blockstate, (OreConfig)conf);
        this.conf = conf;
    }
}

