/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.world;

import com.cout970.magneticraft.config.OreConfig;
import com.cout970.magneticraft.util.vector.Vec2d;
import com.google.common.base.Predicate;
import java.util.Random;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkGenerator;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.fml.common.IWorldGenerator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 )2\u00020\u0001:\u0001)B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0007\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\bB-\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00070\f\u00a2\u0006\u0002\u0010\rB#\u0012\u0006\u0010\u0002\u001a\u00020\u0007\u0012\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00070\f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u000fJ@\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\n2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\b\u0010 \u001a\u0004\u0018\u00010!H\u0016J.\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\"\u001a\u00020\n2\u0006\u0010#\u001a\u00020\n2\u0006\u0010$\u001a\u00020\nJ&\u0010%\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010&\u001a\u00020'2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010(\u001a\u00020\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0002\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00070\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006*"}, d2={"Lcom/cout970/magneticraft/world/OreGenerator;", "Lnet/minecraftforge/fml/common/IWorldGenerator;", "ore", "Lnet/minecraft/block/Block;", "config", "Lcom/cout970/magneticraft/config/OreConfig;", "(Lnet/minecraft/block/Block;Lcom/cout970/magneticraft/config/OreConfig;)V", "Lnet/minecraft/block/state/IBlockState;", "(Lnet/minecraft/block/state/IBlockState;Lcom/cout970/magneticraft/config/OreConfig;)V", "meta", "", "target", "Lcom/google/common/base/Predicate;", "(Lnet/minecraft/block/Block;ILcom/cout970/magneticraft/config/OreConfig;Lcom/google/common/base/Predicate;)V", "predicate", "(Lnet/minecraft/block/state/IBlockState;Lcom/google/common/base/Predicate;Lcom/cout970/magneticraft/config/OreConfig;)V", "getConfig", "()Lcom/cout970/magneticraft/config/OreConfig;", "getOre", "()Lnet/minecraft/block/state/IBlockState;", "getPredicate", "()Lcom/google/common/base/Predicate;", "generate", "", "random", "Ljava/util/Random;", "chunkX", "chunkZ", "world", "Lnet/minecraft/world/World;", "chunkGenerator", "Lnet/minecraft/world/chunk/IChunkGenerator;", "chunkProvider", "Lnet/minecraft/world/chunk/IChunkProvider;", "x", "y", "z", "generateChunkOres", "pos", "Lcom/cout970/magneticraft/util/vector/Vec2d;", "chunkAmount", "Companion", "magneticraft-compileKotlin"})
public class OreGenerator
implements IWorldGenerator {
    @NotNull
    private final IBlockState ore;
    @NotNull
    private final Predicate<IBlockState> predicate;
    @NotNull
    private final OreConfig config;
    public static final Companion Companion = new Companion(null);

    public void generate(@Nullable Random random, int chunkX, int chunkZ, @Nullable World world, @Nullable IChunkGenerator chunkGenerator, @Nullable IChunkProvider chunkProvider) {
        if (world == null || random == null) {
            return;
        }
        if (CollectionsKt.listOf(new Integer[]{1, -1}).contains(world.field_73011_w.getDimension())) {
            return;
        }
        this.generateChunkOres(world, new Vec2d((Number)chunkX, (Number)chunkZ), random, this.config.getChunkAmount());
    }

    /*
     * WARNING - void declaration
     */
    public final void generateChunkOres(@NotNull World world, @NotNull Vec2d pos, @NotNull Random random, int chunkAmount) {
        Intrinsics.checkParameterIsNotNull(world, "world");
        Intrinsics.checkParameterIsNotNull(pos, "pos");
        Intrinsics.checkParameterIsNotNull(random, "random");
        int n = 0;
        int n2 = chunkAmount - 1;
        if (n <= n2) {
            while (true) {
                void k;
                int x = pos.getXi() * 16 + random.nextInt(16);
                int y = this.config.getMinLevel() + random.nextInt(this.config.getMaxLevel() - this.config.getMinLevel());
                int z = pos.getYi() * 16 + random.nextInt(16);
                this.generate(world, random, x, y, z);
                if (k == n2) break;
                ++k;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void generate(@NotNull World world, @NotNull Random random, int x, int y, int z) {
        Intrinsics.checkParameterIsNotNull(world, "world");
        Intrinsics.checkParameterIsNotNull(random, "random");
        float angle = random.nextFloat() * (float)Math.PI;
        double posX = (double)(x + 8) + Math.sin(angle) * (double)this.config.getVeinAmount() / (double)8.0f;
        double negX = (double)(x + 8) - Math.sin(angle) * (double)this.config.getVeinAmount() / (double)8.0f;
        double posZ = (double)(z + 8) + Math.cos(angle) * (double)this.config.getVeinAmount() / (double)8.0f;
        double negZ = (double)(z + 8) - Math.cos(angle) * (double)this.config.getVeinAmount() / (double)8.0f;
        double y1 = y + random.nextInt(3) - 2;
        double y2 = y + random.nextInt(3) - 2;
        int n = 0;
        int n2 = this.config.getVeinAmount() - 1;
        if (n <= n2) {
            while (true) {
                void n3;
                double xPlace = posX + (negX - posX) * (double)n3 / (double)this.config.getVeinAmount();
                double yPlace = y1 + (y2 - y1) * (double)n3 / (double)this.config.getVeinAmount();
                double zPlace = posZ + (negZ - posZ) * (double)n3 / (double)this.config.getVeinAmount();
                double scale = random.nextDouble() * (double)this.config.getVeinAmount() / 16.0;
                double desp = (Math.sin((double)n3 * Math.PI / (double)this.config.getVeinAmount()) + (double)1.0f) * scale + 1.0;
                int minX = Companion.floor_double(xPlace - desp / 2.0);
                int minY = Companion.floor_double(yPlace - desp / 2.0);
                int minZ = Companion.floor_double(zPlace - desp / 2.0);
                int maxX = Companion.floor_double(xPlace + desp / 2.0);
                int maxY = Companion.floor_double(yPlace + desp / 2.0);
                int maxZ = Companion.floor_double(zPlace + desp / 2.0);
                int n4 = minX;
                int n5 = maxX - 1;
                if (n4 <= n5) {
                    while (true) {
                        int n6;
                        int n7;
                        void i;
                        double xDistance;
                        if ((xDistance = ((double)i + 0.5 - xPlace) / (desp / 2.0)) * xDistance < 1.0 && (n7 = minY) <= (n6 = maxY - 1)) {
                            while (true) {
                                int n8;
                                int n9;
                                void j;
                                double yDistance;
                                if (xDistance * xDistance + (yDistance = ((double)j + 0.5 - yPlace) / (desp / 2.0)) * yDistance < 1.0 && (n9 = minZ) <= (n8 = maxZ - 1)) {
                                    while (true) {
                                        IBlockState state;
                                        void k;
                                        double zDistance = ((double)k + 0.5 - zPlace) / (desp / 2.0);
                                        BlockPos blockPos = new BlockPos((int)i, (int)j, (int)k);
                                        if (xDistance * xDistance + yDistance * yDistance + zDistance * zDistance < 1.0 && (state = world.func_180495_p(blockPos)).func_177230_c().isReplaceableOreGen(state, (IBlockAccess)world, blockPos, this.predicate)) {
                                            world.func_180501_a(blockPos, this.ore, 2);
                                        }
                                        if (k == n8) break;
                                        ++k;
                                    }
                                }
                                if (j == n6) break;
                                ++j;
                            }
                        }
                        if (i == n5) break;
                        ++i;
                    }
                }
                if (n3 == n2) break;
                ++n3;
            }
        }
    }

    @NotNull
    public final IBlockState getOre() {
        return this.ore;
    }

    @NotNull
    public final Predicate<IBlockState> getPredicate() {
        return this.predicate;
    }

    @NotNull
    public final OreConfig getConfig() {
        return this.config;
    }

    public OreGenerator(@NotNull IBlockState ore, @NotNull Predicate<IBlockState> predicate2, @NotNull OreConfig config) {
        Intrinsics.checkParameterIsNotNull(ore, "ore");
        Intrinsics.checkParameterIsNotNull(predicate2, "predicate");
        Intrinsics.checkParameterIsNotNull(config, "config");
        this.ore = ore;
        this.predicate = predicate2;
        this.config = config;
    }

    public OreGenerator(@NotNull Block ore, @NotNull OreConfig config) {
        Intrinsics.checkParameterIsNotNull(ore, "ore");
        Intrinsics.checkParameterIsNotNull(config, "config");
        IBlockState iBlockState = ore.func_176223_P();
        Intrinsics.checkExpressionValueIsNotNull(iBlockState, "ore.defaultState");
        this(iBlockState, (Predicate<IBlockState>)((Predicate)1.INSTANCE), config);
    }

    public OreGenerator(@NotNull IBlockState ore, @NotNull OreConfig config) {
        Intrinsics.checkParameterIsNotNull(ore, "ore");
        Intrinsics.checkParameterIsNotNull(config, "config");
        this(ore, (Predicate<IBlockState>)((Predicate)2.INSTANCE), config);
    }

    public OreGenerator(@NotNull Block ore, int meta, @NotNull OreConfig config, @NotNull Predicate<IBlockState> target) {
        Intrinsics.checkParameterIsNotNull(ore, "ore");
        Intrinsics.checkParameterIsNotNull(config, "config");
        Intrinsics.checkParameterIsNotNull(target, "target");
        IBlockState iBlockState = ore.func_176203_a(meta);
        Intrinsics.checkExpressionValueIsNotNull(iBlockState, "ore.getStateFromMeta(meta)");
        this(iBlockState, target, config);
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/cout970/magneticraft/world/OreGenerator$Companion;", "", "()V", "floor_double", "", "value", "", "magneticraft-compileKotlin"})
    public static final class Companion {
        public final int floor_double(double value) {
            int i = (int)value;
            return value < (double)i ? i - 1 : i;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

