/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.api.internal.energy;

import com.cout970.magneticraft.api.core.ITileRef;
import com.cout970.magneticraft.api.core.NodeID;
import com.cout970.magneticraft.api.energy.IElectricNode;
import com.cout970.magneticraft.misc.NBTKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\b\b\u0016\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0005H\u0016J\u0018\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0012\u0010 \u001a\u00020\u001a2\b\u0010!\u001a\u0004\u0018\u00010\"H\u0016J\u0013\u0010#\u001a\u00020\u001f2\b\u0010$\u001a\u0004\u0018\u00010%H\u0096\u0002J\b\u0010&\u001a\u00020\u0005H\u0016J\b\u0010'\u001a\u00020\u0005H\u0016J\b\u0010(\u001a\u00020)H\u0016J\b\u0010*\u001a\u00020+H\u0016J\b\u0010,\u001a\u00020\u0005H\u0016J\b\u0010-\u001a\u00020\u0005H\u0016J\b\u0010.\u001a\u00020/H\u0016J\b\u00100\u001a\u000201H\u0016J\b\u00102\u001a\u00020\"H\u0016J\u000e\u00103\u001a\u00020\u001a2\u0006\u00104\u001a\u00020\u0005J\u000e\u00105\u001a\u00020\u001a2\u0006\u00106\u001a\u00020\u0005J\b\u00107\u001a\u00020\bH\u0016J\u0006\u00108\u001a\u00020\u001aR\u000e\u0010\n\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"Lcom/cout970/magneticraft/api/internal/energy/ElectricNode;", "Lcom/cout970/magneticraft/api/energy/IElectricNode;", "ref", "Lcom/cout970/magneticraft/api/core/ITileRef;", "capacity", "", "resistance", "name", "", "(Lcom/cout970/magneticraft/api/core/ITileRef;DDLjava/lang/String;)V", "amperage", "amperageCount", "getAmperageCount", "()D", "setAmperageCount", "(D)V", "lastTick", "", "getLastTick", "()J", "setLastTick", "(J)V", "getRef", "()Lcom/cout970/magneticraft/api/core/ITileRef;", "voltage", "applyCurrent", "", "current", "applyPower", "power", "simulated", "", "deserializeNBT", "nbt", "Lnet/minecraft/nbt/NBTTagCompound;", "equals", "other", "", "getAmperage", "getCapacity", "getId", "Lcom/cout970/magneticraft/api/core/NodeID;", "getPos", "Lnet/minecraft/util/math/BlockPos;", "getResistance", "getVoltage", "getWorld", "Lnet/minecraft/world/World;", "hashCode", "", "serializeNBT", "setAmperage", "a", "setVoltage", "v", "toString", "updateAmperage", "Magneticraft_1.12"})
public class ElectricNode
implements IElectricNode {
    private double voltage;
    private double amperage;
    private double amperageCount;
    private long lastTick;
    @NotNull
    private final ITileRef ref;
    private final double capacity;
    private final double resistance;
    private final String name;

    public final double getAmperageCount() {
        return this.amperageCount;
    }

    public final void setAmperageCount(double d) {
        this.amperageCount = d;
    }

    public final long getLastTick() {
        return this.lastTick;
    }

    public final void setLastTick(long l) {
        this.lastTick = l;
    }

    @Override
    @NotNull
    public NodeID getId() {
        BlockPos blockPos = this.getPos();
        WorldProvider worldProvider = this.getWorld().field_73011_w;
        Intrinsics.checkExpressionValueIsNotNull((Object)worldProvider, (String)"world.provider");
        return new NodeID(this.name, blockPos, worldProvider.getDimension());
    }

    @Override
    public double getAmperage() {
        this.updateAmperage();
        return this.amperage;
    }

    public final void setAmperage(double a) {
        this.amperage = a;
    }

    @Override
    public double getVoltage() {
        return this.voltage;
    }

    public final void setVoltage(double v) {
        this.voltage = v;
    }

    @Override
    public double getResistance() {
        return this.resistance;
    }

    @Override
    public double getCapacity() {
        return this.capacity;
    }

    @Override
    @NotNull
    public World getWorld() {
        World world = this.ref.getWorld();
        if (world == null) {
            Intrinsics.throwNpe();
        }
        return world;
    }

    @Override
    @NotNull
    public BlockPos getPos() {
        BlockPos blockPos = this.ref.getPos();
        if (blockPos == null) {
            Intrinsics.throwNpe();
        }
        return blockPos;
    }

    public final void updateAmperage() {
        long tick = this.getWorld().func_82737_E();
        long l = tick;
        if (l == this.lastTick) {
            return;
        }
        if (l == this.lastTick + 1L) {
            this.lastTick = tick;
            this.amperage = this.amperageCount;
            this.amperageCount = 0.0;
        } else {
            World $this$isClient$iv = this.getWorld();
            boolean $i$f$isClient = false;
            if ($this$isClient$iv.field_72995_K) {
                return;
            }
            this.amperage = 0.0;
            this.amperageCount = 0.0;
            this.lastTick = tick;
        }
    }

    @Override
    public void applyCurrent(double current) {
        this.updateAmperage();
        ElectricNode electricNode = this;
        double d = electricNode.amperageCount;
        ElectricNode electricNode2 = electricNode;
        boolean bl = false;
        double d2 = Math.abs(current);
        electricNode2.amperageCount = d + d2;
        this.voltage += current / this.getCapacity();
    }

    @Override
    public double applyPower(double power, boolean simulated) {
        double d = this.voltage * this.voltage * this.getCapacity() + power;
        boolean bl = false;
        double energy = Math.abs(d);
        double d2 = RangesKt.coerceAtLeast((double)0.0, (double)(energy / this.getCapacity()));
        boolean bl2 = false;
        double finalVoltage = Math.sqrt(d2);
        double current = this.getCapacity() * (finalVoltage - this.voltage);
        if (!simulated) {
            this.applyCurrent(current);
        }
        bl2 = false;
        return Math.abs(power);
    }

    public void deserializeNBT(@Nullable NBTTagCompound nbt2) {
        if (nbt2 == null) {
            return;
        }
        this.voltage = nbt2.func_74769_h("V");
        this.amperage = nbt2.func_74769_h("A");
    }

    @NotNull
    public NBTTagCompound serializeNBT() {
        return NBTKt.newNbt((Function1<? super NBTTagCompound, Unit>)((Function1)new Function1<NBTTagCompound, Unit>(this){
            final /* synthetic */ ElectricNode this$0;

            public final void invoke(@NotNull NBTTagCompound $this$newNbt) {
                Intrinsics.checkParameterIsNotNull((Object)$this$newNbt, (String)"$receiver");
                $this$newNbt.func_74780_a("V", ElectricNode.access$getVoltage$p(this.this$0));
                $this$newNbt.func_74780_a("A", ElectricNode.access$getAmperage$p(this.this$0));
            }
            {
                this.this$0 = electricNode;
                super(1);
            }
        }));
    }

    @NotNull
    public String toString() {
        return "ElectricNode(id=" + this.getId() + ", resistance=" + this.resistance + ", capacity=" + this.capacity + ", voltage=" + this.voltage + ", amperage=" + this.amperage;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ElectricNode)) {
            return false;
        }
        if (this.resistance != ((ElectricNode)other).resistance) {
            return false;
        }
        if (this.capacity != ((ElectricNode)other).capacity) {
            return false;
        }
        if (Intrinsics.areEqual((Object)this.name, (Object)((ElectricNode)other).name) ^ true) {
            return false;
        }
        if (this.voltage != ((ElectricNode)other).voltage) {
            return false;
        }
        if (this.amperage != ((ElectricNode)other).amperage) {
            return false;
        }
        return this.lastTick == ((ElectricNode)other).lastTick;
    }

    public int hashCode() {
        int result = ((Object)this.resistance).hashCode();
        result = 31 * result + ((Object)this.capacity).hashCode();
        result = 31 * result + this.name.hashCode();
        result = 31 * result + ((Object)this.voltage).hashCode();
        result = 31 * result + ((Object)this.amperage).hashCode();
        result = 31 * result + ((Object)this.lastTick).hashCode();
        return result;
    }

    @NotNull
    public final ITileRef getRef() {
        return this.ref;
    }

    public ElectricNode(@NotNull ITileRef ref, double capacity, double resistance, @NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)ref, (String)"ref");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        this.ref = ref;
        this.capacity = capacity;
        this.resistance = resistance;
        this.name = name;
    }

    public /* synthetic */ ElectricNode(ITileRef iTileRef, double d, double d2, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            d = 1.0;
        }
        if ((n & 4) != 0) {
            d2 = 0.001;
        }
        if ((n & 8) != 0) {
            string = "electric_node_1";
        }
        this(iTileRef, d, d2, string);
    }

    public static final /* synthetic */ double access$getVoltage$p(ElectricNode $this) {
        return $this.voltage;
    }

    public static final /* synthetic */ void access$setVoltage$p(ElectricNode $this, double d) {
        $this.voltage = d;
    }

    public static final /* synthetic */ double access$getAmperage$p(ElectricNode $this) {
        return $this.amperage;
    }

    public static final /* synthetic */ void access$setAmperage$p(ElectricNode $this, double d) {
        $this.amperage = d;
    }
}

