/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.api.internal.registries.machines.heatrecipes;

import com.cout970.magneticraft.api.internal.registries.machines.heatrecipes.IceboxRecipe;
import com.cout970.magneticraft.api.registries.machines.heatrecipes.IIceboxRecipe;
import com.cout970.magneticraft.api.registries.machines.heatrecipes.IIceboxRecipeManager;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J@\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0017\u001a\u00020\u000bH\u0016J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0017\u001a\u00020\rH\u0016J\u000e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\b0\u001aH\u0016J\u000e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00050\u001aH\u0016J\u0010\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\bH\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/cout970/magneticraft/api/internal/registries/machines/heatrecipes/IceboxRecipeManager;", "Lcom/cout970/magneticraft/api/registries/machines/heatrecipes/IIceboxRecipeManager;", "()V", "fluids", "", "Lnet/minecraftforge/fluids/Fluid;", "recipes", "Ljava/util/LinkedList;", "Lcom/cout970/magneticraft/api/registries/machines/heatrecipes/IIceboxRecipe;", "createRecipe", "input", "Lnet/minecraft/item/ItemStack;", "output", "Lnet/minecraftforge/fluids/FluidStack;", "heat", "", "specificHeat", "", "minTemp", "maxTemp", "reverse", "", "findRecipe", "stack", "findRecipeReverse", "getRecipes", "", "getValidFluids", "registerRecipe", "recipe", "Magneticraft_1.12"})
public final class IceboxRecipeManager
implements IIceboxRecipeManager {
    private static final LinkedList<IIceboxRecipe> recipes;
    private static final Set<Fluid> fluids;
    public static final IceboxRecipeManager INSTANCE;

    @Override
    @Nullable
    public IIceboxRecipe findRecipe(@NotNull ItemStack stack) {
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        for (IIceboxRecipe rec : recipes) {
            if (!rec.matches(stack)) continue;
            return rec;
        }
        return null;
    }

    @Override
    @Nullable
    public IIceboxRecipe findRecipeReverse(@NotNull FluidStack stack) {
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        for (IIceboxRecipe rec : recipes) {
            if (!rec.matchesReverse(stack)) continue;
            return rec;
        }
        return null;
    }

    @Override
    public boolean registerRecipe(@NotNull IIceboxRecipe recipe) {
        Intrinsics.checkParameterIsNotNull((Object)recipe, (String)"recipe");
        ItemStack itemStack = recipe.getInput();
        Intrinsics.checkExpressionValueIsNotNull((Object)itemStack, (String)"recipe.input");
        if (this.findRecipe(itemStack) != null) {
            return false;
        }
        recipes.add(recipe);
        FluidStack fluidStack = recipe.getOutput();
        Intrinsics.checkExpressionValueIsNotNull((Object)fluidStack, (String)"recipe.output");
        Fluid fluid = fluidStack.getFluid();
        Intrinsics.checkExpressionValueIsNotNull((Object)fluid, (String)"recipe.output.fluid");
        fluids.add(fluid);
        return true;
    }

    @Override
    @NotNull
    public List<Fluid> getValidFluids() {
        return CollectionsKt.toList((Iterable)fluids);
    }

    @Override
    @NotNull
    public List<IIceboxRecipe> getRecipes() {
        List<IIceboxRecipe> list = Collections.synchronizedList((List)recipes);
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"Collections.synchronizedList(recipes)");
        return list;
    }

    @Override
    @NotNull
    public IIceboxRecipe createRecipe(@NotNull ItemStack input2, @NotNull FluidStack output2, long heat, double specificHeat, double minTemp, double maxTemp, boolean reverse) {
        Intrinsics.checkParameterIsNotNull((Object)input2, (String)"input");
        Intrinsics.checkParameterIsNotNull((Object)output2, (String)"output");
        return new IceboxRecipe(input2, output2, heat, specificHeat, minTemp, maxTemp, reverse);
    }

    private IceboxRecipeManager() {
    }

    static {
        IceboxRecipeManager iceboxRecipeManager;
        INSTANCE = iceboxRecipeManager = new IceboxRecipeManager();
        recipes = new LinkedList();
        boolean bl = false;
        fluids = new LinkedHashSet();
    }
}

