/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.misc;

import com.cout970.magneticraft.Magneticraft;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004J\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u00042\u0006\u0010\b\u001a\u00020\u0005J\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004J\u001e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u001e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u00a8\u0006\u0011"}, d2={"Lcom/cout970/magneticraft/misc/ResourceList;", "", "()V", "getGuideBookLanguages", "", "", "getGuideBookPages", "Lnet/minecraft/util/ResourceLocation;", "lang", "getModAssets", "getResourcesFromDirectory", "directory", "Ljava/io/File;", "pattern", "Lkotlin/text/Regex;", "getResourcesFromJarFile", "file", "Magneticraft_1.12"})
public final class ResourceList {
    public static final ResourceList INSTANCE;

    private final List<String> getResourcesFromJarFile(File file, Regex pattern) {
        ArrayList<String> returnVal = new ArrayList<String>();
        ZipFile zf = null;
        try {
            zf = new ZipFile(file);
        }
        catch (IOException e) {
            throw (Throwable)new Error(e);
        }
        Enumeration<? extends ZipEntry> e = zf.entries();
        while (e.hasMoreElements()) {
            ZipEntry ze;
            String fileName;
            if (e.nextElement() == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.util.zip.ZipEntry");
            }
            String string = fileName = ze.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"fileName");
            if (!pattern.matches((CharSequence)string)) continue;
            returnVal.add(fileName);
        }
        try {
            zf.close();
        }
        catch (IOException e1) {
            throw (Throwable)new Error(e1);
        }
        return returnVal;
    }

    private final List<String> getResourcesFromDirectory(File directory, Regex pattern) {
        File[] fileList;
        ArrayList<String> returnVal = new ArrayList<String>();
        File[] fileArray = directory.listFiles();
        if (fileArray == null) {
            Intrinsics.throwNpe();
        }
        File[] fileArray2 = fileList = fileArray;
        int n = fileArray2.length;
        for (int i = 0; i < n; ++i) {
            File file;
            File file2 = file = fileArray2[i];
            Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"file");
            if (file2.isDirectory()) {
                returnVal.addAll((Collection)this.getResourcesFromDirectory(file, pattern));
                continue;
            }
            try {
                String fileName;
                String string = fileName = file.getCanonicalPath();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"fileName");
                if (!pattern.matches((CharSequence)string)) continue;
                returnVal.add(fileName);
                continue;
            }
            catch (IOException e) {
                throw (Throwable)new Error(e);
            }
        }
        return returnVal;
    }

    @NotNull
    public final List<String> getModAssets() {
        File file = Magneticraft.INSTANCE.getSourceFile();
        String string = ".*assets[/\\\\]magneticraft[/\\\\].*";
        boolean bl = false;
        Regex pattern = new Regex(string);
        return file.isDirectory() ? this.getResourcesFromDirectory(file, pattern) : this.getResourcesFromJarFile(file, pattern);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> getGuideBookLanguages() {
        void $this$mapTo$iv$iv;
        File file = Magneticraft.INSTANCE.getSourceFile();
        String string = ".*assets[/\\\\]magneticraft[/\\\\]guide[/\\\\].*";
        boolean bl = false;
        Regex pattern = new Regex(string);
        List<String> files = file.isDirectory() ? this.getResourcesFromDirectory(file, pattern) : this.getResourcesFromJarFile(file, pattern);
        Iterable $this$map$iv = files;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string2 = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            CharSequence charSequence = (CharSequence)it;
            String string3 = ".*assets[/\\\\]magneticraft[/\\\\]guide[/\\\\](.*)[/\\\\].*";
            boolean bl3 = false;
            string3 = new Regex(string3);
            String string4 = "$1";
            boolean bl4 = false;
            String string5 = string3.replace(charSequence, string4);
            collection.add(string5);
        }
        return CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<ResourceLocation> getGuideBookPages(@NotNull String lang) {
        String string;
        String it;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)lang, (String)"lang");
        File file = Magneticraft.INSTANCE.getSourceFile();
        String string2 = ".*assets[/\\\\]magneticraft[/\\\\]guide[/\\\\]" + lang + "[/\\\\].*";
        boolean bl = false;
        Regex pattern = new Regex(string2);
        List<String> files = file.isDirectory() ? this.getResourcesFromDirectory(file, pattern) : this.getResourcesFromJarFile(file, pattern);
        Iterable $this$map$iv = files;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string3 = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl2 = false;
            CharSequence charSequence = it;
            String string4 = ".*assets[/\\\\]magneticraft[/\\\\]guide[/\\\\]" + lang + "[/\\\\](.*)";
            boolean bl3 = false;
            string4 = new Regex(string4);
            String string5 = "$1";
            boolean bl4 = false;
            string = string4.replace(charSequence, string5);
            collection.add(string);
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void name;
            it = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl5 = false;
            string = new ResourceLocation("magneticraft", "guide/" + lang + '/' + (String)name);
            collection.add(string);
        }
        return (List)destination$iv$iv;
    }

    private ResourceList() {
    }

    static {
        ResourceList resourceList;
        INSTANCE = resourceList = new ResourceList();
    }
}

