/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.misc.crafting;

import com.cout970.magneticraft.api.MagneticraftApi;
import com.cout970.magneticraft.api.internal.ApiUtils;
import com.cout970.magneticraft.api.registries.machines.gasificationunit.IGasificationUnitRecipe;
import com.cout970.magneticraft.misc.HeatKt;
import com.cout970.magneticraft.misc.crafting.IHeatCraftingProcess;
import com.cout970.magneticraft.misc.fluid.Tank;
import com.cout970.magneticraft.misc.inventory.Inventory;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\tJ\b\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0006\u001a\u00020\u000bH\u0002J\b\u0010\u001c\u001a\u00020\u001aH\u0016R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001d"}, d2={"Lcom/cout970/magneticraft/misc/crafting/GasificationCraftingProcess;", "Lcom/cout970/magneticraft/misc/crafting/IHeatCraftingProcess;", "tank", "Lcom/cout970/magneticraft/misc/fluid/Tank;", "inv", "Lcom/cout970/magneticraft/misc/inventory/Inventory;", "input", "", "output", "(Lcom/cout970/magneticraft/misc/fluid/Tank;Lcom/cout970/magneticraft/misc/inventory/Inventory;II)V", "cacheKey", "Lnet/minecraft/item/ItemStack;", "cacheValue", "Lcom/cout970/magneticraft/api/registries/machines/gasificationunit/IGasificationUnitRecipe;", "getInput", "()I", "getInv", "()Lcom/cout970/magneticraft/misc/inventory/Inventory;", "getOutput", "getTank", "()Lcom/cout970/magneticraft/misc/fluid/Tank;", "canCraft", "", "craft", "", "duration", "", "getRecipe", "minTemperature", "Magneticraft_1.12"})
public final class GasificationCraftingProcess
implements IHeatCraftingProcess {
    private ItemStack cacheKey;
    private IGasificationUnitRecipe cacheValue;
    @NotNull
    private final Tank tank;
    @NotNull
    private final Inventory inv;
    private final int input;
    private final int output;

    private final IGasificationUnitRecipe getRecipe(ItemStack input2) {
        if (ApiUtils.INSTANCE.equalsIgnoreSize(this.cacheKey, input2)) {
            return this.cacheValue;
        }
        IGasificationUnitRecipe recipe = MagneticraftApi.getGasificationUnitRecipeManager().findRecipe(input2);
        this.cacheKey = input2;
        this.cacheValue = recipe;
        return recipe;
    }

    @Override
    public void craft() {
        block2: {
            ItemStack itemStack = this.inv.getStackInSlot(this.input);
            Intrinsics.checkExpressionValueIsNotNull((Object)itemStack, (String)"inv.getStackInSlot(input)");
            IGasificationUnitRecipe iGasificationUnitRecipe = this.getRecipe(itemStack);
            if (iGasificationUnitRecipe == null) {
                Intrinsics.throwNpe();
            }
            IGasificationUnitRecipe recipe = iGasificationUnitRecipe;
            this.inv.extractItem(this.input, 1, false);
            ItemStack itemStack2 = recipe.getItemOutput();
            Intrinsics.checkExpressionValueIsNotNull((Object)itemStack2, (String)"recipe.itemOutput");
            ItemStack $this$ifNonEmpty$iv = itemStack2;
            boolean $i$f$ifNonEmpty = false;
            if (!$this$ifNonEmpty$iv.func_190926_b()) {
                ItemStack it = $this$ifNonEmpty$iv;
                boolean bl = false;
                this.inv.insertItem(this.output, it, false);
            }
            FluidStack fluidStack = recipe.getFluidOutput();
            if (fluidStack == null) break block2;
            FluidStack fluidStack2 = fluidStack;
            boolean bl = false;
            boolean bl2 = false;
            FluidStack it = fluidStack2;
            boolean bl3 = false;
            this.tank.fill(it, true);
        }
    }

    @Override
    public boolean canCraft() {
        ItemStack itemStack = this.inv.extractItem(this.input, 1, true);
        Intrinsics.checkExpressionValueIsNotNull((Object)itemStack, (String)"inv.extractItem(input, 1, true)");
        ItemStack item = itemStack;
        if (item.func_190926_b()) {
            return false;
        }
        IGasificationUnitRecipe iGasificationUnitRecipe = this.getRecipe(item);
        if (iGasificationUnitRecipe == null) {
            return false;
        }
        IGasificationUnitRecipe recipe = iGasificationUnitRecipe;
        ItemStack itemStack2 = recipe.getItemOutput();
        Intrinsics.checkExpressionValueIsNotNull((Object)itemStack2, (String)"recipe.itemOutput");
        ItemStack $this$ifNonEmpty$iv = itemStack2;
        boolean $i$f$ifNonEmpty = false;
        if (!$this$ifNonEmpty$iv.func_190926_b()) {
            ItemStack it = $this$ifNonEmpty$iv;
            boolean bl = false;
            if (Intrinsics.areEqual((Object)this.inv.insertItem(this.output, it, true), (Object)ItemStack.field_190927_a) ^ true) {
                return false;
            }
        }
        FluidStack fluidStack = recipe.getFluidOutput();
        if (fluidStack != null) {
            FluidStack fluidStack2 = fluidStack;
            boolean bl = false;
            boolean bl2 = false;
            FluidStack it = fluidStack2;
            boolean bl3 = false;
            if (this.tank.fill(it, false) != it.amount) {
                return false;
            }
        }
        return true;
    }

    @Override
    public float minTemperature() {
        ItemStack itemStack = this.inv.getStackInSlot(this.input);
        Intrinsics.checkExpressionValueIsNotNull((Object)itemStack, (String)"inv.getStackInSlot(input)");
        IGasificationUnitRecipe iGasificationUnitRecipe = this.getRecipe(itemStack);
        return iGasificationUnitRecipe != null ? iGasificationUnitRecipe.minTemperature() : (float)HeatKt.getSTANDARD_AMBIENT_TEMPERATURE();
    }

    @Override
    public float duration() {
        ItemStack itemStack = this.inv.getStackInSlot(this.input);
        Intrinsics.checkExpressionValueIsNotNull((Object)itemStack, (String)"inv.getStackInSlot(input)");
        IGasificationUnitRecipe iGasificationUnitRecipe = this.getRecipe(itemStack);
        return iGasificationUnitRecipe != null ? iGasificationUnitRecipe.getDuration() : 10.0f;
    }

    @NotNull
    public final Tank getTank() {
        return this.tank;
    }

    @NotNull
    public final Inventory getInv() {
        return this.inv;
    }

    public final int getInput() {
        return this.input;
    }

    public final int getOutput() {
        return this.output;
    }

    public GasificationCraftingProcess(@NotNull Tank tank2, @NotNull Inventory inv, int input2, int output2) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)tank2), (String)"tank");
        Intrinsics.checkParameterIsNotNull((Object)((Object)inv), (String)"inv");
        this.tank = tank2;
        this.inv = inv;
        this.input = input2;
        this.output = output2;
        ItemStack itemStack = ItemStack.field_190927_a;
        Intrinsics.checkExpressionValueIsNotNull((Object)itemStack, (String)"ItemStack.EMPTY");
        this.cacheKey = itemStack;
    }
}

