/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.misc.crafting;

import com.cout970.magneticraft.api.MagneticraftApi;
import com.cout970.magneticraft.api.registries.machines.oilheater.IOilHeaterRecipe;
import com.cout970.magneticraft.misc.HeatKt;
import com.cout970.magneticraft.misc.crafting.IHeatCraftingProcess;
import com.cout970.magneticraft.misc.fluid.Tank;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0014\u001a\u00020\u0007H\u0002J\b\u0010\u0015\u001a\u00020\u0012H\u0016R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lcom/cout970/magneticraft/misc/crafting/OilHeaterCraftingProcess;", "Lcom/cout970/magneticraft/misc/crafting/IHeatCraftingProcess;", "inputTank", "Lcom/cout970/magneticraft/misc/fluid/Tank;", "outputTank", "(Lcom/cout970/magneticraft/misc/fluid/Tank;Lcom/cout970/magneticraft/misc/fluid/Tank;)V", "cacheKey", "Lnet/minecraftforge/fluids/FluidStack;", "cacheValue", "Lcom/cout970/magneticraft/api/registries/machines/oilheater/IOilHeaterRecipe;", "getInputTank", "()Lcom/cout970/magneticraft/misc/fluid/Tank;", "getOutputTank", "canCraft", "", "craft", "", "duration", "", "getRecipe", "input", "minTemperature", "Magneticraft_1.12"})
public final class OilHeaterCraftingProcess
implements IHeatCraftingProcess {
    private FluidStack cacheKey;
    private IOilHeaterRecipe cacheValue;
    @NotNull
    private final Tank inputTank;
    @NotNull
    private final Tank outputTank;

    private final IOilHeaterRecipe getRecipe(FluidStack input2) {
        FluidStack fluidStack = this.cacheKey;
        if (fluidStack != null) {
            FluidStack fluidStack2 = fluidStack;
            boolean bl = false;
            boolean bl2 = false;
            FluidStack key2 = fluidStack2;
            boolean bl3 = false;
            if (Intrinsics.areEqual((Object)key2.getFluid(), (Object)input2.getFluid())) {
                return this.cacheValue;
            }
        }
        IOilHeaterRecipe recipe = MagneticraftApi.getOilHeaterRecipeManager().findRecipe(input2);
        this.cacheKey = input2;
        this.cacheValue = recipe;
        return recipe;
    }

    @Override
    public void craft() {
        FluidStack fluidStack = this.inputTank.getFluid();
        if (fluidStack == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)fluidStack, (String)"inputTank.fluid ?: return");
        FluidStack input2 = fluidStack;
        IOilHeaterRecipe iOilHeaterRecipe = this.getRecipe(input2);
        if (iOilHeaterRecipe == null) {
            return;
        }
        IOilHeaterRecipe recipe = iOilHeaterRecipe;
        this.inputTank.drain(recipe.getInput().amount, true);
        this.outputTank.fill(recipe.getOutput(), true);
    }

    @Override
    public boolean canCraft() {
        FluidStack fluidStack = this.inputTank.getFluid();
        if (fluidStack == null) {
            return false;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)fluidStack, (String)"inputTank.fluid ?: return false");
        FluidStack input2 = fluidStack;
        IOilHeaterRecipe iOilHeaterRecipe = this.getRecipe(input2);
        if (iOilHeaterRecipe == null) {
            return false;
        }
        IOilHeaterRecipe recipe = iOilHeaterRecipe;
        if (this.inputTank.getFluidAmount() < recipe.getInput().amount) {
            return false;
        }
        return this.outputTank.getCapacity() - this.outputTank.getFluidAmount() >= recipe.getOutput().amount;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public float minTemperature() {
        float f;
        Object object = this.inputTank.getFluid();
        if (object != null) {
            FluidStack fluidStack = object;
            boolean bl = false;
            boolean bl2 = false;
            FluidStack it = fluidStack;
            boolean bl3 = false;
            FluidStack fluidStack2 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)fluidStack2, (String)"it");
            object = this.getRecipe(fluidStack2);
            if (object != null) {
                f = object.minTemperature();
                return f;
            }
        }
        f = (float)HeatKt.getSTANDARD_AMBIENT_TEMPERATURE();
        return f;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public float duration() {
        FluidStack fluidStack = this.inputTank.getFluid();
        Object object = fluidStack;
        if (fluidStack == null) return 10.0f;
        FluidStack fluidStack2 = object;
        boolean bl = false;
        boolean bl2 = false;
        FluidStack it = fluidStack2;
        boolean bl3 = false;
        FluidStack fluidStack3 = it;
        Intrinsics.checkExpressionValueIsNotNull((Object)fluidStack3, (String)"it");
        IOilHeaterRecipe iOilHeaterRecipe = this.getRecipe(fluidStack3);
        object = iOilHeaterRecipe;
        if (iOilHeaterRecipe == null) return 10.0f;
        float f = object.getDuration();
        return f;
    }

    @NotNull
    public final Tank getInputTank() {
        return this.inputTank;
    }

    @NotNull
    public final Tank getOutputTank() {
        return this.outputTank;
    }

    public OilHeaterCraftingProcess(@NotNull Tank inputTank, @NotNull Tank outputTank) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)inputTank), (String)"inputTank");
        Intrinsics.checkParameterIsNotNull((Object)((Object)outputTank), (String)"outputTank");
        this.inputTank = inputTank;
        this.outputTank = outputTank;
    }
}

