/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.misc.crafting;

import com.cout970.magneticraft.api.MagneticraftApi;
import com.cout970.magneticraft.api.registries.machines.refinery.IRefineryRecipe;
import com.cout970.magneticraft.misc.crafting.ICraftingProcess;
import com.cout970.magneticraft.misc.fluid.Tank;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0018\u001a\u00020\tH\u0002R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\r\u00a8\u0006\u0019"}, d2={"Lcom/cout970/magneticraft/misc/crafting/RefineryCraftingProcess;", "Lcom/cout970/magneticraft/misc/crafting/ICraftingProcess;", "inputTank", "Lcom/cout970/magneticraft/misc/fluid/Tank;", "outputTank0", "outputTank1", "outputTank2", "(Lcom/cout970/magneticraft/misc/fluid/Tank;Lcom/cout970/magneticraft/misc/fluid/Tank;Lcom/cout970/magneticraft/misc/fluid/Tank;Lcom/cout970/magneticraft/misc/fluid/Tank;)V", "cacheKey", "Lnet/minecraftforge/fluids/FluidStack;", "cacheValue", "Lcom/cout970/magneticraft/api/registries/machines/refinery/IRefineryRecipe;", "getInputTank", "()Lcom/cout970/magneticraft/misc/fluid/Tank;", "getOutputTank0", "getOutputTank1", "getOutputTank2", "canCraft", "", "craft", "", "duration", "", "getRecipe", "input", "Magneticraft_1.12"})
public final class RefineryCraftingProcess
implements ICraftingProcess {
    private FluidStack cacheKey;
    private IRefineryRecipe cacheValue;
    @NotNull
    private final Tank inputTank;
    @NotNull
    private final Tank outputTank0;
    @NotNull
    private final Tank outputTank1;
    @NotNull
    private final Tank outputTank2;

    private final IRefineryRecipe getRecipe(FluidStack input2) {
        FluidStack fluidStack = this.cacheKey;
        if (fluidStack != null) {
            FluidStack fluidStack2 = fluidStack;
            boolean bl = false;
            boolean bl2 = false;
            FluidStack key2 = fluidStack2;
            boolean bl3 = false;
            if (Intrinsics.areEqual((Object)key2.getFluid(), (Object)input2.getFluid())) {
                return this.cacheValue;
            }
        }
        IRefineryRecipe recipe = MagneticraftApi.getRefineryRecipeManager().findRecipe(input2);
        this.cacheKey = input2;
        this.cacheValue = recipe;
        return recipe;
    }

    @Override
    public void craft() {
        block4: {
            FluidStack it;
            boolean bl;
            boolean bl2;
            FluidStack fluidStack;
            FluidStack fluidStack2 = this.inputTank.getFluid();
            if (fluidStack2 == null) {
                return;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)fluidStack2, (String)"inputTank.fluid ?: return");
            FluidStack input2 = fluidStack2;
            IRefineryRecipe iRefineryRecipe = this.getRecipe(input2);
            if (iRefineryRecipe == null) {
                return;
            }
            IRefineryRecipe recipe = iRefineryRecipe;
            this.inputTank.drain(recipe.getInput().amount, true);
            FluidStack fluidStack3 = recipe.getOutput0();
            if (fluidStack3 != null) {
                fluidStack = fluidStack3;
                bl2 = false;
                bl = false;
                it = fluidStack;
                boolean bl3 = false;
                this.outputTank0.fill(it, true);
            }
            FluidStack fluidStack4 = recipe.getOutput1();
            if (fluidStack4 != null) {
                fluidStack = fluidStack4;
                bl2 = false;
                bl = false;
                it = fluidStack;
                boolean bl4 = false;
                this.outputTank1.fill(it, true);
            }
            FluidStack fluidStack5 = recipe.getOutput2();
            if (fluidStack5 == null) break block4;
            fluidStack = fluidStack5;
            bl2 = false;
            bl = false;
            it = fluidStack;
            boolean bl5 = false;
            this.outputTank2.fill(it, true);
        }
    }

    @Override
    public boolean canCraft() {
        FluidStack out;
        boolean bl;
        boolean bl2;
        FluidStack fluidStack;
        FluidStack fluidStack2 = this.inputTank.getFluid();
        if (fluidStack2 == null) {
            return false;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)fluidStack2, (String)"inputTank.fluid ?: return false");
        FluidStack input2 = fluidStack2;
        IRefineryRecipe iRefineryRecipe = this.getRecipe(input2);
        if (iRefineryRecipe == null) {
            return false;
        }
        IRefineryRecipe recipe = iRefineryRecipe;
        if (this.inputTank.getFluidAmount() < recipe.getInput().amount) {
            return false;
        }
        FluidStack fluidStack3 = recipe.getOutput0();
        if (fluidStack3 != null) {
            fluidStack = fluidStack3;
            bl2 = false;
            bl = false;
            out = fluidStack;
            boolean bl3 = false;
            if (this.outputTank0.getCapacity() - this.outputTank0.getFluidAmount() < out.amount) {
                return false;
            }
        }
        FluidStack fluidStack4 = recipe.getOutput1();
        if (fluidStack4 != null) {
            fluidStack = fluidStack4;
            bl2 = false;
            bl = false;
            out = fluidStack;
            boolean bl4 = false;
            if (this.outputTank1.getCapacity() - this.outputTank1.getFluidAmount() < out.amount) {
                return false;
            }
        }
        FluidStack fluidStack5 = recipe.getOutput2();
        if (fluidStack5 != null) {
            fluidStack = fluidStack5;
            bl2 = false;
            bl = false;
            out = fluidStack;
            boolean bl5 = false;
            if (this.outputTank2.getCapacity() - this.outputTank2.getFluidAmount() < out.amount) {
                return false;
            }
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public float duration() {
        FluidStack fluidStack = this.inputTank.getFluid();
        Object object = fluidStack;
        if (fluidStack == null) return 10.0f;
        FluidStack fluidStack2 = object;
        boolean bl = false;
        boolean bl2 = false;
        FluidStack it = fluidStack2;
        boolean bl3 = false;
        FluidStack fluidStack3 = it;
        Intrinsics.checkExpressionValueIsNotNull((Object)fluidStack3, (String)"it");
        IRefineryRecipe iRefineryRecipe = this.getRecipe(fluidStack3);
        object = iRefineryRecipe;
        if (iRefineryRecipe == null) return 10.0f;
        float f = object.getDuration();
        return f;
    }

    @NotNull
    public final Tank getInputTank() {
        return this.inputTank;
    }

    @NotNull
    public final Tank getOutputTank0() {
        return this.outputTank0;
    }

    @NotNull
    public final Tank getOutputTank1() {
        return this.outputTank1;
    }

    @NotNull
    public final Tank getOutputTank2() {
        return this.outputTank2;
    }

    public RefineryCraftingProcess(@NotNull Tank inputTank, @NotNull Tank outputTank0, @NotNull Tank outputTank1, @NotNull Tank outputTank2) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)inputTank), (String)"inputTank");
        Intrinsics.checkParameterIsNotNull((Object)((Object)outputTank0), (String)"outputTank0");
        Intrinsics.checkParameterIsNotNull((Object)((Object)outputTank1), (String)"outputTank1");
        Intrinsics.checkParameterIsNotNull((Object)((Object)outputTank2), (String)"outputTank2");
        this.inputTank = inputTank;
        this.outputTank0 = outputTank0;
        this.outputTank1 = outputTank1;
        this.outputTank2 = outputTank2;
    }
}

