/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.misc.inventory;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0002\u0010\u0007J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0096\u0002J \u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u0010H\u0016J\u000e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0002J\u0010\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0005H\u0016J\b\u0010\u001a\u001a\u00020\u0005H\u0016J\u0010\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0005H\u0016J\b\u0010\u001c\u001a\u00020\u0005H\u0016J \u0010\u001d\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0010H\u0016J\u000e\u0010\u001f\u001a\u00020\u00052\u0006\u0010 \u001a\u00020\u0005J\b\u0010!\u001a\u00020\"H\u0016R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\tR\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\t\u00a8\u0006#"}, d2={"Lcom/cout970/magneticraft/misc/inventory/InventoryCapabilityFilter;", "Lnet/minecraftforge/items/IItemHandler;", "inventory", "inputSlots", "", "", "outputSlots", "(Lnet/minecraftforge/items/IItemHandler;Ljava/util/List;Ljava/util/List;)V", "getInputSlots", "()Ljava/util/List;", "getInventory", "()Lnet/minecraftforge/items/IItemHandler;", "getOutputSlots", "slotMap", "getSlotMap", "equals", "", "other", "", "extractItem", "Lnet/minecraft/item/ItemStack;", "slot", "amount", "simulate", "generateSlotMap", "getSlotLimit", "getSlots", "getStackInSlot", "hashCode", "insertItem", "stack", "toRealSlot", "index", "toString", "", "Magneticraft_1.12"})
public final class InventoryCapabilityFilter
implements IItemHandler {
    @NotNull
    private final List<Integer> slotMap;
    @NotNull
    private final IItemHandler inventory;
    @NotNull
    private final List<Integer> inputSlots;
    @NotNull
    private final List<Integer> outputSlots;

    @NotNull
    public final List<Integer> getSlotMap() {
        return this.slotMap;
    }

    private final List<Integer> generateSlotMap() {
        int slot;
        boolean bl = false;
        List map = new ArrayList();
        Iterable $this$forEach$iv = this.inputSlots;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            slot = ((Number)element$iv).intValue();
            boolean bl2 = false;
            if (map.contains(slot)) continue;
            map.add(slot);
        }
        $this$forEach$iv = this.outputSlots;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            slot = ((Number)element$iv).intValue();
            boolean bl3 = false;
            if (map.contains(slot)) continue;
            map.add(slot);
        }
        return map;
    }

    @NotNull
    public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        int realSlot = this.toRealSlot(slot);
        if (this.inputSlots.contains(realSlot)) {
            ItemStack itemStack = this.inventory.insertItem(realSlot, stack, simulate);
            Intrinsics.checkExpressionValueIsNotNull((Object)itemStack, (String)"inventory.insertItem(realSlot, stack, simulate)");
            return itemStack;
        }
        return stack;
    }

    @NotNull
    public ItemStack getStackInSlot(int slot) {
        ItemStack itemStack = this.inventory.getStackInSlot(this.toRealSlot(slot));
        Intrinsics.checkExpressionValueIsNotNull((Object)itemStack, (String)"inventory.getStackInSlot(toRealSlot(slot))");
        return itemStack;
    }

    public int getSlotLimit(int slot) {
        return this.inventory.getSlotLimit(this.toRealSlot(slot));
    }

    public int getSlots() {
        return this.slotMap.size();
    }

    public final int toRealSlot(int index) {
        return ((Number)this.slotMap.get(index)).intValue();
    }

    @NotNull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        int realSlot = this.toRealSlot(slot);
        if (this.outputSlots.contains(realSlot)) {
            ItemStack itemStack = this.inventory.extractItem(realSlot, amount, simulate);
            Intrinsics.checkExpressionValueIsNotNull((Object)itemStack, (String)"inventory.extractItem(realSlot, amount, simulate)");
            return itemStack;
        }
        ItemStack itemStack = ItemStack.field_190927_a;
        Intrinsics.checkExpressionValueIsNotNull((Object)itemStack, (String)"ItemStack.EMPTY");
        return itemStack;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null) ^ true) {
            return false;
        }
        Object object2 = other;
        if (object2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.cout970.magneticraft.misc.inventory.InventoryCapabilityFilter");
        }
        InventoryCapabilityFilter cfr_ignored_0 = (InventoryCapabilityFilter)object2;
        if (Intrinsics.areEqual((Object)this.inventory, (Object)((InventoryCapabilityFilter)other).inventory) ^ true) {
            return false;
        }
        if (Intrinsics.areEqual(this.inputSlots, ((InventoryCapabilityFilter)other).inputSlots) ^ true) {
            return false;
        }
        return !(Intrinsics.areEqual(this.outputSlots, ((InventoryCapabilityFilter)other).outputSlots) ^ true);
    }

    public int hashCode() {
        int result = this.inventory.hashCode();
        result = 31 * result + ((Object)this.inputSlots).hashCode();
        result = 31 * result + ((Object)this.outputSlots).hashCode();
        return result;
    }

    @NotNull
    public String toString() {
        return "InventoryCapabilityFilter(inventory=" + this.inventory + ", inputSlots=" + this.inputSlots + ", outputSlots=" + this.outputSlots + ", slotMap=" + this.slotMap + ')';
    }

    @NotNull
    public final IItemHandler getInventory() {
        return this.inventory;
    }

    @NotNull
    public final List<Integer> getInputSlots() {
        return this.inputSlots;
    }

    @NotNull
    public final List<Integer> getOutputSlots() {
        return this.outputSlots;
    }

    public InventoryCapabilityFilter(@NotNull IItemHandler inventory2, @NotNull List<Integer> inputSlots, @NotNull List<Integer> outputSlots) {
        Intrinsics.checkParameterIsNotNull((Object)inventory2, (String)"inventory");
        Intrinsics.checkParameterIsNotNull(inputSlots, (String)"inputSlots");
        Intrinsics.checkParameterIsNotNull(outputSlots, (String)"outputSlots");
        this.inventory = inventory2;
        this.inputSlots = inputSlots;
        this.outputSlots = outputSlots;
        this.slotMap = this.generateSlotMap();
    }
}

