/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.systems.computer;

import com.cout970.magneticraft.api.computer.ICPU;
import com.cout970.magneticraft.api.computer.IMotherboard;
import com.cout970.magneticraft.api.computer.IRW;
import com.cout970.magneticraft.systems.computer.CPU_MIPS$WhenMappings;
import com.cout970.magneticraft.systems.computer.exception.ArithmeticException;
import com.cout970.magneticraft.systems.computer.exception.BreakpointException;
import com.cout970.magneticraft.systems.computer.exception.InvalidInstruction;
import com.cout970.magneticraft.systems.computer.exception.NullPointerException;
import com.cout970.magneticraft.systems.computer.exception.Syscall;
import com.cout970.magneticraft.systems.computer.exception.WordBoundaryException;
import java.util.Arrays;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0016\n\u0002\u0010\u0015\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u0000 >2\u00020\u0001:\u0002>?B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\u0004H\u0002J\u001c\u0010,\u001a\u00020*2\u0012\u0010-\u001a\u000e\u0012\u0004\u0012\u00020/\u0012\u0004\u0012\u0002000.H\u0016J\u0011\u00101\u001a\u00020\u00042\u0006\u00102\u001a\u00020\u0004H\u0086\bJ\u0010\u00103\u001a\u00020*2\u0006\u00104\u001a\u000205H\u0016J\b\u00106\u001a\u00020*H\u0016J\b\u00107\u001a\u00020*H\u0016J\u0014\u00108\u001a\u000e\u0012\u0004\u0012\u00020/\u0012\u0004\u0012\u0002000.H\u0016J\u0010\u00109\u001a\u00020*2\u0006\u0010:\u001a\u00020\rH\u0016J\u0016\u0010;\u001a\u00020*2\u0006\u0010<\u001a\u00020\u00042\u0006\u0010=\u001a\u00020\u0004R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0006\"\u0004\b\u000b\u0010\bR\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0006\"\u0004\b\u0010\u0010\bR\u001a\u0010\u0011\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0006\"\u0004\b\u0013\u0010\bR\u001a\u0010\u0014\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0006\"\u0004\b\u0016\u0010\bR\u001a\u0010\u0017\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0006\"\u0004\b\u0019\u0010\bR\u001a\u0010\u001a\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u0006\"\u0004\b\u001c\u0010\bR\u001a\u0010\u001d\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u0006\"\u0004\b\u001f\u0010\bR\u001a\u0010 \u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\u0006\"\u0004\b\"\u0010\bR\u001a\u0010#\u001a\u00020$X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(\u00a8\u0006@"}, d2={"Lcom/cout970/magneticraft/systems/computer/CPU_MIPS;", "Lcom/cout970/magneticraft/api/computer/ICPU;", "()V", "debugLevel", "", "getDebugLevel", "()I", "setDebugLevel", "(I)V", "jump", "getJump", "setJump", "motherboard", "Lcom/cout970/magneticraft/api/computer/IMotherboard;", "pfPC", "getPfPC", "setPfPC", "regCause", "getRegCause", "setRegCause", "regEPC", "getRegEPC", "setRegEPC", "regHI", "getRegHI", "setRegHI", "regLO", "getRegLO", "setRegLO", "regPC", "getRegPC", "setRegPC", "regStatus", "getRegStatus", "setRegStatus", "registers", "", "getRegisters", "()[I", "setRegisters", "([I)V", "debugInst", "", "instruct", "deserialize", "map", "", "", "", "getRegister", "t", "interrupt", "exception", "Lcom/cout970/magneticraft/api/computer/ICPU$IInterruption;", "iterate", "reset", "serialize", "setMotherboard", "mb", "setRegister", "s", "value", "Companion", "InstructionType", "Magneticraft_1.12"})
public final class CPU_MIPS
implements ICPU {
    private IMotherboard motherboard;
    private int debugLevel;
    @NotNull
    private int[] registers = new int[32];
    private int regHI;
    private int regLO;
    private int regPC;
    private int regStatus;
    private int regCause;
    private int regEPC;
    private int pfPC;
    private int jump = -1;
    @NotNull
    private static final String[] registerNames;
    @NotNull
    private static final String[] TYPE_R;
    @NotNull
    private static final String[] TYPE_I;
    public static final Companion Companion;

    public final int getDebugLevel() {
        return this.debugLevel;
    }

    public final void setDebugLevel(int n) {
        this.debugLevel = n;
    }

    @NotNull
    public final int[] getRegisters() {
        return this.registers;
    }

    public final void setRegisters(@NotNull int[] nArray) {
        Intrinsics.checkParameterIsNotNull((Object)nArray, (String)"<set-?>");
        this.registers = nArray;
    }

    public final int getRegHI() {
        return this.regHI;
    }

    public final void setRegHI(int n) {
        this.regHI = n;
    }

    public final int getRegLO() {
        return this.regLO;
    }

    public final void setRegLO(int n) {
        this.regLO = n;
    }

    public final int getRegPC() {
        return this.regPC;
    }

    public final void setRegPC(int n) {
        this.regPC = n;
    }

    public final int getRegStatus() {
        return this.regStatus;
    }

    public final void setRegStatus(int n) {
        this.regStatus = n;
    }

    public final int getRegCause() {
        return this.regCause;
    }

    public final void setRegCause(int n) {
        this.regCause = n;
    }

    public final int getRegEPC() {
        return this.regEPC;
    }

    public final void setRegEPC(int n) {
        this.regEPC = n;
    }

    public final int getPfPC() {
        return this.pfPC;
    }

    public final void setPfPC(int n) {
        this.pfPC = n;
    }

    public final int getJump() {
        return this.jump;
    }

    public final void setJump(int n) {
        this.jump = n;
    }

    public final int getRegister(int t) {
        int $i$f$getRegister = 0;
        return this.getRegisters()[t];
    }

    public final void setRegister(int s, int value2) {
        if (s == 0) {
            return;
        }
        if (this.debugLevel > 3) {
            CPU_MIPS.Companion.log("Reg: %s, change from 0x%08x (%d) to 0x%08x (%d)", CPU_MIPS.registerNames[s]);
        }
        this.registers[s] = value2;
    }

    @Override
    public void reset() {
        Arrays.fill(this.registers, 0);
        this.regHI = 0;
        this.regLO = 0;
        this.regPC = 57344;
        this.regStatus = 65535;
        this.regCause = 0;
        this.regEPC = 0;
        this.debugLevel = 2;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void iterate() {
        v0 = this.motherboard;
        v1 = v0 != null ? v0.getBus() : null;
        if (v1 == null) {
            Intrinsics.throwNpe();
        }
        bus = v1;
        this.pfPC = this.regPC;
        instruct = bus.readWord(this.regPC);
        if (this.jump != -1) {
            this.regPC = this.jump;
            this.jump = -1;
        } else {
            this.regPC += 4;
        }
        if (this.debugLevel > 2) {
            this.debugInst(instruct);
        }
        opcode = instruct >>> 26;
        type = null;
        type = instruct == 0 ? InstructionType.NOOP : (instruct == 12 || opcode == 16 ? InstructionType.EXCEPTION : (opcode >>> 2 == 4 ? InstructionType.COPROCESSOR : (opcode == 0 ? InstructionType.R : (opcode == 2 || opcode == 3 ? InstructionType.J : InstructionType.I))));
        block0 : switch (CPU_MIPS$WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1: {
                m1 = 0L;
                m2 = 0L;
                mt = 0L;
                func = instruct & 63;
                shamt = instruct >>> 6 & 31;
                rd = instruct >>> 11 & 31;
                rt = instruct >>> 16 & 31;
                rs = instruct >>> 21 & 31;
                switch (func) {
                    case 0: {
                        var16_104 = this;
                        var23_154 = rd;
                        var22_215 = this;
                        $i$f$getRegister = false;
                        var24_336 = this_$iv.getRegisters()[rt];
                        var22_215.setRegister(var23_154, var24_336 << shamt);
                        break block0;
                    }
                    case 2: {
                        if ((rs & 1) == 0) {
                            this_$iv = this;
                            var23_155 = rd;
                            var22_216 = this;
                            $i$f$getRegister = false;
                            var24_337 = this_$iv.getRegisters()[rt];
                            var22_216.setRegister(var23_155, var24_337 >>> shamt);
                            break block0;
                        }
                        this_$iv = this;
                        $i$f$getRegister = false;
                        left = this_$iv.getRegisters()[rt] & (1 << shamt + 1) - 1;
                        this_$iv = this;
                        var24_338 = left << 32 - shamt;
                        var23_156 = rd;
                        var22_217 = this;
                        $i$f$getRegister = false;
                        var25_411 = this_$iv.getRegisters()[rt];
                        var22_217.setRegister(var23_156, var24_338 | var25_411 >>> shamt);
                        break block0;
                    }
                    case 3: {
                        left = this;
                        var23_157 = rd;
                        var22_218 = this;
                        $i$f$getRegister = false;
                        var24_339 = this_$iv.getRegisters()[rt];
                        var22_218.setRegister(var23_157, var24_339 >> shamt);
                        break block0;
                    }
                    case 4: {
                        this_$iv = this;
                        var23_158 = rd;
                        var22_219 = this;
                        $i$f$getRegister = false;
                        var24_340 = this_$iv.getRegisters()[rt];
                        this_$iv = this;
                        $i$f$getRegister = false;
                        var25_412 = this_$iv.getRegisters()[rs];
                        var22_219.setRegister(var23_158, var24_340 << var25_412);
                        break block0;
                    }
                    case 6: {
                        if ((rs & 1) == 0) {
                            this_$iv = this;
                            var23_159 = rd;
                            var22_220 = this;
                            $i$f$getRegister = false;
                            var24_341 = this_$iv.getRegisters()[rt];
                            this_$iv = this;
                            $i$f$getRegister = false;
                            var25_413 = this_$iv.getRegisters()[rs];
                            var22_220.setRegister(var23_159, var24_341 >>> var25_413);
                            break block0;
                        }
                        this_$iv = this;
                        $i$f$getRegister = false;
                        v2 = this_$iv.getRegisters()[rt];
                        this_$iv = this;
                        var23_160 = 1;
                        var22_221 = v2;
                        $i$f$getRegister = false;
                        var24_342 = this_$iv.getRegisters()[rs];
                        left = var22_221 & (var23_160 << var24_342 + 1) - 1;
                        this_$iv = this;
                        var25_414 = 32;
                        var24_342 = left;
                        var23_160 = rd;
                        var22_222 = this;
                        $i$f$getRegister = false;
                        var26_439 = this_$iv.getRegisters()[rs];
                        this_$iv = this;
                        var24_342 <<= var25_414 - var26_439;
                        $i$f$getRegister = false;
                        var25_414 = this_$iv.getRegisters()[rt];
                        this_$iv = this;
                        $i$f$getRegister = false;
                        var26_439 = this_$iv.getRegisters()[rs];
                        var22_222.setRegister(var23_160, var24_342 | var25_414 >>> var26_439);
                        break block0;
                    }
                    case 7: {
                        left = this;
                        var23_161 = rd;
                        var22_223 = this;
                        $i$f$getRegister = false;
                        var24_343 = this_$iv.getRegisters()[rt];
                        this_$iv = this;
                        $i$f$getRegister = false;
                        var25_415 = this_$iv.getRegisters()[rs];
                        var22_223.setRegister(var23_161, var24_343 >> var25_415);
                        break block0;
                    }
                    case 8: {
                        this_$iv = this;
                        $i$f$getRegister = false;
                        if (this_$iv.getRegisters()[rs] == 0) ** GOTO lbl132
                        this_$iv = this;
                        $i$f$getRegister = false;
                        if (this_$iv.getRegisters()[rs] != -1) ** GOTO lbl134
lbl132:
                        // 2 sources

                        this.interrupt(new NullPointerException());
                        return;
lbl134:
                        // 1 sources

                        this_$iv = this;
                        var22_224 = this;
                        $i$f$getRegister = false;
                        var22_224.jump = var23_162 = this_$iv.getRegisters()[rs];
                        break block0;
                    }
                    case 9: {
                        this_$iv = this;
                        $i$f$getRegister = false;
                        if (this_$iv.getRegisters()[rs] == -1) ** GOTO lbl146
                        this_$iv = this;
                        $i$f$getRegister = false;
                        if (this_$iv.getRegisters()[rs] != 0) ** GOTO lbl147
lbl146:
                        // 2 sources

                        this.interrupt(new NullPointerException());
lbl147:
                        // 2 sources

                        if (rt == 0) {
                            this.setRegister(31, this.regPC);
                        } else {
                            this.setRegister(rt, this.regPC);
                        }
                        this_$iv = this;
                        var22_225 = this;
                        $i$f$getRegister = false;
                        var22_225.jump = var23_163 = this_$iv.getRegisters()[rs];
                        break block0;
                    }
                    case 10: {
                        this_$iv = this;
                        $i$f$getRegister = false;
                        if (this_$iv.getRegisters()[rt] != 0) break block0;
                        this_$iv = this;
                        var23_164 = rd;
                        var22_226 = this;
                        $i$f$getRegister = false;
                        var24_344 = this_$iv.getRegisters()[rs];
                        var22_226.setRegister(var23_164, var24_344);
                        break block0;
                    }
                    case 11: {
                        this_$iv = this;
                        $i$f$getRegister = false;
                        if (this_$iv.getRegisters()[rt] == 0) break block0;
                        this_$iv = this;
                        var23_165 = rd;
                        var22_227 = this;
                        $i$f$getRegister = false;
                        var24_345 = this_$iv.getRegisters()[rs];
                        var22_227.setRegister(var23_165, var24_345);
                        break block0;
                    }
                    case 12: {
                        this.interrupt(new Syscall());
                        break block0;
                    }
                    case 13: {
                        this.interrupt(new BreakpointException());
                        break block0;
                    }
                    case 15: {
                        break block0;
                    }
                    case 16: {
                        this.setRegister(rd, this.regHI);
                        break block0;
                    }
                    case 17: {
                        this_$iv = this;
                        var22_228 = this;
                        $i$f$getRegister = false;
                        var22_228.regHI = var23_166 = this_$iv.getRegisters()[rd];
                        break block0;
                    }
                    case 18: {
                        this.setRegister(rd, this.regLO);
                        break block0;
                    }
                    case 19: {
                        this_$iv = this;
                        var22_229 = this;
                        $i$f$getRegister = false;
                        var22_229.regLO = var23_167 = this_$iv.getRegisters()[rd];
                        break block0;
                    }
                    case 24: {
                        this_$iv = this;
                        $i$f$getRegister = false;
                        m1 = this_$iv.getRegisters()[rs];
                        this_$iv = this;
                        $i$f$getRegister = false;
                        m2 = this_$iv.getRegisters()[rt];
                        mt = m1 * m2;
                        this.regLO = (int)mt;
                        this.regHI = (int)(mt >> 32);
                        break block0;
                    }
                    case 25: {
                        this_$iv = this;
                        $i$f$getRegister = false;
                        m1 = (long)this_$iv.getRegisters()[rs] & 0xFFFFFFFFL;
                        this_$iv = this;
                        $i$f$getRegister = false;
                        m2 = (long)this_$iv.getRegisters()[rt] & 0xFFFFFFFFL;
                        mt = m1 * m2;
                        this.regLO = (int)mt;
                        this.regHI = (int)(mt >> 32);
                        break block0;
                    }
                    case 26: {
                        this_$iv = this;
                        $i$f$getRegister = false;
                        if (this_$iv.getRegisters()[rt] != 0) {
                            this_$iv = this;
                            var22_230 = this;
                            $i$f$getRegister = false;
                            var23_168 = this_$iv.getRegisters()[rs];
                            this_$iv = this;
                            $i$f$getRegister = false;
                            var24_346 = this_$iv.getRegisters()[rt];
                            var22_230.regLO = var23_168 / var24_346;
                            this_$iv = this;
                            var22_230 = this;
                            $i$f$getRegister = false;
                            var23_168 = this_$iv.getRegisters()[rs];
                            this_$iv = this;
                            $i$f$getRegister = false;
                            var24_346 = this_$iv.getRegisters()[rt];
                            var22_230.regHI = var23_168 % var24_346;
                            break block0;
                        }
                        this.interrupt(new ArithmeticException());
                        break block0;
                    }
                    case 27: {
                        this_$iv = this;
                        $i$f$getRegister = false;
                        m1 = (long)this_$iv.getRegisters()[rs] & 0xFFFFFFFFL;
                        this_$iv = this;
                        $i$f$getRegister = false;
                        m2 = (long)this_$iv.getRegisters()[rt] & 0xFFFFFFFFL;
                        if (m2 == 0L) {
                            this.interrupt(new ArithmeticException());
                            break block0;
                        }
                        this.regLO = (int)(m1 / m2);
                        this.regHI = (int)(m1 % m2);
                        break block0;
                    }
                    case 32: {
                        this_$iv = this;
                        var23_169 = rd;
                        var22_231 = this;
                        $i$f$getRegister = false;
                        var24_347 = this_$iv.getRegisters()[rt];
                        this_$iv = this;
                        $i$f$getRegister = false;
                        var25_416 = this_$iv.getRegisters()[rs];
                        var22_231.setRegister(var23_169, var24_347 + var25_416);
                        break block0;
                    }
                    case 33: {
                        this_$iv = this;
                        var23_170 = rd;
                        var22_232 = this;
                        $i$f$getRegister = false;
                        var24_348 = this_$iv.getRegisters()[rt];
                        this_$iv = this;
                        $i$f$getRegister = false;
                        var25_417 = this_$iv.getRegisters()[rs];
                        var22_232.setRegister(var23_170, var24_348 + var25_417);
                        break block0;
                    }
                    case 34: {
                        this_$iv = this;
                        var23_171 = rd;
                        var22_233 = this;
                        $i$f$getRegister = false;
                        var24_349 = this_$iv.getRegisters()[rs];
                        this_$iv = this;
                        $i$f$getRegister = false;
                        var25_418 = this_$iv.getRegisters()[rt];
                        var22_233.setRegister(var23_171, var24_349 - var25_418);
                        break block0;
                    }
                    case 35: {
                        this_$iv = this;
                        var23_172 = rd;
                        var22_234 = this;
                        $i$f$getRegister = false;
                        var24_350 = this_$iv.getRegisters()[rs];
                        this_$iv = this;
                        $i$f$getRegister = false;
                        var25_419 = this_$iv.getRegisters()[rt];
                        var22_234.setRegister(var23_172, var24_350 - var25_419);
                        break block0;
                    }
                    case 36: {
                        this_$iv = this;
                        var23_173 = rd;
                        var22_235 = this;
                        $i$f$getRegister = false;
                        var24_351 = this_$iv.getRegisters()[rt];
                        this_$iv = this;
                        $i$f$getRegister = false;
                        var25_420 = this_$iv.getRegisters()[rs];
                        var22_235.setRegister(var23_173, var24_351 & var25_420);
                        break block0;
                    }
                    case 37: {
                        this_$iv = this;
                        var23_174 = rd;
                        var22_236 = this;
                        $i$f$getRegister = false;
                        var24_352 = this_$iv.getRegisters()[rt];
                        this_$iv = this;
                        $i$f$getRegister = false;
                        var25_421 = this_$iv.getRegisters()[rs];
                        var22_236.setRegister(var23_174, var24_352 | var25_421);
                        break block0;
                    }
                    case 38: {
                        this_$iv = this;
                        var23_175 = rd;
                        var22_237 = this;
                        $i$f$getRegister = false;
                        var24_353 = this_$iv.getRegisters()[rt];
                        this_$iv = this;
                        $i$f$getRegister = false;
                        var25_422 = this_$iv.getRegisters()[rs];
                        var22_237.setRegister(var23_175, var24_353 ^ var25_422);
                        break block0;
                    }
                    case 39: {
                        this_$iv = this;
                        var23_176 = rd;
                        var22_238 = this;
                        $i$f$getRegister = false;
                        var24_354 = this_$iv.getRegisters()[rt];
                        this_$iv = this;
                        $i$f$getRegister = false;
                        var25_423 = this_$iv.getRegisters()[rs];
                        var22_238.setRegister(var23_176, ~(var24_354 | var25_423));
                        break block0;
                    }
                    case 42: {
                        this_$iv = this;
                        var23_177 = rd;
                        var22_239 = this;
                        $i$f$getRegister = false;
                        var24_355 = this_$iv.getRegisters()[rs];
                        this_$iv = this;
                        $i$f$getRegister = false;
                        var25_424 = this_$iv.getRegisters()[rt];
                        var22_239.setRegister(var23_177, var24_355 < var25_424 ? 1 : 0);
                        break block0;
                    }
                    case 43: {
                        this_$iv = this;
                        $i$f$getRegister = false;
                        m1 = (long)this_$iv.getRegisters()[rs] & 0xFFFFFFFFL;
                        this_$iv = this;
                        $i$f$getRegister = false;
                        m2 = (long)this_$iv.getRegisters()[rt] & 0xFFFFFFFFL;
                        this.setRegister(rd, m1 < m2 ? 1 : 0);
                        break block0;
                    }
                }
                this.interrupt(new InvalidInstruction());
                break;
            }
            case 2: {
                dir = CPU_MIPS.Companion.getBitsFromInt(instruct, 0, 25, false);
                switch (opcode) {
                    case 2: {
                        this.jump = this.regPC;
                        this.jump &= (int)0xF0000000L;
                        this.jump |= dir << 2;
                        break;
                    }
                    case 3: {
                        this.setRegister(31, this.regPC + 4);
                        this.jump = this.regPC;
                        this.jump &= (int)0xF0000000L;
                        this.jump |= dir << 2;
                    }
                }
                break;
            }
            case 3: {
                m1 = 0L;
                m2 = 0L;
                rs = instruct >> 21 & 31;
                rt = instruct >> 16 & 31;
                rd = instruct >> 11 & 31;
                immed = instruct << 16 >> 16;
                immedU = instruct << 16 >>> 16;
                switch (opcode) {
                    case 1: {
                        switch (rt) {
                            case 0: {
                                this_$iv = this;
                                $i$f$getRegister = false;
                                if (this_$iv.getRegisters()[rs] >= 0) break block0;
                                this.jump = this.regPC + (immed << 2);
                                break block0;
                            }
                            case 1: {
                                this_$iv = this;
                                $i$f$getRegister = false;
                                if (this_$iv.getRegisters()[rs] < 0) break block0;
                                this.jump = this.regPC + (immed << 2);
                                break block0;
                            }
                            case 16: {
                                this_$iv = this;
                                $i$f$getRegister = false;
                                if (this_$iv.getRegisters()[rs] >= 0) break block0;
                                this.setRegister(31, this.regPC + 4);
                                this.jump = this.regPC + (immed << 2);
                                break block0;
                            }
                            case 17: {
                                this_$iv = this;
                                $i$f$getRegister = false;
                                if (this_$iv.getRegisters()[rs] < 0) break block0;
                                this.setRegister(31, this.regPC + 4);
                                this.jump = this.regPC + (immed << 2);
                                break block0;
                            }
                            case 31: {
                                break block0;
                            }
                        }
                        this.interrupt(new InvalidInstruction());
                        break block0;
                    }
                    case 4: {
                        this_$iv = this;
                        $i$f$getRegister = false;
                        v3 = this_$iv.getRegisters()[rt];
                        this_$iv = this;
                        var22_240 = v3;
                        $i$f$getRegister = false;
                        var23_178 = this_$iv.getRegisters()[rs];
                        if (var22_240 != var23_178) break block0;
                        this.jump = this.regPC + (immed << 2);
                        break block0;
                    }
                    case 5: {
                        this_$iv = this;
                        $i$f$getRegister = false;
                        v4 = this_$iv.getRegisters()[rt];
                        this_$iv = this;
                        var22_241 = v4;
                        $i$f$getRegister = false;
                        var23_179 = this_$iv.getRegisters()[rs];
                        if (var22_241 == var23_179) break block0;
                        this.jump = this.regPC + (immed << 2);
                        break block0;
                    }
                    case 6: {
                        this_$iv = this;
                        $i$f$getRegister = false;
                        if (this_$iv.getRegisters()[rs] > 0) break block0;
                        this.jump = this.regPC + (immed << 2);
                        break block0;
                    }
                    case 7: {
                        this_$iv = this;
                        $i$f$getRegister = false;
                        if (this_$iv.getRegisters()[rs] <= 0) break block0;
                        this.jump = this.regPC + (immed << 2);
                        break block0;
                    }
                    case 8: {
                        this_$iv = this;
                        var23_180 = rt;
                        var22_242 = this;
                        $i$f$getRegister = false;
                        var24_356 = this_$iv.getRegisters()[rs];
                        var22_242.setRegister(var23_180, var24_356 + immed);
                        break block0;
                    }
                    case 9: {
                        this_$iv = this;
                        var23_181 = rt;
                        var22_243 = this;
                        $i$f$getRegister = false;
                        var24_357 = this_$iv.getRegisters()[rs];
                        var22_243.setRegister(var23_181, var24_357 + immed);
                        break block0;
                    }
                    case 10: {
                        this_$iv = this;
                        var23_182 = rt;
                        var22_244 = this;
                        $i$f$getRegister = false;
                        var24_358 = this_$iv.getRegisters()[rs];
                        var22_244.setRegister(var23_182, var24_358 < immed ? 1 : 0);
                        break block0;
                    }
                    case 11: {
                        this_$iv = this;
                        $i$f$getRegister = false;
                        m1 = (long)this_$iv.getRegisters()[rs] & 0xFFFFFFFFL;
                        m2 = (long)immedU & 0xFFFFFFFFL;
                        this.setRegister(rt, m1 < m2 ? 1 : 0);
                        break block0;
                    }
                    case 12: {
                        this_$iv = this;
                        var23_183 = rt;
                        var22_245 = this;
                        $i$f$getRegister = false;
                        var24_359 = this_$iv.getRegisters()[rs];
                        var22_245.setRegister(var23_183, var24_359 & immedU);
                        break block0;
                    }
                    case 13: {
                        this_$iv = this;
                        var23_184 = rt;
                        var22_246 = this;
                        $i$f$getRegister = false;
                        var24_360 = this_$iv.getRegisters()[rs];
                        var22_246.setRegister(var23_184, var24_360 | immedU);
                        break block0;
                    }
                    case 14: {
                        this_$iv = this;
                        var23_185 = rt;
                        var22_247 = this;
                        $i$f$getRegister = false;
                        var24_361 = this_$iv.getRegisters()[rs];
                        var22_247.setRegister(var23_185, var24_361 ^ immedU);
                        break block0;
                    }
                    case 15: {
                        this.setRegister(rt, immedU << 16);
                        break block0;
                    }
                    case 24: {
                        this_$iv = this;
                        var23_186 = rt;
                        var22_248 = this;
                        $i$f$getRegister = false;
                        var24_362 = this_$iv.getRegisters()[rt];
                        var22_248.setRegister(var23_186, var24_362 & (int)0xFFFF0000L | immedU);
                        break block0;
                    }
                    case 25: {
                        this_$iv = this;
                        var23_187 = rt;
                        var22_249 = this;
                        $i$f$getRegister = false;
                        var24_363 = this_$iv.getRegisters()[rt];
                        var22_249.setRegister(var23_187, var24_363 & 65535 | immedU << 16);
                        break block0;
                    }
                    case 26: {
                        this.interrupt(new Syscall());
                        break block0;
                    }
                    case 28: {
                        special = instruct & 31;
                        switch (special) {
                            case 0: {
                                hilo = (long)this.regHI << 32 | (long)this.regLO;
                                this_$iv = this;
                                $i$f$getRegister = false;
                                v5 = this_$iv.getRegisters()[rs];
                                this_$iv = this;
                                var22_250 = v5;
                                $i$f$getRegister = false;
                                var24_364 = this_$iv.getRegisters()[rt];
                                base = var22_250 * (long)var24_364;
                                result = hilo + base;
                                this.regHI = (int)(result >>> 32);
                                this.regHI = (int)result;
                                break block0;
                            }
                            case 1: {
                                hilo = (long)this.regHI << 32 | (long)this.regLO;
                                this_$iv = this;
                                $i$f$getRegister = false;
                                v6 = this_$iv.getRegisters()[rs];
                                this_$iv = this;
                                var22_251 = v6;
                                $i$f$getRegister = false;
                                var24_365 = this_$iv.getRegisters()[rt];
                                base = var22_251 * (long)var24_365;
                                result = hilo + base;
                                this.regHI = (int)(result >>> 32);
                                this.regHI = (int)result;
                                break block0;
                            }
                            case 2: {
                                hilo = this;
                                var23_188 = rd;
                                var22_252 = this;
                                $i$f$getRegister = false;
                                var24_366 = this_$iv.getRegisters()[rs];
                                this_$iv = this;
                                $i$f$getRegister = false;
                                var25_425 = this_$iv.getRegisters()[rt];
                                var22_252.setRegister(var23_188, var24_366 * var25_425);
                                break block0;
                            }
                            case 4: {
                                hilo = (long)this.regHI << 32 | (long)this.regLO;
                                this_$iv = this;
                                $i$f$getRegister = false;
                                v7 = this_$iv.getRegisters()[rs];
                                this_$iv = this;
                                var22_253 = v7;
                                $i$f$getRegister = false;
                                var24_367 = this_$iv.getRegisters()[rt];
                                base = var22_253 * (long)var24_367;
                                result = hilo - base;
                                this.regHI = (int)(result >>> 32);
                                this.regHI = (int)result;
                                break block0;
                            }
                            case 5: {
                                hilo = (long)this.regHI << 32 | (long)this.regLO;
                                this_$iv = this;
                                $i$f$getRegister = false;
                                v8 = this_$iv.getRegisters()[rs];
                                this_$iv = this;
                                var22_254 = v8;
                                $i$f$getRegister = false;
                                var24_368 = this_$iv.getRegisters()[rt];
                                base = var22_254 * (long)var24_368;
                                result = hilo - base;
                                this.regHI = (int)(result >>> 32);
                                this.regHI = (int)result;
                                break block0;
                            }
                            case 33: {
                                hilo = this;
                                var23_189 = rt;
                                var22_255 = this;
                                $i$f$getRegister = false;
                                var24_369 = this_$iv.getRegisters()[rs];
                                var22_255.setRegister(var23_189, Integer.numberOfLeadingZeros(~var24_369));
                                break block0;
                            }
                            case 32: {
                                this_$iv = this;
                                var23_190 = rt;
                                var22_256 = this;
                                $i$f$getRegister = false;
                                var24_370 = this_$iv.getRegisters()[rs];
                                var22_256.setRegister(var23_190, Integer.numberOfLeadingZeros(var24_370));
                                break block0;
                            }
                            case 63: {
                                this.interrupt(new BreakpointException());
                                break block0;
                            }
                        }
                        this.interrupt(new InvalidInstruction());
                        break block0;
                    }
                    case 31: {
                        code = instruct & 63;
                        switch (code) {
                            case 0: {
                                size = instruct >> 11 & 31;
                                pos = instruct >> 6 & 31;
                                base = this;
                                var24_371 = CPU_MIPS.Companion;
                                var23_191 = rt;
                                var22_257 = this;
                                $i$f$getRegister = false;
                                var25_426 = this_$iv.getRegisters()[rs];
                                var22_257.setRegister(var23_191, var24_371.getBitsFromInt(var25_426, pos, pos + size, false));
                                break block0;
                            }
                            case 4: {
                                mbs = instruct >> 11 & 31;
                                lbs = instruct >> 6 & 31;
                                this_$iv = this;
                                $i$f$getRegister = false;
                                a = this_$iv.getRegisters()[rs] & (int)0xFFFFFFFFL << mbs + 1;
                                this_$iv = this;
                                $i$f$getRegister = false;
                                b = this_$iv.getRegisters()[rs] & (int)0xFFFFFFFFL >>> 32 - (mbs - lbs);
                                this_$iv = this;
                                $i$f$getRegister = false;
                                c = this_$iv.getRegisters()[rs] & (int)0xFFFFFFFFL << 32 - (lbs - 1);
                                this.setRegister(rt, a | b | c);
                                break block0;
                            }
                            case 32: {
                                op = instruct >>> 6 & 31;
                                switch (op) {
                                    case 2: {
                                        this_$iv = this;
                                        $i$f$getRegister = false;
                                        a = (this_$iv.getRegisters()[rt] & 255) << 8;
                                        this_$iv = this;
                                        $i$f$getRegister = false;
                                        b = this_$iv.getRegisters()[rt] >>> 8 & 255;
                                        this_$iv = this;
                                        $i$f$getRegister = false;
                                        c = (this_$iv.getRegisters()[rt] >>> 16 & 255) << 24;
                                        this_$iv = this;
                                        $i$f$getRegister = false;
                                        d = (this_$iv.getRegisters()[rt] >>> 24 & 255) << 16;
                                        this.setRegister(rd, a | b | c | d);
                                        break block0;
                                    }
                                    case 16: {
                                        a = this;
                                        var23_192 = rd;
                                        var22_258 = this;
                                        $i$f$getRegister = false;
                                        var24_372 = this_$iv.getRegisters()[rt];
                                        var22_258.setRegister(var23_192, (byte)var24_372);
                                        break block0;
                                    }
                                    case 24: {
                                        this_$iv = this;
                                        var23_193 = rd;
                                        var22_259 = this;
                                        $i$f$getRegister = false;
                                        var24_373 = this_$iv.getRegisters()[rt];
                                        var22_259.setRegister(var23_193, (short)var24_373);
                                        break block0;
                                    }
                                }
                                this.interrupt(new InvalidInstruction());
                                break block0;
                            }
                            case 59: {
                                break block0;
                            }
                        }
                        this.interrupt(new InvalidInstruction());
                        break block0;
                    }
                    case 32: {
                        code = this;
                        var24_374 = bus;
                        var23_194 = rt;
                        var22_260 = this;
                        $i$f$getRegister = false;
                        var25_427 = this_$iv.getRegisters()[rs];
                        var22_260.setRegister(var23_194, var24_374.readByte(var25_427 + immed));
                        break block0;
                    }
                    case 33: {
                        this_$iv = this;
                        var24_375 = bus;
                        var23_195 = rt;
                        var22_261 = this;
                        $i$f$getRegister = false;
                        var25_428 = this_$iv.getRegisters()[rs];
                        var22_261.setRegister(var23_195, (short)var24_375.readWord(var25_428 + immed));
                        break block0;
                    }
                    case 34: {
                        this_$iv = this;
                        $i$f$getRegister = false;
                        addr = this_$iv.getRegisters()[rs] + immed;
                        word = bus.readWord(addr & (int)0xFFFFFFFCL);
                        switch (addr & 3) {
                            case 0: {
                                $i$f$getRegister = this;
                                var24_376 = (word & 255) << 24;
                                var23_196 = rt;
                                var22_262 = this;
                                $i$f$getRegister = false;
                                var25_429 = this_$iv.getRegisters()[rt];
                                var22_262.setRegister(var23_196, var24_376 | var25_429 & 0xFFFFFF);
                                break;
                            }
                            case 1: {
                                this_$iv = this;
                                var24_377 = (word & 65535) << 16;
                                var23_197 = rt;
                                var22_263 = this;
                                $i$f$getRegister = false;
                                var25_430 = this_$iv.getRegisters()[rt];
                                var22_263.setRegister(var23_197, var24_377 | var25_430 & 65535);
                                break;
                            }
                            case 2: {
                                this_$iv = this;
                                var24_378 = (word & 0xFFFFFF) << 8;
                                var23_198 = rt;
                                var22_264 = this;
                                $i$f$getRegister = false;
                                var25_431 = this_$iv.getRegisters()[rt];
                                var22_264.setRegister(var23_198, var24_378 | var25_431 & 255);
                                break;
                            }
                            case 3: {
                                this.setRegister(rt, word);
                            }
                        }
                        break block0;
                    }
                    case 35: {
                        this_$iv = this;
                        $i$f$getRegister = false;
                        addr = this_$iv.getRegisters()[rs] + immed;
                        if ((addr & 3) != 0) {
                            this.interrupt(new WordBoundaryException(addr));
                            break block0;
                        }
                        this.setRegister(rt, bus.readWord(addr));
                        break block0;
                    }
                    case 36: {
                        addr = this;
                        var24_379 = bus;
                        var23_199 = rt;
                        var22_265 = this;
                        $i$f$getRegister = false;
                        var25_432 = this_$iv.getRegisters()[rs];
                        var22_265.setRegister(var23_199, var24_379.readByte(var25_432 + immed) & 255);
                        break block0;
                    }
                    case 37: {
                        this_$iv = this;
                        var24_380 = bus;
                        var23_200 = rt;
                        var22_266 = this;
                        $i$f$getRegister = false;
                        var25_433 = this_$iv.getRegisters()[rs];
                        var22_266.setRegister(var23_200, var24_380.readWord(var25_433 + immed) & 65535);
                        break block0;
                    }
                    case 38: {
                        this_$iv = this;
                        $i$f$getRegister = false;
                        addr = this_$iv.getRegisters()[rs] + immed;
                        word = bus.readWord(addr & (int)0xFFFFFFFCL);
                        switch (addr & 3) {
                            case 0: {
                                this.setRegister(rt, word);
                                break;
                            }
                            case 1: {
                                $i$f$getRegister = this;
                                var24_381 = word >>> 8;
                                var23_201 = rt;
                                var22_267 = this;
                                $i$f$getRegister = false;
                                var25_434 = this_$iv.getRegisters()[rt];
                                var22_267.setRegister(var23_201, var24_381 | var25_434 & (int)0xFF000000L);
                                break;
                            }
                            case 2: {
                                this_$iv = this;
                                var24_382 = word >>> 16;
                                var23_202 = rt;
                                var22_268 = this;
                                $i$f$getRegister = false;
                                var25_435 = this_$iv.getRegisters()[rt];
                                var22_268.setRegister(var23_202, var24_382 | var25_435 & (int)0xFFFF0000L);
                                break;
                            }
                            case 3: {
                                this_$iv = this;
                                var24_383 = word >>> 24;
                                var23_203 = rt;
                                var22_269 = this;
                                $i$f$getRegister = false;
                                var25_436 = this_$iv.getRegisters()[rt];
                                var22_269.setRegister(var23_203, var24_383 | var25_436 & (int)0xFFFFFF00L);
                            }
                        }
                        break block0;
                    }
                    case 40: {
                        addr = this;
                        var22_270 = bus;
                        $i$f$getRegister = false;
                        var23_204 = this_$iv.getRegisters()[rs];
                        this_$iv = this;
                        $i$f$getRegister = false;
                        var24_384 = this_$iv.getRegisters()[rt];
                        var22_270.writeByte(var23_204 += immed, (byte)(var24_384 & 255));
                        break block0;
                    }
                    case 41: {
                        this_$iv = this;
                        $i$f$getRegister = false;
                        addr = this_$iv.getRegisters()[rs] + immed;
                        this_$iv = this;
                        $i$f$getRegister = false;
                        value = this_$iv.getRegisters()[rt];
                        bus.writeByte(addr, (byte)(value & 255));
                        bus.writeByte(addr + 1, (byte)((value & 65280) >>> 8));
                        break block0;
                    }
                    case 42: {
                        this_$iv = this;
                        $i$f$getRegister = false;
                        addr = this_$iv.getRegisters()[rs] + immed;
                        alignAddr = addr & (int)0xFFFFFFFCL;
                        word = bus.readWord(alignAddr);
                        switch (addr & 3) {
                            case 0: {
                                $i$f$getRegister = this;
                                var23_205 = alignAddr;
                                var22_271 = bus;
                                $i$f$getRegister = false;
                                var24_385 = this_$iv.getRegisters()[rt];
                                var22_271.writeWord(var23_205, var24_385 >>> 24 | word & (int)0xFFFFFF00L);
                                break;
                            }
                            case 1: {
                                this_$iv = this;
                                var23_206 = alignAddr;
                                var22_272 = bus;
                                $i$f$getRegister = false;
                                var24_386 = this_$iv.getRegisters()[rt];
                                var22_272.writeWord(var23_206, var24_386 >>> 16 | word & (int)0xFFFF0000L);
                                break;
                            }
                            case 2: {
                                this_$iv = this;
                                var23_207 = alignAddr;
                                var22_273 = bus;
                                $i$f$getRegister = false;
                                var24_387 = this_$iv.getRegisters()[rt];
                                var22_273.writeWord(var23_207, var24_387 >>> 8 | word & (int)0xFF000000L);
                                break;
                            }
                            case 3: {
                                this_$iv = this;
                                var23_208 = alignAddr;
                                var22_274 = bus;
                                $i$f$getRegister = false;
                                var24_388 = this_$iv.getRegisters()[rt];
                                var22_274.writeWord(var23_208, var24_388);
                            }
                        }
                        break block0;
                    }
                    case 43: {
                        this_$iv = this;
                        $i$f$getRegister = false;
                        if ((this_$iv.getRegisters()[rs] + immed & 3) != 0) {
                            this_$iv = this;
                            var22_275 = this;
                            $i$f$getRegister = false;
                            var25_437 = this_$iv.getRegisters()[rs];
                            var27_467 = var25_437 + immed;
                            var22_275.interrupt(new WordBoundaryException(var27_467));
                            break block0;
                        }
                        this_$iv = this;
                        var22_276 = bus;
                        $i$f$getRegister = false;
                        var23_209 = this_$iv.getRegisters()[rs];
                        this_$iv = this;
                        $i$f$getRegister = false;
                        var24_389 = this_$iv.getRegisters()[rt];
                        var22_276.writeWord(var23_209 += immed, var24_389);
                        break block0;
                    }
                    case 46: {
                        this_$iv = this;
                        $i$f$getRegister = false;
                        addr = this_$iv.getRegisters()[rs] + immed;
                        alignAddr = addr & (int)0xFFFFFFFCL;
                        word = bus.readWord(alignAddr);
                        switch (addr & 3) {
                            case 0: {
                                this_$iv = this;
                                var23_210 = alignAddr;
                                var22_277 = bus;
                                $i$f$getRegister = false;
                                var24_390 = this_$iv.getRegisters()[rt];
                                var22_277.writeWord(var23_210, var24_390);
                                break;
                            }
                            case 1: {
                                this_$iv = this;
                                var23_211 = alignAddr;
                                var22_278 = bus;
                                $i$f$getRegister = false;
                                var24_391 = this_$iv.getRegisters()[rt];
                                var22_278.writeWord(var23_211, var24_391 >>> 8 | word & 255);
                                break;
                            }
                            case 2: {
                                this_$iv = this;
                                var23_212 = alignAddr;
                                var22_279 = bus;
                                $i$f$getRegister = false;
                                var24_392 = this_$iv.getRegisters()[rt];
                                var22_279.writeWord(var23_212, var24_392 >>> 16 | word & 65535);
                                break;
                            }
                            case 3: {
                                this_$iv = this;
                                var23_213 = alignAddr;
                                var22_280 = bus;
                                $i$f$getRegister = false;
                                var24_393 = this_$iv.getRegisters()[rt];
                                var22_280.writeWord(var23_213, var24_393 >>> 24 | word & 0xFFFFFF);
                            }
                        }
                        break block0;
                    }
                    case 47: {
                        break block0;
                    }
                    case 48: {
                        this_$iv = this;
                        $i$f$getRegister = false;
                        addr = this_$iv.getRegisters()[rs] + immed;
                        if ((addr & 3) != 0) {
                            this.interrupt(new WordBoundaryException(addr));
                            break block0;
                        }
                        this.setRegister(rt, bus.readWord(addr));
                        break block0;
                    }
                    case 51: {
                        break block0;
                    }
                    case 56: {
                        this_$iv = this;
                        $i$f$getRegister = false;
                        if ((this_$iv.getRegisters()[rs] + immed & 3) != 0) {
                            this_$iv = this;
                            var22_281 = this;
                            $i$f$getRegister = false;
                            var25_438 = this_$iv.getRegisters()[rs];
                            var28_468 = var25_438 + immed;
                            var22_281.interrupt(new WordBoundaryException(var28_468));
                            break block0;
                        }
                        this_$iv = this;
                        var22_282 = bus;
                        $i$f$getRegister = false;
                        var23_214 = this_$iv.getRegisters()[rs];
                        this_$iv = this;
                        $i$f$getRegister = false;
                        var24_394 = this_$iv.getRegisters()[rt];
                        var22_282.writeWord(var23_214 += immed, var24_394);
                        this.setRegister(rt, 1);
                        break block0;
                    }
                }
                this.interrupt(new InvalidInstruction());
                break;
            }
            case 4: {
                this.interrupt(new Syscall());
                break;
            }
            case 5: {
                code = CPU_MIPS.Companion.getBitsFromInt(instruct, 21, 25, false);
                rt = CPU_MIPS.Companion.getBitsFromInt(instruct, 16, 20, false);
                rd = CPU_MIPS.Companion.getBitsFromInt(instruct, 11, 15, false);
                co = instruct >>> 25 & 1;
                special = instruct & 63;
                if (code == 0) {
                    value = 0;
                    switch (rd) {
                        case 12: {
                            value = this.regStatus;
                            break;
                        }
                        case 13: {
                            value = this.regCause;
                            break;
                        }
                        case 14: {
                            value = this.regEPC;
                        }
                    }
                    this.setRegister(rt, value);
                    break;
                }
                if (code == 4) {
                    this_$iv = this;
                    $i$f$getRegister = false;
                    value = this_$iv.getRegisters()[rt];
                    switch (rd) {
                        case 12: {
                            this.regStatus = value;
                            break;
                        }
                        case 13: {
                            this.regCause = value;
                            break;
                        }
                        case 14: {
                            this.regEPC = value;
                        }
                    }
                    break;
                }
                if (code == 16 && special == 16) {
                    this.regPC = this.regEPC;
                    this.regStatus >>= 4;
                    break;
                }
                if (code == 16 && special == 24) {
                    this.regPC = this.regEPC;
                    this.regStatus >>= 4;
                    break;
                }
                if (code == 11 && rd == 12 && special == 0) {
                    this.setRegister(rt, this.regStatus);
                    this.regStatus &= (int)0xFFFFFFF0L;
                    break;
                }
                if (code == 11 && rd == 12 && special == 32) {
                    this.setRegister(rt, this.regStatus);
                    this.regStatus |= 15;
                    break;
                }
                if (co == 1 && special == 31) {
                    this.regPC = this.regEPC;
                    this.regStatus >>= 4;
                    break;
                }
                if (co == 1 && special == 32) {
                    this.interrupt(new BreakpointException());
                    break;
                }
                this.interrupt(new InvalidInstruction());
            }
        }
    }

    private final void debugInst(int instruct) {
        CPU_MIPS.Companion.log("PC: 0x%08x \t " + CPU_MIPS.Companion.decompileInst(instruct), this.pfPC);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void interrupt(@NotNull ICPU.IInterruption exception) {
        Intrinsics.checkParameterIsNotNull((Object)exception, (String)"exception");
        IMotherboard iMotherboard = this.motherboard;
        if (iMotherboard != null) {
            iMotherboard.halt();
        }
        if (this.debugLevel > 0) {
            void t$iv;
            void this_$iv;
            Object[] objectArray;
            int j;
            int n;
            Companion companion;
            Object object;
            Object[] objectArray2;
            int n2;
            int i;
            IMotherboard iMotherboard2 = this.motherboard;
            IRW iRW = iMotherboard2 != null ? iMotherboard2.getBus() : null;
            if (iRW == null) {
                Intrinsics.throwNpe();
            }
            IRW bus2 = iRW;
            Object[] objectArray3 = new Object[5];
            objectArray3[0] = exception.getCode();
            String string = exception.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"exception.name");
            objectArray3[1] = string;
            objectArray3[2] = this.regPC;
            objectArray3[3] = this.pfPC;
            String string2 = exception.getDescription();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"exception.description");
            objectArray3[4] = string2;
            CPU_MIPS.Companion.log("Exception: %d (%s), regPC: 0x%08x, pfPC: 0x%08x, Description: %s", objectArray3);
            int inst = bus2.readWord(this.pfPC);
            this.debugInst(inst);
            CPU_MIPS.Companion.debug("Registers: ");
            int n3 = 0;
            int n4 = 31;
            while (n3 <= n4) {
                Object[] this_$iv2;
                Object[] objectArray4 = new Object[4];
                objectArray4[0] = i;
                objectArray4[1] = registerNames[i];
                Object[] objectArray5 = this;
                n2 = 2;
                Object[] objectArray6 = objectArray4;
                objectArray2 = objectArray4;
                object = "\t %d: \t %s : 0x%08x (%08d)";
                companion = Companion;
                boolean $i$f$getRegister = false;
                n = this_$iv2.getRegisters()[i];
                objectArray6[n2] = n;
                this_$iv2 = this;
                n2 = 3;
                objectArray6 = objectArray2;
                $i$f$getRegister = false;
                n = this_$iv2.getRegisters()[i];
                objectArray6[n2] = n;
                companion.log((String)object, objectArray2);
                ++i;
            }
            CPU_MIPS.Companion.debug("Code before error: ");
            i = 0;
            n4 = 15;
            while (i <= n4) {
                int i2 = 15 - j;
                int word2 = bus2.readWord(this.pfPC - i2 * 4);
                objectArray = "(PC 0x%08x) 0x%08x            %s";
                Object[] objectArray7 = new Object[]{this.pfPC - i2 * 4, word2, Companion.decompileInst(word2)};
                companion = Companion;
                boolean bl = false;
                Intrinsics.checkExpressionValueIsNotNull((Object)String.format((String)objectArray, Arrays.copyOf(objectArray7, objectArray7.length)), (String)"java.lang.String.format(this, *args)");
                companion.debug(object);
                ++j;
            }
            CPU_MIPS.Companion.debug("Code after error: ");
            j = 0;
            n4 = 15;
            while (j <= n4) {
                int word = bus2.readWord(this.pfPC + i * 4);
                String word2 = "(PC 0x%08x) 0x%08x            %s";
                objectArray = new Object[]{this.pfPC + i * 4, word, Companion.decompileInst(word)};
                companion = Companion;
                boolean bl = false;
                Intrinsics.checkExpressionValueIsNotNull((Object)String.format(word2, Arrays.copyOf(objectArray, objectArray.length)), (String)"java.lang.String.format(this, *args)");
                companion.debug(object);
                ++i;
            }
            CPU_MIPS.Companion.debug("Stacktrace:");
            String i22 = "Stack Pointer: 0x%08x";
            Object[] objectArray8 = this;
            int word = 29;
            int n5 = 0;
            objectArray2 = new Object[1];
            object = objectArray2;
            companion = Companion;
            boolean $i$f$getRegister2 = false;
            n2 = this_$iv.getRegisters()[t$iv];
            objectArray2[n5] = n2;
            objectArray8 = object;
            boolean bl = false;
            String string3 = String.format(i22, Arrays.copyOf(objectArray8, objectArray8.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"java.lang.String.format(this, *args)");
            object = string3;
            companion.debug(object);
            int n6 = 50;
            for (int i22 = 0; i22 <= n6; ++i22) {
                int t$iv2;
                Object[] this_$iv3;
                String string4 = "(0x%08x) 0x%08x";
                Object[] $i$f$getRegister2 = this;
                int n7 = 29;
                n5 = 0;
                objectArray2 = new Object[2];
                object = objectArray2;
                companion = Companion;
                boolean $i$f$getRegister3 = false;
                int n8 = this_$iv3.getRegisters()[t$iv2];
                objectArray2[n5] = n8 + i22 * 4;
                this_$iv3 = this;
                t$iv2 = 29;
                IRW iRW2 = bus2;
                n5 = 1;
                objectArray2 = object;
                $i$f$getRegister3 = false;
                n = this_$iv3.getRegisters()[t$iv2];
                objectArray2[n5] = iRW2.readWord(n + i22 * 4);
                Object object2 = object;
                n7 = 0;
                String string5 = String.format(string4, Arrays.copyOf(object2, ((Object[])object2).length));
                Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"java.lang.String.format(this, *args)");
                object = string5;
                companion.debug(object);
            }
        }
    }

    @Override
    public void setMotherboard(@NotNull IMotherboard mb) {
        Intrinsics.checkParameterIsNotNull((Object)mb, (String)"mb");
        this.motherboard = mb;
    }

    @Override
    @NotNull
    public Map<String, Object> serialize() {
        Pair[] pairArray;
        int[] nArray = this.registers;
        String string = "Regs";
        int n = 0;
        Pair[] pairArray2 = pairArray = new Pair[8];
        boolean bl = false;
        int[] nArray2 = Arrays.copyOf(nArray, nArray.length);
        Intrinsics.checkExpressionValueIsNotNull((Object)nArray2, (String)"java.util.Arrays.copyOf(this, size)");
        int[] nArray3 = nArray2;
        pairArray[n] = TuplesKt.to((Object)string, (Object)nArray3);
        Pair[] pairArray3 = pairArray2;
        pairArray2[1] = TuplesKt.to((Object)"PC", (Object)this.regPC);
        pairArray3[2] = TuplesKt.to((Object)"regHI", (Object)this.regHI);
        pairArray3[3] = TuplesKt.to((Object)"regLO", (Object)this.regLO);
        pairArray3[4] = TuplesKt.to((Object)"Status", (Object)this.regStatus);
        pairArray3[5] = TuplesKt.to((Object)"Cause", (Object)this.regCause);
        pairArray3[6] = TuplesKt.to((Object)"EPC", (Object)this.regEPC);
        pairArray3[7] = TuplesKt.to((Object)"Jump", (Object)this.jump);
        return MapsKt.mapOf((Pair[])pairArray3);
    }

    public void deserialize(@NotNull Map<String, ? extends Object> map) {
        Intrinsics.checkParameterIsNotNull(map, (String)"map");
        Object object = map.get("Regs");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.IntArray");
        }
        this.registers = (int[])object;
        Object object2 = map.get("PC");
        if (object2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Int");
        }
        this.regPC = (Integer)object2;
        Object object3 = map.get("regHI");
        if (object3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Int");
        }
        this.regHI = (Integer)object3;
        Object object4 = map.get("regLO");
        if (object4 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Int");
        }
        this.regLO = (Integer)object4;
        Object object5 = map.get("Status");
        if (object5 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Int");
        }
        this.regStatus = (Integer)object5;
        Object object6 = map.get("Cause");
        if (object6 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Int");
        }
        this.regCause = (Integer)object6;
        Object object7 = map.get("EPC");
        if (object7 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Int");
        }
        this.regEPC = (Integer)object7;
        Object object8 = map.get("Jump");
        if (object8 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Int");
        }
        this.jump = (Integer)object8;
    }

    static {
        Companion = new Companion(null);
        registerNames = new String[]{"z0", "at", "v0", "v1", "a0", "a1", "a2", "a3", "t0", "t1", "t2", "t3", "t4", "t5", "t6", "t7", "s0", "s1", "s2", "s3", "s4", "s5", "s6", "s7", "t8", "t9", "k0", "k1", "gp", "sp", "fp", "ra"};
        TYPE_R = new String[]{"SLL   ", "UNKN01", "SRL   ", "SRA   ", "SLLV  ", "UNKN05", "SRLV  ", "SRAV  ", "JR    ", "JALR  ", "UNKN10", "UNKN11", "UNKN12", "UNKN13", "UNKN14", "UNKN15", "MFHI  ", "MTHI  ", "MFLO  ", "MTLO  ", "UNKN20", "UNKN21", "UNKN22", "UNKN23", "MULT  ", "MULTU ", "DIV   ", "DIVU  ", "UNKN28", "UNKN29", "UNKN30", "UNKN31", "ADD   ", "ADDU  ", "SUB   ", "SUBU  ", "AND   ", "OR    ", "XOR   ", "NOR   ", "UNKN40", "UNKN41", "SLT   ", "SLTU  ", "UNKN44", "UNKN45", "UNKN46", "UNKN47", "UNKN48", "UNKN49", "UNKN50", "UNKN51", "UNKN52", "UNKN53", "UNKN54", "UNKN55", "UNKN56", "UNKN57", "UNKN58", "UNKN59", "UNKN60", "UNKN61", "UNKN62", "UNKN63"};
        TYPE_I = new String[]{"UNKNOW", "BGEZ ", "UNKNOW", "UNKNOW", "BEQ  ", "BNE  ", "BLEZ ", "BGTZ ", "ADDI ", "ADDIU", "SLTI ", "SLTIU", "ANDI ", "ORI  ", "XORI ", "LUI  ", "UNKNOW", "UNKNOW", "UNKNOW", "UNKNOW", "UNKNOW", "UNKNOW", "UNKNOW", "UNKNOW", "LLO  ", "LHI  ", "TRAP ", "UNKNOW", "UNKNOW", "UNKNOW", "UNKNOW", "UNKNOW", "LB   ", "LH   ", "LWL  ", "LW   ", "LBU  ", "LHU  ", "LWR   ", "UNKNOW", "SB   ", "SH   ", "SWL  ", "SW   ", "UNKNOW", "UNKNOW", "SWR  ", "UNKNOW", "UNKNOW", "UNKNOW", "UNKNOW", "UNKNOW", "UNKNOW", "UNKNOW", "UNKNOW", "UNKNOW", "UNKNOW", "UNKNOW", "UNKNOW", "UNKNOW", "UNKNOW", "UNKNOW", "UNKNOW", "UNKNOW"};
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\b\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\b\u00a8\u0006\t"}, d2={"Lcom/cout970/magneticraft/systems/computer/CPU_MIPS$InstructionType;", "", "(Ljava/lang/String;I)V", "R", "I", "J", "EXCEPTION", "COPROCESSOR", "NOOP", "Magneticraft_1.12"})
    public static final class InstructionType
    extends Enum<InstructionType> {
        public static final /* enum */ InstructionType R;
        public static final /* enum */ InstructionType I;
        public static final /* enum */ InstructionType J;
        public static final /* enum */ InstructionType EXCEPTION;
        public static final /* enum */ InstructionType COPROCESSOR;
        public static final /* enum */ InstructionType NOOP;
        private static final /* synthetic */ InstructionType[] $VALUES;

        static {
            InstructionType[] instructionTypeArray = new InstructionType[6];
            InstructionType[] instructionTypeArray2 = instructionTypeArray;
            instructionTypeArray[0] = R = new InstructionType();
            instructionTypeArray[1] = I = new InstructionType();
            instructionTypeArray[2] = J = new InstructionType();
            instructionTypeArray[3] = EXCEPTION = new InstructionType();
            instructionTypeArray[4] = COPROCESSOR = new InstructionType();
            instructionTypeArray[5] = NOOP = new InstructionType();
            $VALUES = instructionTypeArray;
        }

        public static InstructionType[] values() {
            return (InstructionType[])$VALUES.clone();
        }

        public static InstructionType valueOf(String string) {
            return Enum.valueOf(InstructionType.class, string);
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0001H\u0002J\u000e\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0012J&\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u0018J)\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u00052\u0012\u0010\u001b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0004\"\u00020\u0001H\u0002\u00a2\u0006\u0002\u0010\u001cR\u0019\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\n\n\u0002\u0010\b\u001a\u0004\b\u0006\u0010\u0007R\u0019\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\n\n\u0002\u0010\b\u001a\u0004\b\n\u0010\u0007R\u0019\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\n\n\u0002\u0010\b\u001a\u0004\b\f\u0010\u0007\u00a8\u0006\u001d"}, d2={"Lcom/cout970/magneticraft/systems/computer/CPU_MIPS$Companion;", "", "()V", "TYPE_I", "", "", "getTYPE_I", "()[Ljava/lang/String;", "[Ljava/lang/String;", "TYPE_R", "getTYPE_R", "registerNames", "getRegisterNames", "debug", "", "t", "decompileInst", "instruct", "", "getBitsFromInt", "inst_", "start_", "end_", "signed", "", "log", "s", "objs", "(Ljava/lang/String;[Ljava/lang/Object;)V", "Magneticraft_1.12"})
    public static final class Companion {
        @NotNull
        public final String[] getRegisterNames() {
            return registerNames;
        }

        @NotNull
        public final String[] getTYPE_R() {
            return TYPE_R;
        }

        @NotNull
        public final String[] getTYPE_I() {
            return TYPE_I;
        }

        private final void log(String s, Object ... objs) {
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            Object[] objectArray = Arrays.copyOf(objs, objs.length);
            Companion companion = this;
            boolean bl = false;
            String string = String.format(s, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"java.lang.String.format(format, *args)");
            String string2 = string;
            companion.debug(string2);
        }

        private final void debug(Object t) {
            String string = t.toString();
            boolean bl = false;
            System.out.println((Object)string);
        }

        public final int getBitsFromInt(int inst_, int start_, int end_, boolean signed) {
            int inst = inst_;
            int start = start_;
            int end = end_;
            if (start > end) {
                int temp = end;
                end = start;
                start = temp;
            }
            int max = (int)0xFFFFFFFFL;
            int mask = max >>> 31 - end & max << start;
            inst &= mask;
            if (signed) {
                return (inst <<= 31 - end) >> start + (31 - end);
            }
            return inst >>> start;
        }

        @NotNull
        public final String decompileInst(int instruct) {
            if (instruct == 0) {
                return "NOP";
            }
            int opcode = this.getBitsFromInt(instruct, 26, 31, false);
            if (instruct == 12 || opcode == 16) {
                String string = "Exception inst: 0x%08x, inst: %d";
                Object[] objectArray = new Object[]{instruct, instruct};
                boolean bl = false;
                String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(this, *args)");
                return string2;
            }
            if (opcode == 0) {
                int rs = this.getBitsFromInt(instruct, 21, 25, false);
                int rt = this.getBitsFromInt(instruct, 16, 20, false);
                int rd = this.getBitsFromInt(instruct, 11, 15, false);
                int shamt = this.getBitsFromInt(instruct, 6, 10, false);
                int func = this.getBitsFromInt(instruct, 0, 5, false);
                String string = "%s $%s, $%s, $%s (%05d) \t Type R: inst: 0x%08x";
                Object[] objectArray = new Object[]{this.getTYPE_R()[func], this.getRegisterNames()[rd], this.getRegisterNames()[rs], this.getRegisterNames()[rt], shamt, instruct};
                boolean bl = false;
                String string3 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"java.lang.String.format(this, *args)");
                return string3;
            }
            if (opcode == 2 || opcode == 3) {
                String[] names = new String[]{"UNKNOW", "UNKNOW", "J    ", "JAL  "};
                int dir = this.getBitsFromInt(instruct, 0, 25, false);
                String rd = "%s 0x%08x (0x%08x) \t Type J: inst: 0x%08x";
                Object[] shamt = new Object[]{names[opcode], dir, dir & (int)0xF0000000L | dir << 2, instruct};
                boolean bl = false;
                String string = String.format(rd, Arrays.copyOf(shamt, shamt.length));
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"java.lang.String.format(this, *args)");
                return string;
            }
            int rs = this.getBitsFromInt(instruct, 21, 25, false);
            int rt = this.getBitsFromInt(instruct, 16, 20, false);
            int inmed = this.getBitsFromInt(instruct, 0, 15, true);
            int inmedU = this.getBitsFromInt(instruct, 0, 15, false);
            String string = "%s $%s, $%s, %05d (%05d) \t Type I: inst: 0x%08x (opcode: 0x%x %d)";
            Object[] objectArray = new Object[]{this.getTYPE_I()[opcode], this.getRegisterNames()[rs], this.getRegisterNames()[rt], inmed, inmedU, instruct, opcode, opcode};
            boolean bl = false;
            String string4 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"java.lang.String.format(this, *args)");
            return string4;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

