/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.systems.computer;

import com.cout970.magneticraft.api.computer.IDevice;
import com.cout970.magneticraft.api.computer.IRW;
import com.cout970.magneticraft.api.computer.IResettable;
import com.cout970.magneticraft.misc.network.IBD;
import com.cout970.magneticraft.systems.computer.DeviceKeyboard;
import com.cout970.magneticraft.systems.computer.ReadOnlyByte;
import com.cout970.magneticraft.systems.computer.ReadOnlyShort;
import com.cout970.magneticraft.systems.computer.ReadWriteByte;
import com.cout970.magneticraft.systems.computer.ReadWriteByteArray;
import com.cout970.magneticraft.systems.computer.ReadWriteStruct;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0005\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u00012\u00020\u0002:\u0001<B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001c\u0010$\u001a\u00020%2\u0012\u0010&\u001a\u000e\u0012\u0004\u0012\u00020(\u0012\u0004\u0012\u00020)0'H\u0016J\u000e\u0010*\u001a\u00020%2\u0006\u0010+\u001a\u00020,J\u0016\u0010-\u001a\u00020%2\u0006\u0010.\u001a\u00020\n2\u0006\u0010/\u001a\u00020\nJ\u0016\u00100\u001a\u00020%2\u0006\u0010.\u001a\u00020\n2\u0006\u0010/\u001a\u00020\nJ\u0018\u00101\u001a\u0002022\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u00020\nH\u0016J\b\u00106\u001a\u00020%H\u0016J\u000e\u00107\u001a\u00020%2\u0006\u0010+\u001a\u00020,J\u0014\u00108\u001a\u000e\u0012\u0004\u0012\u00020(\u0012\u0004\u0012\u00020)0'H\u0016J\b\u00109\u001a\u00020%H\u0016J \u0010:\u001a\u00020%2\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u00020\n2\u0006\u0010;\u001a\u000202H\u0016R\u0015\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0018\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0017R\u0011\u0010\u001a\u001a\u00020\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u001a\u0010\u001e\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\f\"\u0004\b \u0010\u000eR\u001a\u0010!\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\f\"\u0004\b#\u0010\u000e\u00a8\u0006="}, d2={"Lcom/cout970/magneticraft/systems/computer/DeviceKeyboard;", "Lcom/cout970/magneticraft/api/computer/IDevice;", "Lcom/cout970/magneticraft/api/computer/IResettable;", "()V", "clipboardToPaste", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "getClipboardToPaste", "()Ljava/lang/StringBuilder;", "currentKey", "", "getCurrentKey", "()I", "setCurrentKey", "(I)V", "events", "Ljava/util/ArrayDeque;", "Lcom/cout970/magneticraft/systems/computer/DeviceKeyboard$KeyEvent;", "getEvents", "()Ljava/util/ArrayDeque;", "keyBuffer", "", "getKeyBuffer", "()[B", "keyStates", "getKeyStates", "memStruct", "Lcom/cout970/magneticraft/systems/computer/ReadWriteStruct;", "getMemStruct", "()Lcom/cout970/magneticraft/systems/computer/ReadWriteStruct;", "regKeyBufferPtr", "getRegKeyBufferPtr", "setRegKeyBufferPtr", "regKeyBufferSize", "getRegKeyBufferSize", "setRegKeyBufferSize", "deserialize", "", "map", "", "", "", "loadFromClient", "ibd", "Lcom/cout970/magneticraft/misc/network/IBD;", "onKeyPress", "key", "code", "onKeyRelease", "readByte", "", "bus", "Lcom/cout970/magneticraft/api/computer/IRW;", "addr", "reset", "saveToServer", "serialize", "update", "writeByte", "data", "KeyEvent", "Magneticraft_1.12"})
public final class DeviceKeyboard
implements IDevice,
IResettable {
    private int regKeyBufferPtr;
    private int regKeyBufferSize;
    @NotNull
    private final byte[] keyBuffer = new byte[32];
    @NotNull
    private final byte[] keyStates = new byte[256];
    private int currentKey;
    @NotNull
    private final ArrayDeque<KeyEvent> events = new ArrayDeque();
    @NotNull
    private final StringBuilder clipboardToPaste = new StringBuilder();
    @NotNull
    private final ReadWriteStruct memStruct = new ReadWriteStruct("monitor_header", new ReadWriteStruct("device_header", new ReadOnlyByte("online", (Function0<Byte>)((Function0)memStruct.1.INSTANCE)), new ReadOnlyByte("type", (Function0<Byte>)((Function0)memStruct.2.INSTANCE)), new ReadOnlyShort("status", (Function0<Short>)((Function0)memStruct.3.INSTANCE))), new ReadWriteByte("keyBufferPtr", (Function1<? super Byte, Unit>)((Function1)new Function1<Byte, Unit>(this){
        final /* synthetic */ DeviceKeyboard this$0;

        public final void invoke(byte it) {
            this.this$0.setRegKeyBufferPtr(it & 0xFF);
        }
        {
            this.this$0 = deviceKeyboard;
            super(1);
        }
    }), (Function0<Byte>)((Function0)new Function0<Byte>(this){
        final /* synthetic */ DeviceKeyboard this$0;

        public final byte invoke() {
            return (byte)this.this$0.getRegKeyBufferPtr();
        }
        {
            this.this$0 = deviceKeyboard;
            super(0);
        }
    })), new ReadWriteByte("keyBufferSize", (Function1<? super Byte, Unit>)((Function1)new Function1<Byte, Unit>(this){
        final /* synthetic */ DeviceKeyboard this$0;

        public final void invoke(byte it) {
            this.this$0.setRegKeyBufferSize(it & 0xFF);
        }
        {
            this.this$0 = deviceKeyboard;
            super(1);
        }
    }), (Function0<Byte>)((Function0)new Function0<Byte>(this){
        final /* synthetic */ DeviceKeyboard this$0;

        public final byte invoke() {
            return (byte)this.this$0.getRegKeyBufferSize();
        }
        {
            this.this$0 = deviceKeyboard;
            super(0);
        }
    })), new ReadWriteByte("key", (Function1<? super Byte, Unit>)((Function1)new Function1<Byte, Unit>(this){
        final /* synthetic */ DeviceKeyboard this$0;

        public final void invoke(byte it) {
            this.this$0.setCurrentKey(it & 0xFF);
        }
        {
            this.this$0 = deviceKeyboard;
            super(1);
        }
    }), (Function0<Byte>)((Function0)new Function0<Byte>(this){
        final /* synthetic */ DeviceKeyboard this$0;

        public final byte invoke() {
            return (byte)this.this$0.getCurrentKey();
        }
        {
            this.this$0 = deviceKeyboard;
            super(0);
        }
    })), new ReadOnlyByte("isPressed", (Function0<Byte>)((Function0)new Function0<Byte>(this){
        final /* synthetic */ DeviceKeyboard this$0;

        public final byte invoke() {
            return this.this$0.getKeyStates()[this.this$0.getCurrentKey()];
        }
        {
            this.this$0 = deviceKeyboard;
            super(0);
        }
    })), new ReadWriteByteArray("keyBuffer", this.keyBuffer));

    public final int getRegKeyBufferPtr() {
        return this.regKeyBufferPtr;
    }

    public final void setRegKeyBufferPtr(int n) {
        this.regKeyBufferPtr = n;
    }

    public final int getRegKeyBufferSize() {
        return this.regKeyBufferSize;
    }

    public final void setRegKeyBufferSize(int n) {
        this.regKeyBufferSize = n;
    }

    @NotNull
    public final byte[] getKeyBuffer() {
        return this.keyBuffer;
    }

    @NotNull
    public final byte[] getKeyStates() {
        return this.keyStates;
    }

    public final int getCurrentKey() {
        return this.currentKey;
    }

    public final void setCurrentKey(int n) {
        this.currentKey = n;
    }

    @NotNull
    public final ArrayDeque<KeyEvent> getEvents() {
        return this.events;
    }

    @NotNull
    public final StringBuilder getClipboardToPaste() {
        return this.clipboardToPaste;
    }

    @NotNull
    public final ReadWriteStruct getMemStruct() {
        return this.memStruct;
    }

    @Override
    public void update() {
        CharSequence charSequence = this.clipboardToPaste;
        boolean bl = false;
        if (charSequence.length() > 0) {
            char key2 = this.clipboardToPaste.charAt(0);
            while (this.regKeyBufferSize != this.keyBuffer.length / 2) {
                int pos = (this.regKeyBufferPtr + this.regKeyBufferSize) % (this.keyBuffer.length / 2);
                this.keyBuffer[2 * pos] = 1;
                this.keyBuffer[2 * pos + 1] = (byte)key2;
                int n = this.regKeyBufferSize;
                this.regKeyBufferSize = n + 1;
                this.clipboardToPaste.deleteCharAt(0);
                CharSequence charSequence2 = this.clipboardToPaste;
                boolean bl2 = false;
                if (charSequence2.length() == 0) break;
                key2 = this.clipboardToPaste.charAt(0);
            }
        }
    }

    @Override
    public void reset() {
        this.clipboardToPaste.delete(0, this.clipboardToPaste.length());
        ArraysKt.fill$default((byte[])this.keyStates, (byte)0, (int)0, (int)0, (int)6, null);
    }

    public final void onKeyPress(int key2, int code) {
        this.keyStates[code & 0xFF] = 1;
        this.events.addLast(new KeyEvent(key2, code));
    }

    public final void onKeyRelease(int key2, int code) {
        this.keyStates[code & 0xFF] = 0;
    }

    public final void saveToServer(@NotNull IBD ibd) {
        Intrinsics.checkParameterIsNotNull((Object)ibd, (String)"ibd");
        Collection collection = this.events;
        boolean bl = false;
        if (!collection.isEmpty()) {
            KeyEvent e = this.events.removeFirst();
            ibd.setInteger(21, e.getKey());
            ibd.setInteger(22, e.getCode());
        }
        ibd.setByteArray(20, this.keyStates);
    }

    public final void loadFromClient(@NotNull IBD ibd) {
        Intrinsics.checkParameterIsNotNull((Object)ibd, (String)"ibd");
        ibd.getString(44, (Function1<? super String, Unit>)((Function1)new Function1<String, Unit>(this){
            final /* synthetic */ DeviceKeyboard this$0;

            public final void invoke(@NotNull String it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                this.this$0.getClipboardToPaste().append(it);
            }
            {
                this.this$0 = deviceKeyboard;
                super(1);
            }
        }));
        ibd.getInteger(21, (Function1<? super Integer, Unit>)((Function1)new Function1<Integer, Unit>(this, ibd){
            final /* synthetic */ DeviceKeyboard this$0;
            final /* synthetic */ IBD $ibd;

            public final void invoke(int key2) {
                int code = this.$ibd.getInteger(22);
                if (this.this$0.getRegKeyBufferSize() != this.this$0.getKeyBuffer().length / 2) {
                    int pos = (this.this$0.getRegKeyBufferPtr() + this.this$0.getRegKeyBufferSize()) % (this.this$0.getKeyBuffer().length / 2);
                    this.this$0.getKeyBuffer()[2 * pos] = (byte)key2;
                    this.this$0.getKeyBuffer()[2 * pos + 1] = (byte)code;
                    DeviceKeyboard deviceKeyboard = this.this$0;
                    int n = deviceKeyboard.getRegKeyBufferSize();
                    deviceKeyboard.setRegKeyBufferSize(n + 1);
                }
            }
            {
                this.this$0 = deviceKeyboard;
                this.$ibd = iBD;
                super(1);
            }
        }));
        ibd.getByteArray(20, (Function1<? super byte[], Unit>)((Function1)new Function1<byte[], Unit>(this){
            final /* synthetic */ DeviceKeyboard this$0;

            public final void invoke(@NotNull byte[] buffer) {
                Intrinsics.checkParameterIsNotNull((Object)buffer, (String)"buffer");
                System.arraycopy(buffer, 0, this.this$0.getKeyStates(), 0, buffer.length);
            }
            {
                this.this$0 = deviceKeyboard;
                super(1);
            }
        }));
    }

    @Override
    public void writeByte(@NotNull IRW bus2, int addr, byte data) {
        Intrinsics.checkParameterIsNotNull((Object)bus2, (String)"bus");
        this.memStruct.write(addr, data);
    }

    @Override
    public byte readByte(@NotNull IRW bus2, int addr) {
        Intrinsics.checkParameterIsNotNull((Object)bus2, (String)"bus");
        return this.memStruct.read(addr);
    }

    @Override
    @NotNull
    public Map<String, Object> serialize() {
        Pair[] pairArray = new Pair[4];
        pairArray[0] = TuplesKt.to((Object)"KeyBufferPtr", (Object)this.regKeyBufferPtr);
        pairArray[1] = TuplesKt.to((Object)"KeyBufferSize", (Object)this.regKeyBufferSize);
        pairArray[2] = TuplesKt.to((Object)"currentKey", (Object)this.currentKey);
        byte[] byArray = this.keyBuffer;
        String string = "KeyBuffer";
        int n = 3;
        Pair[] pairArray2 = pairArray;
        Pair[] pairArray3 = pairArray;
        boolean bl = false;
        byte[] byArray2 = Arrays.copyOf(byArray, byArray.length);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray2, (String)"java.util.Arrays.copyOf(this, size)");
        byte[] byArray3 = byArray2;
        pairArray2[n] = TuplesKt.to((Object)string, (Object)byArray3);
        return MapsKt.mutableMapOf((Pair[])pairArray3);
    }

    @Override
    public void deserialize(@NotNull Map<String, Object> map) {
        Intrinsics.checkParameterIsNotNull(map, (String)"map");
        Object object = map.get("KeyBufferPtr");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Int");
        }
        this.regKeyBufferPtr = (Integer)object;
        Object object2 = map.get("KeyBufferSize");
        if (object2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Int");
        }
        this.regKeyBufferSize = (Integer)object2;
        Object object3 = map.get("currentKey");
        if (object3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Int");
        }
        this.currentKey = (Integer)object3;
        Object object4 = map.get("KeyBuffer");
        if (object4 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.ByteArray");
        }
        System.arraycopy((byte[])object4, 0, this.keyBuffer, 0, this.keyBuffer.length);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lcom/cout970/magneticraft/systems/computer/DeviceKeyboard$KeyEvent;", "", "key", "", "code", "(II)V", "getCode", "()I", "getKey", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "Magneticraft_1.12"})
    public static final class KeyEvent {
        private final int key;
        private final int code;

        public final int getKey() {
            return this.key;
        }

        public final int getCode() {
            return this.code;
        }

        public KeyEvent(int key2, int code) {
            this.key = key2;
            this.code = code;
        }

        public final int component1() {
            return this.key;
        }

        public final int component2() {
            return this.code;
        }

        @NotNull
        public final KeyEvent copy(int key2, int code) {
            return new KeyEvent(key2, code);
        }

        public static /* synthetic */ KeyEvent copy$default(KeyEvent keyEvent, int n, int n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                n = keyEvent.key;
            }
            if ((n3 & 2) != 0) {
                n2 = keyEvent.code;
            }
            return keyEvent.copy(n, n2);
        }

        @NotNull
        public String toString() {
            return "KeyEvent(key=" + this.key + ", code=" + this.code + ")";
        }

        public int hashCode() {
            return this.key * 31 + this.code;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof KeyEvent)) break block3;
                    KeyEvent keyEvent = (KeyEvent)object;
                    if (!(this.key == keyEvent.key) || !(this.code == keyEvent.code)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

