/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.systems.computer;

import com.cout970.magneticraft.api.computer.IDevice;
import com.cout970.magneticraft.api.computer.IRW;
import com.cout970.magneticraft.misc.network.IBD;
import com.cout970.magneticraft.systems.computer.DeviceMonitor;
import com.cout970.magneticraft.systems.computer.ReadOnlyByte;
import com.cout970.magneticraft.systems.computer.ReadOnlyInt;
import com.cout970.magneticraft.systems.computer.ReadOnlyShort;
import com.cout970.magneticraft.systems.computer.ReadWriteByteArray;
import com.cout970.magneticraft.systems.computer.ReadWriteInt;
import com.cout970.magneticraft.systems.computer.ReadWriteShort;
import com.cout970.magneticraft.systems.computer.ReadWriteStruct;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0005\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u001c\u001a\u00020\u001d2\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020!0\u001fH\u0016J\u0006\u0010\"\u001a\u00020\u0012J\u000e\u0010#\u001a\u00020\u00042\u0006\u0010$\u001a\u00020\u0004J\u0006\u0010%\u001a\u00020\u0012J\u000e\u0010&\u001a\u00020\u001d2\u0006\u0010'\u001a\u00020(J\u0018\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020\u0004H\u0016J\u000e\u0010.\u001a\u00020\u001d2\u0006\u0010'\u001a\u00020(J\u0014\u0010/\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u0002000\u001fH\u0016J\u000e\u00101\u001a\u00020\u001d2\u0006\u00102\u001a\u00020\u0004J\b\u00103\u001a\u00020\u001dH\u0016J \u00104\u001a\u00020\u001d2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020\u00042\u0006\u00105\u001a\u00020*H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0007\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\u0006\"\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\u0006\"\u0004\b\r\u0010\nR\u001a\u0010\u000e\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0006\"\u0004\b\u0010\u0010\nR\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0006R\u0011\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0006\u00a8\u00066"}, d2={"Lcom/cout970/magneticraft/systems/computer/DeviceMonitor;", "Lcom/cout970/magneticraft/api/computer/IDevice;", "()V", "columns", "", "getColumns", "()I", "currentLine", "getCurrentLine", "setCurrentLine", "(I)V", "cursorColumn", "getCursorColumn", "setCursorColumn", "cursorLine", "getCursorLine", "setCursorLine", "lineBuffer", "", "lines", "getLines", "memStruct", "Lcom/cout970/magneticraft/systems/computer/ReadWriteStruct;", "getMemStruct", "()Lcom/cout970/magneticraft/systems/computer/ReadWriteStruct;", "screenBuffer", "screenSize", "getScreenSize", "deserialize", "", "map", "", "", "", "getBuffer", "getChar", "pos", "getScreenBuffer", "loadFromServer", "ibd", "Lcom/cout970/magneticraft/misc/network/IBD;", "readByte", "", "bus", "Lcom/cout970/magneticraft/api/computer/IRW;", "pointer", "saveToClient", "serialize", "Ljava/io/Serializable;", "signal", "id", "update", "writeByte", "data", "Magneticraft_1.12"})
public final class DeviceMonitor
implements IDevice {
    private byte[] screenBuffer;
    private int cursorLine;
    private int cursorColumn;
    private int currentLine;
    private byte[] lineBuffer;
    private final int lines = 34;
    private final int columns = 80;
    private final int screenSize = this.lines * this.columns;
    @NotNull
    private final ReadWriteStruct memStruct = new ReadWriteStruct("monitor_header", new ReadWriteStruct("device_header", new ReadOnlyByte("online", (Function0<Byte>)((Function0)memStruct.1.INSTANCE)), new ReadOnlyByte("type", (Function0<Byte>)((Function0)memStruct.2.INSTANCE)), new ReadOnlyShort("status", (Function0<Short>)((Function0)memStruct.3.INSTANCE))), new ReadOnlyInt("lines", (Function0<Integer>)((Function0)new Function0<Integer>(this){
        final /* synthetic */ DeviceMonitor this$0;

        public final int invoke() {
            return this.this$0.getLines();
        }
        {
            this.this$0 = deviceMonitor;
            super(0);
        }
    })), new ReadOnlyInt("columns", (Function0<Integer>)((Function0)new Function0<Integer>(this){
        final /* synthetic */ DeviceMonitor this$0;

        public final int invoke() {
            return this.this$0.getColumns();
        }
        {
            this.this$0 = deviceMonitor;
            super(0);
        }
    })), new ReadWriteInt("cursorLine", (Function1<? super Integer, Unit>)((Function1)new Function1<Integer, Unit>(this){
        final /* synthetic */ DeviceMonitor this$0;

        public final void invoke(int it) {
            this.this$0.setCursorLine(it);
        }
        {
            this.this$0 = deviceMonitor;
            super(1);
        }
    }), (Function0<Integer>)((Function0)new Function0<Integer>(this){
        final /* synthetic */ DeviceMonitor this$0;

        public final int invoke() {
            return this.this$0.getCursorLine();
        }
        {
            this.this$0 = deviceMonitor;
            super(0);
        }
    })), new ReadWriteInt("cursorColumn", (Function1<? super Integer, Unit>)((Function1)new Function1<Integer, Unit>(this){
        final /* synthetic */ DeviceMonitor this$0;

        public final void invoke(int it) {
            this.this$0.setCursorColumn(it);
        }
        {
            this.this$0 = deviceMonitor;
            super(1);
        }
    }), (Function0<Integer>)((Function0)new Function0<Integer>(this){
        final /* synthetic */ DeviceMonitor this$0;

        public final int invoke() {
            return this.this$0.getCursorColumn();
        }
        {
            this.this$0 = deviceMonitor;
            super(0);
        }
    })), new ReadWriteShort("signal", (Function1<? super Short, Unit>)((Function1)new Function1<Short, Unit>(this){
        final /* synthetic */ DeviceMonitor this$0;

        public final void invoke(short it) {
            this.this$0.signal(it);
        }
        {
            this.this$0 = deviceMonitor;
            super(1);
        }
    }), (Function0<Short>)((Function0)memStruct.11.INSTANCE)), new ReadWriteShort("currentLine", (Function1<? super Short, Unit>)((Function1)new Function1<Short, Unit>(this){
        final /* synthetic */ DeviceMonitor this$0;

        public final void invoke(short it) {
            this.this$0.setCurrentLine(it);
        }
        {
            this.this$0 = deviceMonitor;
            super(1);
        }
    }), (Function0<Short>)((Function0)new Function0<Short>(this){
        final /* synthetic */ DeviceMonitor this$0;

        public final short invoke() {
            return (short)this.this$0.getCurrentLine();
        }
        {
            this.this$0 = deviceMonitor;
            super(0);
        }
    })), new ReadWriteByteArray("buffer", this.getBuffer()));

    public final int getCursorLine() {
        return this.cursorLine;
    }

    public final void setCursorLine(int n) {
        this.cursorLine = n;
    }

    public final int getCursorColumn() {
        return this.cursorColumn;
    }

    public final void setCursorColumn(int n) {
        this.cursorColumn = n;
    }

    public final int getCurrentLine() {
        return this.currentLine;
    }

    public final void setCurrentLine(int n) {
        this.currentLine = n;
    }

    public final int getLines() {
        return this.lines;
    }

    public final int getColumns() {
        return this.columns;
    }

    public final int getScreenSize() {
        return this.screenSize;
    }

    @NotNull
    public final ReadWriteStruct getMemStruct() {
        return this.memStruct;
    }

    @Override
    public void update() {
    }

    /*
     * WARNING - void declaration
     */
    public final void signal(int id) {
        switch (id) {
            case 1: {
                int n = this.currentLine;
                if (0 > n || this.lines - 1 < n) break;
                n = 0;
                int n2 = this.columns;
                while (n < n2) {
                    void i;
                    this.getBuffer()[i] = this.getScreenBuffer()[this.currentLine * this.columns + i];
                    ++i;
                }
                break;
            }
            case 2: {
                int i = this.currentLine;
                if (0 > i || this.lines - 1 < i) break;
                int n = this.columns;
                for (i = 0; i < n; ++i) {
                    this.getScreenBuffer()[this.currentLine * this.columns + i] = this.getBuffer()[i];
                }
                break;
            }
        }
    }

    @Override
    public byte readByte(@NotNull IRW bus2, int pointer) {
        Intrinsics.checkParameterIsNotNull((Object)bus2, (String)"bus");
        return this.memStruct.read(pointer);
    }

    @Override
    public void writeByte(@NotNull IRW bus2, int pointer, byte data) {
        Intrinsics.checkParameterIsNotNull((Object)bus2, (String)"bus");
        this.memStruct.write(pointer, data);
    }

    @NotNull
    public final byte[] getBuffer() {
        block6: {
            block5: {
                if (this.lineBuffer == null) break block5;
                if (this.lineBuffer == null) {
                    Intrinsics.throwNpe();
                }
                if (this.lineBuffer.length == this.columns) break block6;
            }
            this.lineBuffer = new byte[this.columns];
        }
        if (this.lineBuffer == null) {
            Intrinsics.throwNpe();
        }
        return this.lineBuffer;
    }

    @NotNull
    public final byte[] getScreenBuffer() {
        block6: {
            block5: {
                if (this.screenBuffer == null) break block5;
                if (this.screenBuffer == null) {
                    Intrinsics.throwNpe();
                }
                if (this.screenBuffer.length == this.screenSize) break block6;
            }
            this.screenBuffer = new byte[this.screenSize];
        }
        if (this.screenBuffer == null) {
            Intrinsics.throwNpe();
        }
        return this.screenBuffer;
    }

    public final int getChar(int pos) {
        return this.getScreenBuffer()[pos];
    }

    @NotNull
    public Map<String, Serializable> serialize() {
        Pair[] pairArray;
        byte[] byArray = this.getBuffer();
        String string = "Buffer";
        int n = 0;
        Pair[] pairArray2 = pairArray = new Pair[5];
        boolean bl = false;
        byte[] byArray2 = Arrays.copyOf(byArray, byArray.length);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray2, (String)"java.util.Arrays.copyOf(this, size)");
        byte[] byArray3 = byArray2;
        pairArray[n] = TuplesKt.to((Object)string, (Object)byArray3);
        byArray = this.getScreenBuffer();
        string = "ScreenBuffer";
        n = 1;
        pairArray = pairArray2;
        bl = false;
        byte[] byArray4 = Arrays.copyOf(byArray, byArray.length);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray4, (String)"java.util.Arrays.copyOf(this, size)");
        byArray3 = byArray4;
        pairArray[n] = TuplesKt.to((Object)string, (Object)byArray3);
        Pair[] pairArray3 = pairArray2;
        pairArray2[2] = TuplesKt.to((Object)"CurrentLine", (Object)this.currentLine);
        pairArray3[3] = TuplesKt.to((Object)"CursorLine", (Object)this.cursorLine);
        pairArray3[4] = TuplesKt.to((Object)"CursorColumn", (Object)this.cursorColumn);
        return MapsKt.mapOf((Pair[])pairArray3);
    }

    public void deserialize(@NotNull Map<String, ? extends Object> map) {
        Intrinsics.checkParameterIsNotNull(map, (String)"map");
        Object object = map.get("Buffer");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.ByteArray");
        }
        System.arraycopy((byte[])object, 0, this.getBuffer(), 0, this.getBuffer().length);
        Object object2 = map.get("ScreenBuffer");
        if (object2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.ByteArray");
        }
        this.screenBuffer = (byte[])object2;
        Object object3 = map.get("CurrentLine");
        if (object3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Int");
        }
        this.currentLine = (Integer)object3;
        Object object4 = map.get("CursorLine");
        if (object4 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Int");
        }
        this.cursorLine = (Integer)object4;
        Object object5 = map.get("CursorColumn");
        if (object5 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Int");
        }
        this.cursorColumn = (Integer)object5;
    }

    public final void saveToClient(@NotNull IBD ibd) {
        Intrinsics.checkParameterIsNotNull((Object)ibd, (String)"ibd");
        ibd.setInteger(17, this.cursorLine);
        ibd.setInteger(18, this.cursorColumn);
        ibd.setByteArray(19, this.getScreenBuffer());
    }

    public final void loadFromServer(@NotNull IBD ibd) {
        Intrinsics.checkParameterIsNotNull((Object)ibd, (String)"ibd");
        ibd.getInteger(17, (Function1<? super Integer, Unit>)((Function1)new Function1<Integer, Unit>(this){
            final /* synthetic */ DeviceMonitor this$0;

            public final void invoke(int it) {
                this.this$0.setCursorLine(it);
            }
            {
                this.this$0 = deviceMonitor;
                super(1);
            }
        }));
        ibd.getInteger(18, (Function1<? super Integer, Unit>)((Function1)new Function1<Integer, Unit>(this){
            final /* synthetic */ DeviceMonitor this$0;

            public final void invoke(int it) {
                this.this$0.setCursorColumn(it);
            }
            {
                this.this$0 = deviceMonitor;
                super(1);
            }
        }));
        ibd.getByteArray(19, (Function1<? super byte[], Unit>)((Function1)new Function1<byte[], Unit>(this){
            final /* synthetic */ DeviceMonitor this$0;

            public final void invoke(@NotNull byte[] it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                System.arraycopy(it, 0, this.this$0.getScreenBuffer(), 0, this.this$0.getScreenSize());
            }
            {
                this.this$0 = deviceMonitor;
                super(1);
            }
        }));
    }
}

