/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.systems.gui.components;

import com.cout970.magneticraft.misc.vector.Vec2d;
import com.cout970.magneticraft.systems.gui.render.DrawableBox;
import com.cout970.magneticraft.systems.gui.render.IComponent;
import com.cout970.magneticraft.systems.gui.render.IGui;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u001cH\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0096.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u0018\u0010\u000f\u001a\u00060\u0010j\u0002`\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0018\u0010\u0014\u001a\u00060\u0010j\u0002`\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0013R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u001d"}, d2={"Lcom/cout970/magneticraft/systems/gui/components/CompImage;", "Lcom/cout970/magneticraft/systems/gui/render/IComponent;", "texture", "Lnet/minecraft/util/ResourceLocation;", "box", "Lcom/cout970/magneticraft/systems/gui/render/DrawableBox;", "(Lnet/minecraft/util/ResourceLocation;Lcom/cout970/magneticraft/systems/gui/render/DrawableBox;)V", "getBox", "()Lcom/cout970/magneticraft/systems/gui/render/DrawableBox;", "gui", "Lcom/cout970/magneticraft/systems/gui/render/IGui;", "getGui", "()Lcom/cout970/magneticraft/systems/gui/render/IGui;", "setGui", "(Lcom/cout970/magneticraft/systems/gui/render/IGui;)V", "pos", "Lcom/cout970/magneticraft/misc/vector/Vec2d;", "Lcom/cout970/magneticraft/IVector2;", "getPos", "()Lcom/cout970/magneticraft/misc/vector/Vec2d;", "size", "getSize", "getTexture", "()Lnet/minecraft/util/ResourceLocation;", "drawFirstLayer", "", "mouse", "partialTicks", "", "Magneticraft_1.12"})
public final class CompImage
implements IComponent {
    @NotNull
    private final Vec2d pos;
    @NotNull
    private final Vec2d size;
    @NotNull
    public IGui gui;
    @NotNull
    private final ResourceLocation texture;
    @NotNull
    private final DrawableBox box;

    @Override
    @NotNull
    public Vec2d getPos() {
        return this.pos;
    }

    @Override
    @NotNull
    public Vec2d getSize() {
        return this.size;
    }

    @Override
    @NotNull
    public IGui getGui() {
        IGui iGui = this.gui;
        if (iGui == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"gui");
        }
        return iGui;
    }

    @Override
    public void setGui(@NotNull IGui iGui) {
        Intrinsics.checkParameterIsNotNull((Object)iGui, (String)"<set-?>");
        this.gui = iGui;
    }

    @Override
    public void drawFirstLayer(@NotNull Vec2d mouse, float partialTicks) {
        Intrinsics.checkParameterIsNotNull((Object)mouse, (String)"mouse");
        this.getGui().bindTexture(this.texture);
        this.getGui().drawTexture(this.box.offset(this.getGui().getPos()));
    }

    @NotNull
    public final ResourceLocation getTexture() {
        return this.texture;
    }

    @NotNull
    public final DrawableBox getBox() {
        return this.box;
    }

    public CompImage(@NotNull ResourceLocation texture, @NotNull DrawableBox box) {
        Intrinsics.checkParameterIsNotNull((Object)texture, (String)"texture");
        Intrinsics.checkParameterIsNotNull((Object)box, (String)"box");
        this.texture = texture;
        this.box = box;
        this.pos = this.box.getScreenPos();
        this.size = this.box.getScreenSize();
    }

    @Override
    @NotNull
    public Pair<Vec2d, Vec2d> getCollisionBox() {
        return IComponent.DefaultImpls.getCollisionBox(this);
    }

    @Override
    public void init() {
        IComponent.DefaultImpls.init(this);
    }

    @Override
    public void drawSecondLayer(@NotNull Vec2d mouse) {
        Intrinsics.checkParameterIsNotNull((Object)mouse, (String)"mouse");
        IComponent.DefaultImpls.drawSecondLayer(this, mouse);
    }

    @Override
    public boolean onMouseClick(@NotNull Vec2d mouse, int mouseButton) {
        Intrinsics.checkParameterIsNotNull((Object)mouse, (String)"mouse");
        return IComponent.DefaultImpls.onMouseClick(this, mouse, mouseButton);
    }

    @Override
    public boolean onMouseClickMove(@NotNull Vec2d mouse, int clickedMouseButton, long timeSinceLastClick) {
        Intrinsics.checkParameterIsNotNull((Object)mouse, (String)"mouse");
        return IComponent.DefaultImpls.onMouseClickMove(this, mouse, clickedMouseButton, timeSinceLastClick);
    }

    @Override
    public void onMouseReleased(@NotNull Vec2d mouse, int state) {
        Intrinsics.checkParameterIsNotNull((Object)mouse, (String)"mouse");
        IComponent.DefaultImpls.onMouseReleased(this, mouse, state);
    }

    @Override
    public boolean onKeyTyped(char typedChar, int keyCode) {
        return IComponent.DefaultImpls.onKeyTyped(this, typedChar, keyCode);
    }

    @Override
    public boolean onKeyReleased(char typedChar, int keyCode) {
        return IComponent.DefaultImpls.onKeyReleased(this, typedChar, keyCode);
    }

    @Override
    public void onWheel(int amount) {
        IComponent.DefaultImpls.onWheel(this, amount);
    }

    @Override
    public void onGuiClosed() {
        IComponent.DefaultImpls.onGuiClosed(this);
    }
}

