/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.systems.integration.jei;

import com.cout970.magneticraft.api.registries.machines.crushingtable.ICrushingTableRecipe;
import com.cout970.magneticraft.misc.LoggerKt;
import com.cout970.magneticraft.systems.integration.jei.MagneticraftPluginKt;
import com.cout970.magneticraft.systems.tilemodules.ModuleCrushingTable;
import java.awt.Color;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.item.ItemStack;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J0\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\fH\u0016J\u0010\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0013"}, d2={"Lcom/cout970/magneticraft/systems/integration/jei/CrushingTableRecipeWrapper;", "Lmezz/jei/api/recipe/IRecipeWrapper;", "recipe", "Lcom/cout970/magneticraft/api/registries/machines/crushingtable/ICrushingTableRecipe;", "(Lcom/cout970/magneticraft/api/registries/machines/crushingtable/ICrushingTableRecipe;)V", "getRecipe", "()Lcom/cout970/magneticraft/api/registries/machines/crushingtable/ICrushingTableRecipe;", "drawInfo", "", "minecraft", "Lnet/minecraft/client/Minecraft;", "recipeWidth", "", "recipeHeight", "mouseX", "mouseY", "getIngredients", "ingredients", "Lmezz/jei/api/ingredients/IIngredients;", "Magneticraft_1.12"})
public final class CrushingTableRecipeWrapper
implements IRecipeWrapper {
    @NotNull
    private final ICrushingTableRecipe recipe;

    public void getIngredients(@NotNull IIngredients ingredients) {
        Intrinsics.checkParameterIsNotNull((Object)ingredients, (String)"ingredients");
        if (this.recipe.useOreDictionaryEquivalencies()) {
            ItemStack itemStack = this.recipe.getInput();
            Intrinsics.checkExpressionValueIsNotNull((Object)itemStack, (String)"recipe.input");
            ingredients.setInputs(ItemStack.class, CollectionsKt.listOf((Object)MagneticraftPluginKt.access$getOreDictEquivalents(itemStack)));
        } else {
            ingredients.setInput(ItemStack.class, (Object)this.recipe.getInput());
        }
        ingredients.setOutput(ItemStack.class, (Object)this.recipe.getOutput());
    }

    public void drawInfo(@NotNull Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)minecraft, (String)"minecraft");
        ItemStack itemStack = this.recipe.getInput();
        Intrinsics.checkExpressionValueIsNotNull((Object)itemStack, (String)"recipe.input");
        int level = ModuleCrushingTable.Companion.getCrushingLevel(itemStack);
        switch (level) {
            case -1: {
                string = LoggerKt.t("text.magneticraft.jei.mining_level.-1", new Object[0]);
                break;
            }
            case 0: {
                string = LoggerKt.t("text.magneticraft.jei.mining_level.0", new Object[0]);
                break;
            }
            case 1: {
                string = LoggerKt.t("text.magneticraft.jei.mining_level.1", new Object[0]);
                break;
            }
            case 2: {
                string = LoggerKt.t("text.magneticraft.jei.mining_level.2", new Object[0]);
                break;
            }
            case 3: {
                string = LoggerKt.t("text.magneticraft.jei.mining_level.3", new Object[0]);
                break;
            }
            case 4: {
                string = LoggerKt.t("text.magneticraft.jei.mining_level.4", new Object[0]);
                break;
            }
            default: {
                string = LoggerKt.t("text.magneticraft.jei.mining_level.other", String.valueOf(level));
            }
        }
        String name = string;
        FontRenderer fontRenderer = minecraft.field_71466_p;
        Color color = Color.gray;
        Intrinsics.checkExpressionValueIsNotNull((Object)color, (String)"Color.gray");
        fontRenderer.func_78276_b(name, 16, 68, color.getRGB());
    }

    @NotNull
    public final ICrushingTableRecipe getRecipe() {
        return this.recipe;
    }

    public CrushingTableRecipeWrapper(@NotNull ICrushingTableRecipe recipe) {
        Intrinsics.checkParameterIsNotNull((Object)recipe, (String)"recipe");
        this.recipe = recipe;
    }
}

