/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.systems.multiblocks;

import com.cout970.magneticraft.misc.ResourcesKt;
import com.cout970.magneticraft.misc.vector.BlockPosKt;
import com.cout970.magneticraft.systems.multiblocks.BlockData;
import com.cout970.magneticraft.systems.multiblocks.IMultiblockComponent;
import com.cout970.magneticraft.systems.multiblocks.Multiblock;
import com.cout970.magneticraft.systems.multiblocks.MultiblockContext;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001BE\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00126\u0010\u0004\u001a2\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\u000b\u0012\u0004\u0012\u00020\f0\u0005\u00a2\u0006\u0002\u0010\rJ\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\t\u001a\u00020\u0006H\u0016J\u001e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\t\u001a\u00020\u0006H\u0016J\u0018\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\t\u001a\u00020\u0006H\u0016J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\t\u001a\u00020\u0006H\u0016J\u001e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u00172\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0015H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fRA\u0010\u0004\u001a2\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\u000b\u0012\u0004\u0012\u00020\f0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006!"}, d2={"Lcom/cout970/magneticraft/systems/multiblocks/MainBlockComponent;", "Lcom/cout970/magneticraft/systems/multiblocks/IMultiblockComponent;", "block", "Lnet/minecraft/block/Block;", "getter", "Lkotlin/Function2;", "Lcom/cout970/magneticraft/systems/multiblocks/MultiblockContext;", "Lkotlin/ParameterName;", "name", "context", "", "activate", "Lnet/minecraft/block/state/IBlockState;", "(Lnet/minecraft/block/Block;Lkotlin/jvm/functions/Function2;)V", "getBlock", "()Lnet/minecraft/block/Block;", "getGetter", "()Lkotlin/jvm/functions/Function2;", "activateBlock", "", "relativePos", "Lnet/minecraft/util/math/BlockPos;", "checkBlock", "", "Lnet/minecraft/util/text/ITextComponent;", "deactivateBlock", "getBlockData", "Lcom/cout970/magneticraft/systems/multiblocks/BlockData;", "getBlueprintBlocks", "Lnet/minecraft/item/ItemStack;", "multiblock", "Lcom/cout970/magneticraft/systems/multiblocks/Multiblock;", "blockPos", "Magneticraft_1.12"})
public final class MainBlockComponent
implements IMultiblockComponent {
    @NotNull
    private final Block block;
    @NotNull
    private final Function2<MultiblockContext, Boolean, IBlockState> getter;

    @Override
    @NotNull
    public List<ITextComponent> checkBlock(@NotNull BlockPos relativePos, @NotNull MultiblockContext context) {
        IBlockState state;
        Intrinsics.checkParameterIsNotNull((Object)relativePos, (String)"relativePos");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        BlockPos pos = BlockPosKt.plus(context.getCenter(), relativePos);
        IBlockState iBlockState = state = context.getWorld().func_180495_p(pos);
        Intrinsics.checkExpressionValueIsNotNull((Object)iBlockState, (String)"state");
        if (Intrinsics.areEqual((Object)iBlockState.func_177230_c(), (Object)this.block) ^ true) {
            String keyStr = "text.magneticraft.multiblock.invalid_block";
            String string = "[%d, %d, %d]";
            Object[] objectArray = new Object[]{pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()};
            boolean bl = false;
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(this, *args)");
            String vecStr = string2;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = vecStr;
            objectArray2[1] = ResourcesKt.prettyFormat(state);
            String string3 = this.block.func_149732_F();
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"block.localizedName");
            objectArray2[2] = string3;
            return CollectionsKt.listOf((Object)ResourcesKt.i18n(keyStr, objectArray2));
        }
        return CollectionsKt.emptyList();
    }

    @Override
    @NotNull
    public BlockData getBlockData(@NotNull BlockPos relativePos, @NotNull MultiblockContext context) {
        IBlockState state;
        Intrinsics.checkParameterIsNotNull((Object)relativePos, (String)"relativePos");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        BlockPos pos = BlockPosKt.plus(context.getCenter(), relativePos);
        IBlockState iBlockState = state = context.getWorld().func_180495_p(pos);
        Intrinsics.checkExpressionValueIsNotNull((Object)iBlockState, (String)"state");
        return new BlockData(iBlockState, pos);
    }

    @Override
    public void activateBlock(@NotNull BlockPos relativePos, @NotNull MultiblockContext context) {
        Intrinsics.checkParameterIsNotNull((Object)relativePos, (String)"relativePos");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        BlockPos pos = BlockPosKt.plus(context.getCenter(), relativePos);
        context.getWorld().func_175656_a(pos, (IBlockState)this.getter.invoke((Object)context, (Object)true));
        IMultiblockComponent.DefaultImpls.activateBlock(this, relativePos, context);
    }

    @Override
    public void deactivateBlock(@NotNull BlockPos relativePos, @NotNull MultiblockContext context) {
        Intrinsics.checkParameterIsNotNull((Object)relativePos, (String)"relativePos");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        IMultiblockComponent.DefaultImpls.deactivateBlock(this, relativePos, context);
        BlockPos pos = BlockPosKt.plus(context.getCenter(), relativePos);
        context.getWorld().func_175656_a(pos, (IBlockState)this.getter.invoke((Object)context, (Object)false));
    }

    @Override
    @NotNull
    public List<ItemStack> getBlueprintBlocks(@NotNull Multiblock multiblock, @NotNull BlockPos blockPos) {
        Intrinsics.checkParameterIsNotNull((Object)multiblock, (String)"multiblock");
        Intrinsics.checkParameterIsNotNull((Object)blockPos, (String)"blockPos");
        boolean bl = false;
        return CollectionsKt.emptyList();
    }

    @NotNull
    public final Block getBlock() {
        return this.block;
    }

    @NotNull
    public final Function2<MultiblockContext, Boolean, IBlockState> getGetter() {
        return this.getter;
    }

    public MainBlockComponent(@NotNull Block block, @NotNull Function2<? super MultiblockContext, ? super Boolean, ? extends IBlockState> getter) {
        Intrinsics.checkParameterIsNotNull((Object)block, (String)"block");
        Intrinsics.checkParameterIsNotNull(getter, (String)"getter");
        this.block = block;
        this.getter = getter;
    }
}

