/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.systems.tilemodules;

import com.cout970.magneticraft.misc.gui.ValueAverage;
import com.cout970.magneticraft.misc.inventory.InventoriesKt;
import com.cout970.magneticraft.misc.inventory.Inventory;
import com.cout970.magneticraft.misc.network.IBD;
import com.cout970.magneticraft.misc.network.SyncVariable;
import com.cout970.magneticraft.registry.CapabilitiesKt;
import com.cout970.magneticraft.systems.tileentities.IModule;
import com.cout970.magneticraft.systems.tileentities.IModuleContainer;
import com.cout970.magneticraft.systems.tilemodules.ModuleInternalStorage;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\u0005\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0006\u0010!\u001a\u00020\"J\u0006\u0010#\u001a\u00020\"J\u000e\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%H\u0016J\b\u0010'\u001a\u00020\"H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0010X\u0096.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0018\u001a\u00020\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010\t\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u000e\u00a8\u0006("}, d2={"Lcom/cout970/magneticraft/systems/tilemodules/ModuleChargeItems;", "Lcom/cout970/magneticraft/systems/tileentities/IModule;", "inventory", "Lcom/cout970/magneticraft/misc/inventory/Inventory;", "chargeSlot", "", "dischargeSlot", "storage", "Lcom/cout970/magneticraft/systems/tilemodules/ModuleInternalStorage;", "transferRate", "name", "", "(Lcom/cout970/magneticraft/misc/inventory/Inventory;IILcom/cout970/magneticraft/systems/tilemodules/ModuleInternalStorage;ILjava/lang/String;)V", "getChargeSlot", "()I", "container", "Lcom/cout970/magneticraft/systems/tileentities/IModuleContainer;", "getContainer", "()Lcom/cout970/magneticraft/systems/tileentities/IModuleContainer;", "setContainer", "(Lcom/cout970/magneticraft/systems/tileentities/IModuleContainer;)V", "getDischargeSlot", "getInventory", "()Lcom/cout970/magneticraft/misc/inventory/Inventory;", "itemChargeRate", "Lcom/cout970/magneticraft/misc/gui/ValueAverage;", "getItemChargeRate", "()Lcom/cout970/magneticraft/misc/gui/ValueAverage;", "getName", "()Ljava/lang/String;", "getStorage", "()Lcom/cout970/magneticraft/systems/tilemodules/ModuleInternalStorage;", "getTransferRate", "charge", "", "discharge", "getGuiSyncVariables", "", "Lcom/cout970/magneticraft/misc/network/SyncVariable;", "update", "Magneticraft_1.12"})
public final class ModuleChargeItems
implements IModule {
    @NotNull
    public IModuleContainer container;
    @NotNull
    private final ValueAverage itemChargeRate;
    @NotNull
    private final Inventory inventory;
    private final int chargeSlot;
    private final int dischargeSlot;
    @NotNull
    private final ModuleInternalStorage storage;
    private final int transferRate;
    @NotNull
    private final String name;

    @Override
    @NotNull
    public IModuleContainer getContainer() {
        IModuleContainer iModuleContainer = this.container;
        if (iModuleContainer == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"container");
        }
        return iModuleContainer;
    }

    @Override
    public void setContainer(@NotNull IModuleContainer iModuleContainer) {
        Intrinsics.checkParameterIsNotNull((Object)iModuleContainer, (String)"<set-?>");
        this.container = iModuleContainer;
    }

    @NotNull
    public final ValueAverage getItemChargeRate() {
        return this.itemChargeRate;
    }

    @Override
    public void update() {
        this.charge();
        this.discharge();
        this.itemChargeRate.tick();
    }

    public final void discharge() {
        if (this.dischargeSlot == -1) {
            return;
        }
        ItemStack toDischarge = InventoriesKt.get((IItemHandler)this.inventory, this.dischargeSlot);
        if (toDischarge.func_190926_b()) {
            return;
        }
        Capability<IEnergyStorage> capability = CapabilitiesKt.getFORGE_ENERGY();
        if (capability == null) {
            Intrinsics.throwNpe();
        }
        IEnergyStorage iEnergyStorage = CapabilitiesKt.fromItem(capability, toDischarge);
        if (iEnergyStorage == null) {
            return;
        }
        IEnergyStorage cap = iEnergyStorage;
        int space = this.storage.getCapacity() - this.storage.getEnergy();
        int amount = Math.min(space, this.transferRate);
        int taken = cap.extractEnergy(amount, true);
        if (taken > 0) {
            cap.extractEnergy(taken, false);
            ModuleInternalStorage moduleInternalStorage = this.storage;
            moduleInternalStorage.setEnergy(moduleInternalStorage.getEnergy() + taken);
            this.itemChargeRate.plusAssign(taken);
        }
    }

    public final void charge() {
        if (this.chargeSlot == -1) {
            return;
        }
        ItemStack toCharge = InventoriesKt.get((IItemHandler)this.inventory, this.chargeSlot);
        if (toCharge.func_190926_b()) {
            return;
        }
        Capability<IEnergyStorage> capability = CapabilitiesKt.getFORGE_ENERGY();
        if (capability == null) {
            Intrinsics.throwNpe();
        }
        IEnergyStorage iEnergyStorage = CapabilitiesKt.fromItem(capability, toCharge);
        if (iEnergyStorage == null) {
            return;
        }
        IEnergyStorage cap = iEnergyStorage;
        int amount = Math.min(this.storage.getEnergy(), this.transferRate);
        int given = cap.receiveEnergy(amount, true);
        if (given > 0) {
            cap.receiveEnergy(given, false);
            ModuleInternalStorage moduleInternalStorage = this.storage;
            moduleInternalStorage.setEnergy(moduleInternalStorage.getEnergy() - given);
            this.itemChargeRate.minusAssign(given);
        }
    }

    @Override
    @NotNull
    public List<SyncVariable> getGuiSyncVariables() {
        return CollectionsKt.listOf((Object)this.itemChargeRate.toSyncVariable(11));
    }

    @NotNull
    public final Inventory getInventory() {
        return this.inventory;
    }

    public final int getChargeSlot() {
        return this.chargeSlot;
    }

    public final int getDischargeSlot() {
        return this.dischargeSlot;
    }

    @NotNull
    public final ModuleInternalStorage getStorage() {
        return this.storage;
    }

    public final int getTransferRate() {
        return this.transferRate;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    public ModuleChargeItems(@NotNull Inventory inventory2, int chargeSlot, int dischargeSlot, @NotNull ModuleInternalStorage storage, int transferRate, @NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)inventory2), (String)"inventory");
        Intrinsics.checkParameterIsNotNull((Object)storage, (String)"storage");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        this.inventory = inventory2;
        this.chargeSlot = chargeSlot;
        this.dischargeSlot = dischargeSlot;
        this.storage = storage;
        this.transferRate = transferRate;
        this.name = name;
        this.itemChargeRate = new ValueAverage(20);
    }

    public /* synthetic */ ModuleChargeItems(Inventory inventory2, int n, int n2, ModuleInternalStorage moduleInternalStorage, int n3, String string, int n4, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n4 & 2) != 0) {
            n = -1;
        }
        if ((n4 & 4) != 0) {
            n2 = -1;
        }
        if ((n4 & 0x20) != 0) {
            string = "module_charge_items";
        }
        this(inventory2, n, n2, moduleInternalStorage, n3, string);
    }

    @Override
    @NotNull
    public World getWorld() {
        return IModule.DefaultImpls.getWorld(this);
    }

    @Override
    @NotNull
    public BlockPos getPos() {
        return IModule.DefaultImpls.getPos(this);
    }

    @Override
    public void init() {
        IModule.DefaultImpls.init(this);
    }

    @Override
    public void onLoad() {
        IModule.DefaultImpls.onLoad(this);
    }

    @Override
    public void onBreak() {
        IModule.DefaultImpls.onBreak(this);
    }

    @Override
    @Nullable
    public <T> T getCapability(@NotNull Capability<T> cap, @Nullable EnumFacing facing) {
        Intrinsics.checkParameterIsNotNull(cap, (String)"cap");
        return IModule.DefaultImpls.getCapability(this, cap, facing);
    }

    @Override
    public boolean hasCapability(@NotNull Capability<?> cap, @Nullable EnumFacing facing) {
        Intrinsics.checkParameterIsNotNull(cap, (String)"cap");
        return IModule.DefaultImpls.hasCapability(this, cap, facing);
    }

    @Override
    public void deserializeNBT(@NotNull NBTTagCompound nbt2) {
        Intrinsics.checkParameterIsNotNull((Object)nbt2, (String)"nbt");
        IModule.DefaultImpls.deserializeNBT(this, nbt2);
    }

    @Override
    @NotNull
    public NBTTagCompound serializeNBT() {
        return IModule.DefaultImpls.serializeNBT(this);
    }

    @Override
    public void receiveSyncData(@NotNull IBD ibd, @NotNull Side otherSide) {
        Intrinsics.checkParameterIsNotNull((Object)ibd, (String)"ibd");
        Intrinsics.checkParameterIsNotNull((Object)otherSide, (String)"otherSide");
        IModule.DefaultImpls.receiveSyncData(this, ibd, otherSide);
    }
}

