/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.systems.tilemodules;

import com.cout970.magneticraft.api.heat.IHeatNode;
import com.cout970.magneticraft.misc.HeatKt;
import com.cout970.magneticraft.misc.NBTKt;
import com.cout970.magneticraft.misc.inventory.InventoriesKt;
import com.cout970.magneticraft.misc.inventory.Inventory;
import com.cout970.magneticraft.misc.network.IBD;
import com.cout970.magneticraft.misc.network.IntSyncVariable;
import com.cout970.magneticraft.misc.network.SyncVariable;
import com.cout970.magneticraft.misc.vector.AABBKt;
import com.cout970.magneticraft.misc.vector.Vec3dKt;
import com.cout970.magneticraft.misc.vector.Vec3iKt;
import com.cout970.magneticraft.systems.blocks.BlockBase;
import com.cout970.magneticraft.systems.blocks.BoundingBoxArgs;
import com.cout970.magneticraft.systems.blocks.CommonMethods;
import com.cout970.magneticraft.systems.blocks.IOnActivated;
import com.cout970.magneticraft.systems.blocks.OnActivatedArgs;
import com.cout970.magneticraft.systems.config.Config;
import com.cout970.magneticraft.systems.integration.ItemHolder;
import com.cout970.magneticraft.systems.tileentities.IModule;
import com.cout970.magneticraft.systems.tileentities.IModuleContainer;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u000f\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 62\u00020\u00012\u00020\u0002:\u00016B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0006\u0010%\u001a\u00020\u0017J\u0010\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)H\u0016J\u000e\u0010*\u001a\b\u0012\u0004\u0012\u00020,0+H\u0016J\u000e\u0010-\u001a\u00020\u00172\u0006\u0010.\u001a\u00020/J\u0010\u00100\u001a\u00020\u00172\u0006\u00101\u001a\u000202H\u0016J\b\u00103\u001a\u00020)H\u0016J\u0006\u00104\u001a\u00020'J\b\u00105\u001a\u00020'H\u0016R\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0011X\u0096.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u001a\u0010\u001e\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\r\"\u0004\b \u0010\u000fR\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$\u00a8\u00067"}, d2={"Lcom/cout970/magneticraft/systems/tilemodules/ModuleCombustionChamber;", "Lcom/cout970/magneticraft/systems/tileentities/IModule;", "Lcom/cout970/magneticraft/systems/blocks/IOnActivated;", "node", "Lcom/cout970/magneticraft/api/heat/IHeatNode;", "inventory", "Lcom/cout970/magneticraft/misc/inventory/Inventory;", "name", "", "(Lcom/cout970/magneticraft/api/heat/IHeatNode;Lcom/cout970/magneticraft/misc/inventory/Inventory;Ljava/lang/String;)V", "burningTime", "", "getBurningTime", "()I", "setBurningTime", "(I)V", "container", "Lcom/cout970/magneticraft/systems/tileentities/IModuleContainer;", "getContainer", "()Lcom/cout970/magneticraft/systems/tileentities/IModuleContainer;", "setContainer", "(Lcom/cout970/magneticraft/systems/tileentities/IModuleContainer;)V", "doorOpen", "", "getDoorOpen", "()Z", "setDoorOpen", "(Z)V", "getInventory", "()Lcom/cout970/magneticraft/misc/inventory/Inventory;", "maxBurningTime", "getMaxBurningTime", "setMaxBurningTime", "getName", "()Ljava/lang/String;", "getNode", "()Lcom/cout970/magneticraft/api/heat/IHeatNode;", "consumeFuel", "deserializeNBT", "", "nbt", "Lnet/minecraft/nbt/NBTTagCompound;", "getGuiSyncVariables", "", "Lcom/cout970/magneticraft/misc/network/SyncVariable;", "isValidFuel", "stack", "Lnet/minecraft/item/ItemStack;", "onActivated", "args", "Lcom/cout970/magneticraft/systems/blocks/OnActivatedArgs;", "serializeNBT", "spawnParticles", "update", "Companion", "Magneticraft_1.12"})
public final class ModuleCombustionChamber
implements IModule,
IOnActivated {
    @NotNull
    public IModuleContainer container;
    private int burningTime;
    private int maxBurningTime;
    private boolean doorOpen;
    @NotNull
    private final IHeatNode node;
    @NotNull
    private final Inventory inventory;
    @NotNull
    private final String name;
    private static final double MAX_HEAT;
    public static final Companion Companion;

    @Override
    @NotNull
    public IModuleContainer getContainer() {
        IModuleContainer iModuleContainer = this.container;
        if (iModuleContainer == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"container");
        }
        return iModuleContainer;
    }

    @Override
    public void setContainer(@NotNull IModuleContainer iModuleContainer) {
        Intrinsics.checkParameterIsNotNull((Object)iModuleContainer, (String)"<set-?>");
        this.container = iModuleContainer;
    }

    public final int getBurningTime() {
        return this.burningTime;
    }

    public final void setBurningTime(int n) {
        this.burningTime = n;
    }

    public final int getMaxBurningTime() {
        return this.maxBurningTime;
    }

    public final void setMaxBurningTime(int n) {
        this.maxBurningTime = n;
    }

    public final boolean getDoorOpen() {
        return this.doorOpen;
    }

    public final void setDoorOpen(boolean bl) {
        this.doorOpen = bl;
    }

    @Override
    public boolean onActivated(@NotNull OnActivatedArgs args) {
        int index;
        block8: {
            int n;
            Object boxes;
            Object object;
            Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
            Block block = this.getContainer().getBlockState().func_177230_c();
            Block block2 = block;
            if (!(block2 instanceof BlockBase)) {
                block2 = null;
            }
            if ((object = (Function1<BoundingBoxArgs, List<AxisAlignedBB>>)block2) == null || (object = ((BlockBase)((Object)object)).getAabb()) == null || (object = (List)object.invoke((Object)new BoundingBoxArgs(this.getContainer().getBlockState(), (IBlockAccess)this.getWorld(), this.getPos()))) == null) {
                object = CollectionsKt.emptyList();
            }
            Object $this$indexOfFirst$iv = boxes = object;
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            Iterator iterator = $this$indexOfFirst$iv.iterator();
            while (iterator.hasNext()) {
                Object item$iv = iterator.next();
                AxisAlignedBB it = (AxisAlignedBB)item$iv;
                boolean bl = false;
                if (AABBKt.isHitBy(it, args.getHit())) {
                    n = index$iv;
                    break block8;
                }
                ++index$iv;
            }
            n = index = -1;
        }
        if (index != 2) {
            return Config.INSTANCE.getAllowCombustionChamberGui() ? CommonMethods.INSTANCE.openGui(args) : false;
        }
        if (this.doorOpen && this.isValidFuel(args.getHeldItem())) {
            int space = 64 - InventoriesKt.get((IItemHandler)this.inventory, 0).func_190916_E();
            int toMove = Math.min(args.getHeldItem().func_190916_E(), space);
            if (toMove > 0) {
                ItemStack itemStack = this.inventory.insertItem(0, InventoriesKt.withSize(args.getHeldItem(), toMove), false);
                Intrinsics.checkExpressionValueIsNotNull((Object)itemStack, (String)"inventory.insertItem(0, \u2026.withSize(toMove), false)");
                ItemStack notMoved = itemStack;
                args.getHeldItem().func_190918_g(toMove - notMoved.func_190916_E());
            }
        } else {
            this.doorOpen = !this.doorOpen;
            this.getContainer().sendUpdateToNearPlayers();
        }
        return true;
    }

    public final void spawnParticles() {
        if (this.doorOpen && InventoriesKt.isNotEmpty(InventoriesKt.get((IItemHandler)this.inventory, 0))) {
            int n = 2;
            boolean bl = false;
            int n2 = 0;
            n2 = 0;
            int n3 = n;
            while (n2 < n3) {
                int it = n2++;
                boolean bl2 = false;
                Random rand = this.getWorld().field_73012_v;
                Vec3d offset = Vec3dKt.times(Vec3dKt.minus(Vec3dKt.times(Vec3dKt.vec3Of(Float.valueOf(rand.nextFloat()), (Number)0, Float.valueOf(rand.nextFloat())), 2), Vec3dKt.vec3Of(1, 0, 1)), 0.25);
                Vec3d pos = Vec3dKt.plus(Vec3dKt.plus(Vec3iKt.toVec3d((Vec3i)this.getPos()), Vec3dKt.vec3Of(0.5, 0.2, 0.5)), offset);
                Vec3d randDir = Vec3dKt.vec3Of(rand.nextFloat(), rand.nextFloat(), rand.nextFloat());
                Vec3d randDirAllDirections = Vec3dKt.minus(Vec3dKt.times(randDir, Vec3dKt.vec3Of(2, 1, 2)), Vec3dKt.vec3Of(1, 0, 1));
                Vec3d dir = Vec3dKt.plus(Vec3dKt.times(randDirAllDirections, 0.001), Vec3dKt.times(Vec3dKt.plus(Vec3dKt.unaryMinus(offset), Vec3dKt.vec3Of(0, 1, 0)), 0.025));
                this.getWorld().func_175688_a(EnumParticleTypes.FLAME, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, dir.field_72450_a, dir.field_72448_b, dir.field_72449_c, new int[0]);
            }
        }
    }

    @Override
    public void update() {
        boolean consumed;
        World $this$isClient$iv = this.getWorld();
        boolean $i$f$isClient = false;
        if ($this$isClient$iv.field_72995_K) {
            this.spawnParticles();
            return;
        }
        if (this.maxBurningTime > 0) {
            if (this.burningTime > this.maxBurningTime) {
                this.maxBurningTime = 0;
                this.burningTime = 0;
            } else if (this.node.getTemperature() < MAX_HEAT) {
                int speed = (int)((this.doorOpen ? 0.5f : 1.0f) * (float)Config.INSTANCE.getCombustionChamberMaxSpeed());
                this.burningTime += speed;
                this.node.applyHeat(10.0 * (double)speed);
            }
        }
        if (this.maxBurningTime <= 0 && !(consumed = this.consumeFuel()) && this.node.getTemperature() > HeatKt.getSTANDARD_AMBIENT_TEMPERATURE()) {
            this.node.applyHeat(-10.0);
        }
    }

    public final boolean consumeFuel() {
        this.maxBurningTime = 0;
        ItemStack stack = InventoriesKt.get((IItemHandler)this.inventory, 0);
        if (stack.func_190926_b() || !this.isValidFuel(stack)) {
            return false;
        }
        int time = TileEntityFurnace.func_145952_a((ItemStack)stack);
        if (time > 0) {
            stack.func_190918_g(1);
            this.maxBurningTime = time;
        }
        return true;
    }

    public final boolean isValidFuel(@NotNull ItemStack stack) {
        ItemStack it;
        boolean bl;
        boolean bl2;
        ItemStack itemStack;
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        if (stack.func_190926_b()) {
            return false;
        }
        if (Intrinsics.areEqual((Object)stack.func_77973_b(), (Object)Items.field_151044_h)) {
            return true;
        }
        if (Intrinsics.areEqual((Object)stack.func_77973_b(), (Object)Item.func_150898_a((Block)Blocks.field_150402_ci))) {
            return true;
        }
        ItemStack itemStack2 = ItemHolder.coalCoke;
        if (itemStack2 != null) {
            itemStack = itemStack2;
            bl2 = false;
            bl = false;
            it = itemStack;
            boolean bl3 = false;
            if (it.func_77969_a(stack)) {
                return true;
            }
        }
        ItemStack itemStack3 = ItemHolder.coalCokeBlock;
        if (itemStack3 != null) {
            itemStack = itemStack3;
            bl2 = false;
            bl = false;
            it = itemStack;
            boolean bl4 = false;
            if (it.func_77969_a(stack)) {
                return true;
            }
        }
        return false;
    }

    @Override
    @NotNull
    public NBTTagCompound serializeNBT() {
        return NBTKt.newNbt((Function1<? super NBTTagCompound, Unit>)((Function1)new Function1<NBTTagCompound, Unit>(this){
            final /* synthetic */ ModuleCombustionChamber this$0;

            public final void invoke(@NotNull NBTTagCompound $this$newNbt) {
                Intrinsics.checkParameterIsNotNull((Object)$this$newNbt, (String)"$receiver");
                NBTKt.add($this$newNbt, "burningTime", this.this$0.getBurningTime());
                NBTKt.add($this$newNbt, "maxBurningTime", this.this$0.getMaxBurningTime());
                NBTKt.add($this$newNbt, "doorOpen", this.this$0.getDoorOpen());
            }
            {
                this.this$0 = moduleCombustionChamber;
                super(1);
            }
        }));
    }

    @Override
    public void deserializeNBT(@NotNull NBTTagCompound nbt2) {
        Intrinsics.checkParameterIsNotNull((Object)nbt2, (String)"nbt");
        this.burningTime = nbt2.func_74762_e("burningTime");
        this.maxBurningTime = nbt2.func_74762_e("maxBurningTime");
        this.doorOpen = nbt2.func_74767_n("doorOpen");
    }

    @Override
    @NotNull
    public List<SyncVariable> getGuiSyncVariables() {
        return CollectionsKt.listOf((Object[])new IntSyncVariable[]{new IntSyncVariable(2, (Function0<Integer>)((Function0)new Function0<Integer>(this){
            final /* synthetic */ ModuleCombustionChamber this$0;

            public final int invoke() {
                return this.this$0.getBurningTime();
            }
            {
                this.this$0 = moduleCombustionChamber;
                super(0);
            }
        }), (Function1<? super Integer, Unit>)((Function1)new Function1<Integer, Unit>(this){
            final /* synthetic */ ModuleCombustionChamber this$0;

            public final void invoke(int it) {
                this.this$0.setBurningTime(it);
            }
            {
                this.this$0 = moduleCombustionChamber;
                super(1);
            }
        })), new IntSyncVariable(3, (Function0<Integer>)((Function0)new Function0<Integer>(this){
            final /* synthetic */ ModuleCombustionChamber this$0;

            public final int invoke() {
                return this.this$0.getMaxBurningTime();
            }
            {
                this.this$0 = moduleCombustionChamber;
                super(0);
            }
        }), (Function1<? super Integer, Unit>)((Function1)new Function1<Integer, Unit>(this){
            final /* synthetic */ ModuleCombustionChamber this$0;

            public final void invoke(int it) {
                this.this$0.setMaxBurningTime(it);
            }
            {
                this.this$0 = moduleCombustionChamber;
                super(1);
            }
        }))});
    }

    @NotNull
    public final IHeatNode getNode() {
        return this.node;
    }

    @NotNull
    public final Inventory getInventory() {
        return this.inventory;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    public ModuleCombustionChamber(@NotNull IHeatNode node, @NotNull Inventory inventory2, @NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        Intrinsics.checkParameterIsNotNull((Object)((Object)inventory2), (String)"inventory");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        this.node = node;
        this.inventory = inventory2;
        this.name = name;
    }

    public /* synthetic */ ModuleCombustionChamber(IHeatNode iHeatNode, Inventory inventory2, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            string = "module_combustion_chamber";
        }
        this(iHeatNode, inventory2, string);
    }

    static {
        Companion = new Companion(null);
        int $this$fromCelsiusToKelvin$iv = 600;
        boolean $i$f$fromCelsiusToKelvin = false;
        MAX_HEAT = (double)$this$fromCelsiusToKelvin$iv + 273.15;
    }

    @Override
    @NotNull
    public World getWorld() {
        return IModule.DefaultImpls.getWorld(this);
    }

    @Override
    @NotNull
    public BlockPos getPos() {
        return IModule.DefaultImpls.getPos(this);
    }

    @Override
    public void init() {
        IModule.DefaultImpls.init(this);
    }

    @Override
    public void onLoad() {
        IModule.DefaultImpls.onLoad(this);
    }

    @Override
    public void onBreak() {
        IModule.DefaultImpls.onBreak(this);
    }

    @Override
    @Nullable
    public <T> T getCapability(@NotNull Capability<T> cap, @Nullable EnumFacing facing) {
        Intrinsics.checkParameterIsNotNull(cap, (String)"cap");
        return IModule.DefaultImpls.getCapability(this, cap, facing);
    }

    @Override
    public boolean hasCapability(@NotNull Capability<?> cap, @Nullable EnumFacing facing) {
        Intrinsics.checkParameterIsNotNull(cap, (String)"cap");
        return IModule.DefaultImpls.hasCapability(this, cap, facing);
    }

    @Override
    public void receiveSyncData(@NotNull IBD ibd, @NotNull Side otherSide) {
        Intrinsics.checkParameterIsNotNull((Object)ibd, (String)"ibd");
        Intrinsics.checkParameterIsNotNull((Object)otherSide, (String)"otherSide");
        IModule.DefaultImpls.receiveSyncData(this, ibd, otherSide);
    }

    public static final double getMAX_HEAT() {
        Companion companion = Companion;
        return MAX_HEAT;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/cout970/magneticraft/systems/tilemodules/ModuleCombustionChamber$Companion;", "", "()V", "MAX_HEAT", "", "MAX_HEAT$annotations", "getMAX_HEAT", "()D", "Magneticraft_1.12"})
    public static final class Companion {
        @JvmStatic
        public static /* synthetic */ void MAX_HEAT$annotations() {
        }

        public final double getMAX_HEAT() {
            return MAX_HEAT;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

