/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.systems.tilemodules;

import com.cout970.magneticraft.api.energy.IElectricNode;
import com.cout970.magneticraft.misc.fluid.Tank;
import com.cout970.magneticraft.misc.gui.ValueAverage;
import com.cout970.magneticraft.misc.network.IBD;
import com.cout970.magneticraft.misc.network.SyncVariable;
import com.cout970.magneticraft.misc.tileentity.TileEntityKt;
import com.cout970.magneticraft.misc.tileentity.WorkingIndicator;
import com.cout970.magneticraft.systems.tileentities.IModule;
import com.cout970.magneticraft.systems.tileentities.IModuleContainer;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.relauncher.Side;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 *2\u00020\u0001:\u0001*B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0016J\u0006\u0010'\u001a\u00020\u0007J\b\u0010(\u001a\u00020&H\u0016J\b\u0010)\u001a\u00020$H\u0016R\u001a\u0010\u000b\u001a\u00020\fX\u0096.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u001a\u0010\u001d\u001a\u00020\u001eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"\u00a8\u0006+"}, d2={"Lcom/cout970/magneticraft/systems/tilemodules/ModuleSteamGenerator;", "Lcom/cout970/magneticraft/systems/tileentities/IModule;", "steamTank", "Lcom/cout970/magneticraft/misc/fluid/Tank;", "node", "Lcom/cout970/magneticraft/api/energy/IElectricNode;", "maxProduction", "", "name", "", "(Lcom/cout970/magneticraft/misc/fluid/Tank;Lcom/cout970/magneticraft/api/energy/IElectricNode;ILjava/lang/String;)V", "container", "Lcom/cout970/magneticraft/systems/tileentities/IModuleContainer;", "getContainer", "()Lcom/cout970/magneticraft/systems/tileentities/IModuleContainer;", "setContainer", "(Lcom/cout970/magneticraft/systems/tileentities/IModuleContainer;)V", "getMaxProduction", "()I", "getName", "()Ljava/lang/String;", "getNode", "()Lcom/cout970/magneticraft/api/energy/IElectricNode;", "production", "Lcom/cout970/magneticraft/misc/gui/ValueAverage;", "getProduction", "()Lcom/cout970/magneticraft/misc/gui/ValueAverage;", "getSteamTank", "()Lcom/cout970/magneticraft/misc/fluid/Tank;", "working", "Lcom/cout970/magneticraft/misc/tileentity/WorkingIndicator;", "getWorking", "()Lcom/cout970/magneticraft/misc/tileentity/WorkingIndicator;", "setWorking", "(Lcom/cout970/magneticraft/misc/tileentity/WorkingIndicator;)V", "deserializeNBT", "", "nbt", "Lnet/minecraft/nbt/NBTTagCompound;", "getAvailableOperations", "serializeNBT", "update", "Companion", "Magneticraft_1.12"})
public final class ModuleSteamGenerator
implements IModule {
    @NotNull
    public IModuleContainer container;
    @NotNull
    private final ValueAverage production;
    @NotNull
    private WorkingIndicator working;
    @NotNull
    private final Tank steamTank;
    @NotNull
    private final IElectricNode node;
    private final int maxProduction;
    @NotNull
    private final String name;
    public static final int STEAM_PER_OPERATION = 10;
    public static final int ENERGY_PER_OPERATION = 20;
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public IModuleContainer getContainer() {
        IModuleContainer iModuleContainer = this.container;
        if (iModuleContainer == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"container");
        }
        return iModuleContainer;
    }

    @Override
    public void setContainer(@NotNull IModuleContainer iModuleContainer) {
        Intrinsics.checkParameterIsNotNull((Object)iModuleContainer, (String)"<set-?>");
        this.container = iModuleContainer;
    }

    @NotNull
    public final ValueAverage getProduction() {
        return this.production;
    }

    @NotNull
    public final WorkingIndicator getWorking() {
        return this.working;
    }

    public final void setWorking(@NotNull WorkingIndicator workingIndicator) {
        Intrinsics.checkParameterIsNotNull((Object)workingIndicator, (String)"<set-?>");
        this.working = workingIndicator;
    }

    public final int getAvailableOperations() {
        if (this.steamTank.getFluidAmount() < 10) {
            return 0;
        }
        int fluidLimit = this.steamTank.getFluidAmount() / 10;
        if (this.node.getVoltage() > 125.0) {
            return 0;
        }
        return Math.min(fluidLimit, this.maxProduction / 20);
    }

    @Override
    public void update() {
        World $this$isClient$iv = this.getWorld();
        boolean $i$f$isClient = false;
        if ($this$isClient$iv.field_72995_K) {
            return;
        }
        int operations = this.getAvailableOperations();
        if (operations > 0) {
            this.working.onWork();
            this.steamTank.drain(10 * operations, true);
            this.node.applyPower((double)20 * (double)operations, false);
            this.production.plusAssign(20 * operations);
        }
        this.production.tick();
        this.working.tick();
        if (this.working.getWorking() && TileEntityKt.shouldTick(this.getContainer(), 20)) {
            this.getContainer().sendUpdateToNearPlayers();
        }
    }

    @Override
    public void deserializeNBT(@NotNull NBTTagCompound nbt2) {
        Intrinsics.checkParameterIsNotNull((Object)nbt2, (String)"nbt");
        this.working.deserializeNBT(nbt2);
        this.production.setStorage(nbt2.func_74760_g("production"));
    }

    @Override
    @NotNull
    public NBTTagCompound serializeNBT() {
        NBTTagCompound nBTTagCompound = this.working.serializeNBT();
        boolean bl = false;
        boolean bl2 = false;
        NBTTagCompound it = nBTTagCompound;
        boolean bl3 = false;
        it.func_74776_a("production", this.production.getAverage());
        return nBTTagCompound;
    }

    @NotNull
    public final Tank getSteamTank() {
        return this.steamTank;
    }

    @NotNull
    public final IElectricNode getNode() {
        return this.node;
    }

    public final int getMaxProduction() {
        return this.maxProduction;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    public ModuleSteamGenerator(@NotNull Tank steamTank2, @NotNull IElectricNode node, int maxProduction, @NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)steamTank2), (String)"steamTank");
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        this.steamTank = steamTank2;
        this.node = node;
        this.maxProduction = maxProduction;
        this.name = name;
        this.production = new ValueAverage(0, 1, null);
        this.working = new WorkingIndicator(this, 80);
    }

    public /* synthetic */ ModuleSteamGenerator(Tank tank2, IElectricNode iElectricNode, int n, String string, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            n = 240;
        }
        if ((n2 & 8) != 0) {
            string = "module_steam_generator";
        }
        this(tank2, iElectricNode, n, string);
    }

    @Override
    @NotNull
    public World getWorld() {
        return IModule.DefaultImpls.getWorld(this);
    }

    @Override
    @NotNull
    public BlockPos getPos() {
        return IModule.DefaultImpls.getPos(this);
    }

    @Override
    public void init() {
        IModule.DefaultImpls.init(this);
    }

    @Override
    public void onLoad() {
        IModule.DefaultImpls.onLoad(this);
    }

    @Override
    public void onBreak() {
        IModule.DefaultImpls.onBreak(this);
    }

    @Override
    @Nullable
    public <T> T getCapability(@NotNull Capability<T> cap, @Nullable EnumFacing facing) {
        Intrinsics.checkParameterIsNotNull(cap, (String)"cap");
        return IModule.DefaultImpls.getCapability(this, cap, facing);
    }

    @Override
    public boolean hasCapability(@NotNull Capability<?> cap, @Nullable EnumFacing facing) {
        Intrinsics.checkParameterIsNotNull(cap, (String)"cap");
        return IModule.DefaultImpls.hasCapability(this, cap, facing);
    }

    @Override
    public void receiveSyncData(@NotNull IBD ibd, @NotNull Side otherSide) {
        Intrinsics.checkParameterIsNotNull((Object)ibd, (String)"ibd");
        Intrinsics.checkParameterIsNotNull((Object)otherSide, (String)"otherSide");
        IModule.DefaultImpls.receiveSyncData(this, ibd, otherSide);
    }

    @Override
    @NotNull
    public List<SyncVariable> getGuiSyncVariables() {
        return IModule.DefaultImpls.getGuiSyncVariables(this);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/cout970/magneticraft/systems/tilemodules/ModuleSteamGenerator$Companion;", "", "()V", "ENERGY_PER_OPERATION", "", "STEAM_PER_OPERATION", "Magneticraft_1.12"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

