/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.systems.tilemodules.pumpjack;

import com.cout970.magneticraft.misc.NBTKt;
import com.cout970.magneticraft.misc.vector.BlockPosKt;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010(\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 \u00182\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0018B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0006\u0010\u0011\u001a\u00020\u0012J\t\u0010\u0013\u001a\u00020\u0006H\u0096\u0002J\t\u0010\u0014\u001a\u00020\u0002H\u0096\u0002J\u0006\u0010\u0015\u001a\u00020\u0016J\u0006\u0010\u0017\u001a\u00020\u0012R\u001a\u0010\b\u001a\u00020\u0002X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\n\u00a8\u0006\u0019"}, d2={"Lcom/cout970/magneticraft/systems/tilemodules/pumpjack/WorldIterator;", "", "Lnet/minecraft/util/math/BlockPos;", "start", "end", "inverted", "", "(Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/util/math/BlockPos;Z)V", "current", "getCurrent", "()Lnet/minecraft/util/math/BlockPos;", "setCurrent", "(Lnet/minecraft/util/math/BlockPos;)V", "getEnd", "getInverted", "()Z", "getStart", "doneBlocks", "", "hasNext", "next", "reset", "", "totalBlocks", "Companion", "Magneticraft_1.12"})
public final class WorldIterator
implements Iterator<BlockPos>,
KMappedMarker {
    @NotNull
    private BlockPos current;
    @NotNull
    private final BlockPos start;
    @NotNull
    private final BlockPos end;
    private final boolean inverted;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final BlockPos getCurrent() {
        return this.current;
    }

    public final void setCurrent(@NotNull BlockPos blockPos) {
        Intrinsics.checkParameterIsNotNull((Object)blockPos, (String)"<set-?>");
        this.current = blockPos;
    }

    @Override
    public boolean hasNext() {
        return Intrinsics.areEqual((Object)this.current, (Object)(this.inverted ? this.start : this.end)) ^ true;
    }

    public final void reset() {
        this.current = this.inverted ? this.end : this.start;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public BlockPos next() {
        if (BlockPosKt.getXi(this.current) < BlockPosKt.getXi(this.end)) {
            this.current = new BlockPos(BlockPosKt.getXi(this.current) + 1, BlockPosKt.getYi(this.current), BlockPosKt.getZi(this.current));
            return this.current;
        }
        if (BlockPosKt.getZi(this.current) < BlockPosKt.getZi(this.end)) {
            this.current = new BlockPos(BlockPosKt.getXi(this.start), BlockPosKt.getYi(this.current), BlockPosKt.getZi(this.current) + 1);
            return this.current;
        }
        if (this.inverted) {
            if (BlockPosKt.getYi(this.current) > BlockPosKt.getYi(this.start)) {
                this.current = new BlockPos(BlockPosKt.getXi(this.start), BlockPosKt.getYi(this.current) - 1, BlockPosKt.getZi(this.start));
                return this.current;
            }
            String string = "Iterator has no more elements";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        if (BlockPosKt.getYi(this.current) < BlockPosKt.getYi(this.end)) {
            this.current = new BlockPos(BlockPosKt.getXi(this.start), BlockPosKt.getYi(this.current) + 1, BlockPosKt.getZi(this.start));
            return this.current;
        }
        String string = "Iterator has no more elements";
        boolean bl = false;
        throw (Throwable)new IllegalStateException(string.toString());
    }

    public final int totalBlocks() {
        BlockPos totalArea = BlockPosKt.plus(BlockPosKt.minus(this.end, this.start), new BlockPos(1, 1, 1));
        return totalArea.func_177958_n() * totalArea.func_177956_o() * totalArea.func_177952_p();
    }

    public final int doneBlocks() {
        BlockPos totalArea = BlockPosKt.plus(BlockPosKt.minus(this.end, this.start), new BlockPos(1, 1, 1));
        int yLayers = !this.inverted ? (this.current.func_177956_o() - this.start.func_177956_o()) * (totalArea.func_177958_n() * totalArea.func_177952_p()) : (this.end.func_177956_o() - this.current.func_177956_o()) * (totalArea.func_177958_n() * totalArea.func_177952_p());
        int zLayers = (this.current.func_177952_p() - this.start.func_177952_p()) * totalArea.func_177958_n();
        int xLayers = this.current.func_177958_n() - this.start.func_177958_n();
        return xLayers + yLayers + zLayers;
    }

    @NotNull
    public final BlockPos getStart() {
        return this.start;
    }

    @NotNull
    public final BlockPos getEnd() {
        return this.end;
    }

    public final boolean getInverted() {
        return this.inverted;
    }

    public WorldIterator(@NotNull BlockPos start, @NotNull BlockPos end, boolean inverted) {
        Intrinsics.checkParameterIsNotNull((Object)start, (String)"start");
        Intrinsics.checkParameterIsNotNull((Object)end, (String)"end");
        this.start = start;
        this.end = end;
        this.inverted = inverted;
        this.current = this.inverted ? this.end : this.start;
    }

    public /* synthetic */ WorldIterator(BlockPos blockPos, BlockPos blockPos2, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl = false;
        }
        this(blockPos, blockPos2, bl);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\b\b\u0002\u0010\b\u001a\u00020\tJ\u0010\u0010\n\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000b\u001a\u00020\f\u00a8\u0006\r"}, d2={"Lcom/cout970/magneticraft/systems/tilemodules/pumpjack/WorldIterator$Companion;", "", "()V", "create", "Lcom/cout970/magneticraft/systems/tilemodules/pumpjack/WorldIterator;", "a", "Lnet/minecraft/util/math/BlockPos;", "b", "inverted", "", "deserializeNBT", "nbt", "Lnet/minecraft/nbt/NBTTagCompound;", "Magneticraft_1.12"})
    public static final class Companion {
        @NotNull
        public final WorldIterator create(@NotNull BlockPos a, @NotNull BlockPos b, boolean inverted) {
            int n;
            int n2;
            int n3;
            Intrinsics.checkParameterIsNotNull((Object)a, (String)"a");
            Intrinsics.checkParameterIsNotNull((Object)b, (String)"b");
            int n4 = a.func_177958_n();
            int n5 = b.func_177958_n();
            int n6 = 0;
            int n7 = Math.min(n4, n5);
            n4 = 0;
            n5 = a.func_177956_o();
            n6 = b.func_177956_o();
            boolean bl = false;
            n5 = n3 = Math.min(n5, n6);
            n6 = 0;
            n3 = Math.max(n4, n5);
            n4 = a.func_177952_p();
            n5 = b.func_177952_p();
            n6 = 0;
            int n8 = n2 = Math.min(n4, n5);
            int n9 = n3;
            int n10 = n7;
            n4 = a.func_177958_n();
            n5 = b.func_177958_n();
            BlockPos blockPos = new BlockPos(n10, n9, n8);
            n6 = 0;
            n3 = Math.max(n4, n5);
            n4 = a.func_177956_o();
            n5 = b.func_177956_o();
            n6 = 0;
            n2 = Math.max(n4, n5);
            n4 = a.func_177952_p();
            n5 = b.func_177952_p();
            n6 = 0;
            int n11 = n = Math.max(n4, n5);
            int n12 = n2;
            int n13 = n3;
            boolean bl2 = inverted;
            BlockPos blockPos2 = new BlockPos(n13, n12, n11);
            BlockPos blockPos3 = blockPos;
            return new WorldIterator(blockPos3, blockPos2, bl2);
        }

        public static /* synthetic */ WorldIterator create$default(Companion companion, BlockPos blockPos, BlockPos blockPos2, boolean bl, int n, Object object) {
            if ((n & 4) != 0) {
                bl = false;
            }
            return companion.create(blockPos, blockPos2, bl);
        }

        @Nullable
        public final WorldIterator deserializeNBT(@NotNull NBTTagCompound nbt2) {
            WorldIterator worldIterator;
            Intrinsics.checkParameterIsNotNull((Object)nbt2, (String)"nbt");
            if (nbt2.func_74764_b("start")) {
                WorldIterator worldIterator2 = this.create(NBTKt.getBlockPos(nbt2, "start"), NBTKt.getBlockPos(nbt2, "end"), nbt2.func_74767_n("inverted"));
                boolean bl = false;
                boolean bl2 = false;
                WorldIterator $this$apply = worldIterator2;
                boolean bl3 = false;
                $this$apply.setCurrent(NBTKt.getBlockPos(nbt2, "current"));
                worldIterator = worldIterator2;
            } else {
                worldIterator = null;
            }
            return worldIterator;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

