/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.systems.worldgen;

import com.cout970.magneticraft.misc.vector.Vec2d;
import com.cout970.magneticraft.systems.config.GaussOreConfig;
import com.cout970.magneticraft.systems.worldgen.OreGenerator;
import java.util.List;
import java.util.Random;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import net.minecraft.block.state.IBlockState;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J@\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0016"}, d2={"Lcom/cout970/magneticraft/systems/worldgen/GaussianOreGenerator;", "Lcom/cout970/magneticraft/systems/worldgen/OreGenerator;", "blockstate", "Lnet/minecraft/block/state/IBlockState;", "conf", "Lcom/cout970/magneticraft/systems/config/GaussOreConfig;", "(Lnet/minecraft/block/state/IBlockState;Lcom/cout970/magneticraft/systems/config/GaussOreConfig;)V", "getConf", "()Lcom/cout970/magneticraft/systems/config/GaussOreConfig;", "generate", "", "random", "Ljava/util/Random;", "chunkX", "", "chunkZ", "world", "Lnet/minecraft/world/World;", "chunkGenerator", "Lnet/minecraft/world/gen/IChunkGenerator;", "chunkProvider", "Lnet/minecraft/world/chunk/IChunkProvider;", "Magneticraft_1.12"})
public final class GaussianOreGenerator
extends OreGenerator {
    @NotNull
    private final GaussOreConfig conf;

    @Override
    public void generate(@Nullable Random random, int chunkX, int chunkZ, @Nullable World world, @Nullable IChunkGenerator chunkGenerator, @Nullable IChunkProvider chunkProvider) {
        double randGaussian;
        int veins;
        if (world == null || random == null) {
            return;
        }
        List list = CollectionsKt.listOf((Object[])new Integer[]{1, -1});
        WorldProvider worldProvider = world.field_73011_w;
        Intrinsics.checkExpressionValueIsNotNull((Object)worldProvider, (String)"world.provider");
        if (list.contains(worldProvider.getDimension())) {
            return;
        }
        if (this.conf.getActive() && (veins = RangesKt.coerceIn((int)RangesKt.coerceAtLeast((int)((int)Math.floor(randGaussian = random.nextGaussian() * (double)this.conf.getDeviation() + (double)this.conf.getChunkAmount())), (int)0), (int)this.conf.getMinAmountPerChunk(), (int)this.conf.getMaxAmountPerChunk())) > 0) {
            this.generateChunkOres(world, new Vec2d((Number)chunkX, (Number)chunkZ), random, veins);
        }
    }

    @NotNull
    public final GaussOreConfig getConf() {
        return this.conf;
    }

    public GaussianOreGenerator(@NotNull IBlockState blockstate, @NotNull GaussOreConfig conf) {
        Intrinsics.checkParameterIsNotNull((Object)blockstate, (String)"blockstate");
        Intrinsics.checkParameterIsNotNull((Object)conf, (String)"conf");
        super(blockstate, conf);
        this.conf = conf;
    }
}

