/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.systems.worldgen;

import com.cout970.magneticraft.misc.vector.Vec3dKt;
import com.cout970.magneticraft.misc.vector.Vec3iKt;
import com.cout970.magneticraft.systems.config.OilGenConfig;
import com.cout970.magneticraft.systems.worldgen.OilSourceGenerator;
import com.google.common.base.Predicate;
import java.util.Random;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J8\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J&\u0010\u0018\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001a"}, d2={"Lcom/cout970/magneticraft/systems/worldgen/OilSourceGenerator;", "Lnet/minecraftforge/fml/common/IWorldGenerator;", "blockstate", "Lnet/minecraft/block/state/IBlockState;", "config", "Lcom/cout970/magneticraft/systems/config/OilGenConfig;", "(Lnet/minecraft/block/state/IBlockState;Lcom/cout970/magneticraft/systems/config/OilGenConfig;)V", "getBlockstate", "()Lnet/minecraft/block/state/IBlockState;", "getConfig", "()Lcom/cout970/magneticraft/systems/config/OilGenConfig;", "generate", "", "random", "Ljava/util/Random;", "chunkX", "", "chunkZ", "world", "Lnet/minecraft/world/World;", "chunkGenerator", "Lnet/minecraft/world/gen/IChunkGenerator;", "chunkProvider", "Lnet/minecraft/world/chunk/IChunkProvider;", "placeBlocks", "Companion", "Magneticraft_1.12"})
public final class OilSourceGenerator
implements IWorldGenerator {
    @NotNull
    private final IBlockState blockstate;
    @NotNull
    private final OilGenConfig config;
    @NotNull
    private static final Predicate<IBlockState> replaceable;
    public static final Companion Companion;

    public void generate(@NotNull Random random, int chunkX, int chunkZ, @NotNull World world, @NotNull IChunkGenerator chunkGenerator, @NotNull IChunkProvider chunkProvider) {
        Intrinsics.checkParameterIsNotNull((Object)random, (String)"random");
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        Intrinsics.checkParameterIsNotNull((Object)chunkGenerator, (String)"chunkGenerator");
        Intrinsics.checkParameterIsNotNull((Object)chunkProvider, (String)"chunkProvider");
        if (!this.config.getActive()) {
            return;
        }
        int sectorX = chunkX >> 4;
        int sectorZ = chunkZ >> 4;
        if (sectorX % this.config.getDistance() == 0 && sectorZ % this.config.getDistance() == 0) {
            this.placeBlocks(random, chunkX, chunkZ, world);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void placeBlocks(@NotNull Random random, int chunkX, int chunkZ, @NotNull World world) {
        int n;
        Intrinsics.checkParameterIsNotNull((Object)random, (String)"random");
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        int sectorX = chunkX >> 4;
        int sectorZ = chunkZ >> 4;
        Vec3d start = Vec3dKt.vec3Of((sectorX << 4) * 16, 0, (sectorZ << 4) * 16);
        Vec3d size = Vec3dKt.vec3Of(256, 0, 256);
        Vec3d center = Vec3dKt.plus(start, Vec3dKt.times(size, 0.5));
        BlockPos centerBlock = Vec3iKt.toBlockPos(center);
        BlockPos chunkPos = new BlockPos(chunkX << 4, 0, chunkZ << 4);
        double outerRadiusSq = 7744.0;
        if (Vec3iKt.toVec3d((Vec3i)chunkPos).func_72436_e(center) > outerRadiusSq) {
            return;
        }
        int innerRadiusSq = 6400;
        int height = 20;
        int n2 = 0;
        IntRange intRange = new IntRange(n2, 15);
        int n3 = 0;
        IntRange rangeY$iv = new IntRange(n3, 15);
        boolean $i$f$iterateArea = false;
        IntRange intRange2 = rangeY$iv;
        int n4 = intRange2.getFirst();
        if (n4 <= (n = intRange2.getLast())) {
            while (true) {
                void j$iv;
                int n5;
                void rangeX$iv;
                void v1 = rangeX$iv;
                int n6 = v1.getFirst();
                if (n6 <= (n5 = v1.getLast())) {
                    void i$iv;
                    block1: do {
                        int n7;
                        int elev;
                        int n8;
                        void j;
                        BlockPos pos;
                        double dist;
                        void var23_24 = j$iv;
                        void i = ++i$iv;
                        boolean bl = false;
                        if (random.nextInt(3) != 0 || !((dist = centerBlock.func_177951_i((Vec3i)(pos = chunkPos.func_177982_a((int)(i + 8), 0, (int)(j + 8))))) < (double)innerRadiusSq) || (n8 = -(elev = (int)((1.0 - dist / (double)innerRadiusSq) * (double)4))) > (n7 = elev)) continue;
                        while (true) {
                            IBlockState currentBlock;
                            void k;
                            BlockPos currentPos = pos.func_177981_b(height + k);
                            IBlockState iBlockState = currentBlock = world.func_180495_p(currentPos);
                            Intrinsics.checkExpressionValueIsNotNull((Object)iBlockState, (String)"currentBlock");
                            if (iBlockState.func_177230_c().isReplaceableOreGen(currentBlock, (IBlockAccess)world, currentPos, replaceable)) {
                                world.func_180501_a(currentPos, this.blockstate, 2);
                            }
                            if (k == n7) continue block1;
                            ++k;
                        }
                    } while (i$iv != n5);
                }
                if (j$iv == n) break;
                ++j$iv;
            }
        }
    }

    @NotNull
    public final IBlockState getBlockstate() {
        return this.blockstate;
    }

    @NotNull
    public final OilGenConfig getConfig() {
        return this.config;
    }

    public OilSourceGenerator(@NotNull IBlockState blockstate, @NotNull OilGenConfig config) {
        Intrinsics.checkParameterIsNotNull((Object)blockstate, (String)"blockstate");
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        this.blockstate = blockstate;
        this.config = config;
    }

    static {
        Companion = new Companion(null);
        replaceable = Companion.replaceable.1.INSTANCE;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/cout970/magneticraft/systems/worldgen/OilSourceGenerator$Companion;", "", "()V", "replaceable", "Lcom/google/common/base/Predicate;", "Lnet/minecraft/block/state/IBlockState;", "getReplaceable", "()Lcom/google/common/base/Predicate;", "Magneticraft_1.12"})
    public static final class Companion {
        @NotNull
        public final Predicate<IBlockState> getReplaceable() {
            return replaceable;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

