/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.systems.worldgen;

import com.cout970.magneticraft.features.decoration.Blocks;
import com.cout970.magneticraft.features.ores.Blocks;
import com.cout970.magneticraft.systems.config.Config;
import com.cout970.magneticraft.systems.worldgen.GaussianOreGenerator;
import com.cout970.magneticraft.systems.worldgen.OilSourceGenerator;
import com.cout970.magneticraft.systems.worldgen.OreGenerator;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J:\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0006\u0010\u0014\u001a\u00020\bR\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0015"}, d2={"Lcom/cout970/magneticraft/systems/worldgen/WorldGenerator;", "Lnet/minecraftforge/fml/common/IWorldGenerator;", "()V", "generators", "", "getGenerators", "()Ljava/util/List;", "generate", "", "random", "Ljava/util/Random;", "chunkX", "", "chunkZ", "world", "Lnet/minecraft/world/World;", "chunkGenerator", "Lnet/minecraft/world/gen/IChunkGenerator;", "chunkProvider", "Lnet/minecraft/world/chunk/IChunkProvider;", "init", "Magneticraft_1.12"})
public final class WorldGenerator
implements IWorldGenerator {
    @NotNull
    private static final List<IWorldGenerator> generators;
    public static final WorldGenerator INSTANCE;

    @NotNull
    public final List<IWorldGenerator> getGenerators() {
        return generators;
    }

    public final void init() {
        generators.clear();
        generators.add(new OreGenerator(Blocks.OreType.COPPER.getBlockState(Blocks.INSTANCE.getOres()), Config.INSTANCE.getCopperOre()));
        generators.add(new OreGenerator(Blocks.OreType.LEAD.getBlockState(Blocks.INSTANCE.getOres()), Config.INSTANCE.getLeadOre()));
        generators.add(new OreGenerator(Blocks.OreType.TUNGSTEN.getBlockState(Blocks.INSTANCE.getOres()), Config.INSTANCE.getTungstenOre()));
        generators.add(new OreGenerator(Blocks.OreType.PYRITE.getBlockState(Blocks.INSTANCE.getOres()), Config.INSTANCE.getPyriteOre()));
        generators.add(new GaussianOreGenerator(Blocks.LimestoneKind.NORMAL.getBlockState(com.cout970.magneticraft.features.decoration.Blocks.INSTANCE.getLimestone()), Config.INSTANCE.getLimestone()));
        generators.add(new OilSourceGenerator(Blocks.OilAmount.FULL_100.getBlockState(Blocks.INSTANCE.getOilSource()), Config.INSTANCE.getOil()));
    }

    public void generate(@NotNull Random random, int chunkX, int chunkZ, @Nullable World world, @NotNull IChunkGenerator chunkGenerator, @NotNull IChunkProvider chunkProvider) {
        Intrinsics.checkParameterIsNotNull((Object)random, (String)"random");
        Intrinsics.checkParameterIsNotNull((Object)chunkGenerator, (String)"chunkGenerator");
        Intrinsics.checkParameterIsNotNull((Object)chunkProvider, (String)"chunkProvider");
        Iterable $this$forEach$iv = generators;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IWorldGenerator it = (IWorldGenerator)element$iv;
            boolean bl = false;
            it.generate(random, chunkX, chunkZ, world, chunkGenerator, chunkProvider);
        }
    }

    private WorldGenerator() {
    }

    static {
        WorldGenerator worldGenerator;
        INSTANCE = worldGenerator = new WorldGenerator();
        boolean bl = false;
        generators = new ArrayList();
    }
}

