/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.modelloader.api;

import com.cout970.modelloader.api.formats.gltf.GltfAnimationBuilder;
import com.cout970.modelloader.api.formats.gltf.GltfModel;
import com.cout970.modelloader.api.formats.mcx.McxModel;
import com.cout970.modelloader.api.formats.mcx.Mesh;
import com.cout970.vector.api.IVector2;
import com.cout970.vector.extensions.VectorOperationsKt;
import com.cout970.vector.extensions.VectorUtilitiesKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.Vec3d;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u000eJ0\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u000f2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u00112\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u00132\b\b\u0002\u0010\u0014\u001a\u00020\u0015J\u001c\u0010\u0016\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u000e2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00060\u0018\u00a8\u0006\u0019"}, d2={"Lcom/cout970/modelloader/api/ModelUtilities;", "", "()V", "putPartInBuffer", "", "part", "Lcom/cout970/modelloader/api/formats/mcx/McxModel$Part;", "storage", "Lcom/cout970/modelloader/api/formats/mcx/Mesh;", "buffer", "Lnet/minecraft/client/renderer/BufferBuilder;", "renderModel", "model", "Lcom/cout970/modelloader/api/formats/gltf/GltfModel;", "Lcom/cout970/modelloader/api/formats/mcx/McxModel;", "Lnet/minecraft/client/renderer/block/model/IBakedModel;", "state", "Lnet/minecraft/block/state/IBlockState;", "side", "Lnet/minecraft/util/EnumFacing;", "rand", "", "renderModelParts", "parts", "", "modelloader"})
public final class ModelUtilities {
    public static final ModelUtilities INSTANCE;

    public final void renderModel(@NotNull McxModel model) {
        BufferBuilder bufferBuilder;
        Tessellator tessellator;
        Intrinsics.checkParameterIsNotNull((Object)model, (String)"model");
        Tessellator tessellator2 = tessellator = Tessellator.func_178181_a();
        Intrinsics.checkExpressionValueIsNotNull((Object)tessellator2, (String)"tessellator");
        BufferBuilder buffer = tessellator2.func_178180_c();
        Mesh storage = model.getQuads();
        BufferBuilder $receiver = bufferBuilder = buffer;
        $receiver.func_181668_a(7, DefaultVertexFormats.field_181703_c);
        $receiver.func_178969_c(0.0, 0.0, 0.0);
        Iterable $receiver$iv = model.getParts();
        for (Object element$iv : $receiver$iv) {
            McxModel.Part part = (McxModel.Part)element$iv;
            BufferBuilder bufferBuilder2 = buffer;
            Intrinsics.checkExpressionValueIsNotNull((Object)bufferBuilder2, (String)"buffer");
            INSTANCE.putPartInBuffer(part, storage, bufferBuilder2);
        }
        tessellator.func_78381_a();
    }

    public final void renderModel(@NotNull IBakedModel model, @Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
        BufferBuilder buffer;
        BufferBuilder bufferBuilder;
        Tessellator tessellator;
        Intrinsics.checkParameterIsNotNull((Object)model, (String)"model");
        Tessellator tessellator2 = tessellator = Tessellator.func_178181_a();
        Intrinsics.checkExpressionValueIsNotNull((Object)tessellator2, (String)"tessellator");
        BufferBuilder $receiver = bufferBuilder = (buffer = tessellator2.func_178180_c());
        $receiver.func_181668_a(7, DefaultVertexFormats.field_181703_c);
        $receiver.func_178969_c(0.0, 0.0, 0.0);
        List list = model.func_188616_a(state, side, rand);
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"model.getQuads(state, side, rand)");
        Iterable $receiver$iv = list;
        for (Object element$iv : $receiver$iv) {
            BakedQuad part;
            BakedQuad bakedQuad = part = (BakedQuad)element$iv;
            Intrinsics.checkExpressionValueIsNotNull((Object)bakedQuad, (String)"part");
            $receiver.func_178981_a(bakedQuad.func_178209_a());
        }
        tessellator.func_78381_a();
    }

    public static /* synthetic */ void renderModel$default(ModelUtilities modelUtilities, IBakedModel iBakedModel, IBlockState iBlockState, EnumFacing enumFacing, long l, int n, Object object) {
        if ((n & 2) != 0) {
            iBlockState = null;
        }
        if ((n & 4) != 0) {
            enumFacing = null;
        }
        if ((n & 8) != 0) {
            l = 0L;
        }
        modelUtilities.renderModel(iBakedModel, iBlockState, enumFacing, l);
    }

    public final void renderModel(@NotNull GltfModel model) {
        Intrinsics.checkParameterIsNotNull((Object)model, (String)"model");
        new GltfAnimationBuilder().buildPlain(model).render(0.0);
    }

    public final void renderModelParts(@NotNull McxModel model, @NotNull List<McxModel.Part> parts) {
        BufferBuilder bufferBuilder;
        Tessellator tessellator;
        Intrinsics.checkParameterIsNotNull((Object)model, (String)"model");
        Intrinsics.checkParameterIsNotNull(parts, (String)"parts");
        Tessellator tessellator2 = tessellator = Tessellator.func_178181_a();
        Intrinsics.checkExpressionValueIsNotNull((Object)tessellator2, (String)"tessellator");
        BufferBuilder buffer = tessellator2.func_178180_c();
        Mesh storage = model.getQuads();
        BufferBuilder $receiver = bufferBuilder = buffer;
        $receiver.func_181668_a(7, DefaultVertexFormats.field_181703_c);
        $receiver.func_178969_c(0.0, 0.0, 0.0);
        Iterable $receiver$iv = parts;
        for (Object element$iv : $receiver$iv) {
            McxModel.Part part = (McxModel.Part)element$iv;
            BufferBuilder bufferBuilder2 = buffer;
            Intrinsics.checkExpressionValueIsNotNull((Object)bufferBuilder2, (String)"buffer");
            INSTANCE.putPartInBuffer(part, storage, bufferBuilder2);
        }
        tessellator.func_78381_a();
    }

    public final void putPartInBuffer(@NotNull McxModel.Part part, @NotNull Mesh storage, @NotNull BufferBuilder buffer) {
        Intrinsics.checkParameterIsNotNull((Object)part, (String)"part");
        Intrinsics.checkParameterIsNotNull((Object)storage, (String)"storage");
        Intrinsics.checkParameterIsNotNull((Object)buffer, (String)"buffer");
        List<Mesh.Indices> indices = storage.getIndices().subList(part.getFrom(), part.getTo());
        Iterable $receiver$iv = indices;
        for (Object element$iv : $receiver$iv) {
            Vec3d $receiver$iv2;
            BufferBuilder bufferBuilder;
            Mesh.Indices index = (Mesh.Indices)element$iv;
            Vec3d pos0 = storage.getPos().get(index.getA());
            Vec3d pos1 = storage.getPos().get(index.getB());
            Vec3d pos2 = storage.getPos().get(index.getC());
            Vec3d pos3 = storage.getPos().get(index.getD());
            IVector2 tex0 = storage.getTex().get(index.getAt());
            IVector2 tex1 = storage.getTex().get(index.getBt());
            IVector2 tex2 = storage.getTex().get(index.getCt());
            IVector2 tex3 = storage.getTex().get(index.getDt());
            Vec3d normal = VectorUtilitiesKt.cross(VectorOperationsKt.minus(pos2, pos0), VectorOperationsKt.minus(pos3, pos1)).func_72432_b();
            BufferBuilder $receiver = bufferBuilder = buffer;
            Vec3d vec3d = pos0;
            BufferBuilder bufferBuilder2 = $receiver;
            double d = $receiver$iv2.field_72450_a;
            $receiver$iv2 = pos0;
            double d2 = $receiver$iv2.field_72448_b;
            $receiver$iv2 = pos0;
            double d3 = $receiver$iv2.field_72449_c;
            BufferBuilder bufferBuilder3 = bufferBuilder2.func_181662_b(d, d2, d3).func_187315_a(tex0.getXd(), tex0.getYd());
            Vec3d vec3d2 = normal;
            Intrinsics.checkExpressionValueIsNotNull((Object)vec3d2, (String)"normal");
            $receiver$iv2 = vec3d2;
            bufferBuilder2 = bufferBuilder3;
            float f = (float)$receiver$iv2.field_72450_a;
            $receiver$iv2 = normal;
            float f2 = (float)$receiver$iv2.field_72448_b;
            $receiver$iv2 = normal;
            float f3 = (float)$receiver$iv2.field_72449_c;
            bufferBuilder2.func_181663_c(f, f2, f3).func_181675_d();
            $receiver$iv2 = pos1;
            bufferBuilder2 = $receiver;
            d = $receiver$iv2.field_72450_a;
            $receiver$iv2 = pos1;
            d2 = $receiver$iv2.field_72448_b;
            $receiver$iv2 = pos1;
            d3 = $receiver$iv2.field_72449_c;
            $receiver$iv2 = normal;
            bufferBuilder2 = bufferBuilder2.func_181662_b(d, d2, d3).func_187315_a(tex1.getXd(), tex1.getYd());
            f = (float)$receiver$iv2.field_72450_a;
            $receiver$iv2 = normal;
            f2 = (float)$receiver$iv2.field_72448_b;
            $receiver$iv2 = normal;
            f3 = (float)$receiver$iv2.field_72449_c;
            bufferBuilder2.func_181663_c(f, f2, f3).func_181675_d();
            $receiver$iv2 = pos2;
            bufferBuilder2 = $receiver;
            d = $receiver$iv2.field_72450_a;
            $receiver$iv2 = pos2;
            d2 = $receiver$iv2.field_72448_b;
            $receiver$iv2 = pos2;
            d3 = $receiver$iv2.field_72449_c;
            $receiver$iv2 = normal;
            bufferBuilder2 = bufferBuilder2.func_181662_b(d, d2, d3).func_187315_a(tex2.getXd(), tex2.getYd());
            f = (float)$receiver$iv2.field_72450_a;
            $receiver$iv2 = normal;
            f2 = (float)$receiver$iv2.field_72448_b;
            $receiver$iv2 = normal;
            f3 = (float)$receiver$iv2.field_72449_c;
            bufferBuilder2.func_181663_c(f, f2, f3).func_181675_d();
            $receiver$iv2 = pos3;
            bufferBuilder2 = $receiver;
            d = $receiver$iv2.field_72450_a;
            $receiver$iv2 = pos3;
            d2 = $receiver$iv2.field_72448_b;
            $receiver$iv2 = pos3;
            d3 = $receiver$iv2.field_72449_c;
            $receiver$iv2 = normal;
            bufferBuilder2 = bufferBuilder2.func_181662_b(d, d2, d3).func_187315_a(tex3.getXd(), tex3.getYd());
            f = (float)$receiver$iv2.field_72450_a;
            $receiver$iv2 = normal;
            f2 = (float)$receiver$iv2.field_72448_b;
            $receiver$iv2 = normal;
            f3 = (float)$receiver$iv2.field_72449_c;
            bufferBuilder2.func_181663_c(f, f2, f3).func_181675_d();
        }
    }

    private ModelUtilities() {
    }

    static {
        ModelUtilities modelUtilities;
        INSTANCE = modelUtilities = new ModelUtilities();
    }
}

