/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.modelloader.internal;

import com.cout970.modelloader.api.formats.mcx.McxModel;
import com.cout970.modelloader.api.formats.mcx.Mesh;
import com.cout970.modelloader.internal.McxModelSerializerKt;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0002\u0007\bB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\t"}, d2={"Lcom/cout970/modelloader/internal/McxModelSerializer;", "", "()V", "load", "Lcom/cout970/modelloader/api/formats/mcx/McxModel;", "stream", "Ljava/io/InputStream;", "QuadIndicesDeserializer", "ResourceLocationDeserializer", "modelloader"})
public final class McxModelSerializer {
    public static final McxModelSerializer INSTANCE;

    @NotNull
    public final McxModel load(@NotNull InputStream stream) {
        Intrinsics.checkParameterIsNotNull((Object)stream, (String)"stream");
        InputStream inputStream = stream;
        Gson gson = McxModelSerializerKt.access$getGSON$p();
        Charset charset = Charsets.UTF_8;
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream, charset);
        Object object = gson.fromJson((Reader)inputStreamReader, McxModel.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"GSON.fromJson(stream.rea\u2026(), McxModel::class.java)");
        return (McxModel)object;
    }

    private McxModelSerializer() {
    }

    static {
        McxModelSerializer mcxModelSerializer;
        INSTANCE = mcxModelSerializer = new McxModelSerializer();
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J$\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/cout970/modelloader/internal/McxModelSerializer$ResourceLocationDeserializer;", "Lcom/google/gson/JsonDeserializer;", "Lnet/minecraft/util/ResourceLocation;", "()V", "deserialize", "json", "Lcom/google/gson/JsonElement;", "typeOfT", "Ljava/lang/reflect/Type;", "context", "Lcom/google/gson/JsonDeserializationContext;", "modelloader"})
    public static final class ResourceLocationDeserializer
    implements JsonDeserializer<ResourceLocation> {
        @NotNull
        public ResourceLocation deserialize(@NotNull JsonElement json, @Nullable Type typeOfT, @Nullable JsonDeserializationContext context) {
            Intrinsics.checkParameterIsNotNull((Object)json, (String)"json");
            return new ResourceLocation(json.getAsString());
        }
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J$\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/cout970/modelloader/internal/McxModelSerializer$QuadIndicesDeserializer;", "Lcom/google/gson/JsonDeserializer;", "Lcom/cout970/modelloader/api/formats/mcx/Mesh$Indices;", "()V", "deserialize", "json", "Lcom/google/gson/JsonElement;", "typeOfT", "Ljava/lang/reflect/Type;", "context", "Lcom/google/gson/JsonDeserializationContext;", "modelloader"})
    public static final class QuadIndicesDeserializer
    implements JsonDeserializer<Mesh.Indices> {
        @NotNull
        public Mesh.Indices deserialize(@NotNull JsonElement json, @Nullable Type typeOfT, @Nullable JsonDeserializationContext context) {
            Intrinsics.checkParameterIsNotNull((Object)json, (String)"json");
            JsonElement jsonElement = json.getAsJsonArray().get(0);
            Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement, (String)"json.asJsonArray[0]");
            JsonArray pos = jsonElement.getAsJsonArray();
            JsonElement jsonElement2 = json.getAsJsonArray().get(1);
            Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement2, (String)"json.asJsonArray[1]");
            JsonArray tex = jsonElement2.getAsJsonArray();
            JsonElement jsonElement3 = pos.get(0);
            Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement3, (String)"pos[0]");
            int n = jsonElement3.getAsInt();
            JsonElement jsonElement4 = pos.get(1);
            Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement4, (String)"pos[1]");
            int n2 = jsonElement4.getAsInt();
            JsonElement jsonElement5 = pos.get(2);
            Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement5, (String)"pos[2]");
            int n3 = jsonElement5.getAsInt();
            JsonElement jsonElement6 = pos.get(3);
            Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement6, (String)"pos[3]");
            int n4 = jsonElement6.getAsInt();
            JsonElement jsonElement7 = tex.get(0);
            Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement7, (String)"tex[0]");
            int n5 = jsonElement7.getAsInt();
            JsonElement jsonElement8 = tex.get(1);
            Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement8, (String)"tex[1]");
            int n6 = jsonElement8.getAsInt();
            JsonElement jsonElement9 = tex.get(2);
            Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement9, (String)"tex[2]");
            int n7 = jsonElement9.getAsInt();
            JsonElement jsonElement10 = tex.get(3);
            Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement10, (String)"tex[3]");
            return new Mesh.Indices(n, n2, n3, n4, n5, n6, n7, jsonElement10.getAsInt());
        }
    }
}

