/*
 * Decompiled with CFR 0.152.
 */
package tamaized.melongolem;

import com.google.common.collect.ImmutableSet;
import java.awt.Color;
import java.util.Objects;
import java.util.Set;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemAir;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

@Mod.EventBusSubscriber
@Config(modid="melongolem")
public class MelonConfig {
    @Config.Ignore
    public static boolean dirty = true;
    @Config.Name(value="Donator Settings")
    public static DonatorSettings donatorSettings = new DonatorSettings();
    @Config.Name(value="Base Golem Health")
    public static double health = 8.0;
    @Config.Name(value="Melon Slice Damage")
    public static float damage = 4.0f;
    @Config.Name(value="Enable Golem Block Heads")
    public static boolean hats = true;
    @Config.Name(value="Shears Spawn Block")
    public static boolean shear = true;
    @Config.Name(value="Golem Eats Melons")
    public static boolean eats = true;
    @Config.Name(value="Melon Heal Amount")
    public static float heal = 1.0f;
    @Config.Name(value="TehNut Mode")
    public static boolean tehnutMode = false;
    @Config.Name(value="TTS Signs")
    public static boolean tts = true;
    @Config.Name(value="Stabby Life Item")
    @Config.Comment(value={"domain:name:meta\ndomain defaults to `minecraft`\nmeta is optional\ndomain is required if meta is specified"})
    public static String stabby = Objects.requireNonNull(Items.field_151055_y.getRegistryName()).func_110623_a();
    @Config.Ignore
    public static ItemStackWrapper stabItem = new ItemStackWrapper(Items.field_151055_y);

    public static void setupStabby() {
        Item item;
        String[] split = stabby.split(":");
        String domain = "minecraft";
        String regname = split[0];
        int meta = 0;
        boolean hasmeta = false;
        if (split.length > 1) {
            domain = split[0];
            regname = split[1];
            if (split.length > 2) {
                try {
                    meta = Integer.parseInt(split[2]);
                    hasmeta = true;
                }
                catch (NumberFormatException e) {
                    hasmeta = false;
                }
            }
        }
        if ((item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(domain, regname))) == null || item instanceof ItemAir) {
            return;
        }
        stabItem = hasmeta ? new ItemStackWrapper(item, meta) : new ItemStackWrapper(item);
    }

    public static boolean compareStabbyItem(ItemStack stack) {
        return ItemStackWrapper.compare((Set<ItemStackWrapper>)ImmutableSet.of((Object)stabItem), stack);
    }

    @SubscribeEvent
    public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("melongolem")) {
            ConfigManager.sync((String)"melongolem", (Config.Type)Config.Type.INSTANCE);
            MelonConfig.setupStabby();
            MelonConfig.setupColor();
        }
    }

    public static void setupColor() {
        try {
            MelonConfig.donatorSettings.colorint = Color.decode(MelonConfig.donatorSettings.color).getRGB();
        }
        catch (Throwable e) {
            MelonConfig.donatorSettings.color = "0xFFFFFF";
            MelonConfig.donatorSettings.colorint = 0xFFFFFF;
        }
        dirty = true;
    }

    static class ItemStackWrapper {
        boolean ignoreMeta;
        boolean ignoreNBT;
        ItemStack stack;

        public ItemStackWrapper(Item item) {
            this(item, 0);
            this.ignoreMeta = true;
        }

        public ItemStackWrapper(Item item, int meta) {
            this(new ItemStack(item, 1, meta), false, true);
        }

        public ItemStackWrapper(NBTTagCompound tag, boolean ignoreMeta, boolean ignoreNBT) {
            this(new ItemStack(tag), ignoreMeta, ignoreNBT);
        }

        public ItemStackWrapper(ItemStack stack, boolean ignoreMeta, boolean ignoreNBT) {
            this.stack = stack;
            this.ignoreMeta = ignoreMeta;
            this.ignoreNBT = ignoreNBT;
        }

        public static boolean compare(Set<ItemStackWrapper> set, ItemStack stack) {
            for (ItemStackWrapper wrapper : set) {
                boolean flag = wrapper.ignoreMeta && wrapper.ignoreNBT ? wrapper.stack.func_77973_b() == stack.func_77973_b() : (wrapper.ignoreNBT ? wrapper.stack.func_77969_a(stack) : (wrapper.ignoreMeta ? wrapper.stack.func_77973_b() == stack.func_77973_b() && ItemStack.func_77970_a((ItemStack)wrapper.stack, (ItemStack)stack) : ItemStack.func_77989_b((ItemStack)wrapper.stack, (ItemStack)stack)));
                if (!flag) continue;
                return true;
            }
            return false;
        }

        public ItemStackWrapper attachNBT(NBTTagCompound tag) {
            this.ignoreNBT = false;
            this.stack.func_77982_d(tag);
            return this;
        }
    }

    public static class DonatorSettings {
        @Config.Name(value="Enabled")
        public boolean enable = true;
        @Config.Name(value="Color (0xRRGGBB)")
        public String color = "0xFFFFFF";
        @Config.Ignore
        public int colorint = 0xFFFFFF;
    }
}

