/*
 * Decompiled with CFR 0.152.
 */
package tamaized.melongolem.common;

import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackRanged;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityGolem;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemShears;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntitySign;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentUtils;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import tamaized.melongolem.IModProxy;
import tamaized.melongolem.MelonConfig;
import tamaized.melongolem.MelonMod;
import tamaized.melongolem.MelonSounds;
import tamaized.melongolem.common.EntityMelonSlice;
import tamaized.melongolem.network.client.ClientPacketHandlerMelonTTS;

public class EntityMelonGolem
extends EntityGolem
implements IRangedAttackMob,
IShearable,
IEntityAdditionalSpawnData,
IModProxy.ISignHolder {
    public static final TileEntitySign te = new TileEntitySign(){

        @Nonnull
        public Block func_145838_q() {
            return Blocks.field_150444_as;
        }

        public int func_145832_p() {
            return 0;
        }
    };
    private static final DataParameter<ItemStack> HEAD = EntityDataManager.func_187226_a(EntityMelonGolem.class, (DataSerializer)DataSerializers.field_187196_f);
    private static final ResourceLocation LOOT = LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("melongolem", "melongolem"));
    private static final List<DataParameter<ITextComponent>> SIGN_TEXT = Lists.newArrayList((Object[])new DataParameter[]{EntityDataManager.func_187226_a(EntityMelonGolem.class, (DataSerializer)DataSerializers.field_187195_e), EntityDataManager.func_187226_a(EntityMelonGolem.class, (DataSerializer)DataSerializers.field_187195_e), EntityDataManager.func_187226_a(EntityMelonGolem.class, (DataSerializer)DataSerializers.field_187195_e), EntityDataManager.func_187226_a(EntityMelonGolem.class, (DataSerializer)DataSerializers.field_187195_e)});
    private final float pitch;

    public EntityMelonGolem(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.7f, 1.9f);
        this.pitch = this.field_70146_Z.nextFloat() * 3.0f;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(HEAD, (Object)ItemStack.field_190927_a);
        for (DataParameter<ITextComponent> sign : SIGN_TEXT) {
            this.field_70180_af.func_187214_a(sign, (Object)new TextComponentString(""));
        }
    }

    @Override
    public void setSignText(int index, ITextComponent text) {
        this.field_70180_af.func_187227_b(SIGN_TEXT.get(index), (Object)text);
    }

    @Override
    public int entityNetworkId() {
        return this.func_145782_y();
    }

    @Override
    public ITextComponent getSignText(int index) {
        return (ITextComponent)this.field_70180_af.func_187225_a(SIGN_TEXT.get(index));
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAttackRanged((IRangedAttackMob)this, 1.25, 20, 10.0f));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAISearchAndEatMelons((EntityLiving)this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0, 1.0000001E-5f));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityLiving.class, 10, true, false, IMob.field_82192_a));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(MelonConfig.health);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.2f);
    }

    public void func_82196_d(@Nonnull EntityLivingBase target, float distanceFactor) {
        EntityMelonSlice slice = new EntityMelonSlice(this.field_70170_p, (EntityLivingBase)this);
        double d0 = target.field_70163_u + (double)target.func_70047_e() - (double)1.1f;
        double d1 = target.field_70165_t - this.field_70165_t;
        double d2 = d0 - slice.field_70163_u;
        double d3 = target.field_70161_v - this.field_70161_v;
        float f = MathHelper.func_76133_a((double)(d1 * d1 + d3 * d3)) * 0.2f;
        slice.func_70186_c(d1, d2 + (double)f, d3, 1.6f, 12.0f);
        this.func_184185_a(SoundEvents.field_187805_fE, 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
        slice.func_70634_a(slice.field_70165_t, slice.field_70163_u, slice.field_70161_v);
        this.field_70170_p.func_72838_d((Entity)slice);
    }

    public void func_184724_a(boolean swingingArms) {
    }

    public boolean isShearable(@Nonnull ItemStack item, IBlockAccess world, BlockPos pos) {
        return !this.getHead().func_190926_b();
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LOOT;
    }

    protected float func_70647_i() {
        return MelonConfig.tehnutMode ? this.pitch + this.field_70146_Z.nextFloat() * 0.25f - 0.5f : super.func_70647_i();
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return MelonConfig.tehnutMode ? MelonSounds.daddy : SoundEvents.field_187900_fz;
    }

    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource p_184601_1_) {
        return SoundEvents.field_187880_fp;
    }

    @Nullable
    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187874_fm;
    }

    public int func_70627_aG() {
        return this.getHead().func_77973_b() == Items.field_151155_ap ? 200 : super.func_70627_aG();
    }

    public void func_70642_aH() {
        if (MelonConfig.tts && this.getHead().func_77973_b() == Items.field_151155_ap) {
            if (this.field_70170_p != null && !this.field_70170_p.field_72995_K) {
                MelonMod.network.sendToAllAround((IMessage)new ClientPacketHandlerMelonTTS.Packet(this), new NetworkRegistry.TargetPoint(this.field_70170_p.field_73011_w.getDimension(), this.field_70165_t, this.field_70163_u, this.field_70161_v, 15.0));
            }
        } else {
            super.func_70642_aH();
        }
    }

    protected boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        if (!MelonConfig.hats || player.func_184614_ca().func_77973_b() instanceof ItemShears || player.func_184592_cb().func_77973_b() instanceof ItemShears) {
            return false;
        }
        ItemStack stack = player.func_184586_b(hand);
        if (!stack.func_190926_b() && this.getHead().func_190926_b()) {
            if (Block.func_149634_a((Item)stack.func_77973_b()) != Blocks.field_150350_a || stack.func_77973_b() == Items.field_151155_ap) {
                this.setHead(stack);
                if (!player.func_184812_l_()) {
                    player.func_184586_b(hand).func_190918_g(1);
                }
                return true;
            }
        } else if (!this.getHead().func_190926_b() && this.getHead().func_77973_b() == Items.field_151155_ap) {
            MelonMod.proxy.openSignHolderGui(this);
            return true;
        }
        return false;
    }

    public float func_70047_e() {
        return 1.7f;
    }

    @Override
    public ItemStack getHead() {
        return (ItemStack)this.field_70180_af.func_187225_a(HEAD);
    }

    @Override
    public float signHolderDistance(Entity entityIn) {
        return this.func_70032_d(entityIn);
    }

    public void setHead(ItemStack stack) {
        for (int i = 0; i < 4; ++i) {
            this.setSignText(i, (ITextComponent)new TextComponentString(""));
        }
        ItemStack newstack = stack.func_77946_l();
        newstack.func_190920_e(1);
        this.field_70180_af.func_187227_b(HEAD, (Object)newstack);
    }

    @Nonnull
    public List<ItemStack> onSheared(@Nonnull ItemStack item, IBlockAccess world, BlockPos pos, int fortune) {
        ArrayList list = Lists.newArrayList((Object[])new ItemStack[]{MelonConfig.shear ? this.getHead() : ItemStack.field_190927_a});
        this.setHead(ItemStack.field_190927_a);
        return list;
    }

    public void func_70645_a(@Nonnull DamageSource cause) {
        super.func_70645_a(cause);
        ItemStack stack = this.getHead();
        if (!this.field_70170_p.field_72995_K && !stack.func_190926_b()) {
            EntityItem e = new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, stack);
            e.field_70181_x += (double)(this.field_70146_Z.nextFloat() * 0.05f);
            e.field_70159_w += (double)((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.1f);
            e.field_70179_y += (double)((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.1f);
            this.field_70170_p.func_72838_d((Entity)e);
        }
    }

    @Nonnull
    public NBTTagCompound func_189511_e(NBTTagCompound compound) {
        Block block = Block.func_149634_a((Item)this.getHead().func_77973_b());
        compound.func_74768_a("state", this.getHead().func_77973_b() == Items.field_151155_ap ? -100 : Block.func_176210_f((IBlockState)block.func_176203_a(this.getHead().func_77960_j())));
        for (int i = 0; i < 4; ++i) {
            String s = ITextComponent.Serializer.func_150696_a((ITextComponent)this.getSignText(i));
            compound.func_74778_a("Text" + (i + 1), s);
        }
        return super.func_189511_e(compound);
    }

    public void func_70020_e(NBTTagCompound compound) {
        int stateid = compound.func_74762_e("state");
        if (stateid != -100) {
            IBlockState state = Block.func_176220_d((int)stateid);
            this.setHead(state.func_177230_c().getPickBlock(state, null, this.field_70170_p, BlockPos.field_177992_a, null));
        } else {
            this.setHead(new ItemStack(Items.field_151155_ap));
        }
        ICommandSender icommandsender = new ICommandSender(){

            public String func_70005_c_() {
                return "Sign";
            }

            public boolean func_70003_b(int permLevel, @Nonnull String commandName) {
                return permLevel <= 2;
            }

            public BlockPos func_180425_c() {
                return te.func_174877_v();
            }

            public Vec3d func_174791_d() {
                return new Vec3d((double)te.func_174877_v().func_177958_n() + 0.5, (double)te.func_174877_v().func_177956_o() + 0.5, (double)te.func_174877_v().func_177952_p() + 0.5);
            }

            @Nonnull
            public World func_130014_f_() {
                return EntityMelonGolem.this.field_70170_p;
            }

            public MinecraftServer func_184102_h() {
                return EntityMelonGolem.this.field_70170_p.func_73046_m();
            }
        };
        for (int i = 0; i < 4; ++i) {
            String s = compound.func_74779_i("Text" + (i + 1));
            ITextComponent itextcomponent = ITextComponent.Serializer.func_150699_a((String)s);
            try {
                this.setSignText(i, (ITextComponent)(itextcomponent == null ? new TextComponentString("") : TextComponentUtils.func_179985_a((ICommandSender)icommandsender, (ITextComponent)itextcomponent, null)));
                continue;
            }
            catch (CommandException var7) {
                this.setSignText(i, itextcomponent);
            }
        }
        super.func_70020_e(compound);
    }

    public void writeSpawnData(ByteBuf buffer) {
        ByteBufUtils.writeItemStack((ByteBuf)buffer, (ItemStack)this.getHead());
    }

    public void readSpawnData(ByteBuf additionalData) {
        this.setHead(ByteBufUtils.readItemStack((ByteBuf)additionalData));
    }

    static class EntityAISearchAndEatMelons
    extends EntityAIBase {
        private final EntityLiving parent;
        private int cooldown;
        private BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        private boolean foundMelon = false;

        EntityAISearchAndEatMelons(EntityLiving entity) {
            this.parent = entity;
            this.func_75248_a(3);
        }

        public boolean func_75250_a() {
            return MelonConfig.eats && this.parent.func_110143_aJ() < this.parent.func_110138_aP();
        }

        public void func_75251_c() {
            this.cooldown = 0;
        }

        public void func_75246_d() {
            if (this.parent == null) {
                return;
            }
            if (this.cooldown > 0) {
                --this.cooldown;
            }
            int radius = 25;
            AxisAlignedBB area = new AxisAlignedBB(this.parent.field_70165_t - 25.0, this.parent.field_70163_u - 25.0, this.parent.field_70161_v - 25.0, this.parent.field_70165_t + 25.0, this.parent.field_70163_u + 25.0, this.parent.field_70161_v + 25.0);
            List items = this.parent.field_70170_p.func_72872_a(EntityItem.class, area);
            for (EntityItem item : items) {
                if (this.parent.func_70661_as().func_75500_f() && item.func_92059_d().func_77973_b() == Items.field_151127_ba || item.func_92059_d().func_77973_b() == Item.func_150898_a((Block)Blocks.field_150440_ba)) {
                    this.parent.func_70661_as().func_75497_a((Entity)item, 1.25);
                    this.parent.func_70671_ap().func_75651_a((Entity)item, 30.0f, 30.0f);
                }
                if (this.cooldown > 0 || !item.func_70089_S() || item.func_92059_d().func_77973_b() != Items.field_151127_ba || !item.func_174813_aQ().func_72326_a(this.parent.func_174813_aQ().func_186662_g(1.0))) continue;
                item.func_92059_d().func_190918_g(1);
                this.parent.func_184185_a(SoundEvents.field_187739_dZ, 1.0f, 1.0f);
                this.parent.func_70691_i(MelonConfig.heal);
                this.cooldown = 30 + this.parent.func_70681_au().nextInt(40);
            }
            if (this.parent.func_70661_as().func_75500_f()) {
                this.foundMelon = false;
                block1: for (int x = -25; x < 25; ++x) {
                    for (int y = -25; y < 25; ++y) {
                        for (int z = -25; z < 25; ++z) {
                            IItemHandler cap;
                            TileEntity te;
                            this.pos.func_189533_g((Vec3i)this.parent.func_180425_c().func_177982_a(x, y, z));
                            if (!this.parent.field_70170_p.func_175667_e((BlockPos)this.pos) || (te = this.parent.field_70170_p.func_175625_s((BlockPos)this.pos)) == null || !te.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.UP) || (cap = (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.UP)) == null) continue;
                            for (int i = 0; i < cap.getSlots(); ++i) {
                                if (cap.getStackInSlot(i).func_77973_b() != Items.field_151127_ba) continue;
                                boolean bl = this.foundMelon = this.parent.func_70011_f((double)this.pos.func_177958_n(), (double)this.pos.func_177956_o(), (double)this.pos.func_177952_p()) < 2.0 || this.parent.func_70661_as().func_75492_a((double)this.pos.func_177958_n(), (double)this.pos.func_177956_o(), (double)this.pos.func_177952_p(), 1.25);
                                if (this.foundMelon) break block1;
                            }
                        }
                    }
                }
            }
            if (this.foundMelon) {
                int i;
                if (!this.parent.field_70170_p.func_175667_e((BlockPos)this.pos)) {
                    this.parent.func_70661_as().func_75499_g();
                    this.foundMelon = false;
                    return;
                }
                TileEntity te = this.parent.field_70170_p.func_175625_s((BlockPos)this.pos);
                if (te == null || !te.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.UP)) {
                    this.parent.func_70661_as().func_75499_g();
                    this.foundMelon = false;
                    return;
                }
                IItemHandler cap = (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.UP);
                if (cap == null) {
                    this.parent.func_70661_as().func_75499_g();
                    this.foundMelon = false;
                    return;
                }
                boolean valid = false;
                for (i = 0; i < cap.getSlots(); ++i) {
                    if (cap.getStackInSlot(i).func_77973_b() != Items.field_151127_ba) continue;
                    valid = true;
                    break;
                }
                if (!valid) {
                    this.parent.func_70661_as().func_75499_g();
                    this.foundMelon = false;
                    return;
                }
                if (this.cooldown <= 0 && this.parent.func_70011_f((double)this.pos.func_177958_n(), (double)this.pos.func_177956_o(), (double)this.pos.func_177952_p()) < 2.0) {
                    cap.getStackInSlot(i).func_190918_g(1);
                    this.parent.func_184185_a(SoundEvents.field_187739_dZ, 1.0f, 1.0f);
                    this.parent.func_70691_i(MelonConfig.heal);
                    this.cooldown = 10 + this.parent.func_70681_au().nextInt(40);
                }
            }
        }
    }
}

