/*
 * Decompiled with CFR 0.152.
 */
package tamaized.melongolem.common;

import javax.annotation.Nonnull;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import tamaized.melongolem.MelonMod;
import tamaized.melongolem.common.EntityTinyMelonGolem;
import tamaized.melongolem.common.capability.CapabilityList;
import tamaized.melongolem.common.capability.ITinyGolemCapability;
import tamaized.melongolem.network.client.ClientPacketHandlerParticle;

public class ItemMelonStick
extends Item {
    public ItemMelonStick() {
        this.func_77656_e(25);
    }

    public static void summonPet(World world, EntityPlayer owner) {
        ItemMelonStick.summonPet(world, owner, null);
    }

    public static void summonPet(World world, EntityPlayer owner, EntityTinyMelonGolem golem) {
        EntityTinyMelonGolem oldPet;
        if (golem != null && !golem.func_70089_S()) {
            return;
        }
        ITinyGolemCapability cap = CapabilityList.getCap((ICapabilityProvider)owner, CapabilityList.TINY_GOLEM, null);
        if (cap != null && cap.load(true)) {
            WorldServer loader = FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(cap.getLoadDimID());
            loader.func_180495_p(cap.getLoadPos());
            Entity entity = loader.func_175733_a(cap.getLoadPetID());
            if (entity instanceof EntityTinyMelonGolem) {
                EntityTinyMelonGolem melon = (EntityTinyMelonGolem)entity;
                if (world.field_73011_w.getDimension() != loader.field_73011_w.getDimension()) {
                    melon.func_184204_a(world.field_73011_w.getDimension());
                }
                ItemMelonStick.summonPet(world, owner, melon);
                return;
            }
        }
        EntityTinyMelonGolem entityTinyMelonGolem = golem != null ? golem : (oldPet = cap != null ? cap.getPet() : null);
        if (oldPet != null && !oldPet.func_70089_S()) {
            oldPet = null;
        }
        EntityTinyMelonGolem pet = oldPet == null ? new EntityTinyMelonGolem(world) : oldPet;
        pet.func_193101_c(owner);
        if (oldPet == null && cap != null) {
            cap.setPet(pet);
        }
        int x = MathHelper.func_76128_c((double)owner.field_70165_t) - 2;
        int z = MathHelper.func_76128_c((double)owner.field_70161_v) - 2;
        int y = MathHelper.func_76128_c((double)owner.func_174813_aQ().field_72338_b);
        block0: for (int l = pet.func_70681_au().nextInt(6); l <= 8; ++l) {
            for (int i1 = pet.func_70681_au().nextInt(6); i1 <= 8; ++i1) {
                for (int j = 3; j > -3; --j) {
                    if (!ItemMelonStick.isTeleportFriendlyBlock(world, (Entity)pet, x, z, y + j, l, i1)) continue;
                    double posx = (float)(x + l) + 0.5f;
                    double posy = (double)y + (double)j;
                    double posz = (float)(z + i1) + 0.5f;
                    pet.func_70634_a(posx, posy, posz);
                    if (pet.field_70170_p.field_73011_w.getDimension() != owner.field_70170_p.field_73011_w.getDimension()) {
                        pet = (EntityTinyMelonGolem)pet.func_184204_a(owner.field_70170_p.field_73011_w.getDimension());
                        if (cap != null) {
                            cap.setPet(pet);
                        }
                        if (pet == null) {
                            return;
                        }
                        pet.func_70634_a(posx, posy, posz);
                    }
                    for (int i = 0; i < 25; ++i) {
                        Vec3d result = pet.func_70676_i(1.0f).func_178785_b(pet.func_70681_au().nextFloat() * 360.0f).func_178789_a(pet.func_70681_au().nextFloat() * 360.0f).func_186678_a((double)0.35f);
                        ItemMelonStick.spawnVanillaParticleOnServer(world, EnumParticleTypes.END_ROD, pet.field_70165_t + result.field_72450_a, pet.field_70163_u + (double)(pet.field_70131_O / 2.0f) + result.field_72448_b, pet.field_70161_v + result.field_72449_c, 0.0, 0.0, 0.0);
                    }
                    if (oldPet == null) {
                        world.func_72838_d((Entity)pet);
                    }
                    world.func_184133_a(null, pet.func_180425_c(), SoundEvents.field_187638_cR, SoundCategory.PLAYERS, 1.0f, pet.func_70681_au().nextFloat() + 0.5f);
                    break block0;
                }
            }
        }
    }

    public static void spawnVanillaParticleOnServer(World world, EnumParticleTypes particle, double x, double y, double z, double xS, double yS, double zS) {
        MelonMod.network.sendToAllAround((IMessage)new ClientPacketHandlerParticle.Packet(particle.func_179348_c(), new Vec3d(x, y, z), new Vec3d(xS, yS, zS)), new NetworkRegistry.TargetPoint(world.field_73011_w.getDimension(), x, y, z, 64.0));
    }

    private static boolean isTeleportFriendlyBlock(World world, Entity entity, int x, int z, int y, int xOffset, int zOffset) {
        BlockPos blockpos = new BlockPos(x + xOffset, y - 1, z + zOffset);
        IBlockState iblockstate = world.func_180495_p(blockpos);
        return iblockstate.func_193401_d((IBlockAccess)world, blockpos, EnumFacing.DOWN) == BlockFaceShape.SOLID && iblockstate.func_189884_a(entity) && world.func_175623_d(blockpos.func_177984_a()) && world.func_175623_d(blockpos.func_177981_b(2));
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, @Nonnull EnumHand handIn) {
        playerIn.func_184609_a(handIn);
        if (worldIn.field_72995_K) {
            return new ActionResult(EnumActionResult.PASS, (Object)playerIn.func_184586_b(handIn));
        }
        ItemMelonStick.summonPet(worldIn, playerIn);
        playerIn.func_184586_b(handIn).func_77972_a(1, (EntityLivingBase)playerIn);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)playerIn.func_184586_b(handIn));
    }
}

