/*
 * Decompiled with CFR 0.152.
 */
package tamaized.melongolem.common.capability;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import tamaized.melongolem.common.capability.ITinyGolemCapability;

@Mod.EventBusSubscriber(modid="melongolem")
public class CapabilityList {
    @CapabilityInject(value=ITinyGolemCapability.class)
    public static final Capability<ITinyGolemCapability> TINY_GOLEM = null;

    @SubscribeEvent
    public static void attachCapabilityEntity(AttachCapabilitiesEvent<Entity> e) {
        if (e.getObject() instanceof EntityPlayer) {
            e.addCapability(ITinyGolemCapability.ID, (ICapabilityProvider)new ICapabilitySerializable<NBTTagCompound>(){
                ITinyGolemCapability inst = (ITinyGolemCapability)TINY_GOLEM.getDefaultInstance();

                public boolean hasCapability(@Nonnull Capability<?> capability, EnumFacing facing) {
                    return capability == TINY_GOLEM;
                }

                public <T> T getCapability(@Nonnull Capability<T> capability, EnumFacing facing) {
                    return (T)(capability == TINY_GOLEM ? TINY_GOLEM.cast((Object)this.inst) : null);
                }

                public NBTTagCompound serializeNBT() {
                    return (NBTTagCompound)TINY_GOLEM.getStorage().writeNBT(TINY_GOLEM, (Object)this.inst, null);
                }

                public void deserializeNBT(NBTTagCompound nbt) {
                    TINY_GOLEM.getStorage().readNBT(TINY_GOLEM, (Object)this.inst, null, (NBTBase)nbt);
                }
            });
        }
    }

    @SubscribeEvent
    public static void updateClone(PlayerEvent.Clone e) {
        ITinyGolemCapability newcap = CapabilityList.getCap((ICapabilityProvider)e.getEntityPlayer(), TINY_GOLEM, null);
        ITinyGolemCapability oldcap = CapabilityList.getCap((ICapabilityProvider)e.getOriginal(), TINY_GOLEM, null);
        if (newcap != null && oldcap != null) {
            newcap.copyFrom(oldcap);
        }
    }

    public static <T> T getCap(@Nullable ICapabilityProvider provider, Capability<T> cap, @Nullable EnumFacing face) {
        return (T)(provider != null && provider.hasCapability(cap, face) ? provider.getCapability(cap, face) : null);
    }
}

