/*
 * Decompiled with CFR 0.152.
 */
package tamaized.melongolem.network.client;

import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ClientPacketHandlerParticle
implements IMessageHandler<Packet, IMessage> {
    @SideOnly(value=Side.CLIENT)
    private static void processPacket(Packet message, EntityPlayer player, World world) {
        ClientPacketHandlerParticle.spawnParticle(world, EnumParticleTypes.func_179342_a((int)message.id), message.vec, message.vel);
    }

    public static void spawnParticle(World world, EnumParticleTypes particle, Vec3d pos, Vec3d vel) {
        world.func_175688_a(particle, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, vel.field_72450_a, vel.field_72448_b, vel.field_72449_c, new int[0]);
    }

    @SideOnly(value=Side.CLIENT)
    public IMessage onMessage(Packet message, MessageContext ctx) {
        Minecraft.func_71410_x().func_152344_a(() -> ClientPacketHandlerParticle.processPacket(message, (EntityPlayer)Minecraft.func_71410_x().field_71439_g, (World)Minecraft.func_71410_x().field_71441_e));
        return null;
    }

    public static class Packet
    implements IMessage {
        private int id;
        private Vec3d vec;
        private Vec3d vel;

        public Packet() {
        }

        public Packet(int particle, Vec3d pos, Vec3d vel) {
            this.id = particle;
            this.vec = pos;
            this.vel = vel;
        }

        public void fromBytes(ByteBuf buf) {
            this.id = buf.readInt();
            this.vec = new Vec3d(buf.readDouble(), buf.readDouble(), buf.readDouble());
            this.vel = new Vec3d(buf.readDouble(), buf.readDouble(), buf.readDouble());
        }

        public void toBytes(ByteBuf buf) {
            buf.writeInt(this.id);
            buf.writeDouble(this.vec.field_72450_a);
            buf.writeDouble(this.vec.field_72448_b);
            buf.writeDouble(this.vec.field_72449_c);
            buf.writeDouble(this.vel.field_72450_a);
            buf.writeDouble(this.vel.field_72448_b);
            buf.writeDouble(this.vel.field_72449_c);
        }
    }
}

