/*
 * Decompiled with CFR 0.152.
 */
package tamaized.melongolem.network.server;

import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import tamaized.melongolem.IModProxy;
import tamaized.melongolem.common.EntityMelonGolem;

public class ServerPacketHandlerMelonSign
implements IMessageHandler<Packet, IMessage> {
    private static void processPacket(Packet message, EntityPlayerMP player, World world) {
        Entity entity = world.func_73045_a(message.id);
        if (entity instanceof EntityMelonGolem && entity.func_70032_d((Entity)player) <= 6.0f) {
            for (int i = 0; i < message.lines.length; ++i) {
                String text = TextFormatting.func_110646_a((String)message.lines[i]);
                ((EntityMelonGolem)entity).setSignText(i, (ITextComponent)new TextComponentString(text == null ? "" : text));
            }
        }
    }

    public IMessage onMessage(Packet message, MessageContext ctx) {
        EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
        MinecraftServer server = player.func_184102_h();
        if (server != null) {
            server.func_152344_a(() -> ServerPacketHandlerMelonSign.processPacket(message, player, player.field_70170_p));
        }
        return null;
    }

    public static class Packet
    implements IMessage {
        private int id;
        private String[] lines = new String[4];

        public Packet() {
        }

        public Packet(IModProxy.ISignHolder golem) {
            this.id = golem.entityNetworkId();
            this.lines = new String[]{golem.getSignText(0).func_150260_c(), golem.getSignText(1).func_150260_c(), golem.getSignText(2).func_150260_c(), golem.getSignText(3).func_150260_c()};
        }

        public void fromBytes(ByteBuf buf) {
            this.id = buf.readInt();
            for (int i = 0; i < 4; ++i) {
                this.lines[i] = ByteBufUtils.readUTF8String((ByteBuf)buf);
            }
        }

        public void toBytes(ByteBuf buf) {
            buf.writeInt(this.id);
            for (int i = 0; i < 4; ++i) {
                ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.lines[i]);
            }
        }
    }
}

