/*
 * Decompiled with CFR 0.152.
 */
package tamaized.melongolem;

import java.lang.reflect.InvocationTargetException;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemSpawnEgg;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.ObjectHolder;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import tamaized.melongolem.ClientProxy;
import tamaized.melongolem.IModProxy;
import tamaized.melongolem.MelonConfig;
import tamaized.melongolem.ServerProxy;
import tamaized.melongolem.client.RenderMelonGolem;
import tamaized.melongolem.client.RenderMelonSlice;
import tamaized.melongolem.common.EntityMelonGolem;
import tamaized.melongolem.common.EntityMelonSlice;
import tamaized.melongolem.common.EntityTinyMelonGolem;
import tamaized.melongolem.common.ItemMelonStick;
import tamaized.melongolem.common.capability.ITinyGolemCapability;
import tamaized.melongolem.common.capability.TinyGolemCapabilityHandler;
import tamaized.melongolem.common.capability.TinyGolemCapabilityStorage;
import tamaized.melongolem.network.DonatorHandler;
import tamaized.melongolem.network.NetworkMessages;

@Mod(value="melongolem")
@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class MelonMod {
    public static final String MODID = "melongolem";
    public static final IModProxy proxy = (IModProxy)DistExecutor.runForDist(() -> ClientProxy::new, () -> ServerProxy::new);
    public static final MelonConfig config = ((Supplier<MelonConfig>)() -> {
        Pair specPair = new ForgeConfigSpec.Builder().configure(MelonConfig::new);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (ForgeConfigSpec)specPair.getRight());
        return (MelonConfig)specPair.getLeft();
    }).get();
    public static final SimpleChannel network = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation("melongolem", "melongolem")).clientAcceptedVersions(s -> true).serverAcceptedVersions(s -> true).networkProtocolVersion(() -> "1").simpleChannel();
    public static final Logger logger = LogManager.getLogger((String)"melongolem");
    @ObjectHolder(value="melongolem:melonstick")
    public static final Item melonStick = Items.field_190931_a;
    public static final EntityType entityTypeMelonGolem = MelonMod.assign(EntityMelonGolem.class, 128, 1, true);
    @ObjectHolder(value="melongolem:entitymelonslice")
    public static final EntityType entityTypeMelonSlice = (EntityType)MelonMod.getNull();
    @ObjectHolder(value="melongolem:entitytinymelongolem")
    public static final EntityType entityTypeTinyMelonGolem = (EntityType)MelonMod.getNull();

    public MelonMod() {
        DonatorHandler.start();
    }

    @SubscribeEvent
    public static void registerEntities(RegistryEvent.Register<EntityType<?>> e) {
        e.getRegistry().registerAll((IForgeRegistryEntry[])new EntityType[]{entityTypeMelonGolem, MelonMod.assign(EntityMelonSlice.class, 128, 1, true), MelonMod.assign(EntityTinyMelonGolem.class, 128, 1, true)});
    }

    @SubscribeEvent
    public static void registerRenders(FMLClientSetupEvent e) {
        RenderingRegistry.registerEntityRenderingHandler(EntityMelonGolem.class, RenderMelonGolem.Factory::normal);
        RenderingRegistry.registerEntityRenderingHandler(EntityMelonSlice.class, RenderMelonSlice::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityTinyMelonGolem.class, RenderMelonGolem.Factory::tiny);
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> e) {
        e.getRegistry().registerAll((IForgeRegistryEntry[])new Item[]{MelonMod.assign(new ItemMelonStick(new Item.Properties().func_200916_a(ItemGroup.field_78026_f)), "melonstick"), MelonMod.assign((Item)new ItemSpawnEgg(entityTypeMelonGolem, 65280, 0, new Item.Properties().func_200916_a(ItemGroup.field_78026_f)), "melongolemspawnegg")});
    }

    private static Item assign(Item item, String name) {
        return (Item)item.setRegistryName(MODID, name);
    }

    private static <T extends Entity> EntityType<T> assign(Class<T> entity, int range, int freq, boolean updates) {
        String name = entity.getSimpleName().toLowerCase();
        EntityType type = EntityType.Builder.func_201757_a(entity, world -> {
            try {
                return (Entity)entity.getConstructor(World.class).newInstance(world);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                e.printStackTrace();
                return null;
            }
        }).tracker(range, freq, updates).func_206830_a(name);
        type.setRegistryName(MODID, name);
        return type;
    }

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        CapabilityManager.INSTANCE.register(ITinyGolemCapability.class, (Capability.IStorage)new TinyGolemCapabilityStorage(), TinyGolemCapabilityHandler::new);
        NetworkMessages.register(network);
        proxy.init();
    }

    @SubscribeEvent
    public static void init(FMLLoadCompleteEvent event) {
        MelonConfig.setupStabby();
        MelonConfig.setupColor();
        proxy.finish();
    }

    private static <T> T getNull() {
        return null;
    }
}

