/*
 * Decompiled with CFR 0.152.
 */
package tamaized.melongolem.client;

import javax.annotation.Nonnull;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.model.ModelBase;
import net.minecraft.client.renderer.entity.model.ModelSnowMan;
import net.minecraft.entity.EntityLiving;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import tamaized.melongolem.client.LayerMelonHead;
import tamaized.melongolem.common.EntityTinyMelonGolem;

@OnlyIn(value=Dist.CLIENT)
public class RenderMelonGolem<T extends EntityLiving>
extends RenderLiving<T> {
    private static final ResourceLocation TEXTURES = new ResourceLocation("melongolem", "textures/entity/golem.png");
    private static final ResourceLocation TEXTURES_GREY = new ResourceLocation("melongolem", "textures/entity/greygolem.png");
    private final boolean tiny;

    public RenderMelonGolem(RenderManager renderManagerIn, boolean tiny) {
        super(renderManagerIn, (ModelBase)new ModelSnowMan(), tiny ? 0.125f : 0.5f);
        this.func_177094_a(new LayerMelonHead(this));
        this.tiny = tiny;
    }

    public void func_76986_a(@Nonnull T entity, double x, double y, double z, float entityYaw, float partialTicks) {
        GlStateManager.func_179094_E();
        if (this.tiny) {
            GlStateManager.func_179109_b((float)0.0f, (float)-1.11f, (float)0.0f);
            EntityTinyMelonGolem golem = (EntityTinyMelonGolem)entity;
            if (golem.isEnabled()) {
                int color = golem.getColor();
                float r = (float)(color >> 16 & 0xFF) / 255.0f;
                float g = (float)(color >> 8 & 0xFF) / 255.0f;
                float b = (float)(color & 0xFF) / 255.0f;
                GlStateManager.func_179131_c((float)r, (float)g, (float)b, (float)1.0f);
            }
        }
        super.func_76986_a(entity, x, y, z, entityYaw, partialTicks);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179121_F();
    }

    protected ResourceLocation getEntityTexture(@Nonnull T entity) {
        return entity instanceof EntityTinyMelonGolem && ((EntityTinyMelonGolem)entity).isEnabled() ? TEXTURES_GREY : TEXTURES;
    }

    public float prepareScale(@Nonnull T entitylivingbaseIn, float partialTicks) {
        return super.func_188322_c(entitylivingbaseIn, partialTicks) * (this.tiny ? 0.25f : 1.0f);
    }

    public static class Factory {
        public static RenderMelonGolem normal(RenderManager renderManager) {
            return new RenderMelonGolem(renderManager, false);
        }

        public static RenderMelonGolem tiny(RenderManager renderManager) {
            return new RenderMelonGolem(renderManager, true);
        }
    }
}

