/*
 * Decompiled with CFR 0.152.
 */
package tamaized.melongolem.common;

import com.google.common.collect.Lists;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.CommandException;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFollowOwner;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemShears;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.INBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.tileentity.TileEntitySign;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentUtils;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import tamaized.melongolem.IModProxy;
import tamaized.melongolem.MelonMod;
import tamaized.melongolem.common.ItemMelonStick;
import tamaized.melongolem.common.capability.CapabilityList;
import tamaized.melongolem.common.capability.ITinyGolemCapability;
import tamaized.melongolem.network.DonatorHandler;

public class EntityTinyMelonGolem
extends EntityTameable
implements IShearable,
IEntityAdditionalSpawnData,
IModProxy.ISignHolder {
    public static final TileEntitySign te = new TileEntitySign(){

        @Nonnull
        public IBlockState func_195044_w() {
            return Blocks.field_150444_as.func_176223_P();
        }
    };
    private static final DataParameter<ItemStack> HEAD = EntityDataManager.func_187226_a(EntityTinyMelonGolem.class, (DataSerializer)DataSerializers.field_187196_f);
    private static final DataParameter<Boolean> ENABLED = EntityDataManager.func_187226_a(EntityTinyMelonGolem.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> COLOR = EntityDataManager.func_187226_a(EntityTinyMelonGolem.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final List<DataParameter<ITextComponent>> SIGN_TEXT = Lists.newArrayList((Object[])new DataParameter[]{EntityDataManager.func_187226_a(EntityTinyMelonGolem.class, (DataSerializer)DataSerializers.field_187195_e), EntityDataManager.func_187226_a(EntityTinyMelonGolem.class, (DataSerializer)DataSerializers.field_187195_e), EntityDataManager.func_187226_a(EntityTinyMelonGolem.class, (DataSerializer)DataSerializers.field_187195_e), EntityDataManager.func_187226_a(EntityTinyMelonGolem.class, (DataSerializer)DataSerializers.field_187195_e)});

    public EntityTinyMelonGolem(World worldIn) {
        super(Objects.requireNonNull(MelonMod.entityTypeTinyMelonGolem), worldIn);
        this.func_70105_a(0.175f, 0.475f);
    }

    @Nullable
    public EntityAgeable func_90011_a(@Nonnull EntityAgeable ageable) {
        return null;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(HEAD, (Object)ItemStack.field_190927_a);
        this.field_70180_af.func_187214_a(ENABLED, (Object)false);
        this.field_70180_af.func_187214_a(COLOR, (Object)0xFFFFFF);
        for (DataParameter<ITextComponent> sign : SIGN_TEXT) {
            this.field_70180_af.func_187214_a(sign, (Object)new TextComponentString(""));
        }
    }

    public void func_70636_d() {
        ITinyGolemCapability cap;
        DonatorHandler.DonatorSettings settings;
        super.func_70636_d();
        if (this.field_70170_p.field_72995_K || !this.func_70089_S()) {
            return;
        }
        if (this.func_70902_q() != null && this.func_70902_q().func_70089_S() && DonatorHandler.donators.contains(this.func_184753_b()) && (settings = DonatorHandler.settings.get(this.func_184753_b())) != null) {
            this.field_70180_af.func_187227_b(ENABLED, (Object)settings.enabled);
            this.field_70180_af.func_187227_b(COLOR, (Object)settings.color);
        }
        if ((cap = CapabilityList.getCap((ICapabilityProvider)this.func_70902_q(), CapabilityList.TINY_GOLEM, null)) != null && this.func_70902_q() instanceof EntityPlayer && cap.getPet() != this) {
            if (cap.getPet() != null && cap.getPet().func_110124_au().equals(this.func_110124_au())) {
                this.func_70106_y();
                return;
            }
            ItemMelonStick.summonPet(this.field_70170_p, (EntityPlayer)this.func_70902_q(), this);
            if (cap.getPet() == null) {
                cap.setPet(this);
            } else {
                this.func_70097_a(DamageSource.field_76380_i, Float.MAX_VALUE);
            }
        }
    }

    public boolean isEnabled() {
        return (Boolean)this.field_70180_af.func_187225_a(ENABLED);
    }

    public int getColor() {
        return (Integer)this.field_70180_af.func_187225_a(COLOR);
    }

    @Override
    public void setSignText(int index, ITextComponent text) {
        this.field_70180_af.func_187227_b(SIGN_TEXT.get(index), (Object)text);
    }

    @Override
    public ITextComponent getSignText(int index) {
        return (ITextComponent)this.field_70180_af.func_187225_a(SIGN_TEXT.get(index));
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAIFollowOwner((EntityTameable)this, 1.0, 4.0f, 2.0f));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)((Double)MelonMod.config.health.get()).floatValue());
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.2f);
    }

    public boolean isShearable(@Nonnull ItemStack item, IWorldReader world, BlockPos pos) {
        return !this.getHead().func_190926_b();
    }

    protected float func_70647_i() {
        return this.field_70146_Z.nextFloat() * 0.5f + 2.0f;
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187900_fz;
    }

    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource source) {
        return SoundEvents.field_187880_fp;
    }

    @Nullable
    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187874_fm;
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        if (player.func_184614_ca().func_77973_b() instanceof ItemShears || player.func_184592_cb().func_77973_b() instanceof ItemShears) {
            return false;
        }
        ItemStack stack = player.func_184586_b(hand);
        if (!stack.func_190926_b() && this.getHead().func_190926_b()) {
            if (Block.func_149634_a((Item)stack.func_77973_b()) != Blocks.field_150350_a || stack.func_77973_b() == Items.field_151155_ap) {
                this.setHead(stack);
                if (!player.func_184812_l_()) {
                    player.func_184586_b(hand).func_190918_g(1);
                }
                return true;
            }
        } else if (!this.getHead().func_190926_b() && this.getHead().func_77973_b() == Items.field_151155_ap) {
            MelonMod.proxy.openSignHolderGui(this);
            return true;
        }
        return false;
    }

    public float func_70047_e() {
        return 0.425f;
    }

    @Override
    public ItemStack getHead() {
        return (ItemStack)this.field_70180_af.func_187225_a(HEAD);
    }

    public void setHead(ItemStack stack) {
        for (int i = 0; i < 4; ++i) {
            this.setSignText(i, (ITextComponent)new TextComponentString(""));
        }
        ItemStack newstack = stack.func_77946_l();
        newstack.func_190920_e(1);
        this.field_70180_af.func_187227_b(HEAD, (Object)newstack);
    }

    @Nonnull
    public List<ItemStack> onSheared(@Nonnull ItemStack item, IWorld world, BlockPos pos, int fortune) {
        ArrayList list = Lists.newArrayList((Object[])new ItemStack[]{(Boolean)MelonMod.config.shear.get() != false ? this.getHead() : ItemStack.field_190927_a});
        this.setHead(ItemStack.field_190927_a);
        return list;
    }

    public void func_70645_a(@Nonnull DamageSource cause) {
        super.func_70645_a(cause);
        ItemStack stack = this.getHead();
        if (!this.field_70170_p.field_72995_K && !stack.func_190926_b()) {
            EntityItem e = new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, stack);
            e.field_70181_x += (double)(this.field_70146_Z.nextFloat() * 0.05f);
            e.field_70159_w += (double)((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.1f);
            e.field_70179_y += (double)((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.1f);
            this.field_70170_p.func_72838_d((Entity)e);
        }
    }

    @Nonnull
    public NBTTagCompound func_189511_e(NBTTagCompound compound) {
        compound.func_74782_a("head", (INBTBase)this.getHead().serializeNBT());
        compound.func_74757_a("donator_enabled", this.isEnabled());
        compound.func_74768_a("donator_color", this.getColor());
        for (int i = 0; i < 4; ++i) {
            String s = ITextComponent.Serializer.func_150696_a((ITextComponent)this.getSignText(i));
            compound.func_74778_a("Text" + (i + 1), s);
        }
        return super.func_189511_e(compound);
    }

    public void func_70020_e(NBTTagCompound compound) {
        if (compound.func_74764_b("donator_enabled")) {
            this.field_70180_af.func_187227_b(ENABLED, (Object)compound.func_74767_n("donator_enabled"));
        }
        if (compound.func_74764_b("donator_color")) {
            this.field_70180_af.func_187227_b(COLOR, (Object)compound.func_74762_e("donator_color"));
        }
        this.setHead(ItemStack.func_199557_a((NBTTagCompound)compound.func_74775_l("head")));
        for (int i = 0; i < 4; ++i) {
            String s = compound.func_74779_i("Text" + (i + 1));
            ITextComponent itextcomponent = ITextComponent.Serializer.func_150699_a((String)s);
            try {
                this.setSignText(i, (ITextComponent)(itextcomponent == null ? new TextComponentString("") : TextComponentUtils.func_197680_a((CommandSource)this.func_195051_bN(), (ITextComponent)itextcomponent, null)));
                continue;
            }
            catch (CommandSyntaxException | CommandException var7) {
                this.setSignText(i, itextcomponent);
            }
        }
        super.func_70020_e(compound);
    }

    public void writeSpawnData(PacketBuffer buffer) {
        buffer.func_150788_a(this.getHead());
    }

    public void readSpawnData(PacketBuffer additionalData) {
        this.setHead(additionalData.func_150791_c());
    }
}

