/*
 * Decompiled with CFR 0.152.
 */
package tamaized.melongolem.client;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.Direction;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.model.pipeline.IVertexConsumer;
import net.minecraftforge.client.model.pipeline.UnpackedBakedQuad;
import net.minecraftforge.client.model.pipeline.VertexLighterFlat;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import tamaized.melongolem.MelonMod;

@Mod.EventBusSubscriber(modid="melongolem", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class ModelBakeListener {
    @SubscribeEvent
    public static void modelBake(ModelBakeEvent event) {
        for (int i = 0; i <= 1; ++i) {
            ModelResourceLocation mrl = new ModelResourceLocation(Objects.requireNonNull(MelonMod.glisteringMelonBlock.getRegistryName()), i == 0 ? "" : "inventory");
            final IBakedModel model = (IBakedModel)event.getModelRegistry().get(mrl);
            event.getModelRegistry().put(mrl, new IBakedModel(){
                private Map<Direction, List<BakedQuad>> cachedQuads = Maps.newHashMap();

                @Nonnull
                public List<BakedQuad> func_200117_a(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand) {
                    return this.cachedQuads.computeIfAbsent(side, face -> {
                        List delegateQuads = model.func_200117_a(state, side, rand);
                        ArrayList quads = Lists.newArrayList();
                        for (BakedQuad quad : delegateQuads) {
                            quads.add(delegateQuads.indexOf(quad) == 1 ? ModelBakeListener.transformQuad(quad, 0.007f) : quad);
                        }
                        return quads;
                    });
                }

                public boolean func_177555_b() {
                    return model.func_177555_b();
                }

                public boolean func_177556_c() {
                    return model.func_177556_c();
                }

                public boolean func_188618_c() {
                    return model.func_188618_c();
                }

                @Nonnull
                public TextureAtlasSprite func_177554_e() {
                    return model.func_177554_e();
                }

                @Nonnull
                public ItemOverrideList func_188617_f() {
                    return model.func_188617_f();
                }

                @Nonnull
                public ItemCameraTransforms func_177552_f() {
                    return model.func_177552_f();
                }
            });
        }
    }

    private static BakedQuad transformQuad(BakedQuad quad, final float light) {
        VertexFormat newFormat = DefaultVertexFormats.field_176600_a;
        UnpackedBakedQuad.Builder builder = new UnpackedBakedQuad.Builder(newFormat);
        VertexLighterFlat trans = new VertexLighterFlat(Minecraft.func_71410_x().func_184125_al()){

            protected void updateLightmap(@Nonnull float[] normal, float[] lightmap, float x, float y, float z) {
                lightmap[0] = light;
                lightmap[1] = light;
            }

            public void setQuadTint(int tint) {
            }
        };
        trans.setParent((IVertexConsumer)builder);
        quad.pipe((IVertexConsumer)trans);
        builder.setQuadTint(quad.func_178211_c());
        builder.setQuadOrientation(quad.func_178210_d());
        builder.setTexture(quad.func_187508_a());
        builder.setApplyDiffuseLighting(false);
        return builder.build();
    }
}

