/*
 * Decompiled with CFR 0.152.
 */
package tamaized.melongolem.client;

import com.mojang.blaze3d.platform.GLX;
import com.mojang.blaze3d.platform.GlStateManager;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.entity.model.SnowManModel;
import net.minecraft.entity.MobEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import tamaized.melongolem.client.LayerMelonHead;
import tamaized.melongolem.common.EntityTinyMelonGolem;

@OnlyIn(value=Dist.CLIENT)
public class RenderMelonGolem<T extends MobEntity>
extends MobRenderer<T, SnowManModel<T>> {
    private static final ResourceLocation TEXTURES = new ResourceLocation("melongolem", "textures/entity/golem.png");
    private static final ResourceLocation TEXTURES_GREY = new ResourceLocation("melongolem", "textures/entity/greygolem.png");
    private static final ResourceLocation TEXTURES_GLISTER = new ResourceLocation("melongolem", "textures/entity/glistening_melon_golem.png");
    private static final ResourceLocation TEXTURES_GLISTER_OVERLAY = new ResourceLocation("melongolem", "textures/entity/glistening_melon_golem_overlay.png");
    private final Type type;

    public RenderMelonGolem(EntityRendererManager renderManagerIn, Type type) {
        super(renderManagerIn, (EntityModel)new SnowManModel(), type == Type.TINY ? 0.125f : 0.5f);
        this.func_177094_a(new LayerMelonHead(this));
        if (type == Type.GLISTER) {
            this.func_177094_a(new LayerMelonGlister(this));
        }
        this.type = type;
    }

    public void func_76986_a(@Nonnull T entity, double x, double y, double z, float entityYaw, float partialTicks) {
        GlStateManager.pushMatrix();
        if (this.type == Type.TINY) {
            GlStateManager.translatef((float)0.0f, (float)-1.11f, (float)0.0f);
            EntityTinyMelonGolem golem = (EntityTinyMelonGolem)entity;
            if (golem.isEnabled()) {
                int color = golem.getColor();
                float r = (float)(color >> 16 & 0xFF) / 255.0f;
                float g = (float)(color >> 8 & 0xFF) / 255.0f;
                float b = (float)(color & 0xFF) / 255.0f;
                GlStateManager.color4f((float)r, (float)g, (float)b, (float)1.0f);
            }
        }
        if (this.type == Type.GLISTER) {
            int i = ((MobEntity)entity).field_70170_p.func_217338_b(entity.func_180425_c(), 0) | 0x100010;
            GLX.glMultiTexCoord2f((int)GLX.GL_TEXTURE1, (float)(i % 65536), (float)(i >> 16));
        }
        super.func_76986_a(entity, x, y, z, entityYaw, partialTicks);
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.popMatrix();
    }

    protected ResourceLocation getEntityTexture(@Nonnull T entity) {
        return entity instanceof EntityTinyMelonGolem && ((EntityTinyMelonGolem)entity).isEnabled() ? TEXTURES_GREY : (this.type == Type.GLISTER ? TEXTURES_GLISTER : TEXTURES);
    }

    public float prepareScale(@Nonnull T entitylivingbaseIn, float partialTicks) {
        return super.func_188322_c(entitylivingbaseIn, partialTicks) * (this.type == Type.TINY ? 0.25f : 1.0f);
    }

    public static enum Type {
        NORMAL,
        TINY,
        GLISTER;

    }

    public static class Factory {
        public static RenderMelonGolem normal(EntityRendererManager renderManager) {
            return new RenderMelonGolem(renderManager, Type.NORMAL);
        }

        public static RenderMelonGolem tiny(EntityRendererManager renderManager) {
            return new RenderMelonGolem(renderManager, Type.TINY);
        }

        public static RenderMelonGolem glister(EntityRendererManager renderManager) {
            return new RenderMelonGolem(renderManager, Type.GLISTER);
        }
    }

    class LayerMelonGlister<E extends MobEntity>
    extends LayerRenderer<E, SnowManModel<E>> {
        public LayerMelonGlister(IEntityRenderer<E, SnowManModel<E>> p_i50926_1_) {
            super(p_i50926_1_);
        }

        public void render(@Nonnull E entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
            this.func_215333_a(TEXTURES_GLISTER_OVERLAY);
            GlStateManager.enableBlend();
            GlStateManager.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
            GlStateManager.pushMatrix();
            float s = 1.01f;
            GlStateManager.scalef((float)1.01f, (float)1.01f, (float)1.01f);
            int i = 0xF000F0;
            GLX.glMultiTexCoord2f((int)GLX.GL_TEXTURE1, (float)(i % 65536), (float)(i >> 16));
            ((SnowManModel)this.func_215332_c()).func_78088_a(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
            GlStateManager.popMatrix();
            GlStateManager.disableBlend();
        }

        public boolean func_177142_b() {
            return true;
        }
    }
}

