/*
 * Decompiled with CFR 0.152.
 */
package tamaized.melongolem.common;

import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import tamaized.melongolem.MelonMod;
import tamaized.melongolem.common.EntityTinyMelonGolem;
import tamaized.melongolem.common.capability.CapabilityList;
import tamaized.melongolem.common.capability.ITinyGolemCapability;
import tamaized.melongolem.network.client.ClientPacketHandlerParticle;

public class ItemMelonStick
extends Item {
    public ItemMelonStick(Item.Properties prop) {
        super(prop.func_200915_b(25));
    }

    public static void summonPet(World world, PlayerEntity owner) {
        ItemMelonStick.summonPet(world, owner, null);
    }

    public static void summonPet(World world, PlayerEntity owner, EntityTinyMelonGolem golem) {
        EntityTinyMelonGolem oldPet;
        DimensionType dim;
        if (golem != null && !golem.func_70089_S()) {
            return;
        }
        ITinyGolemCapability cap = CapabilityList.getCap((ICapabilityProvider)owner, CapabilityList.TINY_GOLEM, null);
        if (cap != null && cap.load(true) && (dim = DimensionType.func_186069_a((int)cap.getLoadDimID())) != null) {
            ServerWorld loader = ServerLifecycleHooks.getCurrentServer().func_71218_a(dim);
            loader.func_180495_p(cap.getLoadPos());
            Entity entity = loader.func_217461_a(cap.getLoadPetID());
            if (entity instanceof EntityTinyMelonGolem) {
                EntityTinyMelonGolem melon = (EntityTinyMelonGolem)entity;
                if (world.field_73011_w.func_186058_p().func_186068_a() != loader.field_73011_w.func_186058_p().func_186068_a()) {
                    melon.func_212321_a(world.field_73011_w.func_186058_p());
                }
                ItemMelonStick.summonPet(world, owner, melon);
                return;
            }
        }
        EntityTinyMelonGolem entityTinyMelonGolem = golem != null ? golem : (oldPet = cap != null ? cap.getPet() : null);
        if (oldPet != null && !oldPet.func_70089_S()) {
            oldPet = null;
        }
        EntityTinyMelonGolem pet = oldPet == null ? new EntityTinyMelonGolem(world) : oldPet;
        pet.func_193101_c(owner);
        if (oldPet == null && cap != null) {
            cap.setPet(pet);
        }
        int x = MathHelper.func_76128_c((double)owner.field_70165_t) - 2;
        int z = MathHelper.func_76128_c((double)owner.field_70161_v) - 2;
        int y = MathHelper.func_76128_c((double)owner.func_174813_aQ().field_72338_b);
        block0: for (int l = pet.func_70681_au().nextInt(6); l <= 8; ++l) {
            for (int i1 = pet.func_70681_au().nextInt(6); i1 <= 8; ++i1) {
                for (int j = 3; j > -3; --j) {
                    if (!ItemMelonStick.isTeleportFriendlyBlock(world, (Entity)pet, x, z, y + j, l, i1)) continue;
                    double posx = (float)(x + l) + 0.5f;
                    double posy = (double)y + (double)j;
                    double posz = (float)(z + i1) + 0.5f;
                    pet.func_70634_a(posx, posy, posz);
                    if (pet.field_70170_p.field_73011_w.func_186058_p().func_186068_a() != owner.field_70170_p.field_73011_w.func_186058_p().func_186068_a()) {
                        pet = (EntityTinyMelonGolem)pet.func_212321_a(owner.field_70170_p.field_73011_w.func_186058_p());
                        if (cap != null) {
                            cap.setPet(pet);
                        }
                        if (pet == null) {
                            return;
                        }
                        pet.func_70634_a(posx, posy, posz);
                    }
                    for (int i = 0; i < 25; ++i) {
                        Vec3d result = pet.func_70676_i(1.0f).func_178785_b(pet.func_70681_au().nextFloat() * 360.0f).func_178789_a(pet.func_70681_au().nextFloat() * 360.0f).func_186678_a((double)0.35f);
                        ItemMelonStick.spawnVanillaParticleOnServer(world, (IParticleData)ParticleTypes.field_197624_q, pet.field_70165_t + result.field_72450_a, pet.field_70163_u + (double)(pet.func_213302_cg() / 2.0f) + result.field_72448_b, pet.field_70161_v + result.field_72449_c, 0.0, 0.0, 0.0);
                    }
                    if (oldPet == null) {
                        world.func_217376_c((Entity)pet);
                    }
                    world.func_184133_a(null, pet.func_180425_c(), SoundEvents.field_187638_cR, SoundCategory.PLAYERS, 1.0f, pet.func_70681_au().nextFloat() + 0.5f);
                    break block0;
                }
            }
        }
    }

    public static void spawnVanillaParticleOnServer(World world, IParticleData particle, double x, double y, double z, double xS, double yS, double zS) {
        MelonMod.network.send(PacketDistributor.TRACKING_CHUNK.with(() -> world.func_175726_f(new BlockPos(x, y, z))), (Object)new ClientPacketHandlerParticle(particle.func_197554_b().getRegistryName(), new Vec3d(x, y, z), new Vec3d(xS, yS, zS)));
    }

    private static boolean isTeleportFriendlyBlock(World world, Entity entity, int x, int z, int y, int xOffset, int zOffset) {
        BlockPos blockpos = new BlockPos(x + xOffset, y - 1, z + zOffset);
        BlockState iblockstate = world.func_180495_p(blockpos);
        return Block.func_220056_d((BlockState)iblockstate, (IBlockReader)world, (BlockPos)blockpos, (Direction)Direction.UP) && iblockstate.func_215688_a((IBlockReader)entity.field_70170_p, entity.func_180425_c(), entity.func_200600_R()) && world.func_175623_d(blockpos.func_177984_a()) && world.func_175623_d(blockpos.func_177981_b(2));
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, @Nonnull Hand handIn) {
        playerIn.func_184609_a(handIn);
        if (worldIn.field_72995_K) {
            return new ActionResult(ActionResultType.PASS, (Object)playerIn.func_184586_b(handIn));
        }
        ItemMelonStick.summonPet(worldIn, playerIn);
        playerIn.func_184586_b(handIn).func_222118_a(1, (LivingEntity)playerIn, e -> e.func_213334_d(handIn));
        return new ActionResult(ActionResultType.SUCCESS, (Object)playerIn.func_184586_b(handIn));
    }
}

